;
; Floppy Disk test for Z-80 CP/M Systems
;
; Version 1.0   16 December 1980
; From Dr. Dobb's Journal, Number 54, April 1981
;
; Copyright (c) 1980 by
; Ray Duncan
; Laboratory Microsystems 
; 4147 Beethoven Street 
; Los Angeles, CA 90066
;
;
	org	100h
;
cpm	equ	5		; references to
wboot	equ	0		; operating system
;
;
cr	equ	0dh
lf	equ	0ah
ff	equ	0ch
tab	equ	09h
;
				; parameters for disk
				; (supplied as single 
				; density, soft sectored)
$drvf	equ	1		; first drive to allow 
$drvl	equ	3		; last drive
$trkf	equ	0		; first track
$trkl	equ	76		; last
$secf	equ	1		; first sector
$secl	equ	26		; last
$bps	equ	128		; bytes/sector
$bpt	equ	$bps*$secl	; bytes/tracj
;
$dig	equ	2		; set larger for trk/sec >100
;
$ver	equ	1		; version
$rev	equ	0		; revision
;
	jp	dtst		; enter from CP/M
;
				; global variables for all routines
;
pass	dw	0		; current pass number
errors	dw	0		; error count for pass
;
drv	db	0
trk	dw	0
sec	dw	0
buffer	dw	0		; current memory address
iolen	dw	0		; bytes last transferred
;
trkf	dw	0		; first track to test
trkl	dw	0		; last track to test
secf	dw	0		; first sector to test
secl	dw	0		; last sector to test
;
bypass	db	0		; 0 do not bypass error
				; 1 bypass/print total/per pass
skew	db	0		; 0 no sector skew
				; 1 use sector skew
list	db	0		; 0 print errors/console
				; 1 print errors/printer
lockio	db	0		; 0 no lock
				; 1 lock on read
				; 2 lock on write
restor	db	0		; 0 do not restore orig data
				; 1 restore orig data
lockpt	db	0		; 0 use var test
				; 1 lock on user data
pattrn	db	0		; contains user 8 bit pattern
passl	dw	0
digits	db	$dig		; maximum number of digits
xtran	dw	sectrb		; address of sector trans table
;
; 	disk test --- main control
;
dtst	equ	$		; entry from CP/M
	ld	de,dtsta	; print program title
	ld	c,9
	call	cpm
	ld	hl,(cpm+1)
	ld	de,buffend
	or	a,a		; make sure enouth user
	sbc	hl,de		; memory to execute test
	jr	nc,dtst01
	ld	de,dtsts	; not enouth memory,
	ld	c,9		; print warning and exit.
	call	cpm
	jp	wboot
dtst01	ld	c,12		; check CP/M version
	call	cpm
	ld	a,l		; make sure 2.x
	and	0f0h
	cp	20h
	jr	z,dtst02
	ld	de,dtstz	; not CP/M 2.x, print
	ld	c,9		; error message and exit
	call	cpm
	jp	wboot
dtst02	xor	a,a		; initialize variables
	ld	(bypass),a
	ld	(skew),a
	ld	(list),a
	ld	(lockio),a
	ld	(restor),a
	ld	(lockpt),a
	ld	(pass),a
	ld	(pass+1),a
	ld	(errors),a
	ld	(errors+1),a
				; now set up test
		 		; configuration
	ld	de,dtstb
	call	getyn		; itemize errors?
	cp	'y'
	jr	z,dtst03	; yes
	ld	a,1		; no
	ld	(bypass),a
	jr	dtst04		; skip query for output
				; device, since errors
				; will not be listed
dtst03	ld	de,dtstc	; audit errors on console
	call	getl		; or line printer?
	cp	'c'
	jr	z,dtst04	; c = console
	cp	'p'
	call	nz,query
	jr	nz,dtst03	; no match, try again
	ld	a,1		; p = line printer
	ld	(list),a
dtst04	ld	de,dtstd	; lock on read or write?
	call	getl
	cp	'n'		; n = no locks
	jr	z,dtst06
	cp	'r'		; r = lock on read
	jr	nz,dtst05
	ld	a,1
	ld	(lockio),a
	jr	dtst12		; bypass querys about
				; restore mode and
				; data pattern: since
				; we are locked in read
				; mode, they are
				; irrelevant.
				;
dtst05	cp	'w'		; w = lock on write 
	call	nz,query
	jr	nz,dtst04	; no match, try again
	ld	a,2
	ld	(lockio),a
	jr	dtst08		; bypass restore question,
				; since we are locked in
				; read write mode.
				;
dtst06	ld	de,dtste	; restore user data?
	call	getyn
	cp	'y'		; y = restore
	jr	nz,dtst08
	ld	a,1		; n = do not restore
	ld	(restor),a
dtst08	ld	de,dtstf	; lock on data pattern?
	call	getyn
	cp	'n'
	jr	z,dtst12	; n = use variable pattern
	ld	a,1		; y = lock on pattern
	ld	(lockpt),a	; supplied by operator
	ld	de,dtstg	; accept data pattern
	call	geth		; from keyboard
	ld	(pattrn),a
dtst12	ld	de,dtsth	; select drive to be
	call	getl		; used for test
	sub	'a'		; convert to logical #
	cp	$drvf		; make sure its legal
	call	c,query
	jr	c,dtst12	; too small, try again
	cp	$drvl+1
	call	nc,query
	jr	nc,dtst12	; too large, try again
	ld	(drv),a		; save drive assignment
	add	'A'		; also format for output
	ld	(dtsti1),a
	ld	de,dtsti	; confirm selected drive?
	call	getyn
	cp	'n'
	jr	z,dtst12	; not confirmed, try again
				; 
				; initialize track
				; limits
	ld	hl,$trkf
	ld	(trkf),hl
	ld	hl,$trkl
	ld	(trkl),hl
dtst15	ld	de,dtstj	; test all tracks?
	call	getyn
	cp	'y'		; use all of them
	jr	z,dtst20	; n = user wants to specify 
				; range of tracks
dtst17	ld	de,dtstk	; enter first track to test
	call	getn
	ld	(trkf),hl	; save it
	ld	de,dtstl	; enter last track to test
	call	getn
	ld	(trkl),hl	; save it
	ld	de,(trkf)	; make sure first
	or	a,a		; track <= last track
	sbc	hl,de
	call	c,query		; wrong, start over
	jr	c,dtst17
dtst20				; initialize sector
				; limits
	ld	hl,$secf
	ld(secf),hl
	ld	hl,$secl
	ld	(secl),hl
dtst22	ld	de,dtstm	; use all sectors
	call	getyn		; of each track?
	cp	'y'
	jr	z,dtst26	; y = use all sectors
				; n = user wants to specify
				; range of sectors
dtst24	ld	de,dtstn	; enter first sector to test
	call	getn
	ld	(secf),hl	; save it
	ld	de,dtsto	; enter last sector to test
	call	getn
	ld	(secl),hl	; save it
	ld	de,(secf)	; make sure first sector
	or	a,a		; <= last sector
	sbc	hl,de
	call	c,query
	jr	c,dtst24	; error, start over
				;
				; all variables set up
				; now --- how many
dtst26	ld	de,dtstp	; test passes should be 
	call	getn		; made?
	ld	(passl),hl	; save # of passes
	ld	de,dtstt	; print ad	hl,buff3	; yes, save current
	ld	de,merr1	; disk contents
	call	rdbuf
dtst45	ld	a,(lockio)
	cp	a,1		; is this lock on read?
	jr	z,dtst47	; yes, jump
	ld	hl,buff1	; set up test pattern
	ld	de,$bpt
	call	bufpat
	ld	hl,buff1	; write test pattern
	ld	de,merr2
	call	wtbuf
dtst47	ld	a,(lockio)
	cp	a,2		; is this lock on write?
	jr	z,dtst70	; yes, jump
	ld	hl,buff2	; read back test pattern
				; (or just read existing
				; data if locked on read)
	ld	de,merr3
	call	rdbuf
dtst50	ld	a,(lockio)
	or 	a,a		; is this lock on
				; read or write?
	jr	nz,dtst70	; yes, jump
				; no, compare test data
	ld	hl,buff1	; written to data read
	ld	de,buff2	; back from disk. If
	ld	bc,merr4	; difference found, 
	call	bufcmp		; print error message
dtst70	ld	a,(restor)
	or	a,a		; using restore mode?
	jr	z,dtst80	; no, jump
				; yes, write back user's
				; data
	ld	hl,buff3
	ld	de,merr6
	call	wtbuf
	ld	hl,buff1	; verify that
	ld	de,merr7	; it was rewritten ok
	call	rdbuf
	ld	hl,buff1
	ld	de,buff3
	ld	bc,merr5	; check restored data
	call	bufcmp
				; if difference found,
				; print 'data cannot
				; be restored '
				;
dtst80				; advance current track
	ld	de,(trk)
	inc	de
	ld	(trk),de
	ld	hl,(trkl)
	or	a,a		; done with all tracks?
	sbc	hl,de
	jp	nc,dtst42	; no, process another
				;
dtst90				; end of pass
	ld	bc,(pass)
	inc	bc		; count passes
	ld	(pass),bc
	ld	hl,dtstr1
	call	conv		; convert pass #
	ld	bc,(errors)
	ld	hl,dtstr2
	call	conv		; convert error count
	ld	de,dtstr	; print pass and errors
	ld	c,9		; on console
	call	cpm
	ld	a,(list)	; also using printer?
	or	a,a
	jr	z,dtst92	; no, jump
				; yes, also send pass and
				; error count to list device
	ld	hl,dtstr
	call	perr9
dtst92				; reset error count
	xor	a,a
	ld	(errors),a
	ld	(errors+1),a
	ld	hl,(pass)
	ld	de,(passl)
	or	a,a		; are enough passes done?
	sbc	hl,de
	jp	c,dtst40	; not yet, loop
dtst94				; done with all passes
	ld	de,dtstw	; ask whether to exit
	call	getl		; or to continue test
	cp	'c'		; c = continue
	jp	z,dtst
	cp	'e'		; e = exit
	jr	nz,dtst94	; if no match, try again
	ld	de,dtstx	; print goodbye
	ld	c,9
	call	cpm		; and return control
	jp	wboot		; to CP/M
;
;	routines to read and write up to one track
;
rdbuf				; read current track from
				; secf to secl
				;
				; call hl = buffer base addr
				;      de = error msg addr
	ld	(rdbufa),de	; save message address
	ld	(buffer),hl	; save buffer address
	ld	hl,0		; initialize transfer byte
	ld	(iolen),hl	; count
	call	seldsk		; select disk
	ld	hl,(secf)
	ld	(sec),hl	; initialize current sector
rdbuf1	call	setio		; set& up track, sector, memory
	call	read		; now request transfer
	or	a,a		; was i/o successful?
	jr	z,rdbuf2	; no error, jump
	ld	de,(rd