JNZ	FIL01		;LOOP FOR NUMSEC SECTORS
	RET
;
;	DFILADR  -  FILL IN TRACK AND SECTOR NUMBERS
;
DFILADR:
	LXI	B,SECMAP	;POINTER TO SECTOR MAP
	LDA	DNUMSEC		;NUMBER OF SECTORS
	STA	SEC		;SECTOR COUNTER
	LHLD	FOFF		;FILL ADDR OFFSET
	XCHG
	LXI	H,TRKBUF+43	;LOCATION OF FIRST TRACK NUMBER
	LDA	SECSIZ		;SECTOR SIZE CODE
	ORA	A
	JZ	DFIL00
	LXI	H,TRKBUF+46
DFIL00:	DCR	A
	JNZ	DFIL01
	LXI	H,TRKBUF+162	;LOCATION FIRST TRACK NO 256 BYTE SECTORS
DFIL01:	LDA	TRK		;TRACK NO
	MOV	M,A		;TO BUFFER
	INX	H
	INX	H		;POINT TO SECTOR
	LDAX	B		;SECTOR NUMBER
	MOV	M,A		;TO BUFFER
	INX	H
	LDA	SECSIZ		;SECTOR SIZE CODE
	MOV	M,A		;TO MEMORY
	DAD	D		;INCR BUFFER POINTER
	INX	B		;INCR SECTOR MAP POINTER
	LDA	SEC
	DCR	A
	STA	SEC		;DECR SECTOR COUNT
	JNZ	FIL01		;LOOP FOR NUMSEC SECTORS
	RET
;
;
;	FILBUF  -  FILL END OF TRACK WITH FF'S OR 4E'S
;
FILBUF:	LXI	D,1200		;END OF TRACK FILL
	MVI	B,0FFH		;FILL CHAR
	LDA	DDFLG		;CHECK DENSITY FLAG
	ORA	A
	JZ	ET1
	MVI	B,4EH		;DD FILL BYTE
ET1:	MOV	M,B
	INX	H
	DCX	D		;DECR COUNT
	MOV	A,D
	ORA	E
	JNZ	ET1
	RET
;
;	IDREAD  -  READ ID FIELD ON CURRENT TRACK AND PUT DATA IN IDTAB
;
IDREAD:	LDA	RETRYS
IDRD01:	STA	IDECNT		;ERROR COUNT
	MVI	A,0D8H		;INTERRUPT
	OUT	DCOM
	LXI	H,IDTAB		;POINT TO TABLE
	XTHL
	XTHL			;SHORT DELAY
	MVI	A,0C4H		;READ ADDR COMMAND
	OUT	DCOM		;SEND IT
IDRD02:	IN	WAIT		;WAIT FOR DRQ OR INTRQ
	ORA	A
	JP	IDRD03
	IN	DDATA		;READ DATA BYTE
	MOV	M,A		;STORE IT
	INX	H		;INCR POINTER
	JMP	IDRD02		;LOOP TILL INTRQ
IDRD03:	IN	STATP		;READ STATUS
	ANI	08H
	RZ
	LDA	IDECNT		;ERROR COUNT
	DCR	A		;DECR IT
	JNZ	IDRD01		;TRY AGAIN
	PRINT	<CR,LF,'ERROR IN READING ID FIELD'>
	JMP	ENDFIL
;
;
;
;	TIMED DELAY LOOP.  CALLED WITH NUMBER MSEC DELAY IN A
;
DELAY:	PUSH	D
	PUSH	H
DSTART:	LXI	D,1
	LXI	H,65335		;CONST FOR 1 MSEC DELAY (4 MHZ)
DLOOP:	DAD	D
	JNC	DLOOP		;LOOP TILL CARRY  5.0 USEC/ITERATION
	DCR	A		;DECR MSEC COUNT
	JNZ	DSTART
	POP	H
	POP	D
	RET
;
;
;    EXIT ROUTINES
;
ENDFIL:	PRINT	CRLF,$
	LDA	DRIVE
	CALL	SELECT
	LDA	INFLAG		;SEE WHERE TO GO
	ORA	A
	JNZ	NEWIN		;BACK FOR MORE INPUT
MONITOR:LHLD	OLDSTK
	SPHL			;RESET ORIGINAL STACK
	RET			;BACK TO CP/M
;
;  ERROR ROUTINES
;
ERRMSG:	PRINT	<CR,LF,'FORMATTING ERROR DRIVE '>
	LDA	NEWDRV
	ORA	A		;TEST DRIVE NUMBER
	JZ	ERM2
	PRINT	<'B',CR,LF>
	JMP	ENDFIL
ERM2:	PRINT	<'A',CR,LF>
	JMP	ENDFIL
;
;    CHECK FOR LEGITIMATE SECTOR NUMBERS (1-26). AND CHECK IF SECTOR NUMBER
;    ALREADY ASSIGNED
;
SECERR:	CPI	1
	JP	SE0
	PRINT	<CR,LF,' ERROR - SECTOR NUMBERS MUST BE GREATER THAN ZERO'>
	JMP	SE1
SE0:	CPI	27
	JM	SE2
	PRINT	<CR,LF,' ERROR - SECTOR GREATER THAN 26'>
SE1:	STC
	RET
SE2:	LXI	H,SECMAP
	MVI	B,26
SE3:	CMP	M		;CHECK IF SECTOR ALREADY USED
	JNZ	SE4
	PRINT	<CR,LF,' SORRY YOU ALREADY USED THAT ONE'>
	JMP	SE1
SE4:	INX	H
	DCR	B
	JNZ	SE3
SE5:	ORA	A		;CLEAR CARRY
	RET
;
;    SCANERR - NUMBER MISSING WHERE EXPECTED
;
SCANERR:PRINT  <CR,LF,LF,'MISSING OPERAND, PLEASE START OVER',CR,LF>
	JMP	ENDFIL		;EXIT
;
;    DECERR - NON NUMERIC CHMATCH
	STC			;SET CARRY
SR3:	RES
	RET
SR5:	INX	H		;INCR POINTER
	DCR	B		;DECR SECTOR COUNT
	JNZ	SR1		;LOOP FOR 26 SECTORS
	ORA	A		;RESET CARRY
	JMP	SR3		;EXIT
;
;
;    CLEAR ROUTINE CLEARS SCREEN (NULLS FOR SOME TERMINALS)
;
CLEAR:	SAVE
	PRINT	<27,42,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0>
	RESTORE
	RET
;
;    SEEK ROUTINE MOVES TO TRACK IN A REG (ASSUMES PREVIOUS HOME)
;
SEEK:	SAV			;SAVE REGS
	MOV	E,A		;SAVE TRACK NO IN E
	IN	TRACK		;READ 1771 TRACK REG
	MOV	B,A		;SAVE IN B
	CMP	E		;COMPARE WITH REQUESTED TRACK
	JZ	SEEK3
	MVI	D,0
	MVI	C,5		;RETRYS
SEEK1:	MOV	A,E		;TRACK NO
	OUT	DDATA		;TRACK NO TO DATA REG
SEEKW:	IN	STATP		;CHECK BUSY
	RRC
	JC	SEEKW		;WAIT TILL NOT BUSY DOOR CLOSED ETC.
	MVI	A,1CH+STEP	;SEEK COMMAND (6 MSEC) WITH VERIFY
	OUT	DCOM		;DO IT
	IN	WAIT
	IN	STATP		;READ DISK STATUS
	ANI	91H
	JZ	SEEK3		;EXIT IF ZERO
	DCR	C		;DECR ERROR COUNT
	JZ	SEEK2		;SEEK ERROR AFTER 5 RETRYS
	CALL	HOME		;HOME THE DRIVE
	JMP	SEEK1		;TRY AGAIN
SEEK2:	PUSH	D		;SAVE TRACK NO
	PRINT	<CR,LF,'SEEK ERROR TRACK '>
	POP	H		;TRACK NO TO L
	DECOUT			;PRINT TRACK NO
	PRINT	<' DRIVE '>
	LDA	DRVNO		;GET SELECTED DRIVE
	CALL	PRNDRV		;PRINT A THRU C
	JMP	ENDFIL		;EXIT
SEEK3:	RES			;RESTORE REGS
	RET
;
;
;    HOME SELECTED DRIVE
;
HOME:	SAV
	PUSH	PSW
HOME1:	IN	STATP		;READ STATUS
	RRC			;SHIFT BUSY BIT INTO CARRY
	JC	HOME1		;WAIT TILL NOT BUSY
	MVI	A,STEP		;HOME - NO HEAD LOAD NO VERIFY
	OUT	DCOM		;ISSUE COMMAND
	IN	WAIT		;WAIT TILL COMPLETE
	MVI	A,200		;200 MSEC DELAY
	CALL	DELAY
HOME3:	IN	STATP		;READ DISK STATUS
	ANI	4		;CHECK TRACK ZERO FLAG
	JZ	HOMERR		;ERROR IF NOT T 0
HOME5:	LXI	H,TRKTBL	;POINT TO TRACK TABLE
	MVI	D,0
	LDA	DRVNO		;SELECTED DRIVE
	MOV	E,A
	DAD	D		;ADDR OF TABLE ENTRY
	XRA	A		;ZERO
	MOV	M,A		;TRACK ZERO
	MVI	A,200
	CALL	DELAY		;WAIT
	POP	PSW
	RES
	RET
HOMERR:	PRINT	<CR,LF,'ERROR IN HOMING DRIVE '>
	LDA	DRVNO		;SELECTED DRIVE
	CALL	PRNDRV		;PRINT IT
	JMP	ENDFIL		;EXIT
;
;    READ ROUTINE READ SECTOR FROM SELECTED TRACK AND KEEP TRACK OF 
;    ERRORS. DE POINTS TO THE MEMORY BUFFER. THE SECTOR TO BE READ
;    IS IN SNUM.
;
READ0:	MVI	B,88H		;READ WITHOUT HEAD LOAD COMMAND
	LDA	RETRYS		;RETRY COUNT
	STA	ERRORS		;ERROR COUNT
	JMP	READ2		;TO READ ROUTINE
READ1:	MVI	B,8CH		;READ WITH HEAD LOAD COMMAND
	LDA	RETRYS		;RETRY COUNT
	STA	ERRORS		;ERROR COUNT
READ2:	LDA	SNUM		;GET SECTOR NUMBER
	OUT	SECTP		;SET SECTOR NUMBER INTO 1771
READ3:	XCHG
	SHLD	BBLOCK		;POINTER TO START OF CURRENT BLOCK
	MOV	A,B		;GET READ COMMAND
	OUT	DCOM		;SENT IT
READ5:	IN	WAIT		;WAIT TILL COMMAND EXECUTED
	ORA	A		;CHECK ERROR STATUS
	JP	READ6		;DONE IF BIT 7 HI (INTRQ)
	IN	DDATA		;READ DATA
	MOV	M,A		;STORE IT IN BUFFER
	INX	H
	JMP	READ5		;BACK FOR ANOTHER BYTE
READ6:	XCHG
	IN	STATP		;DISK STATUS
	ANI	9DH		;CHECK ERROR BITS
	RZ			;RETURN IF NONE
	LDA	SOFTERR		;SOFT ERRORS
	INR	A
	STA	SOFTERR		;STORE IT BACK
	LDA	ERRORS		;ERROR COUNT
	DCR	A
	STA	ERRORS		;STORE IT BACK
	JZ	RFILL		;RETRY TRYS IF ZERO
	XCHG
	LHLD	BBLOCK		;RESET BUFFER POINTER
	XCHG
	JMP	READ2		;TRY AGAIN FOR RETRY TIMES
RFILL:	LDA	NOFILL		;ERROR FILL FLAG
	ORA	A		;IF ZERO DON'T FILL WITH E5'S
	JNZ	READ8
	SAVE
	LHLD	BBLOCK		;POINTS TO BEGINNING OF READ BLOCK
	MVI	C,128		;COUNTER
	MVI	A,0E5H		;FILL BYTE
READ7:	MOV	M,A		;STORE E5
	INX	H		;INCR POINTER
	DCR	C
	JNZ	READ7		;LOOP FOR 128 BYTES
	JMP	READ9
READ8:	SAV			;SAVE REGISTERS
READ9:	PRINT	<CR,LF,'PERMANENT READ ERROR TRACK '>
READ10:	LHLD	TNUM		;TRACK NUMBER
	DECOUT			;PRINT DECIMAL
	PRINT	<' SECTOR '>
	LHLD	SNUM		;SECTOR NUMBER
	DECOUT
	PRINT	<' DRIVE '>
	LDA	DRVNO		;GET SELECTED DRIVE NO
	CALL	PRNDRV		;PRINT DRIVE NO A THRU C
READ12:	LXI	H,HARDERR	;POINT TO HARD ERRORS
	INR	M		;INCREMENT IT
	MVI	A,0FFH		;SET ERROR FLAG
	RES			;RESTORE REGISTERS
	CALL	CHECKC		;ABORT ON CONTROL C
	RET
;
;    VERIFY ROUTINE READ SECTOR FROM SELECTED TRACK AND KEEP TRACK OF 
;    ERRORS. DE POINTS TO MEMORY BUFFER. (SWAPPED INTERNALLY WITH HL
;    FOR SPEED IN THIS ROUTINE)
;    THE SECTOR NUMBER TO BE READ IS IN SNUM
;
VER0:	MVI	B,88H		;READ WITHOUT HEAD LOAD
	LDA	RETRYS		;RETRY COUNT
	STA	ERRORS		;ERROR COUNT
	JMP	VER2		;TO READ ROUTINE
VER1:	MVI	B,8CH		;READ WITH HEAD LOAD
	LDA	RETRYS		;RETRY COUNT
	STA	ERRORS		;ERROR COUNT
VER2:	LDA	SNUM		;SECTOR NUMBER
	OUT	SECTP		;SET SECTOR NUMBER INTO 1771
	XCHG			;SWAP REGISTERS
	SHLD	BBLOCK		;START CURRENT BLOCK
	MOV	A,B		;GET READ COMMAND
	OUT	DCOM		;SENT IT
VER5:	IN	WAIT		;WAIT TILL COMMAND EXECUTED
	ORA	A		;CHECK ERROR STATUS
	JP	VER8		;DONE IF BIT 7 HI (INTRQ)
	IN	DDATA		;READ DATA
	CMP	M		;COMPARE WITH MEMORY
	INX	H
	JZ	VER5		;BACK FOR ANOTHER BYTE
VER6:	XCHG
	LDA	SOFTERR		;SOFT ERRORS
	INR	A		;INCREMENT IT
	STA	SOFTERR		;STORE IT BACK
	LDA	ERRORS		;ERROR COUNT
	DCR	A		;DECREMENT IT
	STA	ERRORS		;STORE IT BACK
	XCHG
	LHLD	BBLOCK		;RESET MEMORY POINTER
	XCHG
	JNZ	VER2		;TRY AGAIN FOR RETRY TIMES
	PUSH	H
	LXI	H,128		;SECTOR INCR
	DAD	D		;ADD TO MEMORY POINTER
	XCHG
	POP	H
	SAVE			;SAVE REGISTERS
	PRINT	<CR,LF,'PERMANENT VERIFY 0R READ CRC ERROR TRACK '>
	JMP	READ10		;PRINT REST OF ERROR MESSAGE AND RET
VER8:	XCHG			;SWITCH REGISTERS BACK
	IN	STATP		;GET DISK STATUS
	ANI	9DH		;CHECK ERROR BITS
	RZ			;RETURN IF NONE
	XCHG
	JMP	VER6
;
;
;
;    WRITE ROUTINE WRITES A SECTOR ON SELECTED TRACK
;    DE POINTS TO THE MEMORY BUFFER. THE SECTOR NUMBER TO BE WRITTEN
;    IS IN SNUM.
;
WRITE0:	MVI	B,0A8H		;WRITE WITHOUT HEAD LOAD COMMAND
	LDA	RETRYS
	STA	ERRORS
	JMP	WRITE2
WRITE1:	MVI	B,0ACH
	LDA	RETRYS
	STA	ERRORS
WRITE2:	LDA	SNUM		;SECTOR NUMBER
	OUT	SECTP		;OUT TO SECTOR PORT
WRITE3:	MOV	A,B		;COMMAND TO A
	OUT	DCOM		;ISSUE WRITE COMMND
	XTHL
	XTHL
	XTHL
	XTHL
WRITE5:	IN	WAIT		;WAIT TILL COMMAND EXECUTED
	ORA	A		;CHECK ERROR STATUS
	JP	WRITE7		;DONE IF BIT 7 HI (INTRQ)
	LDAX	D		;GET A BYTE FROM MEMORY
	OUT	DDATA		;WRITE TO DISK
	INX	D		;INCR POINTER
	JMP	WRITE5		;BACK FOR ANOTHER BYTE
WRITE7:	XTHL
	XTHL			;SHORT DELAY
	IN	STATP		;READ DISK STATUS
	ANI	0FDH		;CHECK ERROR BITS
	RZ			;RETURN IF NONE
	LDA	SOFTERR		;SOFT ERRORS
	INR	A		;INCREMENT IT
	STA	SOFTERR		;STORE IT BACK
	LDA	ERRORS		;ERROR COUNT
	DCR	A
	JNZ	WRITE1		;TRY AGAIN FOR RETRY TIMES
	SAV
	PRINT	<CR,LF,'PERMANENT WRITE ERROR TRACK '>
	JMP	READ10		;PRINT REST OF ERROR MESS
;
;    RDTRK READS A TRACK FOR VALIDATION OR COPY
;    HL POINTS TO SECTOR MAP, DE POINTS TO MEMORY BUFFER
;
RDTRK:	SAV			;SAVE REGISTERS
	MOV	A,B		;CHECK FOR TRACK 0
	ORA	A
	MVI	A,26		;TRACK ZERO ALWAYS HAS 26 SECTORS
	JZ	RDTA
	LDA	NUMSEC		;COUNT OF SECTORS PER TRACK
RDTA:	MOV	C,A		;TO C
	LDA	DDFLG		;DENSITY FLAG
	ORA	A
	JZ	RDT0
	LDA	DNUMSEC		;SECTORS DOUBLE DENSITY
	MOV	C,A
RDT0:	MOV	A,M		;GET A SECTOR NUMBER
	STA	SNUM		;SAVE SECTOR NUMBER IN MEMORY
	CALL	READ1		;READ WITH HEAD LOAD
RDT1:	INX	H		;INCR SECTOR MAP POINTER
	DCR	C		;DECR SECTOR COUNT
	JZ	RDT4		;EXIT
	ORA	A		;CHECK SECTOR READ RETURN CODE
	JNZ	RDT0		;IF ERROR READ WITH HEAD LOAD
	MOV	A,M		;GET A SECTOR NUMBER FROM MAP
	STA	SNUM		;SAVE SECTOR NUMBER IN MEMORY
	CALL	READ0		;READ DISK WITHOUT HEAD LOAD
	JMP	RDT1		;LOOP FOR NUMSEC SECTORS
RDT4:	RES			;RESTORE REGISTERS
	CALL	CHECKC		;ABORT ON CONTROL C
	RET
;
;
;    WRTRK WRITES AND VERIFIES A TRACK
;    HL POINTS TO SECTOR MAP, DE POINTS TO MEMORY BUFFER
;
WRTRK:	SAV			;SAVE REGISTERS
	MOV	A,B		;CHECK FOR TRACK ZERO
	ORA	A
	MVI	A,26		;TRACK ZERO ALWAYS HAS 26 SECTORS
	JZ	WRTA
	LDA	NUMSEC		;COUNT OF SECTORS PER TRACK
WRTA:	MOV	C,A		;TO C
	LDA	DDFLG		;DENSITY SWITCH
	ORA	A
	JZ	WRT
	LDA	DNUMSEC				;VERIFY FLAG
	ORA	A
	JNZ	WRT20		;NO VERIFY IF NOT ZERO
	LDA	NUMSEC		;SECTOR COUNT
	MOV	C,A		;TO C
	LDA	DDFLG		;DENSITY FLAG
	ORA	A
	JZ	WRT10
	LDA	DNUMSEC		;NUMBER OF SECTORS (MFM)
	MOV	C,A		;TO C
WRT10:	MOV	A,M		;GET SECTOR NUMBER
	STA	SNUM		;SAVE IT
	CALL	VER0		;VERIFY WITHOUT HEAD LOAD
WRT11:	INX	H		;INCR SECTOR MAP POINTER
	DCR	C		;DECR SECTOR COUNT
	JZ	WRT20		;EXIT
	ORA	A		;CHECK READ ERROR RETURN CODE
	JZ	WRT10		;BACK TO READ IF NO ERROR
	PRINT	<CR,LF,LF,'VALIDATING DESTINATION DISK',CR,LF>
	LDA	DEST		;DEST DISK NO
	JMP	REVAL
WRT20:	RES			;RESTORE REGISTERS
	RET
;
;    TRACK READ ROUTINE. TRACK NO IS IN A, HL POINTS TO BUFFER
;
TRKRD:	SAVE
	LXI	H,TRKBUF	;SET POINTER TO TRACK INPUT BUFFER
	CALL	SEEK		;FIND THE TRACK
	MVI	A,0E4H		;READ TRACK COMMAND
	OUT	DCOM		;ISSUE IT
RTF1:	IN	WAIT		;WAIT AND READ DISK STATUS
	ORA	A
	JP	RTF3		;EXIT
	IN	DDATA		;READ DATA
	MOV	M,A		;SAVE BYTE IN MEMORY
	INX	H		;INCR POINTER
	JMP	RTF1		;LOOP TILL INTRQ
RTF3:	RESTORE
	RET
;
;    THIS ROUTINE OFFSETS THE SECTOR MAP BY A CONSTANT (OFFSET) PER TRACK
;    CALLED WITH OFFSET IN A AND HL POINTING TO SECTOR MAP.
;
MAPSLEW:SAVE			;SAVE REGS
	PUSH	H		;SAVE POINTER TO SECTOR MAP ON STACK
	MOV	B,A		;SAVE OFFSET IN B
	XCHG			;SECTOR MAP POINTER TO DE
	LXI	H,NUMSEC	;POINT TO NUMBER OF SECTORS (FM)
	LDA	DDFLG		;DENSITY FLAG
	ORA	A
	JZ	MS0
	LXI	H,DNUMSEC	;NUMBER OF SECTORS (MFM)
MS0:	MOV	C,M		;SECTOR COUNT TO C
	MOV	L,C		;SECTOR COUNT TO L
	MVI	H,0
	MOV	A,B		;OFFSET BACK TO A
	ADD	L		;ADD SECTOR COUNT TO OFFSET
	MOV	B,A		;OFFSET+SECTOR COUNT TO B
	DAD	D		;16 BIT ADD DE TO HL
MS1:	LDAX	D		;GET A SECTOR NO  (DE POINTS TO SOURCE)
	MOV	M,A		;STORE IT  (HL POINTS TO DESTINATION)
	DCR	B		;DECR COUNT OF BYTES TO BE MOVED
	JZ	MS5		;EXIT
	MOV	A,C		;GET NUMBER OF SECTORS
	CMP	B		;DOES B=26
	JNZ	MS3		;JUMP IF NOT
	POP	H		;RESET DESTINATION
	DCX	H		;PRE DECREMENT IT
MS3:	INX	H
	INX	D		;INDEX POINTERS
	JMP	MS1		;LOOP FOR OFFSET+26 ITERATIONS
MS5:	RESTORE			;RESTORE REGS
	RET
;
;    SELECT THE DRIVE IN A
;
SELECT:	SAV
	MOV	C,A
	LXI	H,DRVNO		;POINT TO DRIVE NO
	CMP	M		;COMPARE WITH A
	JZ	SEL5
	MOV	A,M		;OLD DRIVE NUMBER
	MOV	E,A		;OLD DRIVE NO TO E
	MVI	D,0
	LXI	H,TRKTBL	;POINT TO TRACK TABLE
	IN	TRACK		;READ 1771 TRACK REG
	IF	DUAL
	MVI	B,4		;SET ALL TRACKS THE SAME
SEL1:	MOV	M,A		;STORE TRACK
	INX	H		;INCR TRACK TABLE POINTER
	DCR	B
	JNZ	SEL1		;LOOP FOR 4 DRIVES
	ELSE
	DAD	D		;COMPUTE ADDR
	MOV	M,A		;TRACK NO TO TABLE
	ENDIF
	MOV	A,C		;GET NEW DRIVE NO
	ANI	3		;DELETE HEAD SELECT BIT
	MOV	E,A		;NEW DRIVE TO E
	LXI	H,TRKTBL	;POINT TO TRACK TABLE
	DAD	D		;COMPUTE ADDR
	MOV	A,M		;NEW TRACK NO
	ORA	A		;SET FLAGS
	JP	SEL3		;PREV SELECTED IF NOT MINUS
	MOV	A,C		;NEW DRIVE NO
	CALL	SELTARB
	CALL	HOME
	XRA	A		;TRACK ZERO
SEL3:	OUT	TRACK		;SET 1771 TRACK REG
SEL5:	MOV	A,C
	STA	DRVNO		;RESET DRIVE NO
	MOV	A,C		;RESTORE DRIVE NO TO A
	CALL	SELTARB
	RES
	RET
;
;
;  SELTARB SELECT DRIVE (TARBELL CONTROLLER)
;
SELTARB:ADD	A
	ADD	A
	ADD	A
	ADD	A		;SHIFT LEFT 4 BITS
	ORI	2
	STA	LATCH
	CALL	WSHIFT
	RET
;
;
;
;	SWAIT  SHORT WAIT AFTER SELECT TO ALLOW FOR HEAD LOAD TIME
SWAIT:	SAV
	LXI	D,1500		;TIMEING CONST APPROX 15 MSEC
SWAIT1:	DCX	D
	MOV	A,D
	ORA	E
	JNZ	SWAIT1
	RES
	RET
;
;
;    GETNUM  GET A NUMBER FROM INPUT BUFFER AND TEST
;
GETNUM:	SAV
	SCAN	,40H
	JZ	SCANERR		;ERROR IF NO NUMBER
	DECIN			;CONVERT TO DECIMAL
	JC	DECERR		;INPUT ERROR IF CARRY
	SHLD	DECFULL		;SAVE FULL 16 BIT VALUE
	RES
	RET
;
;
;
;    GETRK GETS AND TESTS STARTING AND ENDING TRACK NUMBERS FROM THE INPUT
;    BUFFER. TRACKS STORED IN STRK AND ETRK. ROUTINE RETURNS WITH STRK IN A
;
GETRK:	SAV
	XRA	A		;ZERO
	STA	STRK		;DEFAULT TO 0
	MVI	A,76
	STA	ETRK		;DEFAULT TO 76
	INSTR	82H,40H,'TRACK'	;TRACK SPECIFICATIONS?
	JNC	GT5
	CALL	GETNUM		;GET TRACK NUMBER
	CALL	TRKTEST		;CHECK IT
	STA	STRK		;STARTING TRACK
	STA	ETRK		;SET ENDING TRACK TOO IF NO OTHER SPECIFIED
	INSTR	82H,40H,'-'	;TRACK SEPARATOR
	JNC	GT5
	CALL	GETNUM		;GET ENDING TRACK
	CALL	TRKTEST		;CHECK IT
	STA	ETRK		;ENDING TRACK
GT5:	LDA	STRK		;STARTING TRACK TO A
	RES
	RET
;
;    DBLSUB  16 BIT SUBTRACT DE FROM HL TO HL
;
DBLSUB:	XRA	A		;CLEAR CARRY
	MOV	A,L
	SBB	E		;SUBTRACT LOW BYTES
	MOV	L,A		;BACK TO L
	MOV	A,H
	SBB	D		;SUBTRACT HIGH BYTES
	MOV	H,A		;DIFFERENCE IN HL
	RET
;
;    POLL CONSOLE INPUT FOR CONTROL C
;
CHECKC:	SAV			;SAVE REGS
	PUSH	PSW
	MVI	C,11		;CP/M STATUS POLL CODE
	CALL	5		;CALL	CP/M
	ANI	1		;1 IF CHARACTER WAITING
	JZ	CKC3		;EXIT
	CHARIN			;READ THE CONSOLE
	CPI	3		;WAS IT A CONTROL C
	JZ	ENDFIL		;BACK TO INPUT LOOP
CKC3:	POP	PSW
	RES			;RESTORE REGS
	RET
;
;	READ CONSOLE FOR YES
;
CHECKY: SAV
	CHARIN			;READ CONSOLE
	RES
	CPI	'Y'		;YES
	RZ
	JMP	ENDFIL		;BACK TO INPUT IF NOT YES
;
;
;    SIZE ROUTINE SETS SECTOR SIZES 128, 256, OR 512 BYTES
;
SIZE:	MVI	A,0FFH
	STA	OPTION		;SET OPTION SWITCH
	CALL	GETNUM		;GET SECTOR SIZE
	CPI	128		;128 BYTE SECTOR
	RZ			;STANDARD FORMAT RETURN ZERO SET
SIZE0:	LHLD	DECFULL		;CONVERTED DECIMAL NUMBER
	LXI	D,-256		;COMPARE HL WITH 256
	DAD	D
	MOV	A,H
	ORA	L		;TEST ZERO
	JNZ	SIZE1
	MVI	A,1
	STA	SECSIZ		;256 BYTE SECTORS
	MVI	A,16
	STA	NUMSEC		;NUMBER OF SECTORS
	MVI	A,26
	STA	DNUMSEC
	LXI	H,256
	SHLD	BYTES		;BYTES PER SECTOR
	MVI	A,32		;ADDR LEADER GAP
	STA	GAP
	MVI	A,46
	STA	DGAP		;ADDR LEADER GAP (MFM)
	LXI	H,316		;SECTOR OFFSET (FM)
	SHLD	FILOFF
	LXI	H,359		;SECTOR OFFSET (MFM)
	SHLD	DFILOFF
	RET
SIZE1:	LHLD	DECFULL		;CONVERTED DECIMAL NUMBER
	LXI	D,-512		;COMPARE HL WITH 512
	DAD	D		;ADD TO HL
	MOV	A,H
	ORA	L
	JNZ	SIZE3		;NOT 512 OR 128
	MVI	A,2		;SET SIZE TO 512
	STA	SECSIZ
	LXI	H,512		;BYTES PER SECTOR
	SHLD	BYTES
	MVI	A,8		;SECTORS PER TRACK
	STA	NUMSEC
	MVI	A,16
	STA	DNUMSEC		;SECTORS PER TRACK (MFM)
	MVI	A,50		;ADDR LEADER GAP
	STA	GAP
	MVI	A,64
	STA	DGAP
	LXI	H,590		;OFFSET FOR 512 BYTES (FM)
	SHLD	FILOFF
	LXI	H,633
	SHLD	DFILOFF		;OFFSET FOR 512 BYTES (MFM)
	RET
SIZE3:	LHLD	DECFULL		;CONVERTED DECIMAL NO
	LXI	D,-1024
	DAD	D		;ADD
	MOV	A,H
	ORA	L
	JNZ	SIZE4		;NOT 1024 MUST BE ERROR
	MVI	A,3		;SIZE CODE 1024 BYTE SECTORS
	STA	SECSIZ
	LXI	H,1024
	SHLD	BYTES		;BYTE COUNT
	MVI	A,4		;SECTORS PER TRACK
	STA	NUMSEC
	MVI	A,8		;SECTORS PER TRACK DOUBLE DENSITY
	STA	DNUMSEC
	MVI	A,50		;ADDR LEADER GAP
	STA	GAP
	MVI	A,64
	STA	DGAP
	LXI	H,1102		;OFFSET FOR 1024 BYTE SECTORS FM
	SHLD	FILOFF
	LXI	H,1145
	SHLD	DFILOFF
	RET
SIZE4:	PRINT	<CR,LF,LF,'ERROR IN FORMAT SECTOR SIZE',CR,LF,BEL>
	JMP	ENDFIL
;
;    DENSEL -  SELECT DENSITY
;    FOR TARBELL DOUBLE DENSITY CONTROLLER
;
DENSEL:	CPI	'D'		;DOUBLE DENSITY
	JZ	DENSEL1
	XRA	A
	STA	DDFLG		;SET DENSITY FLAG
	LDA	LATCH
	ANI	0F7H
	STA	LATCH
	CALL	WSHIFT		;SELECT SINGLE DENSITY
	RET
DENSEL1:MVI	A,0FFH
	STA	DDFLG
	LDA	LATCH
	ORI	08H
	STA	LATCH
	CALL	WSHIFT		;SELECT DOUBLE DENSITY
	RET
;
;
;    GETDRV  SEARCH COMMAND STRING FOR DRIVE NAME AND RETURN CODE
;    A..H = 0..7   CARRY SET IF DRIVE PRESENT
;    GETDRV IS CALLED WITH HL POINTING TO STARTING POSITION FOR SEARCH
;
GETDRV:	SAV			;SAVE REGS
	LXI	D,DSKNAME	;POINT TO NAME TABLE
	MVI	C,0		;DRIVE NUMBER
GD1:	SAV
	MVI	B,40H		;STRING LENGTH
	MVI	C,2		;SUBSTRING LENGTH
	INSTR	
	RES
	JC	GD3		;FOUND NAME ON CARRY
	MOV	A,C		;DRIVE NO TO A
	CPI	7		;CHECK LIMIT
	JZ	GD3
	INR	C		;INCR DRIVE NO
	INX	D
	INX	D		;POINT TO NEXT NAME
	JMP	GD1		;LOOP FOR 8 DRIVES
GD3:	MOV	A,C		;DRIVE NO TO A
	RES
	RET
;
DSKNAME:DB	'A:'		;TABLE OF DISK NAMES
	DB	'B:'
	DB	'C:'
	DB	'D:'
	DB	'E:'
	DB	'F:'
	DB	'G:'
	DB	'H:'
;
;   TS
	RRC
	RRC		;SHIFT TO
	RRC
	RRC		;LEAST SIGNFCNT BITS
	MOV	B,A	;SAVE BITS
	MOV	A,C	;GET ORIG BYTE
	ANI	8	;SAVE BIT #3
	ADD	B	;CONSTRUCT WHOLE BYTE
	OUT	WAIT	;SEND IT
	POP	PSW
	POP	B
	RET		;DONE
	ENDIF
;
;
;
;    EQUATES AND DATA ALLOCATIONS
;

SPACE:	DB	' $'		;ASCII SPACE
CRLF:	DB	0DH,0AH,24H	;ASCII CR LF
CNT:	DB	0		;TEMP COUNTER
TNUM:	DW	0		;TRACK NUMBER
SNUM:	DW	0		;SECTOR NUMBER
HARDERR:DW	0		;HARD DISK ERRORS
SOFTERR:DW	0		;SOFT DISK ERRORS
ERRORS:	DB	0		;RETRY COUNTER DURING READ OR VERIFY
VERERR:	DB	0		;VERIFY ERROR FLAG, SET TO FF ON COPY ERROR
VERFLG:	DB	0		;FLAG WHEN FF NO VERIFICATION DURING COPY
NOFILL	DB	0		;FLAG, WHEN TRUE (FF) NO FILL WITH E5 ON ERROR
RETRYS:	DB	0		;MAXIMUM NUMBER OF RETRYS
INFLAG:	DB	0		;FLAG, IF TRUE RETURN FOR MORE CONSOLE INPUT
VALFLG:	DB	0		;VALIDATION FLAG, VALIDATE AFTER FORMAT IF 0
DDFLG:	DB	0		;DOUBLE DENSITY FLAG
SKF:	DB	0		;SKEW FACTOR
TRKLIM:	DB	0		;THE NUMBER OF TRACKS THAT FIT IN MEMORY
OFFSET:	DB	0		;TRACK SECTOR OFFSET
DRIVE:	DB	0		;STORAGE FOR ORIGINALLY LOGGED DRIVE NO
DRVNO	DB	0		;SELECTED DRIVE
NEWDRV:	DB	0		;NEW DRIVE NO
LATCH	DB	0		;LATCH COMMAND
OPTION:	DB	0		;USED TO DECIDE IF TO USE FORMAT CODE FROM DISK
TRKTBL:	DB	0		;TRACK POS A:
	DB	0		;TRACK POS B:
	DB	0		;TRACK POS C:
	DB	0		;TRACK POS D:
SOURCE:	DB	0		;SOURCE DRIVE FOR COPY OPERATION
DEST:	DB	0		;DESTINATION DRIVE FOR COPY
OLDSTK:	DW	0		;OLD STACK POINTER
ENDSTK:	DS	48		;NEW STACK
NEWSTK:	DW	0		;TOP OF NEW STACK
SECSIZ:	DB	0		;SECTOR SIZE CODE FOR FORMAT (0,1 OR 2)
NUMSEC:	DB	0		;NUMBER OF SECTORS PER TRACK
DNUMSEC:DB	0		;NUMBER OF BYTES PER SECTOR (MFM)
FSECT:	DB	0		;SECTOR COUNT USED IN FORMATTING
BYTES:	DW	0		;NUMBER OF BYTES PER SECTOR
GAP:	DB	0		;FORMAT ADDR LEADER GAP
DGAP:	DB	0		;FORMAT ADDR LEADER GAP (MFM)
FILOFF:	DW	0		;SECTOR OFFSET IN TRACK BUFFER (FM)
DFILOFF:DW	0		;SECTOR OFFSET IN TRACK BUFFER (MFM)
FOFF:	DW	0		;TEMP STORAGE FOR SECTOR OFFSET
CPYOFF:	DB	0		;OFFSET USED FOR COPY ROUTINES
TRK:	DB	0		;TRACK NUMBER USED IN FORMATTING DISK
SEC:	DB	0		;SECTOR COUNT USED IN FORMATTING
STRK:	DW	0		;STARTING TRACK FOR FORMAT OR COPY
ETRK:	DW	0		;ENDING TRACK FOR FORMAT OR COPY
STRKR:	DB	0		;STARTING TRACK FOR READ
STRKW:	DB	0		;STARTING TRACK FOR WRITE
PSEC:	DW	0		;PHYSICAL SECTOR
PSEC1:	DW	0		;ANOTHER
LSEC:	DW	0		;LOGICAL SECTOR
LSEC1:	DW	0		;ANOTHER
BBLOCK:	DW	0		;POINTER TO START OF CURRENT READ BLOCK
SECMAP:	DS	104		;PHYSICAL TO LOGICAL SECTOR MAP FOR READ
SECMAP1:DS	104		;SECTOR MAP FOR WRITE
SECMAP0:DS	53		;SECTOR MAP TRACK ZERO - ALWAYS SINGLE DENSITY
TRKSIZE:DW	0		;NO OF BYTES PER TRACK FOR COPY ROUTINES
DENCODE:DB	0		;DOUBLE DENSITY CODE (LAST BYTE SECTOR 1 T 0)
CODE:	DB	0		;SPECIAL CODE FOR DISK ID FOR PASCAL
DENTEMP:DB	0		;TEMP STORAGE FOR DDFLG
SIZTEMP:DB	0		;TEMP STORAGE FOR SECSIZ
SECTEMP:DB	0		;TEMP STORAGE FOR NUMSEC
BYTETEMP:DW	0		;TEMP STORAGE FOR BYTES
GAPTEMP:DB	0		;TEMP STORAGE FOR GAP
OFFTEMP:DW	0		;TEMP STORAGE FOR OFFSET
DDMAP:	DB	1,18,35,10,27,44,2,19,36,11,28,45,3
	DB	20,37,12,29,46,4,21,38,13,30,47,5
	DB	22,39,14,31,48,6,23,40,15,32,49,7
	DB	24,41,16,33,50,8,25,42,17,34,51,9,26,43
;
DDMAP1:	DB	1,35,27,2,36,28,3,37,29,4,38,30,5,39,31
	DB	6,40,32,7,41,33,8,42,34,9,43,18,10,44,19,11,45
	DB	20,12,46,21,13,47,22,14,48,23,15,49,24,16,50
	DB	25,17,51,26
DECFULL:DW	0		;FULL 16 BIT VALUE OF DECIMAL INPUT
IDECNT:	DB	0		;ERROR COUNT FOR ID READ
IDTAB:	DB	0		;ADDR FIELD FOR ID READ
IDTAB1:	DB	0		;ZERO
IDTAB2:	DB	0		;SECTOR ADDR
IDTAB3:	DB	0		;ZERO
IDTAB4:	DB	0		;CRC
IDTAB5:	DB	0		;CRC
TRKBUF:	DB	0		;BUFFER STORAGE
	END
;
;
8,3,37,29,4,38,30,5,39,31
	DB	6,40,32,7,41,33,8,42,34,9,43,18,10,44,19,11,45
	DB	20,12,46,21,13,47,22,14,48,23,15,49,24,16,50
	DB	25,17,51,26
DECFULL:DW	0		;FULL 16 BIT VALUE OF DECIMAL INPUT
IDECNT:	DB	0		;ERROR COUNT FOR ID READ
IDTAB:	DB	0		;ADDR FIELD FOR ID READ
IDTAB1:	DB	0		;ZERO
IDTAB2:	DB	0		;SECTOR ADDR
IDTAB3:	DB	0		;ZERO
IDTAB4:	DB	0		;CRC
IDTAB5:	DB	0		;CRC
	IF	TARBELL
CMD	EQU	0F8H
TRACK	EQU	CMD+1
SECT	EQU	CMD+2
DAL	EQU	CMD+3
WAIT	EQU	CMD+4
;
DMACHK	EQU	CMD+5
ADR0	EQU	0E0H
WCT0	EQU	0E1H
CMND	EQU	0E8H
	ENDIF
;
	IF SUPRQAD
CMD	EQU	0CH
TRACK	EQU	CMD+1
SECT	EQU	CMD+2
DAL	EQU	CMD+3
WAIT	EQU	CMD+8
	ENDIF
 DDT     COM   & ^             DDTX    COM                   512DT   COM                  EDIT    COM                  ;
WSHIFT
	IF	SUPRQAD
	PUSH	B
	PUSH	PSW
	MOV	C,A
	ANI	70H	;SAVE GOOD BITS
	RRC
	RRC
	RRC
	RRC		;SHIFT TO LSB POSITIONS
	MOV	B,A	;SAVE GOOD BITS
	MOV	A,C	;GET ORIG BYTE
	ANI	8	;SAVE BIT 3 ONLY
	ADD	B	;FILL OUT WHOLE BYTE
	OUT	WAIT
	POP	PSW	;RESTORE BYTE AND FLAGS
	POP	B	;RESTORE 'BC'
	RET
	ENDIF
;
	IF	TARBELL
	OUT	WAIT
	RET
	ENDIF
;
 SWEEP35 COM   1 2            TABLE   COM   3                TESTCOPYPRN  L M Q R          TESTCOPYPRN  ZS T U           