interface to CP/M BIOS
;
seldsk	ld	a,(drv)		; select disk drive
	ld	c,a
	ld	de,24
				; this routine links
				; to the desired routine
				; through the standard
				; CP/M BIOS jump table
jpbios	ld	hl,(wboot+1)
	add	hl,de
	jp	(hl)
;
settrk	ld	bc,(trk)	; select track
	ld	de,27
	jr	jpbios
;
setsec	ld	bc,(sec)	; select sector
	ld	de,30
	ld	a,(skew)	; use sector skew?
	or	a,a
	jr	z,jpbios	; no
	call	sectran		; translate sector addr.
	jr	jpbios
;
setdma	ld	bc,(buffer)	; set memory addr.
	ld	de,33
	jr	jpbios
;
setio	call	settrk		; set up track, sector,
	call	setsec		; and memory address
	call	setdma		; for subsequent read
	ret			; or write
;
read				; read one disk sector
	ld	de,36
	jr	jpbios
;
write				; write one disk sector
	ld	de,39
	jr	jpbios
;
sectran				; translate logical to
				; physical sector number
				;
				; call bc = logical sector
				; return bc = physical sector
	push	hl
	ld	hl,sectrb-1
	add	hl,bc
	ld	c,(hl)
	pop	hl
	ret
sectrb	db	1,4,7,10,13	; table built
	db	16,19,22,25,2	; with skew factor = 3
	db	5,8,11,14,17,20
	db	23,26,3,6,9,12
	db	15,18,21,24
;
;	messages for test initialization and
;	error printing
dtsta	db	cr,lf,lf
	db	'Z-80 Floppy Disk '
	db	'Test version '
	db	$ver+'0','.'
	db	$rev+'0',cr,lf
	db	'(c) 1980 Laboratory '
	db	'Microsystems',cr,lf,'$'
dtstb	db	cr,lf,'Itemize '
	db	'errors?    $'

dtstc	db	cr,lf,'Use '
	db	'console or printer'
	db	'? (C/P) $'
dtstd	db	cr,lf,'lock on read '
	db	'or write? (N/R/W) $'
dtste	db	cr,lf,'Restore '
	db	'original data? $'
dtstf	db	cr,lf,'Lock on '
	db	'data pattern? $'
dtstg	db	cr,lf,'Enter data '
	db	'pattern, hex 00-FF$ '
dtsth	db	cr,lf,'Drive '
	db	'to be tested '
	db	'(',$drvf+'A','-'
	db	$drvl+'A',') $'
dtsti	db	cr,lf,'Confirm: test drive '
dtsti1	db	'X ? $'
dtstj	db	cr,lf,'Test all '
	db	'tracks?    $'
dtstk	db	cr,lf,'First '
	db	'track to test     $'
dtstl	db	cr,lf,'Last '
	db	'track to test     $'
dtstm	db	cr,lf,'Test all '
	db	'sectors?    $'
dtstn	db	cr,lf,'First '
	db	'sector to test    $'
dtsto	db	cr,lf,'Last '
	db	'sector to test    $'
dtstp	db	cr,lf,'How many '
	db	'test passes?    $'
dtstq	db	cr,lf,lf,'pass  '
	db	'Drive  Track  '
	db	'Sector Error-type'
	db	cr,lf,'$'
dtstr	db	cr,lf,'pass '
dtstr1	db	'nnnn complete, '
dtstr2	db	'nnnn errors. '
	db	cr,'$'
dtsts	db	cr,lf,'Not enough '
	db	'memory to execute. '
	db	cr,lf,'$'
dtstt	db	cr,lf,lf,'Beginning '
	db	'disk test - push '
	db	'any key to abort '
	db	'program.',cr,lf,'$'
dtstu	db	'Warning: user '
	db	'data will not be '
	db	'restored. ',cr,lf,'$'
dtstv	db	'User data will be '
	db	'restored. ',cr,lf,'$'
dtstw	db	cr,lf,'Continue or '
	db	'exit test? (C/E)$'
dtstx	db	cr,lf
	db	'Goodbye. ',cr,lf,'$'
dtsty	db	cr,lf,'Use sector '
	db	'skew? $'
dtstz	db	cr,lf,'Need CP/M 2.x '
	db	'to execute. ',cr,lf,'$'
merr1	db	'read error - original data$'
merr2	db	'write error - test pattern$'
merr3	db	'read error - test pattern$'
merr4	db	'compare error - test pattern$'
merr5	db	'original data cannot '
	db	'be restored$'
merr6	db	'write error - restore phase$'
merr7	db	'read error - restore phase$'
;
;	utility and console input routines
;
getyn				; get y or n response
				; from operator.
				;
				; call de = address of cue
				; return acc = y or n
	push	de		; save cue address
	ld	c,9		; print cue message
	call	cpm
	ld	de,getyna
	ld	c,9		; print possible answers
	call	cpm
	call	getchar		; get character for consold
	or	a,20h		; fold to lower case
	pop	de		; restore cue address
				; in case needed again
	cp	'y'		; make sure response is ok
	ret	z		; exit is y
	cp	'n'
	ret	z		; exit if n
	push	de
	call	query		; print question mark if
	pop	de		; not y or n, try again
	jr	getyn
getyna	db	'(Y/N) ',tab,'> $'
getl				; get any letter response 
				; from operator.
				;
				; call de = address of cue
				; return acc = ASCII char.
	ld	c,9		; print cue message
	call	cpm
	ld	de,getla	; tab and print
	ld	c,9		; cue mark
	call	cpm
	call	getchar		; read console
	or	a,20h		; fold to lower case
	ret
getla	db	tab,'> $'
;
getn				; get a decimal number
				; from the console.
				;
				; call de = address of cue
				; return hl = number
	push	de		; save cue message address
				; in case needed later
	ld	c,9
	call	cpm		; print cue message
	ld	de,getna	; print tab and cue mark
	ld	c,9
	call	cpm
	ld	hl,0		; initialize forming answer
	ld	a,(digits)
	ld	b,a		; total characters allowed 
				; to be input
getn1	push	hl		; save answer
	push	bc		; save char. count
	call	getchar		; read console
	pop	bc		; restore char. count
	pop	hl		; restore forming answer
	cp	cr		; is this return
	jr	z,getn9		; yes, exit with answer
	cp	'0'		; is this legal	char.?
	jr	c,getn3		; no, jump
	cp	'9'+1		; is this legal char.?
	jr	nc,getn3	; no, jump
	and	0fh		; isolate bottom 4 bits
				; previous data * 10
	push	hl
	pop	de
	add	hl,hl		; *2
	add	hl,hl		; *4
	add	hl,de		; *5
	add	hl,hl		; *10
	ld	e,a		; now add in this digit
	ld	d,0
	add	hl,de
	djnz	getn1		; count characters accepted
	jr	getn9		; enough accepted, exit
getn3				; illegal character detected
	call	query		; print question mark and
	pop	de		; restart input
	jr	getn
getn9				; input complete, clean
				; stack and exit with
				; answer in (hl)
	pop	de
	ret
getna	db	tab,'> $'
getnb	db	'?$'
;
geth				; get $dig hex digits
				; from keyboard
				;
				; call de = addr of cue
				; return acc = lower 8 bits
				; of entered number, 
				;      hl = entire 16 bit number
				;
	push	de		; save cue address
				; in case needed again
	ld	c,9
	call	cpm		; print cue message
	ld	de,getha	; print tab and cue mark
	ld	c,9
	call	cpm
	ld	hl,0		; initialize forming
				; answer
	ld	a,(digits)
	ld	b,a		; max digits to accept
geth1	push	bc		; save registers
	push	hl
	call	getchar		; read console
	pop	hl
	pop	bc		; save registers
	cp	cr		; if carriage return, exit
	jr	z,geth25
	cp	'0'		; make sure its legal
	jr	c,geth3		; no, jump
	cp	'9'+1		; if alpha fold to
	jr	c,geth15	; lower case
	or	20h
geth15	cp	'f'+1		; make sure its legal
	jr	nc,geth3	; no, jump
	cp	'a'		; check if alpha
	jr	c,geth2		; jump if 0-9
	add	9		; add correction
geth2	and	0fh
	add	hl,hl		; previous data *16
	add	hl,hl		; (left shift 4 bits)
	add	hl,hl
	add	hl,hl
	add	a,l		; add this char. to
	ld	l,a		; forming results
	djnz	geth1		; keep reading console
geth25	pop	de		; clean up stack
	ld	a,l		; put lower 8 bits
	ret			; of answer in acc.
				; in case exit by carriage ret.
geth3	call	query		; print question mark
	pop	de		; then restart input
	jr	geth
getha	db	tab,'> $'
;
query	push	af		; save flags
	ld	c,9		; print question mark
	ld	de,querya
	call	cpm
	pop	af		; restore flags
	ret
querya	db	' ?$'
;
getchar				; get 1 character from 
				; console via raw input
				; mode. Do not echo a 
				; carriage return.
	ld	e,0ffh
	ld	c,6
	call	cpm		; read consold
	or	a,a		; anything there?
	jr	z,getchar	; no, try again
	cp	cr		; is it a carriage return?
	ret	z			; ASCII character
	ld	(hl),a		; and store it
	inc	hl		; bump output pointer
	push	de		; bc <- remainder
	pop	bc
	ret
;
div				; single precision divide
				; call bc = numerator
				;      de = divisor
				; return bc = quotient
				;      de = remainder
	push	hl
	ld	hl,0
	or	a,a
	sbc	hl,de
	ex	de,hl
	ld	hl,0
	ld	a,17
div0	push	hl
	add	hl,de
	jr	nc,div1
	ex	(sp),hl
div1	pop	hl
	push	af
	rl	c
	rl	b
	rl	l
	rl	h
	pop	af
	dec	a
	jr	nz,div0
	or	a,a
	rr	h
	rr	l
	ex	de,hl
	pop	hl
	ret
;
buff1	equ	1000h		; disk buffers
buff2	equ	$bpt*2+buff1
buff3	equ	$bpt*2+buff2
buffend	equ	$bpt*2+buff3
;
	end	100h
 remainder
	push	hl
	ld	hl,0
	or	a,a
	sbc	hl,de
	ex	de,hl
	ld	hl,0
	ld	a,17
div0	push	hl
	add	hl,de
	jr	nc,div1
	ex	(sp),hl
div1	pop	hl
	push	af
	rl	c
	rl	b
	rl	l
	rl	h
	pop	af
	dec	a
	jr	nz,div0
	or	a,a
	rr	h
	rr	l
	ex	de,hl
	pop	ingle density
	MVI	A,STPRAT+HLAB	;restore drive
	CALL	EXECC1		;restore to track 0
	MVI	A,1
	OUT	SECTP		;address sector 1
	LXI	H,DIRBF
	CALL	READLS		;read a logical sector
	LDA	DIRBF+7EH
	CPI	0DEH		;double density 16 secs of 512?
	JRZ	DD64
	CPI	0DDH		;double density 51 secs?
	JRZ	DD51
	LXI	H,1*256 + 0	;format flag and density mask
	LXI	D,DPBLK1	;single density parm block
SD2A:	LXI	B,TRANS		;sector translate table
	JMPR	PUT
;
DD51:	LXI	H,2*256 + 8	;as above for 51 secs ddens
	LXI	D,DPBLK2
	JMPR	PUT1

DD64:	LXI	H,3*256 + 8	; 64 logical secs (16 by 512)
	LXI	D,DPBLK3
PUT1:	LXI	B,0
PUT:	MOV	A,L		;disk density mask
	XTHL			; pointer to disk hardware
	ORA	M		;add in density mask
	MOV	M,A		;and save
	STA	DISKHS		; (value for selected disk)
	DCX	H		;back up to format address
	XTHL
	MOV	A,H		;format type
	POP	H
	MOV	M,A		;save type (0, 1, 2, 3)
	STA	DISKHF
	Pk
SD2A:	LXI	B,TRANS		;sector translate table
	JMPR	PUT
;
DD51:	LXI	H,2*256 + 8	;as above for 51 secs ddens
	LXI	D,DPBLK2
	;	  DU.ASM  V7.5	Revised 1/23/81
;	DISK UTILITY - By Ward Christensen
;
;See DU.DOC for description and detailed instructions.
;
;This version of DU is compatible with CP/M 1.4 and 2.x
;and does not require alteration for various hardware
;configurations.  It adjusts itself automatically to
;the correct number of sectors, tracks, directory size,
;etc.  It has been tested on 5-1/4" and 8" floppy, and
;10 megabyte hard disk systems.
;
;Because of the automatic adaption feature, no conditional
;assembly options are included.  The only alteration that
;needs to be done is to use DDT to set the byte at 103h
;to zero for systems using a 2 mHz clock or non-zero for
;4 mHz clock.  This only affects the time delay used in
;the 'sleep' command.
;
;*************************************************
;* 						 *
;*   This program has been heavily modified	 *
;* to allow it to work without modification	 *
;* on most versions of CP/M 1.4 and, hopefully,	 *
;* all versions of CP/M 2.x.			 *
;*   If you have difficulty getting this program *
;* to run, AND if you are using CP/M 2.x, AND	 *
;* if you know your BIOS to be bug-free, leave	 *
;* a message on Technical CBBS of Dearborn,	 *
;* Michigan (313)-846-6127 with a description	 *
;* of the problem and a summary of your hard-	 *
;* ware configuration.				 *
;*   One known possible problem involves the	 *
;* system tracks on some systems, and results	 *
;* from the system sectors being skewed. There	 *
;* is NO way for a program executing under CP/M	 *
;* to know about this.  This program assumes the *
;* standard convention of no skew being used on	 *
;: the system tracks. This usually isn't a prob- *
;* lem because the SYSGEN program can be used to *
;* get the system from the disk so that	it can	 *
;* be modified.					 *
;*   This program should work under standard	 *
;* versions of CP/M 1.4.  The only requirement	 *
;* is that the BIOS "SETSEC" routine not modify	 *
;* the sector number passed to it in the B 	 *
;* register.  Again, system tracks with skewed	 *
;* sectors will be a problem.			 *
;*   If you add any features or make any useful	 *
;* changes to this program, please modem a copy	 *
;* to the above CBBS, so the currency of the	 *
;* program can be maintained.			 *
;* 						 *
;* 		Ron Fowler			 *
;* 						 *
;*************************************************
;
;01/23/81 Changed SETSEC to ignore high-order result of
;	  SECTRN if SPT<256.  This fixes some translation
;	  problems where the BIOS leaves garbage in H. (BRR)
;
;01/15/81 Changed labels to be no more than 6 characters
;	  long.  Moved stack.  Cleaned up file.  (KBP)
;
;01/13/81 Updated help messages for '#' and 'N' commands.
;	  Modified sign-on message.  (RGF)
;
;01/12/81 Fixed problem with sector translation under
;	  CP/M 1.4.  (RGF)
;
;01/11/81 Fixed problem with CP/M 1.4.  Added 'N' command.
;	  Hard-code 'FASTCLOCK' as a boolean at 103h.  Add
;	  fix for sector number being 0 in system tracks,
;	  as suggested by Keith Petersen, W8SDZ. Added '#'
;	  command and memory-full check. Changed login to
;	  position to directory track at every log.  This
;	  is necessary to set up the 'FIRST0' flag.  (RGF)
;
;01/08/81 Corrected error in MAP routine that caused map
;	  to fail when >255 groups allocated.  Changed
;	  'REPEAT' to allow up to 65535 repeats.  (RGF)
;
;01/06/81 Modified to allow use with ALL systems, without
;	  conditional assembly, thru use of disk parameter
;	  block.  By Ron Fowler, Westland, Mich.
;
;01/05/81 Modified '+' and '-' commands as follows:
;		1) + at end of disk now wraps to start
;		2) - at start wraps back to end
;		3) argument for + & - now good to 65535
;				(RGF)
;
;01/03/81 Modified logic in console status test to allow
;	  any non-zero value to indicate char waiting.
;			(RGF)
;
;01/02/81 Made compatible with MACRO80 assembler (labels
;	  made unique within 6 chars, and separated multi-
;	  statement lines).  (RGF)
;
;11/14/80 Corrected missing conditional in CLCSUB routine
;	  for MICROP or DIGDBL.  Cleaned up file.  (KBP)
;
;11/04/80 Forced write type 1 (pre-read and immediate write)
;	  so deblocking BIOS's don't mess up.  Ignore bit 7
;	  in = command unless <nn> form was used.  Display
;	  unprintables as <nn> in V command.  Show user no.
;	  in M command (will always be 00 for 1.4) and only
;	  print parentheses if E5 present.  (BRR)
;
;10/30/80 Fixed bug in backspace/control-X.  Corrected more
;	  bit-7 stuff.	Added 'U' command to change user no.
;	  under CP/M 2.x.  Added pauses in help file. (BRR)
;
;10/27/80 Added Thinkertoys DBL DENS, Micromation DBL DENS,
;	  Industrial Micro Systems DBL and QUAD DENS.
;	  Fixed several bit-7 problems in MAP and DUMP logic.
;	  Added control-X (CRT erase line) to command input
;	  logic.  (Bruce R. Ratoff, ACGNJ-SIG/M)
;
;09/16/80 Fix backspace in line enter routine, add MAXDIR
;	  equate, general cleanup of ASM file. (KBP)
;
;06/22/80 Put in 'Q' command.  Fix so 'P' (printer)
;	  mode outputs L/F's.  (WLC)
;
;05/21/80 Make sector, track, be decimal, not hex.
;	  Also dis-allow a read until positioned.
;	  (DU otherwise not in sync with CP/M)  (WLC)
;
;03/24/80 Mod for Micropolis, Digital Microsystems DD,
;	  and Northstar DD CP/M.  Trap out garbage
;	  during VIEW of file.  By Keith Petersen, W8SDZ
;
;02/24/80 Mod login command to not really do log, just
;	  drive select.  (WLC)
;
;02/12/80 Mod for heath CP/M.  (WLC)
;
;01/08/80 Reposition after 'M' command.  (WLC)
;
;01/07/79 Add VIEW command.  (WLcomments in the code 
;portion of this program - it was just hacked
;together to satisfy my needs, but lots of
;other people found it useful.	Its external
;documentation is good, but its sadly lacking
;comments on the instructions.  (WLC)
;		----------------
;
;System equates
;
BASE	EQU	0	;SET TO 4200H FOR HEATH OR TRS-80 ALTCPM
;
FCB	EQU	BASE+5CH
BDOS	EQU	BASE+5
PRINT	EQU	9
GVERS	EQU	12
RESETDK EQU	13
SELDK	EQU	14
SRCHF	EQU	17	;SEARCH FIRST
SUSER	EQU	32
GETDSK	EQU	25
GETDPB	EQU	31
;
TRNOFF	EQU	15	;CP/M 1.4 OFFSET FROM BASE
			;OF BDOS TO SECTRAN ROUTINE
SKWOFF	EQU	1AH	;CP/M 1.4 OFFSET TO SKEW TABLE
S2OFF	EQU	14	;OFFSET INTO FCB FOR S2 BYTE
DPBOFF	EQU	3AH	;CP/M 1.4 OFFSET TO DPB WITHIN BDOS
S2MASK	EQU	0FH	;MASK FOR EXTENDED RC BITS OF S2
DPBLEN	EQU	15	;SIZE OF CP/M 2.x DISK PARM BLOCK
;
;
;Define ASCII characters
;
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
TAB	EQU	09H	;TAB
BS	EQU	08H	;BACKSPACE
;
	ORG	BASE+100H
;
	JMP	PASTCK	;JUMP OVER CLOCK BYTE AND I.D.
;
CLOCK:	DB	0	;<---PUT NON-ZERO HERE FOR 4 MHZ CLOCK
	DB	'DU.COM ver 7.5 1/23/81'
;
PASTCK:	LHLD	BDOS+1	;GET POINTER TO BDOS ENTRY
	MVI	L,0	;SET HL=BASE OF BDOS
	SPHL		;PUT STACK THERE
	SHLD	SETSTK+1 ;SAVE FOR LATER LXI SP INSTR.
	MVI	C,GVERS	;GET CP/M VERSION NR
	CALL	BDOS
	MOV	A,H	;COMBINE THE TWO BYTE...
	ORA	L	;...VERSION NR FOR A FLAG
	STA	VER2FL	;SAVE IT
;
;Set up local jumps to BIOS
	LHLD	BASE+1	;WARM BOOT POINTER
	LXI	D,3	;READY FOR ADD
	DAD	D	
	SHLD	VCONST+1
	DAD	D
	SHLD	VCONIN+1
	DAD	D
	SHLD	VCONOT+1
	DAD	D
	SHLD	VLIST+1
	DAD	D	;PUNCH
	DAD	D	;RDR
	DAD	D
	SHLD	VHOME+1
	DAD	D
	SHLD	VSELDK+1
	DAD	D
	SHLD	VSETRK+1
	DAD	D
	SHLD	VSTSEC+1
	DAD	D
	SHLD	SETDMA+1
	DAD	D
	SHLD	VREAD+1
	DAD	D
	SHLD	VWRITE+1
	LDA	VER2FL
	ORA	A
	JZ	DOCPM1
	DAD	D	;LISTST
	DAD	D
	SHLD	VSCTRN+1
	JMP	HELLO
;
DOCPM1: LHLD	BDOS+1
	MVI	L,0	 ;BDOS ON PAGE BOUNDARY
	PUSH	H
	LXI	D,TRNOFF ;CP/M 1.4 SECTRAN ROUTINE OFFSET
	DAD	D
	SHLD	VSCTRN+1
	POP	H
	LXI	D,SKWOFF ;CP/M 1.4 SKEW TABLE OFFSET
	DAD	D
	SHLD	SECTBL	 ;SET UP SKEW TABLE POINTER
;
HELLO:	CALL	ILPRT
	DB	CR,LF,'DISK UTILITY ver 7.5',CR,LF
	DB	'Universal Version',CR,LF
	DB	CR,LF
	DB	'Type ? for help',CR,LF
	DB	'Type X to exit'
	DB	CR,LF,0
	CALL	GETSTP	   ;SET UP PARAMETERS
	LXI	H,BASE+80H ;TO INPUT BUFF
	MOV	A,M
	ORA	A
	JZ	PRMPTR	;NO COMMAND
;
;Got initial command, set it up
	MOV	B,A	;SAVE LENGTH
	DCR	B
	JZ	PRMPTR
	LXI	D,INBUF
	INX	H	;SKIP LEN
	INX	H	;SKIP ' '
	CALL	MOVE
	MVI	A,CR
	STAX	D
	LXI	H,INBUF
	JMP	PRMPTI
;
PRMPTR: XRA	A
	STA	QFLAG
	CALL	RDBUF
;
PRMPTI: MVI	A,255
	STA	TOGO	;LOOP COUNT FOR "/"
	STA	TOGO+1
;
PROMPT	EQU	$
SETSTK:	LXI	SP,$-$	;MODIFIED AT INIT
	XRA	A	;ZERO 2-UP PRINT
	STA	TWOUP	;..SWITCH
	MVI	A,1
	STA	FTSW	;TELL SEARCH NOT TO INCR
	PUSH	H
	LXI	H,BASE+100H
	SHLD	BUFAD	;FOR RDBYTE
	POP	H
	CALL	CTLCS	;ABORT?
	JZ	PRMPTR	;..YES, READ BUFFER
;
;Do we have to position in directory after find?
	LDA	FINDFL
	ORA	A
	JNZ	POSDIR	;POSITION IN DIRECTORY
	MOV	A,M
	CPI	CR
	JZ	PRMPTR
	CPI	';'	;LOGICAL CR?
	INX	H
	JZ	PROMPT
	CALL	UPCASE
	STA	DUMTYP	;TYPE OF DUMP (A,D,H)
;
;Command dispatcher
;
	CPI	'+'	
	JZ	 PLUS
;
	CPI	'-'
	JZ	MINUS
;
	CPI	'='
	JZ	SEARCH
;
	CPI	'<'
	JZ	SAVE
;
	CPI	'>'
	JZ	RESTOR
;
	CPI	'#'
	JZ	STATS
;
	CPI	'?'
	JZ	HELP
;
	CPI	'A'
	JZ	DUMP
;
	CPI	'C'
	JZ	CHG
;
	CPI	'D'
	JZ	DUMP
;
	CPI	'F'
	JZ	POSFIL
;
	CPI	'G'
	JZ	POS
;
	CPI	'H'
	JZ	DUMP
;
	CPI	'L'
	JZ	LOGIN
;
	CPI	'M'
	JZ	MAP
;
	CPI	'N'
	JZ	NEWDSK
;
	CPI	'P'
	JZ	PRNTFF
;
	CPI	'Q'
	JZ	QUIET
;
	CPI	'R'
	JZ	DOREAD
;
	CPI	'S'
	JZ	POS
;
	CPI	'T'
	JZ	POS
;
	CPI	'U'	;******CP/M 2.x ONLY******
	JZ	USER
;
	CPI	'V'
	JZ	VIEW
;
	CPI	'W'
	JZ	DORITE
;
	CPI	'X'
	JZ	BASE
;
	CPI	'Z'
	JZ	SLEEP
;
	CPI	'/'
	JZ	REPEAT
;
WHAT:	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'?',0
	JMP	PRMPTR
;
;Memory full error
;
MEMFUL: XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'+++ Out of memory +++'
	DB	CR,LF,0
	JMP	PRMPTR
;
;Print disk statistics
;
STATS:	PUSH	H
	CALL	ILPRT
	DB	'Disk Information:',CR,LF
	DB	'Tracks:',9,9,0
	LHLD	MAXTRK
	INX	H
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Sec/trk:',9,0
	LHLD	SPT
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Grpsize:',9,0
	LDA	BLM
	INR	A
	MOV	L,A
	MVI	H,0
	CALL	DEC
	CALL	ILPRT
	DB	' (sectors per group)',CR,LF
	DB	'Tot grps:',9,0
	LHLD	DSM
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Dir entries:',9,0
	LHLD	DRM
	INX	H
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Sys tracks:',9,0
	LHLD	SYSTRK
	CALL	DEC
	CALL	CRLF
	POP	H
	JMP	PROMPT
;
;The following command resets the disk
;system thru CP/M, and may be usable for
;changing the disk density or format.
;This can only be done if your BIOS resets
;the auto-density select parameters at
;every track-zero access.
;
NEWDSK: PUSH	H
	MVI	C,RESETDK
	CALL	BDOS
	LDA	DRIVE
	MOV	C,A
	POP	H
	CALL	SELECT
	JMP	PROMPT
;
;Quite mode
;
QUIET:	STA	QFLAG	;NOW QUIET
	JMP	PROMPT
;
;Repeat buffer contents
;
REPEAT: CALL	DECIN	;NN SPECIFIED?
	MOV	A,D
	ORA	E
	JZ	NNN	;NO.
	LHLD	TOGO
	INX	H	;TEST FOR FIRST TIME
	MOV	A,H
	ORA	L	;WAS IT 0FFFFH?
	JNZ	NNN	;NO: COUNTING
	XCHG		;GET COUNT
	SHLD	TOGO	;SET COUNT
;
NNN:	LHLD	TOGO
	XCHG
	LXI	H,INBUF	;READY TO REPEAT
	INX	D	;TEST FOR 0FFFFH
	MOV	A,D
	ORA	E
	JZ	PROMPT	;CONTINOUS
	DCX	D	;COUNT DOWN
	DCX	D	;MAKE UP FOR PREV INX D
	XCHG
	SHLD	TOGO
	MOV	A,H	;ALL DONE?
	ORA	L
	XCHG		;GET BACK INBUF PTR
	JNZ	PROMPT	;NO, KEEP GOING
	JMP	PRMPTR	;ALL DONE
;
;Set CP/M 2.x user number
;
USER:	LDA	VER2FL
	ORA	A
	JZ	WHAT
	CALL	DECIN		;GET REQUESTED USER NO.
	MOV	A,E
	CPI	32		;VALID?
	JNC	WHAT
	MOV	A,D
	ORA	A
	JNZ	WHAT
	MVI	C,SUSER
	PUSH	H		;SAVE CHAR POINTER
	CALL	BDOS		;SET USER NO.
	POP	H
	JMP	PROMPT
;
;Toggle print flag
;
PRNTFF:	LDA	PFLAG
	XRI	1
	STA	PFLAG
	JMP	PROMPT
;
;Sleep routine, in tenths of a sec
;
SLEEP:	CALL	HEXIN	;GET COUNT IF ANY
	MOV	A,E	;ANY?
	ORA	A
	JNZ	SLEPLP
	MVI	E,10
;
SLEPLP:	LXI	B,8000	;APPROX .1 SEC @ 2MHz
	LDA	CLOCK
	ORA	A
	JZ	SLEEP2
	LXI	B,16000	;APPROX .1 SEC @ 4 MHz
;
SLEEP2: DCX	B
	MOV	A,B
	ORA	C
	JNZ	SLEEP2
	PUSH	D
	CALL	CTLCS
	POP	D
	JZ	PRMPTR
	DCR	E
	JNZ	SLEPLP
	JMP	PROMPT
;
;Check for control-C or S
;
CTLCS:	CALL	CONST
	ORA	A
	JNZ	GETC
	ORI	1	;NO CHAR, RETN NZ
	RET
;
GETC:	CALL	CONIN
	ANI	1FH	;ALLOW ASCII
	CPI	'S'-40H
	CZ	CONIN
	CPI	'C'-40H
	RET		;0 SET IF CTL-C
;
;Find our way at initialization
;
GETSTP: MVI	C,GETDSK
	CALL	BDOS	;GET CURNT DSK
	MOV	C,A	;  WE HAVE TO SELECT
	JMP	SELECT	;  TO GET THE DPH
;
LOGIN:	CALL	DOLOG
	JMP	PROMPT
;
DOLOG:	MOV	A,M	;DISK REQ?
	LXI	D,0
	CPI	CR
	JZ	LGNODK
	CPI	';'
	JZ	LGNODK
	CALL	UPCASE
	INX	H
	SUI	'A'
	MOV	C,A
;
SELECT: PUSH	H
	MOV	A,C
	STA	DRIVE	;REMEMBER LATER WHERE WE ARE
;
VSELDK: CALL	$-$	;ADDR FILLED IN BY 'INIT'
	LDA	VER2FL
	ORA	A	;IF NOT CP/M 2.x ...
	JZ	SELSKP	;..THEN SKIP THIS JUNK
	MOV	A,H
	ORA	L
	JZ	WHAT	;SELECT ERROR
	MOV	E,M	;GET THE SECTOR TABLE PNTR
	INX	H
	MOV	D,M
	INX	H
	XCHG
	SHLD	SECTBL
	LXI	H,8	;OFFSET TO DPBPTR
	DAD	D
	MOV	A,M	;PICK UP DPB POINTER
	INX	H	;  TO USE
	MOV	H,M	;  AS PARAMETER
	MOV	L,A	;  TO LOGIT
;
SELSKP: CALL	LOGIT
	LHLD	SYSTRK	;RESET TRACK AND SECTOR
	XCHG		;  TO DIRECTORY
	CALL	SETTRK	;  ON EVERY
	LXI	D,1	;  LOGIN
	CALL	SETSEC	;  CHANGE
	LHLD	PHYSEC	;THIS LOGIC WILL TELL
	MOV	A,H	;  IF FIRST SEC
	ORA	L	;  IS PHYSICAL 0
	STA	FIRST0
	CALL	CLCSUB
	POP	H
;
LGNODK: CALL	NORITE
	RET
;
;Read in the disk directory
;
REDDIR:	PUSH	H
	CALL	NORITE	;POSITIONING LOST
	LHLD	SYSTRK
	SHLD	CURTRK
	LXI	H,1
	SHLD	CURSEC
	LHLD	DRM	;GET
;
MAP:	CALL	REDDIR	;READ IN DIRECTORY
	MVI	C,0	;INIT START GRP #
	LDA	AL0	;READ DIR GRP BITS
	CALL	COLECT	;COLLECT COUNT OF DIR GRPS..
	LDA	AL1	;..IN REGISTER C
	CALL	COLECT
	MVI	B,0	;BC NOW HAS A DEFAULT START GRP #
	CALL	HEXIN
	PUSH	H	;SAVE INBUF PTR
	MOV	A,E	;GET START
	ORA	D	;NOTHING?
	JZ	MAPDF	;..YES, DFLT
	MOV	B,D
	MOV	C,E
;
MAPDF:	CALL	HEXB
	MVI	A,'-'
	CALL	TYPE
	CALL	GETGRP	;GET GRP(C) TO HL
;
MAPCNT:	INX	B	;NEXT GRP #
	PUSH	H
	LHLD	DSM	;GET HIGHEST GRP #
	INX	H	;PLUS 1 FOR COMPARISON
	MOV	A,L	;WHEN BC REACHES DSM+1..
	CMP	C	;..THEN WE HAVE EXCEEDED..
	JNZ	MAPC1	;..THE DISK CAPACITY..
	MOV	A,H
	CMP	B
;
MAPC1:	POP	H
	JZ	MAPEND	;..AND WE ARE DONE
	PUSH	H
	CALL	GETGRP	;GET ANOTHER
	POP	D	;SEE IF SAME
	CALL	CTLCS
	JZ	MAPND2
	MOV	A,D
	CMP	H
	JNZ	MAPDIF
	MOV	A,E
	CMP	L
	JZ	MAPCNT	;SAME, CONTINUE
;
;Different file encountered
MAPDIF:	DCX	B
	CALL	HEXB
	INX	B
	XCHG
	CALL	MAPNAM
	JMP	MAPDF
;
;End of map
;
MAPEND: DCX	B	;GET LAST
	CALL	HEXB
	CALL	MAPNAM
	POP	H
	CALL	CRLF
;
;End of map - reposition to previous group
;
MAPND2: PUSH	H
	LHLD	GROUP
	XCHG
	JMP	POSGP2
;
;Print file name pointed to by HL
;
MAPNAM:	CALL	SPACE
	MOV	A,H
	ORA	L	;NONE?
	JZ	NONAME
	MOV	A,M	;SEE IF ALLOC
	CPI	0E5H	;FREE?
	MVI	A,' '
	JNZ	MPNSP1
	MVI	A,'('
;
MPNSP1: CALL	TYPE
	PUSH	H	;SAVE POINTER
	MOV	A,M
	CALL	HEX	;SHOW USER NUMBER
	CALL	SPACE
	INX	H	;SKIP USER BYTE
	PUSH	B
	MVI	B,8
	CALL	MAPN2
	MVI	A,'.'
	CALL	TYPE
	MVI	B,3
	CALL	MAPN2
	POP	B
	CALL	SPACE
	MOV	A,M	;GET EXT
	CALL	HEX
	POP	H
	MOV	A,M
	CPI	0E5H
	MVI	A,' '
	JNZ	MPNSP2
	MVI	A,')'
;
MPNSP2: CALL	TYPE	;")" IF ERASED FILE
	JMP	FLIP
;
NONAME: CALL	ILPRT
	DB	'    ++FREE++        ',0
;
FLIP:	LDA	TWOUP
	XRI	1
	STA	TWOUP
	JZ	CRLF
;
DELIM:	MVI	A,':'
	CALL	TYPE
	JMP	SPACE
;
;Print name, length in B
;
MAPN2:	MOV	A,M
	ANI	7FH	;STRIP POSSIBLE 2.x ATTR