MF)
	INC	BC			; count passes
	LD	(MEMF),BC
	LD	HL,MEMG1		; convert pass count
	CALL	CHA
	LD	BC,(MEME)
	LD	HL,MEMG2		; convert error count
	CALL	CHA			; this pass
	LD	BC,(MEMX)
	LD	HL,(MEME)
	ADD	HL,BC			; accumulate errors for all passes
	LD	(MEMX),HL
	PUSH	HL			; format cumulative
	POP	BC			; errors
	LD	HL,MEMG23
	CALL	CHA
	LD	A,CR			; set up output to skip AND & OR of
					; failing memory address if no errors
					; have been found
	LD	(MEMG25),A
	LD	HL,(MEMX)
	LD	A,H			; make sure no errors
	OR	A,L
	JR	Z,MEM67			; none yet, jump
	LD	A,' '  			; remove the carriage return 
					; from output string....
	LD	(MEMG25),A
	LD	BC,(MEMK)
	LD	HL,MEMG3		; convert logical AND
	CALL	CHA			; of failing address
	LD	BC,(MEML)
	LD	HL,(MEMG4)		; convert logical OR
	CALL	CHA			; of failing address
MEM67					; now print pass audit
	LD	HL,MEMG
	CALL	DSPLY
	LD	A,(MEMJ)		; rotate bit crosstalk pattern so that
	RLCA	
	LD	(MEMJ),A		; eight passes all bit 
					; patterns will be used
	POP	DE			; restore LBA+1
	JP	MEM1			; start another pass
;
;
; Error  auditing routine.
; Console outputt of the form:
;
; A=xxxx  P=xx  C=xx  Xor=xx  Error-type
;
; A = failing address
; P = calculated pattern
; C = actual contents of address
; Xor = exclusive OR of pattern and contents
;        (isolates failing bit)
; Error-type = Rd presumed read (soft) error
;              Wt presemed write (hard) error
;
;
ERR1	PUSH	AF			; possible write error
	LD	A,'W'
	LD	(MEMD5),A
	LD	A,'t'
	LD	(MEMD5+1),A
	POP	AF
	JR	ERROR
;
ERR2	PUSH	AF			; possible read error
	LD	A,'R'
	LD	(MEMD5),A
	LD	A,'d'
	LD	(MEMD5+1),A
	POP	AF
;
ERROR					; error auditing routine
	PUSH	BC			; save registers
	PUSH	DE
	PUSH	HL
	PUSH	AF
	XOR	B			; logical exclusive OR
					; of calculated pattern and actual
					; memory contents
;					; 
	LD	C,A
	LD	HL,MEMD4		; convert OR for output
	CALL	CHAB
	POP	AF			; get memory contents and convert
					; it for output
	LD	C,A
	LD	HL,MEMD3
	CALL	CHAB
	LD	C,B			; convert pattern
	LD	HL,MEMD2
	CALL	CHAB
	POP	BC			; convert current
	PUSH	BC			; memory address
	LD	HL,MEMD1
	CALL	CHA
	LD	HL,(MEME)
	INC	HL			; count errors this pass
	LD	(MEME),HL
	POP	DE			; get current memory
	PUSH	DE			; address
	LD	HL,(MEMK)
	LD	A,D			; save logical AND of 
	AND	H			; failing addresses
	LD	H,A
	LD	A,E
	AND	L
	LD	L,A
	LD	(MEMK),HL
	LD	HL,(MEML)
	LD	A,D			; save logical OR o
	OR	H			; failing addresses
	LD	H,A
	LD	A,E
	OR	L			; 
	LD	L,A
	LD	(MEML),HL

	LD	A,(MEMP)		; check itemize errors flag
	OR	A
	JR	Z,ERR9			; skip print of flag=0
	LD	HL,MEMD			; print error audit
	CALL	DSPLY
ERR9	POP	HL			; restore registers
	POP	DE
	POP	BC
	RET
;
;
; Compute test data pattern for given memory address.
;
; Call with HL = memory address
;            C = pattern counter
;
; Return     A = data pattern
;
PATTN					; pattern computation
	PUSH	HL
	LD	B,0			; branch on pattern
	LD	HL,PATT0-2
	ADD	HL,BC
	ADD	HL,BC
	EX	(SP),HL			; (restore memory address)
	RET				; (branch)
PATT0	JR	PAT1			; 1. Cambridge pattern
	JR	PAT2			; 2. Address
	JR	PAT3			; 3. Alternate 1s and 0s
	JR	PAT4			; 4. Address inverse
	JR	PAT5			; 5. Alternate 0s and 1s
	JR	PAT6			; 6. All ones
	JR	PAT7			; 7. Cambridge inverse
	JR	PAT8			; 8. All zeros
	JR	PAT9			; 9. Bit crosstalk
	JR	PAT10			; 10.Bit crosstalk inverse
;
PAT1	LD	A,L			; Cambridge pattern
	RRCA
	RRCA
	RRCA
	XOR	H
	AND	1
	JR	Z,ONES
ZEROS	XOR	A
	RET
ONES	LD	A,0FFH
	RET
;
;
PAT2	LD	A,L			; address
	RET
;
;
PAT3	LD	A,0AAH			; alternate 1s and 0s
	RET
;
;
PAT4	LD	A,L			; address inverse
	CPL
	RET
;
;
PAT5	LD	A,55H			; alternate 0s and 1s
	RET
;
;
PAT6	EQU	ONES			; all bits = ones
;
;
PAT7	LD	A,L			; Cambridge pattern inverse
	RRCA
	RRCA
	RRCA
	XOR	H
	AND	1
	JR	Z,ZEROS
	JR	ONES
;
;
PAT8	EQU	ZEROS			; all bits = zero
;
;
PAT9	LD	A,L			; bit crosstalk
	RRA
	JR	C,PAT91
	LD	A,(MEMJ)
	RET
PAT91	LD	A,(MEMJ)
	CPL
	RET
;
;
PAT10	LD	A,L			; bit crosstalk inverse
	RRA
	JR	NC,PAT91
	LD	A,(MEMJ)
	RET
;
;
;
;
;  Binary to hex ASCII conversion
;
;  Call          HL  =  address for 4 character ASCII output string
;
;                BC  =  16 bit binary data
;
;  Returns       HL,DE,BC unchanged
;                A  =  garbage
;
;
CHA	PUSH	HL			; save registers
	PUSH	DE
	PUSH	BC
	INC	HL
	INC	HL
	INC	HL
	LD	D,4			; character counter
CHA1	LD	A,C			; next 4 bits
	AND	0FH
	CP	0AH			; is it A-F?
	JR	C,CHA15		; no
	ADD	7			; yes
CHA15	ADD	'0'			; form ASCng
;
;                  C = 8 bit binary data
;
;  Return         HL,DE,BC unchanged, A destroyed
;
CHAB	PUSH	HL			; save registers
	PUSH	DE
	PUSH	BC
	INC	HL
	LD	D,2
	JR	CHA1
;
;
;  Print character string
;
;  Call          HL = first byte address of output string
;                     (must end with ASCII carriage return)
;
;
DSPLY	CALL	CRLF
DSPLY1	LD	A,(HL)
	CALL	CO			; send this character
	CP	CR			; end of string?
	RET	Z			; yes, exit
	INC	HL			; no, bump string pointer
	JR	DSPLY1
;
;
;  Get keyboard entry of hex image
;
;  Return   HL = 16 bit binary data .
;
ENTR	LD	HL,0			; initialize data
	CALL	CRLF			; send carriage return
					; and line feed
	LD	A,'>'			; send a cue mark
	CALL	CO
	LD	C,4			; char counter
ENTR1	CALL	CIW			; get 1 character
	CALL	CO			; echo it
	CP	CR			; carriage return?
	RET	Z			; yes, exit
	CP	'A'			; is it 0-9?
	JR	C,ENTR15		; yes
	AND	A,0DFH			; no, force lower case
ENTR15					; shift previous data
					; left 4 bits
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	JR	C,ENTR3			; if overflow, print?
	CP	'0'			; is it 0-F?
	JR	C,ENTR3			; illegal character
	CP	'F'+1
	JR	NC,ENTR3		; illegal character
	CP	'A'			; is it A-F?
	JR	C,ENTR2			; no, its 0-9
	ADD	9			; add fudge factor
ENTR2	AND	0FH			; isolate 4 bits
	OR	L			; merge with previous data
	LD	L,A
	DEC	C			; count characters
	RET	Z			; exit if 4 received
	JR	ENTR1			; get another character
ENTR3	LD	A,'?'			; print question mark
	CALL	CO			; and restart entry
	JR	ENTR
;
;
;  Print carriage return and line feed
;
;
CRLF	LD	A,CR
	CALL	CO
	LD	A,LF
	CALL	CO
	RET
;
;
;  Miscellaneous messages and data area
;
MEMA	DB	LF,'laboratory  '
        DB      'Microsystems  Z-80'
        DB      ' Memory test  '
        DB      ' version 2.3',Lf,Cr
MEMB    Db      'Enter address of first  '
        Db      'memory byte to test: ',Cr
MEMC    Db      'Enter address of last  '
        Db      'memory byte to test: ',Cr
MEMD    Db      'Address='
MEMD1   Db      '$$$$  Pattern='
MEMD2   Db      '$$  Contents='
MEMD3   Db      '$$  Xor='
MEMD4   Db      '$$  Type='
MEMD5   Db      '   ',Cr
MEME    Dw      0			; errors this pass
MEMF	DW	0			; pass count
MEMG    Db      '$$$$-$$$$  Pass: '
MEMG1   Db      '$$$$  Errors:  '
MEMG2   Db      '$$$$  Cum.  Errors:  '
MEMG23  Db      '$$$$ '
MEMG25  Db      Cr,'And: '
MEMG3   Db      '$$$$  Or:  '
MEMG4   Db      '$$$$',Cr
MEMI	DW	0			; first byte address to test
MEMJ	DB	0FEH			; bit crosstalk pattern
MEMK	DW	-1			; logical AND of failing addresses
MEML	DW	0			; logical OR of failing addresses
MEMM	DB	Lf,'Goodbye',Cr
MEMN    Db      'I=itemize errors,  '
        Db      'T=print error total only, '
        Db      'E=exit test',Cr
MEMP	DB	0			; flag 1=itemize, 0=total
MEMQ    DB      'Operating System '
        DB      'destroyed, manual '
        Db      'reset is needed. ',Cr
MEMR	DW	0			; address of first byte
					; of operating system
MEMS	DB	0			; actual first byte of OS
					; before testing begins
MEMT	DB	'End of program used as first '
        DB      'address to test = '
MEMT1   Db      '$$$$',Cr
MEMU    Db      'Error: last byte address less '
        Db      'than first byte address. ',Cr
MEMV    Db      Lf
        Db      'To abort test push any key'
        Db      Cr
MEMW    Db      'Warning:  Operating system '
        Db      'will be destroyed.',Cr
MEMX    Dw	0			; cumulative error count
;
;
;  Return (in Acc) one character from console. ;
;
CIW	CALL	CI
	OR	A			; anything there?
	JR	Z,CIW			; no, loop
	RET				; got character, return
;
;
;  Read console status and input a character (in Acc) if waiting,
;  else, return Acc = zero.
;
;
CI	PUSH	BC			; save register
	LD	A,($STAT)
	LD	C,A
	LD	A,($RDA)
	LD	B,A
CIL	IN	A,(C)			; read status port
	AND	B			; check if character waiting now
	JR	NZ,CI2			; yes, jump
	POP	BC			; no, restore
	RET				; register and return
CI2	LD	A,($DATA)		; read data port
	LD	C,A
	IN	A,(C)
	POP	BC			; restore register
	AND	7FH			; strip parity bit
	CP	ESC			; if now escape code
	RET	NZ ; return to caller
					; if escape code, restart test
	LD	SP,STACK
	JP	MEM01
;
;
;  Write one character (in Acc) to console.
;
;
CO	PUSH	BC			; save registir
	PUSH	AF
	LD	A,($STAT)
	LD	C,A
	LD	A,($TBE)
	LD	B,A
CO1					; read status port
	IN	A,(C)
	AND	A,B			; check if transmit busy
	JR	Z,CO1			; yes, loop
	LD	A,($DATA)		; no, send character
	LD	C,A
	POP	AF			; (restore data)
	OUT	(C),A			; (sent it)
	POP	BC			; (restore other register)
	RET				; return to caller
;
;
TEND	EQU	$+2
	END	100H

ACK
	JP	MEM01
;
;
;  Write one character (in Acc) to console.
;
;
CO	PUSH	BC			; save registir
	PUSH	AF
	LD	A,($STAT)
	LD	C,A
	LD	A,($TBE)
	LD	B,A
CO1					; read status port
	IN	A,(C)
	AND	A,B			; check if transmit busy
	JR	Z,CO1			; yes, loop
	LD	A,($DATA)		; no, send character
	LD	C,A
	POP	AF			; (restore data)
	OUT	(C),A			; (sent it)
	POP	BC			; (restore ot
READLS:	PUSH	B		;save	bc, de
	PUSH	D
	LXI	B,ERCNT*256 + WAIT
RRTRY:	MVI	A,80H
	OUT	DCOM		;read a block
	CALL	HDLAY		;delay for head load
	PUSH	H
	XCHG
	LXI	H,RLOOP		;set up for fast transfer
RLOOP:	INP	A		;read port c and set status
	JP	RDONE
	IN	DDATA		;read byte
	STAX	D
	INX	D
	PCHL
;
RDONE:	IN	DSTAT
	ANI	9DH
	JRZ	REXIT		;return on good read
	POP	H
	DJNZ	RRTRY
	ENDIF

	LXI	H,RDERR
	CALL	PMSG		;read error message
	MVI	A,1
	ORA	A		;set status
	JMPR	REXIT1

	IF	NOT DMACNTL
REXIT:	XCHG			;put next address in hl
	ENDIF

REXIT2:	POP	D		;throw away orig. dma
REXIT1:	POP	D		;restore de
	POP	B		;restore bc
	RET
;
;-write logical sector-
;bc, de unchanged
;hl is dma address
;hl returned hl + length
;
	IF	DMACNTL		;if using dma
WRITEL:	PUSH	B		;save bc
	PUSH	D		;save de
	MVI	A,ERCNT		;retry count
WRTRY:	STA	RTCNT		;save it
	PUSH	H		;save dma address
	LXI	B,FWRIT SHL 8 OR WCT0
	LDA	DISKHF		;check if deblocking
	CPI	3		;if = 3, deblocking
	LXI	D,DMAW SHL 8 OR B512
	;	1/3/82	PORTS AND MASKS SET FOR KTM
;
;	*************************************************
;	***   MODMTERM.ASM   11/25/80   DICK JOSLIN   ***
;	*************************************************
;
;	MODEM ROUTINE FOR DUMB TERMINAL
;
;	************* NOTE *****************
;	THIS ROUTINE USES 'READY NOT' BITS BECAUSE MY
;	COMPUTER IS SET-UP THAT WAY.  IF YOU USE THE
;	'READY' BIT, THEN CHANGE THE 'JZ' INSTNS TO 'JNZ'
;	AND CHANGE THE 'JNZ' INSTNS TO 'JZ'
;
;	THE PURPOSE OF THIS PROGRAM IS TO GET YOUR NEW
;	MODEM 'ON-LINE' WITH MINIMUM SOFTWARE.  MANY MORE
;	ELABORATE OPERATING PROGRAMS ARE AVAILABLE AFTER
;	YOU HAVE THE HARDWARE BUGS IRONED OUT.
;
;	DATA FROM THE PHONE LINE IS FIRST STORED INTO A
;	1 PAGE BUFFER (256 BYTES) BEGINNING AT 200H.  THIS
;	AVOIDS THE USE OF 'WAIT' LOOPS FOR BUSY DEVICES.
;
;	THE PRINTER MAY BE TURNED ON AND OFF BY USE OF THE
;	'CNTL P' KEYS, AS WITH MOST CP/M UTILITIES.
;
;	'CNTL X' REBOOT TO CP/M ADDED
;
;	SET THESE TWO EQUATES TO YOUR CONSOLE PORT ADDRESSES
;
TRUE	EQU	-1
FALSE	EQU	0
;
IMSAI	EQU	FALSE
KTM	EQU	TRUE
;
	IF IMSAI
CONST	EQU	00H	;CONSOLE STATUS
CONDTA	EQU	01H	