 BYTE MASK
;
	IF	IMSAI
	JNZ	LOOP	; IF BIT 8 = 0, PRINTER CLEAR
	ENDIF
;
	IF	KTM
	JZ	LOOP
	ENDIF
;
	LDA	SAVE	; GET THE CHARACTER
	OUT	DATA	; SENT IT
;
	JMP	START	; RECYCLE
;
SAVE	DB	0	; CHARACTER STORAGE
	END
;


	IF	KTM
	JZ	START
	ENDIF
;
	IN	DATA	; DATA PORT IO-4 SERIAL 'A'
	ANI	7FH	; STRIP BIT 8
	STA	SAVE	; STORE THE CHARACTER
;
	CPI	CTLC	; IS IT '^C'
	JZ	REBOOT	; IF SO RETURN TO CPM
;
LOOP	IN	STAT	; READ SERIAL PORT 'A' STATUS
	ANI	MASKOT	; PRINTER; 512SQDT.ASM	2/12/83		**DJ**
;	SUPER QUAD DISK PORTS ADDED
;double density test aid
;
;this program allows you to test double density
;disk which run with the new tarbell double
;density board.
;this program will read an entire disk and keep
;a running tab of errors. at the completion of the
;test, the type of errors found will be displayed.
;this program in conjunction with the 'dformat'
;program will allow  you to optimize your disk for
;the lowest amount of errors.
;
	MACLIB	MCROTRBL
	MACLIB	SKEW
;
TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
;
TARBELL	EQU	FALSE
SUPRQAD	EQU	NOT TARBELL
;
FIRST	EQU	1		;first sector on disk
LAST	EQU	26		;last sector on disk
SKEWFSD	EQU	6		;skew factor for single density
SKEWFDD	EQU	1		;skew factor for double density
SECTDDB	EQU	16		;last sector for deblocked disk
SKFDEBL	EQU	4		;skew factor for deblocked
BELL	EQU	7		;bell code
BS	EQU	8		;back space code
BDOS	EQU	5
WBOOT	EQU	0
;
ADR0	EQU	0E0H		;dma address register port
WCT0	EQU	ADR0+1
CMND	EQU	ADR0+8
;
	IF	TARBELL
CMD	EQU	0F8H
STATUS	EQU	CMD
TRK	EQU	CMD+1
SEC	EQU	CMD+2
DAL	EQU	CMD+3
WAIT	EQU	CMD+4
INTRQ	EQU	CMD+5		;intrq port from 1791
	ENDIF
;
	IF	SUPRQAD
CMD	EQU	0CH
STATUS	EQU	CMD
TRK	EQU	CMD+1
SEC	EQU	CMD+2
DAL	EQU	CMD+3
WAIT	EQU	CMD+8
INTRQ	EQU	WAIT
	ENDIF
;
RCMD	EQU	80H
STPRT	EQU	1		;0=3ms,1=6ms,2=10ms,3=15ms
HLAB	EQU	8		;0=no head load at beginning of seek
SEEK	EQU	10H+HLAB+STPRT	;seek command
RTYCNT	EQU	10		;10 retrys
INTRP	EQU	0D0H
RESTOR	EQU	STPRT		;restore command
PANEL	EQU	0FFH		;imsai front panel
SECS	EQU	LAST		;sectors/track
SSECS	EQU	26		;single density sectors/track
;
SIDE0	MACRO	DATA
	IF	NOT NUL DATA
	LDA	DATA	;;get storage value
	ENDIF
	ANI	10111000B
	CALL	WSHIFT	;;set to side 0
	ENDM
;
SIDE1	MACRO	DATA1
	IF	NOT NUL DATA1
	LDA	DATA1	;;get storage value
	ENDIF
	ORI	01000000B
	CALL	WSHIFT	;;change to side 1
	ENDM
;
FOLD	MACRO
	LOCAL	NOCONV
	CPI	'a'
	JC	NOCONV
	CPI	'z'+1
	JNC	NOCONV
	ANI	5FH
NOCONV:
	ENDM
;
	ORG 100H
;
START1:	LXI  SP,STACK	;set stack pointer.
	PRINT <'Tarbell Double Density Deblock Test Program'>


	PRINT <CR,LF,'STD version 1.9 of 5-12-81'>

	PRINT <CR,LF,CR,LF,'Test disks formatted with:'>
	PRINT <CR,LF,'Track  0    = 26 128 byte sectors'>
	PRINT <CR,LF,'Track  1-76 = double density'>
	PRINT <CR,LF,'Deblocked 512 byte sectors'>
;
START:	XRA A			;get a zero
	STA XFER		;default to dma operation
	LXI H,04080H		;init. read operation
	SHLD DMARED
	PRINT <CR,LF,CR,LF,'Title: '>
	INPUT DCBUFF,80
	PRINT <CR,LF,'Starting Track '>
	CALL INP
	STA STRACK
	PRINT <CR,LF,'Ending Track   '>
	CALL INP
	STA ETRACK
	PRINT <CR,LF,'Drive (A,B,C,D)? '>
	INPUT DCBUFF,6
	LDA  DCBUFF+2
	FOLD
DRIVE:	ANI 3			;strip ascii bits
	DCR A			;make it cpm drive number
	ADD A
	ADD A
	ADD A
	ADD A			;shift for latch select
	SIDE0			;select side 0 (default side).
	STA CLATCH		;save drive code
	PRINT <CR,LF,'Test a Double Sided Drive? (Y or N) '>
	INPUT  DCBUFF,6
	LDA	DCBUFF+2
	FOLD
	CPI 'N'			;no?
	JZ  NOTSID
	PRINT <CR,LF,'Side 0 or Side 1? (0 or 1) '>
	INPUT	DCBUFF,6
	LDA	DCBUFF+2
	CPI  '0'		;side 0?
	JZ  NOTSID
	SIDE1 CLATCH
	STA  CLATCH		;save the current drive side code.
NOTSID:	MVI A,RESTOR
	OUT CMD			;restore drive
	CALL DMALOP		;wait till drive restored
;	
	IF	SUPRQAD
	MVI	A,'N'
	JMP	SKIPDMA
	ENDIF
;
	PRINT <CR,LF,'Use DMA for testing (Y or N)? '>
	INPUT	DCBUFF,6
	LDA	DCBUFF+2
	FOLD
	CPI 'Y'			;use dma
	JZ  DTESTD		;yes, test using dma
;
SKIPDMA	STA XFER		;no, set it for pgdt.
	PRINT <BEL>
	PRINT <CR,LF,CR,LF,'****************************',CR,LF>
	PRINT <'Requires a 4 MHz CPU to test',CR,LF>
	PRINT <'****************************',CR,LF>
DTESTD:	PRINT <CR,LF>
DTESTF:	PRINT <CR,'Insert test disk and hit return (cr) '>
	INPUT	DCBUFF,6
	LDA	DCBUFF+1
	ORA	A		;must be a zero
	JZ	DTESTE		;did not type cr, redo from start
	PRINT <CR,'                                                  '>
	JMP	DTESTF		;reprint the question
;
DTESTE:	PRINT <CR,LF>
	LXI H,SECNT		;point at error bOunters
	MVI B,TK-SECNT		;get length of table
	XRA A
CLRLP:	MOV M,A
	INX H
	DCR B
	JNZ CLRLP		;clear table
DOTEST:	LDA STRACK
	STA TK
	ORA A			;cHeck if going to trk zero
	CZ  SDTEST		;yes, change sector count.
	LXI  H,4200H		;dma read and length
	SHLD DMARED		;set it
	LXI  H,SKEWDDB		;double density table
	SHLD TABLE
	MOV  A,M		;get sector bbyte
	STA  SECT		;save it
	CALL DENSET		;set up for double density
TLOOP:	XRA A			;test loop
	STA RCOUNT		;reset retry cOunt
SEEKE:				;seek retry entry point
	CALL SEEKTK		;go seek to value in tk
	IN STATUS		;check status
	ANI 099H		;strip off head load,protect
				;index,track 0 bits from status
	JNZ SERROR		;not 0 then log error
	CALL CHECKRTY		;good ,go see if bad before
READLOOP:
	XRA A
	STA RCOUNT		;reset retry count
READE:				;retry entry point for readsec
	CHARSTAT
	JZ READE1		;skip if no char.
	CHARIN			;get it
	CPI 3
	JZ FORGET
READE1:	CALL READSEC		;go read sector pointed to by sect
	IN STATUS		;check 1791 status
	ORA A			;0 = good
	JNZ RERROR		;if bad go log and retry
SKIPIT:				;entry when max retrys is reached
	CALL CHECKRTY		;good ,go see if bad before
	LHLD TABLE		;get skew table address
	INX H
	SHLD TABLE
	MOV A,M			;get sector number
	ORA A			;is it end of table?
	JNZ SAMETK
;
;increment track (tk)
;
NEWTK:	CALL DENSET		;change to double density
	LDA  TK			;get track number
	INR A
	MOV B,A
	LDA ETRACK		;get last track to test
	CMP B			;check it aginst new track
	JM TOTAL		;if new tk > last tk then done
	STA  SECT		;save it
	LDA CLATCH		;get current density and drive
	ANI 0F7H		;make single density
	STA CLATCH		;save it
	CALL	WSHIFT		;change density
	JMP TLOOP		;read single density
;
DENSET:	LDA CLATCH
	ORI 8			;double density enable
	STA CLATCH
	CALL	WSHIFT
	RET
;
SAMETK:	STA SECT		;update sector pointer
	JMP READLOOP		;go do more
SERROR:	MOV B,A			;enter here from seek error
	INXM SECNT		;inc seek error counter
	LDA RCOUNT		;get retry counter
	INR A
	CPI RTYCNT+1		;see if max retrys
	JZ FORGET
	CPI 1			;see if first retry
	JNZ SEEKE		;not first then just retry
	CALL DSTATUS		;first error so print prameters
	JMP SEEKE		;now do retry
FORGET:	LXI D,FMSG		;message
	MVI C,9
	CALL BDOS
	JMP TOTAL
RERROR:				;enter for read errors
	MOV B,A			;save error
	ANI 4			;lost data?
	JZ E1			;0=no
	INXM LDCNT
E1:	MOV A,B			;get error status
	ANI 8			;crc error?
	JZ E2
	INXM CRCNT
E2:	MOV A,B
	ANI 0E3H		;check other bits
	JZ E4
	INXM OTHER
E4:	MOV A,B
	ANI 10H
	JZ E5
	INXM IDCNT
E5:	LDA RCOUNT
	INR A
	CPI RTYCNT+1
	STA RCOUNT
	JZ SKIPIT		;past max retrys then skip sector
	CPI 1
	JNZ READE		;not first error then just retry
	CALL DSTATUS		;first error, print it
	JMP READE		;now do retry
CHECKRTY:
	LDA RCOUNT		;get retry count
	ORA A			;see if its zero
	RZ			;if 0 then dont do anything
	LXI H,RTYMSG1		;point at middle of retry message
	CALL BIND1		;convert to decimal and put in message
	LXI D,RTYMSG		;point at retry message
	MVI C,9
	CALL BDOS		;print it
	RET
TOTAL:	PRINT <CR,LF,'Seek Errors  '>
	LHLD SECNT
	CALL DEC
	PRINT <CR,LF,'Lost Data    '>
	LHLD LDCNT
	CALL DEC
	PRINT <CR,LF,'CRC Errors   '>
	LHLD CRCNT
	CALL DEC
	PRINT <CR,LF,'ID Errors    '>
	LHLD IDCNT
	CALL DEC
	PRINT <CR,LF,'Other Errors '>
	LHLD OTHER
	CALL DEC
				;done ,now print total values of 
				;all error counters
	JMP START
;
DEC:	DECOUT
	RET
;
READSEC:
	LDA XFER		;check for dma testing
	ORA A			;is it zero?
	JNZ PGDT		;no, use program data transfer
	XRA A			;clear dma chip
	OUT CMND
	LHLD DMARED		;get operation
	DCX H			;count = count-1
	MOV A,L			;read count byte
	OUT WCT0		;tell dma controller
	MOV A,H			;get read command
	OUT WCT0		;  and tell dma controller
	LXI H,RDBUFF		;point to buffer
	MOV A,L			;get low memory address byte
	OUT ADR0		;  and send it to dma controller
	MOV A,H			;get high memory address byte
	OUT ADR0		;  and send it to dma controller
	LDA SECT
	OUT SEC			;tell 1791 what sector to read
	MVI A,41H		;get ch 0 request command
	OUT CMND		;  and send it to dma controller
	MVI B,RCMD
	CALL HDLD
	ORA B
	OUT CMD
DMALOP:	IN INTRQ		;check intrq port
	RLC			; bit 7
	JC DMALOP		;loop till not busy
	RET
;
HDLD:	IN  CMD
	ANI  20H
	MVI  A,0
	RZ
	MVI  A,4
	RET
;
SEEKTK:	LDA TK
	OUT DAL 		;tell 1791
	MVI A,SEEK
	OUT CMD
WAITRDY:JMP DMALOP		;loop till seek done
;
PGDT:	LXI H,RDBUFF		;point to buffer
	LDA SECT		;get sector to read
	OUT SEC			;tell controller chip
	MVI B,RCMD		;get disk read command
	CALL HDLD
	ORA  B
	OUT CMD			;tell controller
PGDTL:	IN  WAIT		;wait for intrq or drq.
	ORA A			;set flags
	RP			;return if done
	IN DAL			;get a byte from disk
	MOV M,A			;put into memory
	INX H			;bump pointer
	JMP PGDTL		;loop till done.
;
DSTATUS:LDA F1793		;get status bit msg flag byte
	ORA A			;is it zero?
	JNZ DERROR		;no, jmp past 1793 flag msg
	CMA			;yes, print 1793 flag bytes once
	STA F1793		;and make flag byte non-zero.
	PUSH B
	PRINT <CR,LF,CR,LF,'1793  RDY  -  RDT RNF CRC LSD DRQ BSY'>
	POP  B
DERROR:	MOV A,B
	LXI H,MSG1
	PUSH D
	CALL BINCON		;convert to hex
	POP D
	LXI H,MSG2
	IN TRK
	CALL BIND1
	LXI H,MSG3
	IN SEC
	CALL BIND1
	LXI B,MSG4
	IN DAL
	CALL CONVT
	MVI C,9
	LXI D,MSG0
	CALL BDOS
	RET
;
BINCON:	MVI	B,8		;loop count
	LXI	D,4		;byte count
BLOOP:	RLC			;check for binary 1
	JC	BONE		;jump if it is
	MVI	M,'0'		;no, show ascii zero
BUMP:	DAD	D		;bump pointer
	DCR	B		;decrease counter
	RZ			;we are done
	JMP	BLOOP		;more bits to convert
BONE:	MVI	M,'1'		;bit is a binary 1
	JMP	BUMP
;
CONVT:	MOV D,A			;save the value
	RAR
	RAR
	RAR
	RAR
	CALL BIN1		;convert to ascii
	MOV A,D
	CALL BIN1
	RET
BIN1:	ANI 0FH
	ADI '0'
	CPI 3AH
	JM DONE
	ADI 7
DONE:	STAX B
	INX B
	RET
;
MSG0:	DB 0AH,0DH,'Status '
MSG1:	DB '                               '
	DB ' Track '
MSG2:	DB 30H,30H
	DB ' Sector '
MSG3:	DB 30H,30H
	DB ' Data '
MSG4:	DB 30H,30H
	DB '$'
RTYMSG:	DB ' Retrys '
RTYMSG1:DB 30H,30H,'$'
FMSG:	DB 0DH,0AH
	DB 0DH,0AH,'F O R G E T  T H I S ! ! !',0DH,0AH,'$'
;
BIND1:	MVI B,10
	CALL BID1
	ADI '0'
	MOV M,A
	RET
BID1:	MVI M,'0'-1
	INR M
	SUB B
	JNC BID1+2
	ADD B
	INX H
	RET
INP:	INPUT DCBUFF,6
	LDA DCBUFF+1
	LXI H,DCBUFF+2
	LXI B,0
	MOV C,A
	DAD B
	MVI M,0FFH
	DECIN DCBUFF+2
	RET
;
WSHIFT:
	IF	SUPRQAD
	PUSH	B
	PUSH	PSW
	MOV	C,A
	ANI	70H	;SAVE SIDE AND DRIVE BITS
	RRC
	RRC
	RRC
	RRC
	MOV	B,A
	MOV	A,C
	ANI	8
	ADD	B	;CONSTRUCT CONTROL BYTE
	OUT	WAIT
	POP	PSW
	POP	B
	ENDIF
;
	IF	TARBELL
	OUT	WAIT
	ENDIF
;
	RET
;
STRACK:	DB 0		;starting track
ETRACK:	DB 76		;ending track
RCOUNT:	DB 0		;retry counter
SECNT:	DW 0		;seek error counter
LDCNT:	DW 0		;lost data counter
CRCNT:	DW 0		;crc error counter
IDCNT:	DW 0		;id not found error
OTHER:	DW 0		;other errors
F1793:	DB 0		;0=print 1793 error bits message once.
TK:	DB 1		;start at track 1+1
SECT:	DB 1
ESECT:	DB SECS+1	;max sectors per disk
TABLE:	DW  0		;skew table address storage
DMARED:	DW  04080H	;dma read operation storage,default to 128 byte
XFER:	DB 0		;dma or pgdt flag byte
CLATCH:	DS  1		;currentt drive code
	DS  64		;stack area
STACK:	DS  1
SKEWSD:	SKEW	FIRST,SSECS,SKEWFSD
SKEWDDB:SKEW	FIRST,SECTDDB,SKFDEBL
DCBUFF:	DS  9
RDBUFF:	DS  1		;read buffer
	END  START1
793:	DB 0		;0=print 1793 error bits message once.
TK:	DB 1		;start at track 1+1
SECT:	DB 1
ESECT:	DB SECS+1	;max sectors per disk
TABLE:	DW  0		;skew table address storage
DMARED:	DW  04080H	;dma read operation storage,default to 128 byte
XFER:	DB 0	                                                                                                                          N CONTROL KEY
	JMP	5
;
	END
;
 LSTDRIVRASM   Q                SETMRGN COM   N                SETMRGN ASM   	V                SETLINESCOM   J                FF      $$$                     SETMRGN BAK   	W               SQBI62DYBAK  k l m n         SQBI62DYBAK  o               1	e
FINDBAD - ver 4.2
Bad sector lockout program
For single-density 8" single sided only.
$	 ͋͵ʀ͗ͬ		   *  "= "A "D:\ =_ ͎ {yx *|! 5|	   ,y5	i`))) |+}0	 ]VL      ,}T.$`k& 	^
	
* "*q#"   Y!"*|}>":<22͗õ2*!w#ɯ:2PPORTS THE USE OF 4 DISK DRIVES.
	DFOCO MAY BE USED BOTH SINGLE DENSITY (FM) AND DOUBLE DENSITY (MFM).
THE OPERATIONS PERFORMED ARE IN GENERAL THE SAME BUT MAY BE SLIGHTLY
MORE LIMITED IN THE CASE OF DOUBLE DENSITY.
	DFOCO WILL RUN ON ANY 8080 OR Z-80 BASED SYSTEM USING THE DELTA
DISK CONTROLLER. THE PROGRAM USES CP/M FOR ALL CONSOLE INPUT-OUTPUT,
HOWEVER ALL DISK OPERATIONS ARE DIRECTLY EXECUTED BY DFOCO. THIS IS
NECESSARY BECAUSE DFOCO USES NON CP/M COMMANDS LIKE DISK TRACK READ,
AND DFOCO KEEPS CONTROL OF ALL DISK ERRORS TO FACILITATE ACCOUNTING
AND ERROR RECOVERY. IT SHOULD BE POSSIBLE HOWEVER, TO MODIFY DFOCO
TO RUN WITH ANY WESTERN DIGITAL 1771 OR 1791 BASED DISK CONTROLER.
THERE ARE TWO DIFFERENT VERSIONS OF DFOCO, ONE FOR STANDARD DISK DRIVES
AND THE OTHER FOR FAST SEEK PERSCI DRIVES. THE SINGLE DENSITY OPERATIONS
WILL BE DESCRIBED IN DETAIL FIRST.



	* * * * * * *  SINGLE DENSITY OPERATIONS  * * * * * * *


			VALIDATING DISKS

	IT IS OFTEN USEFUL TO BE ABLE TO TELL WHETHER OR NOT THE RECORDING
SURFACE OF A DISK IS COMPLETELY INTACT BEFORE USING THE DISK. THIS IS
ESPECIALLY TRUE SINCE WHILE CP/M ALWAYS CHECKS FOR READ ERRORS THERE IS
NO CHECK DONE FOR WRITE ERRORS. YOU WILL NOT KNOW YOU HAVE A BAD COPY
OF A FILE UNTIL THE FIRST TIME YOU TRY TO READ IT AGAIN WHICH MAY BE DAYS
OR EVEN MONTHS LATER.
	VALIDATING A DISK CONSISTS SIMPLY OF READING EACH SECTOR ON THE
DISK AND VERIFYING THAT THE CRC IS CORRECT. THIS SIMPLE PROCESS NOT ONLY
DETECTS PHYSICAL DAMAGE TO THE MEDIA SUCH AS SCRATCHES BUT ALSO FORMATTING
ERRORS SOMETIMES CAUSED BY NOISE TRANSIENTS, ERRORS WHICH WILL DISAPPEAR
UPON REFORMATTING THE DISK. THE FOLLOWING ARE EXAMPLES OF VALIDATION COMMANDS.

		VALID			(DEFAULT IS DRIVE A:)
		VALID C:
		VALID D:  RETRY 20


	THE PROGRAM WILL READ THE ENTIRE DISK AND REPORT ANY READ ERRORS.
IF A CRC ERROR OCCURS THE SECTOR WILL BE REREAD A MAXIMUM OF EITHER
THE NUMBER OF RETRYS SPECIFIED OR 10 TIMES IF NO RETRY COUNT IS ENTERED.
BOTH THE TOTAL NUMBER OF PERMANENT OR HARD ERROR AND RETRYS ARE REPORTED
AT THE END OF THE VALIDATION PROCESS.

		SUCCESSFUL VALIDATION DRIVE B:

			   OR

		PERMANENT READ ERROR TRACK 17 SECTOR 5 DRIVE B
		PERMANENT READ ERROR TRACK 42 SECTOR 19 DRIVE B
		THERE WERE 27 RETRYS AND 2 HARD ERRORS


			COPYING DISKS

	ALL OR PART OF A DISK MAY BE COPIED BETWEEN ANY SPECIFIED DRIVES.
THE FOLLOWING ARE EXAMPLES OF TYPICAL COPY COMMANDS:

	COPY				(DEFAULT IS A: TO B:)
	COPY A: TO C:
	COPY D:  TO  B:  RETRY 20
	COPY A: TO C: TRACK 0-1
	COPY B: TO D:  TRACK  3 - 20
	COPY A: TO A:			(SINGLE DISK TRANSFER)

DFOCO WILL RESPOND WITH AND ACKNOWLEDGMENT AND INSTRUCTIONS. FOR EXAMPLE:

	COPYING DISK A TO DISK B
	TYPE RETURN TO START

	THE PROGRAM WILL HALT AND WAIT FOR DISKS TO BE CHANGED ETC. AND
WILL BEGIN THE ACTUAL COPY OPERATION AFTER RETURN IS TYPED. IF YOU HAVE
MADE AN ERROR AND WISH TO REENTER THE COMMAND TYPE CONTROL C. THE COPY
OPERATION IS OPTIMIZED FOR SPEED. THE PROGRAM WILL DETERMINE THE MAXIMUM
AMOUNT OF MEMORY AVAILABLE AND READ WHOLE TRACKS FROM THE SOURCE DISK
UNTIL THE MEMORY IS FILLED. THEN THE ENTIRE MEMORY BUFFER IS WRITTEN
ONTO THE DESTINATION DISK. ALL TRANSFERS ARE VERIFIED. AS EACH TRACK IS
WRITTEN ONTO THE DESTINATION DISK IT IS READ BACK AND COMPARED BYTE BY
BYTE WITH THE CONTENTS OF THE MEMORY BUFFER. ANY ERRORS ARE REPORTED.
	IF THE SOURCE AND DESTINATION ARE THE SAME DFOCO WILL FIRST
RESPOND WITH A REQUEST THAT YOU VERIFY THAT YOU REALLY WANT TO PERFORM
A SINGLE DRIVE COPY. IF THE REQUEST IS ACKNOWLEDGED THE PROGRAM
WILL INDICATE WHICH DISK TO MOUNT IN THE SPECIFIED DRIVE.
AS WITH TWO DRIVE COPIES THE PROGRAM WILL FILL THE ENTIRE MEMORY BUFFER
WITH DATA. THE PROGRAM WILL THEN HALT AND NOTIFY YOU TO CHANGE DISKS.
THE NUMBER OF DISK CHANGES REQUIRED WILL OF COURSE DEPEND UPON THE
AMOUNT OF MEMORY AVAILABLE. WITH A 48K SYSTEM 8 SWAPS ARE REQUIRED, WITH
A 64K SYSTEM ONLY 6 ARE NEEDED.


		COPYING DISKS WITH DIFFERENT SIZE SECTORS

	DFOCO WILL COPY DISKS WITH SECTORS OF 128, 256 OR 512 BYTES. THE
PRIMARY LIMITATION OF THE PROGRAM IS THAT BOTH DISKS MUST HAVE THE SAME
SIZE SECTORS. THE SIZE SHOULD BE SPECIFIED IN THE COPY COMMAND.

		COPY A: TO C:  SIZE 256
		COPY B: TO A: SIZE 512
		COPY C:  TO D:  SIZE 128

	SPECIFYING A SECTOR SIZE OF OTHER THAN 128, 256 OR 512 BYTES WILL
GENERATE AN ERROR MESSAGE.



		ERROR HANDLING DURING COPY OPERATIONS


	ERROR HANDLING AND RECOVERY IS AN EXTREMELY INPORTANT PART OF ANY
DISK FILE MANAGEMENT SYSTEM. DFOCO IS DESIGNED TO PERMIT THE MAXIMUM RECOVERY
OF DATA FROM DAMAGED OR "CRASHED" DISKS. TWO TYPES OF ERRORS OCCUR DURING
COPY OPERATIONS, ERRORS IN READING FROM THE SOURCE DISK AND ERRORS WRITING
TO THE DESTINATION DISK. READ ERRORS ARE BY FAR THE MOST COMMON.
	IF A READ ERROR OCCURS DFOCO WILL ATTEMPT TO REREAD THE SECTOR 10
(OR RETRY) TIMES. IF THE READ ERROR PERSISTS ONE OF TWO ACTIONS MAY BE CHOSEN.
THE DEFAULT IS TO FILL THE SECTOR WITH E5H AND WRITE IT ON THE DESTINATION
DISK. THE OTHER CHOICE IS SIMPLY TO ACCEPT THE DATA AS READ IN AND WRITE IT ON
THE DESTINATION DISK. THIS IS THE NOFILL OPTION. NOFILL PERMITS THE MAXIMUM
DATA RECOVERY BUT REQUIRES CAREFUL INSPECTION OF THE SECTOR CAUSING THE ERROR
SINCE THE ERRORS MAY NOT BE OBVIOUS.
	WRITE ERRORS ARE HANDLED IN A SOMEWHAT DIFFERENT FASHION. SINCE THERE
IS USUALLY NO VALUABLE DATA ON THE DESTINATION DISK, THE NORMAL CHOICE IS TO
NOT PERMIT COPY OPERATIONS IF WRITE ERROR OCCUR. DFOCO WILL ATTEMPT TO WRITE
A SECTOR 10 (OR RETRY) TIMES. IF THE ERROR PERSISTS, DFOCO WILL STOP THE COPY
OPERATION AND VALIDATE THE DESTINATION DISK THUS REPORTING ALL BAD SECTORS.
IT IS POSSIBLE TO COPY IN THE PRESENCE OF WRITE ERRORS BY TURNING OFF THE
WRITE VERIFICATION, THE NOVERIFY OPTION. HOWEVER SINCE DISKS HAVE BECOME
RELATIVELY INEXPENSIVE THIS OPTION IS PROBABLY UNWISE EXCEPT IN VERY SPECIAL
CASES. SOME EXAMPLES ARE AS FOLLOWS:

	COPY B: TO C: NOFILL   RETRY 25
	COPY A: TO B: TRACK 0-5 NOVERIFY
	COPY D: TO A: NOVERIFY NOFILL 


			DISK FORMATTING AND MAPPING

	THE STANDARD IBM FORMAT FOR 8 INCH FLOPPY DISKS IS GIVEN IN THE
WESTERN DIGITAL DOCUMENTATION FOR THE 1791 DISK CONROLLER CHIP AND IN VARIOUS
IBM DOCUMENTS. THE USUAL FORMAT IS "SOFT SECTORED". THIS MEANS ESSENTIALLY
THAT THE TRACK AND SECTOR NUMBERS ARE ACTUALLY WRITTEN ON THE DISK AS DATA
RATHER THAN BEING DETERMINED BY THE PRESENCE OF PHYSICAL INDICATORS SUCH AS
HOLES IN THE DISK. FORMATTING A DISK CONSISTS OF WRITING BOTH THE TRACK
AND SECTOR NUMBERS AS WELL AS CLOCKING INFORMATION FOR THE CONTROLER ON THE
DISK. IT IS IMPORTANT TO REMEMBER THAT A "BLANK" DISK IS BY NO MEANS REALLY
BLANK. RATHER IT CONTAINS A GREAT DEAL OF FORMATTING INFORMATION WITHOUT
WHICH THE CONTROLER IS TOTALLY UNABLE TO READ IT.
	BECAUSE OF THIS "SOFT SECTORING" IT IS SOMETIMES POSSIBLE AND OFTEN
USEFUL TO CHANGE THE FORMAT TO ALLOW INCREASED AMOUNTS OF DATA TO BE WRITTEN
ON THE DISK OR HIGHER SPEED OF OPERATION. THERE ARE TWO POSSIBLE CHANGES
THAT ARE USEFUL, CHANGING THE SIZE OF THE SECTORS OR CHANGING THEIR ORDERING.
	THIS VERSIONROLLERS WERE
QUITE SLOW AND COMPUTER MEMORIES SMALL AND VERY COSTLY. SMALL MEMORIES 
DICTATED SMALL SECTOR SIZES ON DISKS SINCE THE LARGER THE SECTORS THE LARGER
THE MEMORY BUFFERS REQUIRED. SLOW CONTROLERS MEANT THAT HAVING READ A SECTOR
FROM THE DISK IT WAS NECESSARY TO WAIT BEFORE ANOTHER SECTOR COULD BE READ.
DELAYS OF 5 SECTOR TIMES (ABOUT 25 MSEC) WERE COMMON. THUS CP/M IS SET UP
TO READ EVERY 6TH SECTOR AROUND THE DISK. THIS STRATEGY UNFORTUNATELY IS
FAR FROM OPTIMAL FOR PRESENT DAY CONTROLLERS WHICH CAN READ CONSECUTIVE
SECTORS FROM A DISK WITH EASE. NOTE THAT DFOCO WHICH READS AN ENTIRE TRACK
IN A SINGLE DISK REVOLUTION IS OVER 5 TIMES AS FAST AS PIP. UNFORTUNATELY
CP/M STANDARD SYSTEM PROGRAMS SUCH AS PIP AND THE ASSEMBLER CAN ONLY BE
SPEEDED UP A SMALL AMOUNT, ABOUT 20 PER CENT, BY CHANGING DISK FORMATS ALONE.
HOWEVER, NEW PROGRAMS WRITTEN TO TAKE ADVANTAGE OF FASTER CONTROLERS CAN
BE SPEEDED UP A GREAT DEAL MORE.


			MAPPING DISK FORMATS

	WHEN EXPERIMENTING WITH NONSTANDARD FORMATS IT IS OFTEN VERY USEFUL
TO BE ABLE TO READ AND DISPLAY THE ACTUAL DISK FORMAT. YOU CAN'T NECECESSARILY
TELL WHATS ON A DISK BY LOOKING AT THE LABEL. THE MAP COMMAND READS THE FORMAT
FROM A SINGLE TRACK ON A SPECIFIED DISK AND DISPLAYS IT. THERE ARE 26 SECTORS
PER TRACK IN THE STANDARD IBM FORMAT WHICH ARE NUMBERED IN SEQUENTIAL ORDER.
TO DISPLAY THE SECTOR ORDERING TYPE:

		MAP			(DEFAULT IS TRACK 0 DRIVE A:)
		MAP C: TRACK 76

	THE PROGRAM WILL READ THE SPECIFIED TRACK AND DISPLAY THE PHYSICAL TO
LOGICAL SECTOR MAPPING. THE PHYSICAL SECTORS STARTING FROM THE SINGLE INDEX
HOLE IN THE DISK ARE SIMPLY NUMBERED 1 THRU 26. THE CORRESPONDING LOGICAL
SECTORS ACTUALLY WRITTEN ON THE DISK ARE DISPLAYED BESIDE THE PHYSICAL SECTOR
NUMBER.  FOR DISKS FORMATTED WITH LESS THAN 26 SECTORS, THE UNUSED LOGICAL
SECTOR NUMBERS DISPLAY AS A '-'.
	OCCASIONALLY DFOCO WILL DISPLAY OBVIOUSLY INCORRECT MAPPING DATA, FOR
EXAMPLE TRACK 404 SECTOR NUMBER 201. THIS MEANS THE FORMAT ON THE DISK IS
INCORRECT. THE DISK CONTROLLER WILL OFTEN READ THESE DISKS CORRECTLY
BUT IT IS USUALLY A GOOD IDEA TO COPY THE DATA TO A CORRECTLY FORMATTED DISK.
FORMATTING PROBLEMS OF THIS TYPE OFTEN SHOW UP WHEN YOU ATTEMPT TO READ
DISKS PRODUCED ON ANOTHER COMPUTER SYSTEM. IF THE HEAD ALLIGNMENT IF ONLY
SLIGHTLY DIFFERENT FROM YOURS YOU MAY GET MAPPING ERRORS EVEN THOUGH YOU ARE
USUALLY ABLE TO READ THE DATA CORRECTLY.


			FORMATTING DISKS


	DFOCO PERMITS FORMATTING DISKS ON ANY DRIVE SUPPORTED BY CP/M. EITHER
THE ENTIRE DISK OR SPECIFIED TRACKS MAY BE FORMATTED. IT IS EVEN POSSIBLE
TO WRITE DIFFERENT FORMATS ON DIFFERENT TRACKS OF THE SAME DISK. 

			STANDARD FORMAT


	TO WRITE THE STANDARD IBM FORMAT ON A DISK TYPE

		FORMAT				(DEFAULT IS DRIVE A)
		FORMAT B: 
		FORMAT C:  TRACK  20-40

	THE PROGRAM WILL HALT AND THEN RESPOND WITH:

		STANDARD IBM 3740 FORMAT

		INSERT DISK TO BE FORMATTED IN DRIVE A
		TYPE CARRIAGE RETURN

	NON STANDARD FORMATS MAY HAVE ALMOST ANY FORM YOU SPECIFY. THE FIRST
VARIATION IS TO OFFSET THE SAME FORMAT FROM TRACK TO TRACK. THIS IS USEFUL
TO COMPENSATE FOR THE TIME IT TAKES TO STEP THE HEAD FROM ONE TRACK TO
ANOTHER AND IS ONE OF THE TECHNIQUES USED IN DFOCO TO INCREASE THE COPY SPEED.
THE FOLLOWING IS AN EXAMPLE OF TRACK OFFSETTING:

		FORMAT B: OFFSET 5

THIS RESULTS IN THE FOLLOWING FORMAT ON THE DISK

		TRACK 0		TRACK 1		TRACK 2		ETC.

SECTOR		  1		  6		  11
SECTOR		  2		  7		  12
SECTOR		  3		  8		  13
SECTOR		  4		  9 		  14

	A SECOND FORMATTING VARIATION IS TO SKEW THE SECTORS BY A CONSTANT
AMOUNT. THIS CAN BE SPECIFIED AS FOLLOWS.

		FORMAT B: SKEW 3

	THIS WILL RESULT IN A DISPLAY OF THE PHYSICAL TO LOGICAL SECTOR MAPPING
AND PERMIT CHANGING THE SPECIFICATIONS BEFORE WRITING THE FORMAT ON THE DISK.

	PHYSICAL	LOGICAL		PHYSICAL	LOGICAL
	 SECTOR		SECTOR		 SECTOR		SECTOR
	   1		  1		   14		  14
	   2		  4		   15		  17
	   3		  7		   16		  20
	   4		 10		   17		  23
	   5		 13		   18		  26
	   6		 16		   19		   3
	   7		 19		   20		   6
	   8		 22		   21		   9
	   9		 25		   22		  12
	  10		  2		   23		  15
	  11		  5	  	   24		  18
	  12		  8		   25		  21
	  13		 11		   26		  24

TYPE RETURN TO FORMAT, SECTOR NO TO CORRECT

	TYPING A SECTOR NUMBER ALLOWS THE LOGICAL SECTOR NUMBER TO BE CHANGED.
BEFORE USING A SECTOR NUMBER IT MUST BE FIRST SET TO ZERO SINCE THE PROGRAM
CHECKS AND DOES NOT PERMIT TWO SECTORS WITH THE SAME NUMBER. THE SECTOR MAPPING
IS REDISPLAYED FOR VERIFICATION AFTER EACH CHANGE.
	THE FINAL FORMATTING OPTION I