;****************************************
;*					*
;*		C R T . A S M		*
;*					*
;****************************************
;
;
;	Last Change: Ted - Feb. 06, 1984
;
; Copyright (C) 1980, 1981, 1982, 1983, 1984 by CompuView Products, Inc.
;
;	CompuView Products, Inc.
;	1955 Pauline Blvd.
;	Ann Arbor, MI 48103
;
;
;	Tables of Escape sequences for each type of CRT terminal.
;
;
;	Each table starts on a 128 byte sector boundary
;
;	Each table consists of 16 control sequences consisting of up to
;	7 bytes and cursor addressing info (ADDOFF) consisting of three bytes
;	Each control sequence begins with a count byte, which is the
;	count of the characters to be sent to the CRT, followed by those
;	characters, followed by the delay in milliseconds needed by the CRT.
;
;	ADDOFF specifies whether the cursor address is sent in binary or
;	ASCII, whether the row or column coordinate is sent first, and the
;	offset to add to the row and column coordinates.
;
;	BYTE 1 : Bit 0 : 0 = ROW first then COLUMN
;	                 1 = COLUMN first then ROW
;	         Bit 7 : 0 = Address in binary
;	                 1 = Address in ASCII
;
;	BYTE 2 : First coordinates offset.
;	BYTE 3 : Second coordinates offset.
;
;	The count for CLEAR SCREEN uses its high bit as a flag.  If Bit 8 is 
;	set, it indicates that the computer is emulating a CRT terminal.  In 
;	this case the screen is not pre-cleared when writting new screens.
;
;	Assembly Directions:   (Assume logged onto drive B:)
;
;	A:ASM CRT.BBZ
;	A:LOAD CRT
;	ERA CRT.TBL
;	REN CRT.TBL=CRT.COM
;
;
	ORG	100H			; Start first one at 100H
;
;	(1)	ACT IV
;
	DB	1,14H,0,0,0,0,0		;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	1,1FH,6,0,0,0,0		;EOS
	DB	1,1EH,0,0,0,0,0		;EOL
	DB	1,1,0,0,0,0,0		;INSERT LINE
	DB	1,17H,0,0,0,0,0		;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	1,1,0,0,0,0,0		;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(2)	ADDS REG 20
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF 
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,6BH,6,0,0,0	;EOS
	DB	2,1BH,4BH,2,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(3)	ADDS REG 30
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,6BH,6,0,0,0	;EOS
	DB	2,1BH,4BH,2,0,0,0	;EOL
	DB	2,1BH,4DH,2,0,0,0	;INSERT LINE
	DB	2,1BH,6CH,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4DH,0,0,0,0	;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	2,1BH,62H,0,0,0,0	;ENABLE STATUS LINE
	DB	2,1BH,42H,0,0,0,0	;DISABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(4)	ADDS REG 100
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,20H,20H		;ADDOFF
	DB	1,0CH,0,0,0,0,0		;CLEAR SCREEN
	DB	2,1BH,6BH,6,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	3,1BH,30H,50H,0,0,0	;BEGIN REVERSE VIDEO - N/A
	DB	3,1BH,30H,40H,0,0,0	;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(5)	ADDS VIEWPOINT
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,0CH,0,0,0,0,0		;CLEAR SCREEN
	DB	2,1BH,6BH,6,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	3,1BH,30H,50H,0,0,0	;BEGIN REVERSE VIDEO - N/A
	DB	3,1BH,30H,40H,0,0,0	;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(6)	ADDS VIEWPOINT/3A PLUS
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,1AH,0,0,0,0,0		;CLEAR SCREEN
	DB	2,1BH,59H,6,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	3,1BH,30H,52H,0,0,0	;BEGIN REVERSE VIDEO - N/A
	DB	3,1BH,30H,40H,0,0,0	;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(7)	ADM-3A
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,1AH,6,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(8)	ADM-31
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,1AH,2,0,0,0,0		;CLEAR SCREEN
	DB	2,1BH,59H,06H,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,0AH,0,0,0	;INSERT LINE
	DB	2,1BH,52H,0,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,0,0,0,0	;REVERSE SCROLL
	DB	3,1BH,47H,06H,0,0,0	;BEGIN REVERSE VIDEO
	DB	3,1BH,47H,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(9)	AMPEX DIALOGUE 80	
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	2,1BH,2BH,6,0,0,0	;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	2,1BH,45H,2,0,0,0	;INSERT LINE
	DB	2,1BH,52H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,2,0,0,0	;REVERSE SCROLL
	DB	2,1BH,6AH,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,6BH,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(10)	ANN ARBOR 400D
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,58H,0,0,0,0	;CURSOR LEADIN
	DB	2,1BH,59H,0,0,0,0	;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE
	DB	0,0,0,0,0,0,0		;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL
	DB	2,1BH,43H,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,40H,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(11)	ANSI STANDARD -  Ann Arbor AMBASSADOR, etc.
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,5BH,0,0,0,0	;CURSOR LEADIN
	DB	1,3BH,0,0,0,0,0		;CHARS between X and Y.
	DB	1,48H,0,0,0,0,0		;CURSOR LEAD OUT
	DB	80H,1H,1H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	4,1BH,5BH,30H,4AH,0FFH,0	;EOS
	DB	4,1BH,5BH,30H,4BH,0,0	;EOL
	DB	4,1BH,5BH,31H,4CH,0,0	;INSERT LINE
	DB	4,1BH,5BH,31H,4DH,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	4,1BH,5BH,31H,4CH,0,0	;REVERSE SCROLL
	DB	4,1BH,5BH,37H,6DH,0,0	;BEGIN REVERSE VIDEO
	DB	4,1BH,5BH,30H,6DH,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(12)	BEEHIVE - But not all of them.
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,46H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,6,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	2,1BH,4CH,03,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,66H,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,03,0,0,0	;REVERSE SCROLL
	DB	03,1BH,64H,50H,0,0,0	;BEGIN REVERSE VIDEO
	DB	03,1BH,64H,40H,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(13)	Control Data CD110
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,59H,6,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,1AH,03,0,0,0	;INSERT LINE
	DB	2,1BH,13H,03,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,1AH,03,0,0,0	;REVERSE SCROLL
	DB	02,1BH,6AH,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	02,1BH,6BH,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(14)	CONTROL DATA CD722
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,05H,0,0,0,0,0		;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y-N/A
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT-N/A
	DB	01H,0,0			;ADDOFF
	DB	1,18H,0,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS-N/A
	DB	1,16H,0,0,0,0,0		;EOL
	DB	2,1EH,52H,03,0,0,0	;INSERT LINE
	DB	2,1EH,51H,03,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1EH,52H,03,0,0,0	;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO-N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO-N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE-N/A
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE-N/A
;
;
;
;	(15)	DATAMEDIA
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,1EH,0,0,0,0,0		;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,0,0			;ADDOFF
	DB	1,0CH,6,0,0,0,0		;CLEAR SCREEN - not used.
	DB	1,0BH,6,0,0,0,0		;EOS
	DB	1,1DH,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(16)	DEC VT-100 / VT-180
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,5BH,0,0,0,0	;CURSOR LEADIN
	DB	1,3BH,0,0,0,0,0		;CHARS between X and Y.
	DB	1,48H,0,0,0,0,0		;CURSOR LEAD OUT
	DB	80H,1H,1H		;ADDOFF
	DB	4,1BH,5BH,32H,4AH,12,0	;CLEAR SCREEN
	DB	4,1BH,5BH,30H,4AH,30H,0	;EOS
	DB	4,1BH,5BH,30H,4BH,10,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE
	DB	4,1BH,5BH,32H,4BH,05H,0	;DELETE LINE
	DB	1,0AH,10H,0,0,0,0	;FORWARD SCROLL
	DB	2,1BH,4DH,0AH,0,0,0	;REVERSE SCROLL
	DB	4,1BH,5BH,37H,6DH,0,0	;BEGIN REVERSE VIDEO
	DB	4,1BH,5BH,30H,6DH,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	2,1BH,3DH,05H,0,0,0	;ENTER VISUAL MODE
	DB	2,1BH,3EH,05H,0,0,0	;EXIT VISUAL MODE
;
;
;	(17)	DEC VT-52
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,08,0,0,0	;EOS
	DB	2,1BH,4BH,03,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,49H,0,0,0,0	;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(18)	DYNABYTE 57
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,43H,0,0,0,0	;CURSOR LEADIN
	DB	1,2CH,0,0,0,0,0		;CHARS between X and Y.
	DB	1,0DH,0,0,0,0,0		;CURSOR LEAD OUT
	DB	80H,0,0			;ADDOFF
	DB	1,0CH,10,0,0,0,0	;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS - N/A
	DB	0,0,0,0,0,0,0		;EOL - N/A
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(19)	EMULOG-200
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,10H,0,0,0,0,0		;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.-N/A
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT-N/A
	DB	01H,0,0			;ADDOFF
	DB	1,0CH,0,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS - N/A
	DB	1,0BH,0,0,0,0,0		;EOL - N/A
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	0,0,0,0,0,0,0		;FORWARD SCROLL-N/A
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	2,1EH,44H,0,0,0,0	;BEGIN REVERSE VIDEO 
	DB	2,1EH,45H,0,0,0,0	;END REVERSE VIDEO 
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(20)	FULCRUM VIO-2
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	2,1BH,1AH,0,0,0,0	;CLEAR SCREEN
	DB	2,1BH,59H,04H,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,2,0,0,0	;INSERT LINE
	DB	2,1BH,52H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,2,0,0,0	;REVERSE SCROLL
	DB	3,1BH,5AH,26H,0,0,0	;BEGIN REVERSE VIDEO
	DB	3,1BH,5AH,20H,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(21)	HAZELTINE 1500
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,7EH,11H,0,0,0,0	;CURSOR LEADIN 
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,7EH,18H,6,0,0,0	;EOS
	DB	2,7EH,0FH,0,0,0,0	;EOL
	DB	2,7EH,1AH,2,0,0,0	;INSERT LINE
	DB	2,7EH,13H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,7EH,1AH,0,0,0,0	;REVERSE SCROLL
	DB	2,7EH,1FH,0,0,0,0	;BEGIN DOUBLE INTENSITY
	DB	2,7EH,19H,0,0,0,0	;END DOUBLE INTENSITY
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(22)	H19/Z19
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,6,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	2,1BH,4CH,0,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,0,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,0,0,0,0	;REVERSE SCROLL
	DB	2,1BH,70H,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,71H,0,0,0,0	;END REVERSE VIDEO
	DB	5,1BH,78H,31H,1BH,77H,0	;ENABLE STATUS LINE
	DB	5,1BH,79H,31H,1BH,76H,0	;DISABLE STATUS LINE
	DB	03,1BH,78H,37H,0,0,0	;ENTER VISUAL MODE
	DB	03,1BH,79H,37H,0,0,0	;EXIT VISUAL MODE
;
;
;	(23)	HP 2621
;
	ORG	($ AND 0FF80H) + 80H
	DB	03,1BH,26H,61H,0,0,0	;CURSOR LEADIN
	DB	1,72H,0,0,0,0,0		;CHARS between X and Y.
	DB	1,43H,0,0,0,0,0		;CURSOR LEAD OUT
	DB	80H,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,6,0,0,0	;EOS
	DB	2,1BH,4BH,2,0,0,0	;EOL
	DB	2,1BH,4CH,2,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,2,0,0,0	;REVERSE SCROLL
	DB	4,1BH,26H,64H,42H,0,0	;BEGIN REVERSE VIDEO
	DB	4,1BH,26H,64H,40H,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(24)	HUMAN DESIGNED SYSTEMS, INC. "CONCEPT"
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,61H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,05H,8,0,0,0	;EOS
	DB	2,1BH,15H,2,0,0,0	;EOL
	DB	2,1BH,12H,2,0,0,0	;INSERT LINE
	DB	2,1BH,02H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,12H,2,0,0,0	;REVERSE SCROLL
	DB	2,1BH,44H,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,64H,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(25)	IBM DISPLAYWRITER
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	2+80H,1BH,4CH,0,0,0,0	;CLEAR SCREEN, CRT Emulation
	DB	0,0,0,0,0,0,0		;EOS
	DB	2,1BH,49H,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE
	DB	0,0,0,0,0,0,0		;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL
	DB	3,1BH,33H,10H,0,0,0	;BEGIN REVERSE VIDEO
	DB	3,1BH,33H,00H,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(26)	IBM 3101
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN FOR
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,6,0,0,0	;EOS
	DB	2,1BH,49H,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(27)	INFO 10
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,66H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,6,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LIN - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LIN - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(28)	INTERTUBE II (Up to 1.7)
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,0CH,6,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS - N/A
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(29)	INTERTUBE (Later)
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN 
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,6BH,6,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(30)	ISC 8063
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,03H,0,0,0,0,0		;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,0,0			;ADDOFF
	DB	1,0CH,6,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(31)	KIMTRON ABM 85
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y-N/A
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT-N/A
	DB	80H,0,0			;ADDOFF
	DB	2,1BH,2BH,0,0,0,0	;CLEAR SCREEN 
	DB	2,1BH,59H,0,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,2,0,0,0	;INSERT LINE
	DB	2,1BH,52H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,0,0,0,0	;REVERSE SCROLL
	DB	2,1BH,4AH,0,0,0,0	;BEGIN REVERSE VIDEO 
	DB	2,1BH,4BH,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE-N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE-N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE-N/A
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE-N/A
;
;
;	(32)	LINWOOD BETA BANDIT
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,5BH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	1,48H,0,0,0,0,0		;CURSOR LEAD OUT
	DB	80H,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	4,1BH,5BH,30H,4AH,6,0	;EOS
	DB	4,1BH,5BH,30H,4BH,4,0	;EOL
	DB	3,1BH,5BH,4CH,2,0,0	;INSERT LINE
	DB	3,1BH,5BH,4DH,2,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	3,1BH,5BH,4CH,2,0,0	;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(33)	NEC APC
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	4+80H,1BH,5BH,32H,4AH,0,0 ;CLEAR SCREEN, CRT Emulation
	DB	4,1BH,5BH,30H,4AH,0,0	;EOS
	DB	4,1BH,5BH,30H,4BH,0,0	;EOL
	DB	0,1BH,5BH,31H,4CH,0,0	;INSERT LINE
	DB	4,1BH,5BH,32H,4BH,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,1BH,5BH,31H,4CH,0,0	;REVERSE SCROLL
	DB	4,1BH,5BH,37H,6DH,0,0	;BEGIN REVERSE VIDEO
	DB	4,1BH,5BH,30H,6DH,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(34)	NORTH STAR ADVANTAGE
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,32,32			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN
	DB	1,0FH,6,0,0,0,0		;EOS
	DB	1,0EH,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE
	DB	0,0,0,0,0,0,0		;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1EH,0BH,0,0,0,0	;REVERSE SCROLL
	DB	1,01H,0,0,0,0,0		;BEGIN DOUBLE INTENSITY
	DB	1,02H,0,0,0,0,0		;END DOUBLE INTENSITY
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	1,04H,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(35)	PERKIN ELMER 1251/1245 "SUPER OWL"
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,58H,0AH,0,0,0	;CURSOR LEADIN
	DB	2,1BH,59H,0AH,0,0,0	;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	2,1BH,4BH,0CAH,0,0,0	;CLEAR SCREEN & Delay
	DB	2,1BH,4AH,0FFH,0,0,0,0	;EOS
	DB	2,1BH,49H,50,0,0,0	;EOL & Delay
	DB	2,1BH,4CH,90,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,90,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,90,0,0,0	;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(36)	PERKIN ELMER 550
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,58H,0,0,0,0	;CURSOR LEADIN
	DB	2,1BH,59H,0,0,0,0	;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	2,1BH,4BH,40,0,0,0	;CLEAR SCREEN & Delay
	DB	0,0,0,0,0,0,0		;EOS - N/A
	DB	2,1BH,49H,20,0,0,0	;EOL & Delay
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(37)	VDB 8024
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,1AH,2,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	2,1,0AH,0,0,0,0		;FORWARD SCROLL
	DB	2,2,0AH,0,0,0,0		;REVERSE SCROLL
	DB	1,12H,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	1,11H,0,0,0,0,0		;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	1,1,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(38)	SOROC 120
;
	ORG	($ AND 0FF80H) + 80H
	DB	4,0,0,1BH,3DH,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	2,1BH,2AH,6,0,0,0	;CLEAR SCREEN - not used.
	DB	2,1BH,59H,0AH,0,0,0	;EOS
	DB	2,1BH,54H,03,0,0,0	;EOL
	DB	0,1BH,45H,2,0,0,0	;INSERT LINE - 140 only
	DB	0,1BH,52H,2,0,0,0	;DELETE LINE - 140 only
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,1BH,45H,2,0,0,0	;REVERSE SCROLL - 140 only
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(39)	SUPERBRAIN
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1+80H,0CH,0,0,0,0,0	;CLEAR SCREEN, CRT Emulation
	DB	00,1BH,7EH,6BH,0,0,0	;EOS (Until Intertek fixes the BUG##)
	DB	03,1BH,7EH,4BH,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(40)	SWTPC CT82
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,0BH,0,0,0,0,0		;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	1,16H,2,0,0,0,0		;EOS
	DB	1,06H,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(41)	TEC 500	
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,1AH,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(42)	TELERAY
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,6,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	2,1BH,4CH,2,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,2,0,0,0	;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(43)	TELEVIDEO 920, 912
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,59H,6,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,2,0,0,0	;INSERT LINE
	DB	2,1BH,52H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,2,0,0,0	;REVERSE SCROLL
	DB	2,1BH,6AH,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,6BH,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(44)	TELEVIDEO 925
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,59H,6,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,2,0,0,0	;INSERT LINE
	DB	2,1BH,52H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,2,0,0,0	;REVERSE SCROLL
	DB	3,1BH,47H,34H,0,0,0	;BEGIN REVERSE VIDEO
	DB	3,1BH,47H,30H,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(45)	TELEVIDEO 950, 910
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN FOR
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,59H,6,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,2,0,0,0	;INSERT LINE
	DB	2,1BH,52H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,2,0,0,0	;REVERSE SCROLL
	DB	3,1BH,47H,34H,0,0,0	;BEGIN REVERSE VIDEO
	DB	3,1BH,47H,30H,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(46)	VICTOR 9000
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0+80H,0,0,0,0,0,0	;CLEAR SCREEN - N/A, CRT Emulation
	DB	2,1BH,4AH,6,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	2,1BH,4CH,0,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,0,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,0,0,0,0	;REVERSE SCROLL
	DB	2,1BH,70H,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,71H,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE
	DB	03,1BH,78H,36H,0,0,0	;ENTER VISUAL MODE
	DB	03,1BH,79H,36H,0,0,0	;EXIT VISUAL MODE
;
;
;	(47)	VOLKER-CRAIG 404
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,10H,0,0,0,0,0		;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN
	DB	1,17H,10,0,0,0,0	;EOS
	DB	1,16H,2,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE
	DB	0,0,0,0,0,0,0		;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(48)	WYSE TECHNOLOGY WY-100
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	2,1BH,2BH,6,0,0,0	;CLEAR SCREEN
	DB	2,1BH,59H,6,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,0,0,0,0	;INSERT LINE
	DB	2,1BH,52H,0,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,0,0,0,0	;REVERSE SCROLL
	DB	3,1BH,47H,36H,0,0,0	;BEGIN REVERSE VIDEO
	DB	3,1BH,47H,30H,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(49)	XEROX 820
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1+80H,1AH,2,0,0,0,0	;CLEAR SCREEN, CRT Emulation
	DB	1,11H,0,0,0,0,0		;EOS
	DB	1,18H,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,01H,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(50)	CUSTOMER 2  (COMARK SYSTEM)
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,66H,10,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,20H,20H		;ADDOFF
	DB	3,1BH,60H,7FH,0,0,0	;CLEAR SCREEN
	DB	3,1BH,4AH,7FH,0,0,0	;EOS
	DB	2,1BH,4BH,5,0,0,0	;EOL
	DB	3,1BH,5BH,4CH,5,0,0	;INSERT LINE
	DB	3,1BH,5BH,4DH,5,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL
	DB	2,1BH,31H,5,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,32H,5,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE

;
;	(51)	CUSTOMER 1
;		fergerson BB1 modified for reverse video
;
;

	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,1AH,0,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	2,1BH,45H,0,0,0,0	;INSERT LINE 
	DB	2,1BH,52H,0,0,0,0	;DELETE LINE 
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	2,1BH,29H,0,0,0,0	;BEGIN REVERSE VIDEO 
	DB	2,1BH,28H,0,0,0,0	;END REVERSE VIDEO 
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
