;	BOOTSTRAP LOADER
	ORG	00H
;
;
;LOAD THE MONITOR AT 2900
LOADP	EQU	2900H	;LOAD POINT
BCP	EQU	3E00H	;MONITOR
HLAST 	EQU 	40H	;H ADDRESS JUST PAST CBIOS
LAST	EQU	21	;LAST SECTOR ON TRK1 TO LOAD
SKIP	EQU	1	;NUMBER OF SECTORS TO SKIP
;
DMAH	EQU	126	;HIGH ORDER DMA ADDR
DMAL	EQU	125	;LOW ORDER DMA ADDR
REBOOT	EQU	125	;REBOOT SYSTEM ON ERROR
INIT0	EQU	(0 SHL 7) OR SKIP+1	;TRK/SEC INITIALLY
END0	EQU	(0 SHL 7) OR 27	;END OF FIRST TRK
INIT1	EQU	(1 SHL 7) OR 1	;TRK/SEC INIT FOR TRK 1
END1	EQU	(1 SHL 7) OR LAST+1	;LAST POSITION ON TRK 1
;
T76	EQU	04H	;TOWARD 76
STT	EQU	02H	;STEP TRACK
SRF	EQU	02H	;STEP READY FLAG
DOUT	EQU	7FH	;DISK OUTPUT PORT
DINP	EQU	7FH	;DISK INPUT PORT
RDS	EQU	40H	;READ SECTOR
ERR	EQU	0F0H	;ERROR CONDITIONS
IOF	EQU	08H	;IO FINISH 
;
;
	NOP		;SOME DYNAMIC MEMORIES PROHIBIT USE OF
			;THIS BYTE IN THE BOOTSTRAP
;	INITIALIZE TRK/SEC AND DMA ADDRESS
START:
	MVI	E,INIT0
	LXI	H,LOADP-3
;
READL:	;READ LOOP
;	SEND DMA ADDRESS
	MOV	A,H
	OUT	DMAH
	MOV	A,L
	OUT	DMAL
;
;	GET DATA FROM MEMORY
	MOV	B,M
	INX	H
	MOV	C,M
	INX	H
	MOV	D,M
;
;	SET UP TRACK AND SECTOR
	DCX	H
	MOV	A,E
	ANI	11111B	;SECTOR NUMBER
	MOV	M,A
	;
	DCX	H
	MOV	A,E
	RAL
	RAL
	ANI	1
	MOV	M,A	;TRACK NUMBER
;
;	PERFORM THE READ
	MVI	A,RDS
	OUT	DOUT
;
WRD:	IN	DINP
	ANI	ERR
	JZ	NERROR
;
;	ERROR, REBOOT
	IN	125	;REBOOT ON ERROR
	HLT
NERROR:	;NO ERROR SO FAR
	IN	DINP
	ANI	IOF
	JZ	WRD	;GO BACK AND WAIT
;
;	I/O FINISH, INCREMENT EVERYTHING.
;	REPLACE DATA BYTES
	MOV	M,B
	INX	H
	MOV	M,C
	INX	H
	MOV	M,D	;BYTES REPLACED
;
;	ADD 126 TO DMA ADDRESS
	LXI	B,126
	DAD	B
;	INC TRACK/SECTOR
	MOV	A,E
	INR	A
	CPI	END0	;END OF TRACK 0?
	JNZ	CMP1
;
;	STEP TRACK TO TRACK 1
	MVI	A,T76
	OUT	DOUT
	ORI	STT
	OUT	DOUT
	MVI	A,T76
	OUT	DOUT
;
WST:	;WAIT FOR STEP AND HEAD SETTLE (18 MSEC)
	MVI	A,18D
WST0:
	MVI	C,82H	;ONE MILLISEAOND TIMING FOR OUR IMSAI
			;CAN BE ADJUSTED FOR DIFFERENT MACHINES
WST2:
	DCR	C
	JNZ	WST2
	DCR	A
	JNZ	WST0
;
;		TRACK STEPPED
	MVI	A,INIT1
CMP1:	CPI	END1	;END OF TRACK 1?
	MOV	E,A	;RESTORE TRK/SEC
	JNZ	READL	;GO BACK FOR MORE
;
;	END OF LOAD
;SET LOC 4 TO CONTAIN ACTIVE DRIVE=0
	XRA	A
	STA	04H
;NOW CALCULATE A CHECK SUM FROM BEGINNING OF LOAD
;POINT THRU ALL OF CBIOS
	XRA	A
	LXI	H,LOADP
L3:
	ADD	M
	INX	H
	MOV	B,A	;SAVE TOTAL
	MOV	A,H
	CPI	HLAST
	MOV	A,B	;GET THE SUM BACK
	JNZ	L3
;DISPLAY SUM ON THE IMSAI FRONT PANEL
	OUT	255D
	JMP	BCP	;GO TO COMMAND PROCESSOR
;
	ORG	7FH
	NOP		;FOR SOME DYNAMIC MEMORIES
	END
