	ORG	100H
CBBASE	EQU	3E00H
CONOUT	EQU	CBBASE+0CH
CONIN	EQU	CBBASE+9
CTLC	EQU	3
LASTSEC	EQU	26
	LXI	SP,STKTOP
GO:
	LXI	D,MESGA
	CALL	CRPRT
	CALL	CONIN
	CPI	CTLC	;IS IT CONTROL C?
	JZ	0	;REBOOT IF YES
	LXI	D,MESGB
	CALL	CRPRT
	CALL	CONIN
	CALL	COPY
	JMP	GO	;LOOP TILL CTL C
;
MESGA:	DB	'SOURCE ON A, THEN RETURN $'
MESGB:	DB	'DESTINATION ON B, THEN RETURN $'
MESGC:	DB	'COMPARE ERROR ON TRACK $'
MESGD:	DB	'(HEX) SECTOR $'
MESGE:	DB	'PERMANENT $'
;
CRPRT:	CALL	CRLF
PRTMSG:	LDAX	D	;GET CHAR
	INX	D
	CPI	'$'
	RZ
	PUSH	D
	MOV	C,A
	CALL	CONOUT
	POP	D
	JMP	PRTMSG	;LOOP TILL $
;
CRLF:	MVI	C,0DH
	CALL	CONOUT
	MVI	C,0AH
	CALL	CONOUT
	RET
;
PRTHEX:	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	PRTNBL
	POP	PSW
PRTNBL:	ANI	0FH
	ADI	30H
	CPI	3AH
	JC	SML
	ADI	7
SML:
	MOV	C,A
	CALL	CONOUT
	RET
;
;
COPY:
	MVI	C,0
	CALL	SELDSK	;SELECT DISK A
	CALL	HOME	;AND HOME
	MVI	C,1
	CALL	SELDSK	;ALSO B
	CALL	HOME
	MVI	A,0
	STA	TRK	;SET UP TRACK POINTER
RDLOOP:	MVI	C,0
	XRA	A
	STA	CMPERR
	CALL	SELDSK
	LDA	TRK	;GET TRACK
	MOV	C,A
	CALL	READT	;READ ENTIRE TRACK
RETRYW:
	MVI	C,1
	CALL	SELDSK
	LDA	TRK
	MOV	C,A
	CALL	WRITET	;WRITE TRACK
	LDA	TRK
	MOV	C,A
	CALL	COMPT	;REREAD AND COMPARE
	JNZ	RETRYW	;RETRY IF ERR
	LDA	TRK
	INR	A
	STA	TRK
	CPI	77	;ARE WE DONE?
	JNZ	RDLOOP	;LOOP IF NOT
	RET
;
;
COMPT:	LXI	H,BUF1
	CALL	RT2	;REREAD INTO BUF1
	LXI	H,BUF0
	LXI	D,BUF1
	LXI	B,128*LASTSEC
CMPLP:	LDAX	D
	CMP	M
	JNZ	CERR
	INX	H
	INX	D
	DCR	C
	JNZ	CMPLP
	DCR	B	;ARE WE AT END OF BUFFER?
	JNZ	CMPLP
	RET
CERR:	PUSH	B
	LXI	D,MESGC
	CALL	CRPRT
	LDA	TRK
	CALL	PRTHEX
	LXI	D,MESGD
	CALL	PRTMSG
	POP	H	;PUSHED FROM B
	DAD	H	;COMPUTE SECTOR IN ERROR
	LXI	D,0FF00H
	DAD	D
	MVI	A,27
	SUB	H
	CALL	PRTHEX	;PRINT SECTOR
	LDA	CMPERR
	INR	A
	STA	CMPERR	;INCREMENT ERROR COUNT
	CPI	10
	RNZ
	LXI	D,MESGE
	CALL	PRTMSG
	XRA	A
	RET
;
;
READT:	LXI	H,BUF0	;TRACK # IN C
RT2:	SHLD	DMAAD
	CALL	SETTRK
	MVI	C,1
RT3:	PUSH	B
	CALL	SETSEC
	CALL	READ
	LHLD	DMAAD
	LXI	D,128
	DAD	D
	SHLD	DMAAD
	POP	B
	MVI	A,LASTSEC
	CMP	C
	RZ
	INR	C
	JMP	RT3
;
;
WRITET:	LXI	H,BUF0	;TRACK # IN C
WT2:	SHLD	DMAAD
	CALL	SETTRK
	MVI	C,1
WT3:	PUSH	B
	CALL	SETSEC
	CALL	WRITE
	LHLD	DMAAD
	LXI	D,128
	DAD	D
	SHLD	DMAAD
	POP	B
	MVI	A,LASTSEC
	CMP	C
	RZ
	INR	C
	JMP	WT3
CMPERR:	DB	0	;NUMBER OF COMPARE ERRORS
TRK:	DB	0
STK:	DS	32
STKTOP:	DB	0
	ORG	400H	;KEEP CONSTANT
;		TRACK   =  LAST SELECTED TRACK
;		SECTOR  =  LAST SELECTED SECTOR
;		DMAAD   =  LAST SELECTED DMA ADDRESS
;		DISKNO  =  LAST SELECTED DISK NUMBER
;	(NOTE THAT ALL ARE BYTE VALUES EXCEPT FOR DMAAD)
;
SCRAT	DB	0,0,0,0,0,0,0,0,0,0,0	;START OF SCRATCH AREA
TRACK	EQU	SCRAT		;CURRENT TRACK ON DRIVE 0
TRAK1	EQU	TRACK+1		;CURRENT TRACK ON DRIVE 1
SECTOR	EQU	SCRAT+2		;CURRENTLY SELECTED SECTOR
DMAAD	EQU	SCRAT+3		;CURRENT DMA ADDRESS
DISKNO	EQU	SCRAT+5		;CURRENT DISK NUMBER
DUMMY	EQU	DISKNO+1	;MUST BE 0 FOR DOUBLE ADD
;
;
;
;
;	I/O DRIVERS FOR THE DISK FOLLOW
;
HOME:	;MOVE TO THE TRACK 00 POSITION OF CURRENT DRIVE
	LDA	DISKNO	;SELECTED DISK
	MOV	C,A	;FOLLOW PARAMETER CONVENTIONS
	CALL	SELDSK	;ROUTINE TO SELECT THE DISK
;SET UP H,L TO POINT TO WORD WITH TRACK FOR SELECTED DISK
	LXI	D,TRACK
	LHLD	DISKNO
	DAD	D
HOMEL:
	MVI	M,00	;SET CURRENT TRACK PTR BACK TO 0
	IN	127	;READ FDC STATUS
	ANI	4	;TEST TRACK 0 BIT
	RNZ		;RETURN IF AT 0
	STC		;DIRECTION=OUT
	CALL	STEP	;STEP ONE TRACK
	JMP	HOMEL	;LOOP
;
SELDSK:	;SELECT DISK GIVEN BY REGISTER C
;MAKE SURE DUMMY IS 0 (FOR USE IN DOUBLE ADD TO H,L)
	XRA	A
	STA	DUMMY
	MOV	A,C
	STA	DISKNO
	RRC		;PUT INTO BITS 4,5
	RRC
	RRC
	RRC
	ORI	08	;ENABLE DISK SELECT
	OUT	127	;SELECT THE DISK
	RET
;
SETTRK:	;SET TRACK GIVEN BY REGISTER C
;FIRST REFERENCE CORRECT TRACK INDICATOR ACCORDING TO
;SELECTED DISK
	LXI	D,TRACK	;ADDRESS OF TRACK FOR DISK 0
	LHLD	DISKNO	;FIND OUT WHICH DISK IS SELECTED
	DAD	D
	MOV	A,C	;DESIRED TRACK
	CMP	M
	RZ		;WE ARE ALREADY ON THE TRACK
SETTKX:
	CALL	STEP	;STEP TRACK-CARRY HAS DIRECTION
			;STEP WILL UPDATE TRACK INDICATOR
	MOV	A,C
	CMP	M	;ARE WE WHERE WE WANT TO BE
	JNZ	SETTKX	;NOT YET
;HAVE STEPPED ENOUGH
SEEKRT:
;DELAY 18 MSEC FOR FINAL STEP TIME AND HEAD SETTLE TIME
	MVI	A,18D
	CALL	DELAY
	RET		;END OF SETTRK ROUTINE
;
DELAY:	;ROUTINE TO DELAY C(A) MILLISECONDS
	MVI	C,82H	;ADJUST FOR 1 MSEC LOOP DELAY
			;THIS IS THE VALUE FOR OUR IMSAI
LDXA:
	DCR	C
	JNZ	LDXA	;LOOP 1 MSEC
	DCR	A
	JNZ	DELAY
	RET		;END OF DELAY ROUTINE
;
SETSEC:	;SET SECTOR GIVEN BY REGISTER C
	MOV	A,C
	STA	SECTOR
	RET
;
SETDMA:	;SET DMA ADDRESS GIVEN BY REGISTERS B AND C
	MOV	L,C	;LOW ORDER ADDRESS
	MOV	H,B	;HIGH ORDER ADDRESS
	SHLD	DMAAD	;SAVE THE ADDRESS
	RET
;
;
ERRORS:	DB	0	;KEEP TRACK OF NUMBER OF ERRORS
READ:	;PERFORM READ OPERATION.
	;THIS IS SIMILAR TO WRITE, SO SET UP READ COMMAND AND USE
	;COMMON CODE IN WRITE
	MVI	D,40H	;SET READ FLAG
	JMP	WAITIO	;TO PERFORM THE ACTUAL I/O
;
WRITE:	;PERFORM A WRITE OPERATION
	MVI	D,80H	;SET WRITE COMMAND
;
WAITIO:
;ENTER HERE FROM READ AND WRITE TO PERFORM THE ACTUAL I/O 
;OPERATION.  RETURN A 00H IN REGISTER A IF THE OPERATION COMPLETES
;PROPERLY, AND 01H IF AN ERROR OCCURS DURING THE READ OR WRITE
;
;IN THIS CASE, WE HAVE SAVED THE DISK NUMBER IN 'DISKNO' (0,1)
;			THE TRACK NUMBER IN 'TRACK' (0-76)
;			THE SECTOR NUMBER IN 'SECTOR' (1-26)
;			THE DMA ADDRESS IN 'DMAAD' (3-3F80H)
			;D STILL HAS R/W FLAG
	MVI	A,0	;SET ERROR COUNT
	STA	ERRORS	;RETRY SOME FAILURES 10 TIMES
			;BEFORE GIVING UP
TRYAGN:
;FIRST WE HAVE TO FIGURE OUT WHICH DRIVE IS SELECTED
;AND WHICH TRACK IS DESIRED
	LXI	B,TRACK
	LHLD	DISKNO
	DAD	B	;H,L POINT TO CORRECT TRACK INDICATOR
	MOV	A,M
	PUSH	PSW	;NEED IT LATER
	LHLD	DMAAD	;GET BUFFER ADDRESS
	DCX	H	;SAVE AND REPLACE 3 BYTES BELOW
			;BUF WITH TRACK,SECTOR,ADDRESS MARK
	MOV	B,M
	MVI	A,0FBH	;ADDRESS MARK
	MOV	M,A
	DCX	H
	MOV	C,M
	LDA	SECTOR	;NOTE THAT INVALID SECTOR NUMBER
			;WILL RESULT IN HEAD UNLOADED
			;ERROR, SO DONT CHECK
	MOV	M,A
	DCX	H
	MOV	E,M
	POP	PSW
	MOV	M,A
	MOV	A,H	;SET UP FDC DMA ADDRESS
	OUT	126	;HIGH BYTE
	MOV	A,L
	OUT	125	;LOW BYTE
	MOV	A,D	;GET R/W FLAG
	OUT	127	;START DISK READ/WRITE
RWWAIT:	IN	127	;READ FDC STATUS
	ANI	0F8H	;TEST FOR ANY ERROR OR IOF
	JZ	RWWAIT
	MOV	M,E	;RESTORE 3 BYTES BELOW BUF
	INX	H
	MOV	M,C
	INX	H
	MOV	M,B
	IN	127	;TEST FOR ERRORS
	ANI	0F0H
	RZ		;A WILL BE 0 IF NO ERRORS
;COME HERE ON ERROR FROM DISK
	PUSH	D	;SAVE READ/WRITE CODE
	LXI	D,MESGE1
	CALL	CRPRT
	IN	127
	ANI	0F0H
	CALL	PRTHEX
	LXI	D,MESGE2
	CALL	PRTMSG
	LDA	DISKNO
	ADI	'A'
	MOV	C,A
	CALL	CONOUT
	LXI	D,MESGE3
	CALL	PRTMSG
	LXI	D,TRACK
	LHLD	DISKNO
	DAD	D
	MOV	A,M
	CALL	PRTHEX
	LXI	D,MESGE4
	CALL	PRTMSG
	LDA	SECTOR
	CALL	PRTHEX
	LDA	ERRORS
	INR	A
	STA	ERRORS
	CPI	20
	JNZ	REDO	;RETRY	20 TIMES
	POP	D
	MVI	A,0FFH	;ERROR RETURN
	RET
;
MESGE1:	DB	'DISK ERROR, TYPE $'
MESGE2:	DB	', ON DRIVE $'
MESGE3:	DB	', AT TRACK $'
MESGE4:	DB	', SECTOR $'
REDO:
	POP	D	;GET R/W FLAG
	IN	127	;GET ERROR BITS
	ANI	0E0H	;RETRY IF NOT TRACK ERROR
	JNZ	TRYAGN
;WAS A TRACK ERROR SO NEED TO RESEEK
	PUSH	D	;SAVE	READ/WRITE INDICATOR
;FIGURE OUT THE DESIRED TRACK
	LXI	D,TRACK
	LHLD	DISKNO	;SELECTED DISK
	DAD	D	;POINT TO CORRECT TRACK INDICATOR
	MOV	A,M	;DESIRED TRACK
	PUSH	PSW	;SAVE IT
	CALL	HOME
	POP	PSW
	MOV	C,A
	CALL	SETTRK
	POP	D	;GET READ/WRITE INDICATOR
	JMP	TRYAGN
;
;
;
STEP:				;STEP HEAD OUT TOWARDS ZERO
				;IF CARRY IS SET; ELSE
				;STEP IN
; H,L POINT TO CORRECT TRACK INDICATOR WORD
	PUSH	PSW	;SAVE DIRECTION
STWAIT:	IN	127	;INPUT FDC STATUS
	ANI	2	;TEST STEP READY BIT
	JZ	STWAIT	;WAIT FOR STEP READY(MAX 10 MSEC)
	POP	PSW	;GET DIRECTION TO STEP
	JC	OUTX
	INR	M	;INCREMENT CURRENT TRACK BYTE
	MVI	A,4	;SET DIRECTION = IN
DOSTEP:
	OUT	127	;SET DIRECTION BIT IN FDC
	ORI	2
	OUT	127	;PULSE STEP BIT
	ANI	0FDH
	OUT	127	;TURN OFF PULSE
	RET
;
OUTX:
	DCR	M	;UPDATE TRACK BYTE
	XRA	A	;SET DIRECTION = OUT
	JMP	DOSTEP
;
;
;
BUF0:	DS	128*LASTSEC
BUF1:	DS	128*LASTSEC
	END
