	ORG 100H
	LXI	SP,2000H
MONITOR	EQU	0005H
REBOOT	EQU	0000H
;
;INITIALIZE DISKETTES
;
AGAIN:
	CALL	HOME	;GET TO TRACK 0
;PRINT MESSAGE TO SELECT INITIALIZE ROM
	MVI	C,9D	;MONITOR CALL TO PRINT BUFFER
	LXI	D,MESS1
	CALL	MONITOR
;WAIT FOR ANSWER
	MVI	C,01
	CALL	MONITOR
;CHECK FOR YES
	CPI	'Y'
	JZ	OK
	CPI	079H
	JNZ	SYSTEM
OK:
	MVI	C,9D	;PRINT BUFFER CALL
	LXI	D,MESS2	;PROMPT TO PUT IN CORRECT DISK
	CALL	MONITOR
;WAIT FOR RESPONSE
	MVI	C,01
	CALL	MONITOR
;NOW GO AHEAD AND INITIALIZE
;SET UP A TRACKS WORTH OF DATA
;
	XRA	A
	STA	TRK	;START AT TRACK 0
	LXI	H,IDATA+1
	LXI	D,IDATA+1+5+129+1
;
;COPY IDATA 25 TIMES FOR 26 SECTORS
;
	MVI	B,25
ML2:	MVI	C,135	;135 TOTAL BYTES
ML1:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	ML1
	DCR	B
	JNZ	ML2
;
;NOW FILL IN SECTOR BYTES
;
	LXI	H,DSECT
	LXI	D,135
	MVI	A,1
SL1:	MOV	M,A
	DAD	D
	INR	A
	CPI	27
	JNZ	SL1
;
;SET FINISH CODE BYTE
;
	LXI	H,FINCDE+25*135
	MVI	M,0FFH
;
;SET TRACK BYTES
;
LTRK:	LDA	TRK
	LXI	H,DTRK
	LXI	D,135
	MVI	B,26
TL1:	MOV	M,A
	DAD	D
	DCR	B
	JNZ	TL1
;
;;
;HERE WE GO - TURN MICROCODE ON
;
	LXI	H,IDATA
	MOV	A,H
	OUT	126	;SET DMA ADDRESS OM FCD
	MOV	A,L
	OUT	125	;POINTS TO INDEX AM
	XRA	A
	OUT	127
	MVI	A,50D
	CALL	DELAY
	MVI	A,80H
	OUT	127
WW:	IN	127
	ANI	8	;WAIT FOR IO FINISH
	JZ	WW
	IN	127	;CHECK FOR ERROR
	ANI	0F0H
	JZ	NEXTRK
	JMP	REBOOT
;
;INCREMENT TRACK, STEP
;
NEXTRK:	LDA	TRK
	INR	A
	STA	TRK
	CPI	77
	JNZ	DOSTP
	JMP	AGAIN	;DO ANOTHER
DOSTP:	CALL	SEEK
	JMP	LTRK	;FIX TRACK BYTES IN MEM
			;AND WRITE NEXT TRACK
;
DELAY:
	PUSH	B	;DELAY (A) MSEC
LD:
	MVI	C,88H
LDXA:
	DCR	C
	JNZ	LDXA	;LOOP 1 MSEC
	DCR	A
	JNZ	LD
	POP	B
	RET
;
;
;DISK I/O ROUTINES:
;
;	HOME  - STEP HEAD TO TRACK ZERO
;	STEP  - STEP R/W HEAD ONE TRACK IN OR OUT
;	SEEK  - STEP HEAD TO DESIRED TRACK
;
;
;
;TO MAKE USE OF THESE ROUTINES, USER PROGRAMS WILL FILL IN 
;THE FOLLOWING LOCATIONS WITH THE DESIRED DATA.
;
DISKNO:	DB	08	;FILL WITH DISK DRIVE NUMBER IN
			;LOW ORDER BITS.  BIT 3 IS A
			;CONTROL SIGNAL THAT MUST BE 1.
TRK:	DB	0	;FILL IN THE TRACK NUMBER OF THE
			;DISK RECORD DESIRED
SECT:	DB	0	;FILL IN WITH THE SECTOR NUMBER
			;OF THE DISK RECORD DESIRED
ERR:	DW	2100H	;FILL WITH THE ADDRESS OF YOUR
			;ROUTINE THAT HANDLES ERROR
			;RETURNS FROM DISK ACCESS
;
;
;THE FOLLOWING ARE USED BY THE ROUTINES AND DO NOT NEED
;ALTERING BY A USER PROGRAM
;
ERRTYP:	DB	0	;CONTAINS THE ERROR CONDITION
			;FROM THE LAST DISK ACCESS IN 
			;THE FOLLOWING FORMAT.
;
;	IF ONLY ONE BIT IS ON
;
;BIT 7 MEANS HEAD UNLOADED BECAUSE 8 REVOLUTIONS HAVE GONE BY
;		WITHOUT FINDING THE REQUESTED SECTOR
;BIT 6 MEANS DATA FIELD CRC ERROR
;BIT 5 MEANS ID FIELD CRC ERROR
;BIT 4 MEANS TRACK ERROR
;BIT 1 MEANS FILE INOPERATIVE (NOT USED ON 800 SERIES )
;
;	MULTIPLE BIT INDICATIONS
;
;bits 4,5 ON MEAN NO DATA ADDRESS MARK WAS FOUND BETWEEN
;	 	  ID FIELDS
;BITS 4,6 MEAN DATA OVERRUN (DMA WAS TOO SLOW)
;
;
TRACK:	DB	0
AM:	DB	4CH
ERRORS:	DB	0
;
;
HOME:			;SEEK TRACK 00
			;DISKNO MUST BE SET CORRECTLY
	LDA	DISKNO	;SELECT DISK
	OUT	127
	XRA	A
	STA	TRACK	;SET CURRENT TRACK PTR TO 0
	IN	127	;READ FDC STATUS
	ANI	4	;TEST TRACK 0 BIT
	RNZ		;RETURN IF AT 0
	STC		;DIRECTION=OUT
	CALL	STEP	;STEP ONE TRACK
	JMP	HOME	;LOOP
STEP:
			;STEP HEAD OUT (TOWARDS ZERO)
			;IF CARRY IS SET
			;STEP HEAD IN IF CARRY IS RESET.
	PUSH	PSW	;SAVE DIRECTION
STWAIT:	IN	127	;INPUT FDC STATUS
	ANI	2	;TEST STEP READY BIT
	JZ	STWAIT	;WAIT FOR STEP READY;MAX 10 MSEC
	LXI	H,TRACK	;POINTER TO CURRENT TRACK
	POP	PSW	;GET DIRECTION TO STEP
	JC	OUTX
	INR	M	;INCREMENT CURRENT TRACK BYTE
	MVI	A,4	;SET DIRECTION=IN
DOSTEP:	OUT	127	;SET FDC DIRECTION BIT
	ORI	2
	OUT	127	;PULSE STEP BIT
	ANI	0FDH
	OUT	127	;TURN OFF STEP BIT
	RET
;
OUTX:	DCR	M	;UPDATE TRACK BYTE
	XRA	A	;SET DIRECTION=OUT
	JMP	DOSTEP
;
SEEK:			;SEEK TRACK GIVEN IN BYTE TRK
	LDA	TRK
	MVI	C,1	;ERROR TYPE IF TRK INVALID
	CPI	77	;IS TRK BETWEEN 0 AND 76?
	JP	REBOOT	;IF NOT
	LXI	H,TRACK
	CMP	M	;COMPARE WITH PRESENT TRACK
	JZ	SEEKRTN	;FINISHED IF EQUAL
	CALL	STEP	;STEP TRACK,CARRY HAS DIRECTION
	JMP	SEEK
SEEKRTN:
;NEED A 18 MILLISEC DELAY AFTER FINAL STEP
	MVI	A,18D
	CALL	DELAY
	RET
SYSTEM:
;PRINT PROMPT TO PUT SYSTEM DISK BACK IN
	MVI	C,09D
	LXI	D,MESS3
	CALL	MONITOR
	MVI	C,01
	CALL	MONITOR	;WAIT FOR RESPONSE
	JMP	REBOOT	;REBOOT THE SYSTEM
MESS1:	DW	0D0AH
	DB	'INITIALIZATION ROMS SELECTED-YES OR NO? $'
MESS2:	DW	0D0AH
	DB	'PUT DISKETTE TO BE INITIALIZED INTO DRIVE A $'
MESS3:	DW	0D0AH
	DB	'SYSTEM DISKETTE IN? $'
IDATA:
KNDXAM:	DB	0FCH
	DB	0FEH
DTRK:	DB	0
	DB	0
DSECT:	DB	1
	DB	0
	DB	0FBH
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
	DB	0E5H,0E5H,0E5H,0E5H
FINCDE:	DB	0	;ENDCODE
	DB	0,0,0,0
	DB	0,0,0,0
BIGBUF:	DB	0		;BIG BUFFER STARTS HERE
;
;
	END
