	title	'FOXYCALC disk I/O overlay module, version 1.0'
;
	page	58
;
		org	100h		;locate in overlay area
;
;
bdos		equ	0005h		;bdos entry point
open$f		equ	15		;open file function number
set$dma		equ	26		;set dma address function number
ran$rd		equ	33		;random read function number
ran$wr		equ	34		;random write function number
;
ex$off		equ	12		;extent offset from fcb(0)
cr$off		equ	32		;current record offset from fcb(0)
;
tab		equ	09h		;ascii tab character
;
;
;
; ***** INIT$FCB *****
;
; function:	attempts to build a fcb pointed to by <de>
;		from the string pointed to by <hl>
;
; input:	input string in <hl> and fcb in <de>
; returns:	the fcb is initialized, ready for an open
;		or make function call
;
; uses:		flags,<psw>,<bc>,<de>,<hl>
; destroys:	all registers
;
int$fcb:	call	scan$blank	;skip any leading whitespace
		xchg			;swap pointers, <de>= .line,
					;  <hl>= .fcb
;
;	get the first char and convert it to a drive number
;	in case he has selected a drive
;
		ldax	d
		call	uc$alpha	;convert to upper-case
		sui	'@'		;strip bias
		mov	m,a
		inx	d		;next character
		ldax	d
		inx	d		;point to first char of name
					;  in-case drive specified
		cpi	':'		;drive delimiter
		jz	init$fcb$1	;bypass auto-select init
;
		xra	a		;no drive specified, so
		mov	m,a		;  force auto-select code
		dcx	d		;no drive specified so back-up pointer
		dcx	d
;
init$fcb$1:	mvi	b,8		;fcb.name field length
		inx	h		;point to fcb.name field
		call	fill$fcb	;fill-in the name field
;
		ldax	d		;possible name delimiter
		cpi	'.'
		jnz	init$fcb$3
;
		inx	d		;point to type string
;
init$fcb$3:	mvi	b,3		;file type name length
		jmp	fill$fcb
;
fill$fcb:	ldax	d		;get character from line
		ora	a		;test for line end
		jnz	fill$fcb$2
;
		mvi	m,' '		;fill with blanks
		jmp	fill$fcb$4
;
fill$fcb$2:	cpi	'*'		;wild card ?
		jnz	fill$fcb$3
;
		mvi	m,'?'		;match any
		jmp	fill$fcb$4
;
fill$fcb$3:	call	uc$alpha	;convert to upper-case
		mov	m,a		;fill fcb position
		inx	d		;next char in line
;
fill$fcb$4:	inx	h		;next position in fcb
		dcr	b
		jnz	fill$fcb	;loop until field filled
;
		ret
;
;
; ***** UC$ALPHA *****
;
; function:	Translate lower case alpha characters to upper case.
;
; input:	character to translate in <a>.
; returns:	character or translated character in <a>.
;
; uses:		flags
; destroys:	flags
;
uc$alpha:	cpi	'a'		;check if in range "a"-"z"
		rc			; .lt. "a" return, already uppercase
;
		cpi	'z'+1		;upper bound
		rnc			;out of range return as is
;
		sui	' '		;if in range subtract 20h
		ret
;
;
; ***** SCAN$BLANK *****
;
; function:	scan a line buffer ignoring spaces and tabs
;
; input:	<hl> points to some position in a line buffer
; returns:	<hl> points to the first non-blank character
;
; uses:		flags, <a>
; destroys:	flags, <a>
;
scan$blank:	mov	a,m		;get character
		cpi	' '		;see if .gt. space or tab
		jz	scan1
;
		cpi	tab		;a tab (09h) character ?
		rnz
;
scan$1:		inx	h		;point to next position
		jmp	scan$blank	;loop, scaning
;
;
;	open file function
;	opens the file addressed by <hl>
;
;	first clear drive number, extent number ,current record
;	and random record address fields.
;
open$fl:	push	h		;save pointer to fcb
		mvi	m,00h		;clear drive auto-select
		lxi	d,ex$off
		dad	d		;pointer to extent byte
		mov	m,d		;clear extent byte
		lxi	d,cr$off-ex$off
		dad	d
		mov	m,d		;clear current record
		inx	h
		mov	m,d		;clear random record
		inx	h
		mov	m,d
		inx	h
		mov	m,d
;
open$fl$1:	pop	d		;pointer to dr_fcb field
		push	d		;re-save
		mvi	c,open$f	;open file function number
		call	bdos
		ora	a		; 0...3 0k, 0ffh file not found
		jm	try$dr$a	; try to open on drive A:
		pop	h		;return value, fcb address in <hl>
		ret
;
;	we couldn't find the file on the default drive,
;	so try on drive A:
;
try$dr$a:	pop	h		;get pointer to fcb
		mov	a,m		;get drive number
		inr	a		; 0= auto-select, 1= drive A:
		cpi	2		; try drives less than 2
		jnc	open$err
		mov	m,a
		push	h
		jmp	open$fl$1
;
open$err:	lxi	h,0000h		;file not found error code
		ret
;
;
		end		;of disk file overlay
