	REM--------------------------------------------------
	REM		Q   P   A   R   M
	REM
	REM	COPYRIGHT (C) 1977 STRUCTURED SYSTEMS GROUP
	REM	PARAMETER FILE BUILDER PROGRAM IN BASIC-E FOR
	REM	'QSORT', SSG'S CP/M COMPATIBLE SORT/MERGE
	REM	PROGRAM.
	REM--------------------------------------------------

	REM		SEPTEMBER 12, 1977

	CPYRGHT$="COPYRIGHT (C) 1977  STRUCTURED SYSTEMS GROUP "
	MAXKEYS=5
	DIM KPOS(MAXKEYS),KLEN(MAXKEYS),KAD$(MAXKEYS),KAN$(MAXKEYS)
	EOF$=CHR$(26)
	PAD$=CHR$(0)
	TRUE=1
	FALSE=0

	GOSUB 100			REM INITIALIZE
	GOSUB 110			REM ENTER PARAMETER FILE NAME
	GOSUB 120			REM ENTER INPUT FILE DRIVE
	GOSUB 130			REM ENTER INPUT FILE NAME
	GOSUB 140			REM ENTER INPUT FILE TYPE
	GOSUB 150			REM ENTER OUTPUT FILE DRIVE
	GOSUB 160			REM ENTER OUTPUT FILE NAME
	GOSUB 170			REM ENTER OUTPUT FILE TYPE
	GOSUB 180			REM ENTER RECORD LENGTH
	GOSUB 190			REM ENTER BACKUP FLAG
	GOSUB 200			REM ENTER DISK CHANGE FLAG
	GOSUB 210			REM CONSOLE OUTPUT FLAG
	GOSUB 220			REM ENTER WORK DRIVE
	GOSUB 230			REM ENTER SORT KEYS
	GOSUB 240			REM BUILD OUTPUT RECORD
	GOSUB 250			REM OPEN PAR FILE
	GOSUB 260			REM WRITE OUTPUT RECORD
	GOSUB 270			REM CLOSE PAR FILE
999999  STOP

100	REM-----INITIALIZE--------------------------------------
	FOR X=1 TO MAXKEYS
		KLEN(X)=0
		KPOS(X)=0
		KAD$(X)="A"
		KAN$(X)="N"
	NEXT X
	RETURN

110	REM-----ENTER PARAMETER FILE NAME----------------------
	PRINT
	PRINT "ENTER PARAMETER FILE NAME ";
	GOSUB 1100			REM ENTER FILE NAME
	PAR.NAME$=NAME$+".SRT"
	RETURN

120	REM-----ENTER INPUT FILE DRIVE-------------------------
	PRINT
	PRINT "ENTER INPUT FILE DRIVE ";
	GOSUB 1000			REM ENTER DRIVE
	DRIVEIN$=DRIVE$
	RETURN

130	REM-----ENTER INPUT FILE NAME--------------------------
	PRINT
	PRINT "ENTER INPUT FILE NAME ";
	GOSUB 1100			REM ENTER FILE NAME
	IN.NAME$=NAME$
	RETURN

140	REM-----ENTER INPUT FILE TYPE-------------------------
	PRINT
	PRINT "ENTER INPUT FILE TYPE ";
	GOSUB 1200			REM ENTER FILE TYPE
	IN.TYPE$=TYPE$
	RETURN

150	REM-----ENTER OUTPUT FILE DRIVE-----------------------
	PRINT
	PRINT "ENTER OUTPUT FILE DRIVE ";
	GOSUB 1000			REM ENTER DRIVE
	DRIVEOUT$=DRIVE$
	RETURN

160	REM-----ENTER OUTPUT FILE NAME----------------------
	PRINT
	PRINT "ENTER OUTPUT FILE NAME ";
	GOSUB 1100			REM ENTER FILE NAME
	OUT.NAME$=NAME$
	RETURN

170	REM-----ENTER OUTPUT FILE TYPE------------------------
	PRINT
	PRINT "ENTER OUTPUT FILE TYPE ";
	GOSUB 1200			REM ENTER FILE TYPE
	OUT.TYPE$=TYPE$
	RETURN

180	REM-----ENTER RECORD LENGTH---------------------------
	PRINT
180.1	REM
	PRINT "ENTER LOGICAL RECORD LENGTH IN DECIMAL ";
	INPUT REC.LENGTH
	IF REC.LENGTH<1 OR REC.LENGTH>255 THEN \
		PRINT "WRONG LENGTH" :\
		GOTO 180.1
	RETURN

190	REM-----ENTER BACKUP FLAG----------------------------
	PRINT
	PRINT "WANT OUTPUT FILE BACKED UP ";
	GOSUB 1300			REM ENTER Y OR N
	BACKUP.FLAG=ANS
	RETURN

200	REM-----ENTER DISK CHANGE FLAG-------------------------
	PRINT
	PRINT "WANT TO CHANGE OUTPUT DISKETTE ";
	GOSUB 1300			REM ENTER Y OR N
	DISK.CHANGE.FLAG=ANS
	RETURN

210	REM-----ENTER CONSOLE OUTPUT FLAG----------------------
	PRINT 
	PRINT "WANT CONSOLE OUTPUT ";
	GOSUB 1300			REM ENTER Y OR N
	CONSOLE.FLAG=ANS
	RETURN

220	REM-----ENTER WORK DRIVE-----------------------------
	PRINT
220.1	REM
	PRINT "ENTER WORK FILE DRIVE ";
	GOSUB 1000			REM ENTER DRIVE
	IF DRIVE$=DRIVEOUT$ AND DISK.CHANGE.FLAG=TRUE THEN \
		PRINT "CAN'T HAVE WORK AND OUT FILES ON SAME DISK" :\
		PRINT "IF DISK NEEDS CHANGING" :\
		GOTO 220.1
	WORK.DRIVE$=DRIVE$
	RETURN

230	REM-----ENTER SORT KEYS--------------------------------
	PRINT
	FOR X=1 TO MAXKEYS
230.1		REM
		GOSUB 2000		REM ENTER KEY START
		IF KPOS(1)=0 THEN \
			PRINT "FIRST KEY MUST BE USED" :\
			GOTO 230.1
		IF KPOS(X)=0 THEN \
			RETURN		REM ALL DONE
		GOSUB 2100		REM ENTER KEY LENGTH
		GOSUB 2200		REM ENTER ASCEND/DESCEND
		GOSUB 2300		REM ENTER ALPHA/NUMERIC
	NEXT X
	RETURN

240	REM-----BUILD OUTPUT RECORD---------------------------
	PRINT "BUILDING PARAMETER RECORD"
	RECORD$=""
	RECORD$=RECORD$+DRIVEIN$
	RECORD$=RECORD$+IN.NAME$
	RECORD$=RECORD$+IN.TYPE$
	RECORD$=RECORD$+DRIVEOUT$
	RECORD$=RECORD$+OUT.NAME$
	RECORD$=RECORD$+OUT.TYPE$
	RECORD$=RECORD$+PAD$
	RECORD$=RECORD$+CHR$(REC.LENGTH)
	RECORD$=RECORD$+PAD$+PAD$+PAD$+PAD$+PAD$
	RECORD$=RECORD$+CHR$(BACKUP.FLAG)
	RECORD$=RECORD$+CHR$(DISK.CHANGE.FLAG)
	RECORD$=RECORD$+CHR$(CONSOLE.FLAG)
	RECORD$=RECORD$+WORK.DRIVE$
	FOR X=1 TO MAXKEYS
		RECORD$=RECORD$+CHR$(KPOS(X))
		RECORD$=RECORD$+CHR$(KLEN(X))
		RECORD$=RECORD$+KAD$(X)
		RECORD$=RECORD$+KAN$(X)
	NEXT X
	RECORD$=RECORD$+PAD$+PAD$+PAD$+PAD$+PAD$+PAD$+PAD$+PAD$
	RECORD$=RECORD$+EOF$
	RETURN

260	REM-----WRITE OUTPUT RECORD----------------------------
	PRINT #1;RECORD$
	RETURN

250	REM-----OPEN PARAMETER FILE---------------------------
	IF END #1 THEN 250.5
	FILE PAR.NAME$
	RETURN

250.5	REM-----EOF ON PARAMETER FILE-----------------------
	PRINT "EOF ON PAR FILE"
	RETURN

270	REM-----CLOSE PARAMETER FILE--------------------------
	CLOSE 1
	RETURN

1000	REM-----ENTER DRIVE-----------------------------------
	INPUT DRIVE$
	IF DRIVE$<>"A" AND \
	   DRIVE$<>"B" AND \
	   DRIVE$<>"@" THEN \
		PRINT "INVALID DRIVE" :\
		GOTO 1000
	IF DRIVE$="A" THEN DRIVE$=CHR$(1)
	IF DRIVE$="B" THEN DRIVE$=CHR$(2)
	IF DRIVE$="@" THEN DRIVE$=CHR$(0)
	RETURN

1100	REM-----ENTER FILE NAME-------------------------------
	INPUT NAME$
	IF LEN(NAME$)<1 OR LEN(NAME$)>8 THEN \
		PRINT "WRONG LENGTH" :\
		GOTO 1100
	FOR Q=1 TO LEN(NAME$)
		CHAR$=MID$(NAME$,Q,1)
		IF CHAR$<"0" OR CHAR$>"Z" OR \
		   (CHAR$>"9" AND CHAR$<"A") THEN \
			PRINT "INVALID CHARACTERS IN NAME" :\
			GOTO 1100
	NEXT Q
	NAME$=LEFT$(NAME$+"       ",8)
	RETURN

1200	REM-----ENTER FILE TYPE--------------------------------
	INPUT TYPE$
	IF LEN(TYPE$)>3 THEN \
		PRINT "WRONG LENGTH" :\
		GOTO 1200
	IF LEN(TYPE$)=0 THEN \
		TYPE$="   " :\
		RETURN
	FOR Q=1 TO LEN(TYPE$)
		CHAR$=MID$(TYPE$,Q,1)
		IF CHAR$<"0" OR CHAR$>"Z" OR \
		  (CHAR$>"9" AND CHAR$<"A") THEN \
			PRINT "INVALID CHARACTERS IN TYPE" :\
			GOTO 1200
	NEXT Q
	TYPE$=LEFT$(TYPE$+"   ",3)
	RETURN

1300	REM-----ENTER YES OR NO--------------------------------
	INPUT ANS$
	IF LEFT$(ANS$,1)="Y" THEN \
		ANS=1 :\
		RETURN
	IF LEFT$(ANS$,1)="N" THEN \
		ANS=0 :\
		RETURN
	IF ANS$="TESTING" THEN \
		ANS=2 :\
		RETURN
	PRINT "ENTER 'Y' OR 'N'"
	GOTO 1300

2000	REM-----ENTER KEY STARTING POSITION--------------------
	PRINT
	PRINT "ENTER KEY #";X;" STARTING POSITION ";
	INPUT POSITION
	IF POSITION>REC.LENGTH THEN \
		PRINT "EXCEEDS RECORD LENGTH" :\
		GOTO 2000
	IF POSITION<0 THEN \
		PRINT "NEGATIVE NUMBER INVALID" :\
		GOTO 2000
	KPOS(X)=POSITION
	RETURN

2100	REM-----ENTER KEY LENGTH-----------------------------------
	PRINT "ENTER KEY #";X;" LENGTH ";
	INPUT LENGTH
	IF (KPOS(X)-1)+LENGTH>REC.LENGTH THEN \
		PRINT "KEY EXCEEDS RECORD LENGTH" :\
		GOTO 2100
	IF LENGTH<1 THEN \
		PRINT "NEGATIVE OR ZERO LENGTH INVALID" :\
		GOTO 2100
	KLEN(X)=LENGTH
	RETURN

2200	REM-----ENTER ASCEND/DESCEND FLAG--------------------------
	PRINT "ENTER KEY #";X;" ASCEND/DESCEND FLAG ";
	INPUT AD$
	IF AD$="A" THEN \
		KAD$(X)=AD$ :\
		RETURN
	IF AD$="D" THEN \
		KAD$(X)=AD$ :\
		RETURN
	PRINT "ENTER 'A' OR 'D'"
	GOTO 2200

2300	REM-----ENTER ALPHA/NUMERIC FLAG----------------------------
	PRINT "ENTER KEY #";X;" ALPHA/NUMERIC FLAG ";
	INPUT AN$
	IF AN$="A" THEN \
		KAN$(X)=AN$ :\
		RETURN
	IF AN$="N" THEN \
		KAN$(X)=AN$ :\
		RETURN
	PRINT "ENTER 'A' OR 'N'"
	GOTO 2300

