	title	'IMSAI VIO 24/80 driver.  27 oct 82'
;	
;	vio terminal firmware requires refresh memory at
;	f000 and firmware itself at f800
;************************************************
;
videoram	equ	0f000h		;refresh mem on vio
sysram		equ	0f780h		;system ram
viofm		equ	0f800h		;firmware start
ctrport		equ	videoram+7ffh	;hardware control word
;
;
		org	sysram
;
curlin		db	0		;current line # 0-23
curcol		db	0		;current col # 0-79
invidio		db	0		;inverse vidio mode (by char)
vdimde		db	0		;mode 0=graphics, not 0=text
insrt		db	0		;inserting characters mode
escont		db	0		;escape char count
escode		db	0		;escape code last used
userctr		dw	0		;user cir tble ptr, non zero
useresc		dw	0		;user escape tble ptr, non zero
usercmd		dw	0		;user monitor command table
ramptr		dw	0		;ram space ptr with direct i/o
curptr		dw	0		;cursor address
prtmd		db	0		;protected mode 0=no
ccur		db	0		;char under cursor(for graphics)
cchar		db	0		;current character to display
ctrlc		db	0		;control word as follows
;
;	7 -- scroll mode 0=scroll,1=wrap
;	6 -- unused
;	5 -- up/low: 0=up, 1=low
;	4 -- 1=inverse vidio screen
;	3 -- 00=blank, 01=low128+inv, 10=high128
;	2 -- 11=256 char graphics
;	1 -- # lines 0=24, 1=12
;	0 -- # chars 0=80, 1=40
;
tab		equ	$
;
		org	$+10		;80 bits for tab control
;
cline		dw	0		;chars/line
lpage		db	0		;lines/page-1
nchars		dw	0		;#chars on display
pruprf		db	0		;transition protect flag
userf		db	0		;entry point flag 0=init48, 1=char48, 2=user
lastc		dw	0		;last character on screen ptr+1
;
;************************************************
;	 user entry points
;************************************************
;
		org	viofm
;
		jmp	init		;initialization point
		jmp	charout		;character output
;
;
;************************************************
;
init:		push	h
		push	d
		push	b
		push	psw
		lxi	h,curlin	;start of zeroed area
		mvi	b,cline-curlin and 0ffh
		xra	a
;
init1:		mov	m,a		;zero area
		inx	h
		dcr	b
		jnz	init1
		lxi	h,videoram	;begin cursor pos
		shld	curptr
		lxi	h,1920		;default chars/screen
		shld	nchars
		call	blnks		;clear screen and home
		mvi	a,8h		;default 80x24 screen text mode
		lxi	d,bmp1		;set up return addr
		push	d
;
;	subroutine to set hardware control port
;
setcmd:		sta	ctrlc
		sta	ctrport		;hardware control port
		cma
		ani	3
		rrc			;finding nchar on screen
		lxi	h,40		;cols/line
		jnc	stcmd1		;enough
		dad	h		;cols/line=80
;
stcmd1:		shld	cline
		lxi	h,lpage		;pt at lines/page
		mvi	m,11
		rar
		jnc	stcmd2
		mvi	m,23
;
stcmd2:		lxi	h,480		;count for 12x40 screen
		jnc	stcmd3
		dad	h
;
stcmd3:		ora	a		;set flags
		jz	stcmd4
		dad	h
;
stcmd4:		shld	nchars
		lxi	d,videoram
		dad	d
		shld	lastc		;last char /screen ptr+1
		lda	ctrlc		;control code
		ani	0ch		;mode bits only
		xri	0ch
		sta	vdimde		;0=graphics
;
;	check cursor within possible new bounds
;
escret:		xra	a
		sta	escont		;count=0
		ret
;
;************************************************
;	normal entry point for communicating with
;	the vidio monitor as if a crt.
;************************************************
;
charout:	push	h
		push	d
		push	b
		push	psw
		sta	cchar
		lhld	curptr		;cursor position
		lda	ccur		;char under cursor
		mov	m,a		;remove cursor
		lxi	h,cchar		;pt at current char
		mov	a,m		;get char
		cpi	1bh		;escape char?
		jz	escape
		lda	escont		;are we in escape seq alreaady?
		ora	a
		jnz	escape		;yes
		mov	a,m		;current char
		cpi	7fh		;delete char (rubout)?
		jz	nousr1		;yes
		lda	vdimde		;graphics mode?
		ora	a
		jz	char1		;yes
		mov	a,m
		cpi	0ffh		;dummy pad from user?
		jz	bmp1		;yes
		ani	7fh		;strip parity bit
		mov	m,a
		sbi	20h		;control code?
		jm	control		;yes
		lda	ctrlc		;control word
		mov	b,a		;tmp save
		ani	0ch		;mode only
		cpi	08h		;low half of char gen rom?
		jnz	char1		;no, upper half
		mov	a,b		;control word
		ani	20h		;up/low case
		jnz	char1		;lower ok as is
		mov	a,m		;current char
		sbi	61h		;lower case a
		jm	char1		;not alpha
		sbi	7bh-61h
		jp	char1		;not alpha
		adi	7bh-20h		;restore and convert 2 uppercase
		mov	m,a
;
char1:		call	inschr		;insert cchar at cursor pos
		call	bmpcur
;
bmp10:		call	calpos		;cursor pos
;
bmp1:		call	inscurs		;insert cursor
		pop	psw
		pop	b
		pop	d
		pop	h
		ret
;
bmpcur:		call	bmpc		;bump cursor char position
		cz	bmpcur1		;do line feed
		lda	prtmd		;protect mode?
		xchg			;<hl>=current cursor ptr
		ana	m		;is it protected?
		jm	bmpcur		;yes, skip protected field
		ret			;go insert cursor
;
lfeed:		lxi	h,curlin
;
bmpcur1:	inr	m
		lda	lpage		;max lines/page
		cmp	m		;exceed max?
		rp
		dcr	m		;leave at last line
;
;************************************************
;	scroll up or wrap around as set by ctrlc
;************************************************
;
scroll:		lda	ctrlc		;kind of scroll?
		ani	8ch		;leave scroll and mode bits
		jm	scroll3		;wrap around
		cpi	0ch		;graphics mode
		jnz	scroll1		;no,allow scroll
;
scroll3:	xra	a
		mov	m,a		;home cursor for wrap around
		inx	h
		mov	m,a
		ret
;
scroll1:	lhld	cline		;cols/line
		push	h		;save cols/line
		xchg
		lhld	nchars		;# chars per page
		mov	a,l
		sub	e
		mov	c,a
		mov	b,h
		xchg
		lxi	d,videoram
		dad	d		;hl=source,de=dest.
		call	mvcup
;
scroll2:	jmp	dline1		;erase current line & return
;
;************************************************
;	process control codes
;************************************************
;
control:	xchg			;<de>=cchar ptr
		lhld	userctr		;user table if any
		mov	a,h
		ora	a
		ldax	d		;cchar in a
		jz	nouser		;no table user defined
		call	lookup
		jnz	fndctrl		;found table entry
;
nouser:		lda	cchar
;
nousr1:		lxi	h,ctrtbl
		call	lookup
		jz	bmp1		;not found
;
fndctrl:	lxi	d,bmp10		;return address
		push	d		;on stack
		lxi	d,curcol
		pchl
;
;************************************************
;	process escape sequences
;************************************************
;
escape:		lxi	d,bmp10		;return address
		push	d
		xchg
		lxi	h,escont
		mov	a,m		;escape count
		inr	m		;escont=escont+1
		ora	a
		rz
		dcr	a
		inx	h
		ldax	d		;get cchar
		jnz	escap1		;escont>1
		mov	m,a		;save escape code
;
escap1:		lhld	useresc		;user escape table ptr
		mov	a,h
		ora	a
		ldax	d		;esccode
		jz	nuesc		;no user defined table
		call	lookup		;lookup in users table
		jnz	fndesc		;found escape seq in user
;
nuesc:		lda	escode		;try again in vio table
		ani	0dfh		;remove lower casebit
		lxi	h,esctbl
		call	lookup
		jz	escret		;not found
;
fndesc:		lda	ctrlc
		lxi	d,setcmd
		pchl
;
;************************************************
;	cursor control
;************************************************
;
upline:		dcx	d		;<de>=curlin ptr
;
bcklne:		ldax	d		;<de>=curlin or curcol
		ora	a		;set flags
		rz
		dcr	a		;back up 1
;
bckl1:		stax	d
		ret
;
cret:		xra	a
		sta	insrt		;remove insert mode
		jmp	bckl1
;
;************************************************
;	toggle protected mode flag
;************************************************
;
prtect:		lxi	h,prtmd		;pt at flag
		jmp	insmd1		;go toggle it
;
;************************************************
;	toggle insert mode flag
;************************************************
;
insmde:		lxi	h,insrt
;
insmd1:		mov	a,m
		cma
		mov	m,a
		ret
;
;************************************************
;	blank screen and home
;************************************************
;
blnks:		lhld	nchars		;#chars on screen
		xchg
		lxi	h,videoram
;
blnks1:		lda	prtmd		;in protected mode?
		ani	80h
		ana	m		;protected?
		jm	blnks2		;is protected, do not blank
		mvi	m,' '
;
blnks2:		inx	h
		dcx	d
		mov	a,d
		ora	e		;done yet?
		jnz	blnks1		;no
;
home:		lxi	h,0
		shld	curlin
		ret
;
;************************************************
;	blank from cursor to end of unprotected field
;************************************************
;
blankl:		call	charln		;calc # chars to end of line
;
blankl3:	lda	prtmd		;protected mode?
		ora	a
		jz	blankl1		;not protected,skip check
		mov	a,m		;get char
		ora	a
		jm	blankl2		;is protected, do not blank
;
blankl1:	mvi	a,' '
		mov	m,a		;insert blank
;
blankl2:	inx	h		;next char
		dcr	c		;count
		jnz	blankl3
		ret
;
;************************************************
;	turn on protected field/turn off protected field
;************************************************
;
protc:		lxi	h,invidio	;pt at inverted vidio flag
		jmp	insmd1
;
;************************************************
;	delete char and shift protected field left one place
;************************************************
;
delete:		call	charln
		lhld	curptr		;cursor position
		mov	d,h
		mov	e,l
		inx	h
		call	mvcup		;shift line left one place
		mvi	a,' '
		dcx	d		;back up one
		stax	d		;insert final blank
		ret
;
;************************************************
;	calc # chars from cursor to end of unprotected field
;	inclusive return <hl>=cursor ptr
;************************************************
;
charln:		lda	prtmd		;protect mode flag
		ani	80h
		mov	d,a		;save protect mode bit
		lhld	curptr		;cursor position
		push	h
		lda	curcol
		mov	e,a		;e=current column
		lxi	b,0		;# chars to end
;
charln1:	lda	cline		;cols/line
		sub	e
		inr	e
		inx	h
		inr	c		;count increased
		dcr	a		;done yet with line
		jz	charln2		;end of line return
		mov	a,m		;<hl>=end+1
		ana	d		;protected?
		jp	charln1		;no, keep going
;
charln2:	pop	h		;cursor position
		ret
;
;************************************************
;	table look up routine. searches first byte of three byte records
;	for a match or zero.  zero indicates end of table with no match,
;	returned in a reg.  <hl> loaded with second two bytes of table
;	if match found.
;************************************************
;
lookup:		mov	b,a		;save
;
lukup1:		mov	a,m		;get first byte of record
		lxi	d,curlin
		ora	a
		rz			;done, no match
		cmp	b		;same as requested?
		jnz	tblup1		;no
		inx	h
		mov	e,m
		inx	h
		mov	d,m
		xchg
		ora	a		;set flags
		ret
;
tblup1:		inx	h
		inx	h
		inx	h		;bump to next record
		jmp	lukup1
;
;************************************************
;	delete current line and return cursor
;************************************************
;
dline:		call	nmchm		;set up for move
		push	h		;save cols/line
		dad	d		;<hl>=source begin
		call	mvcup
dline1:		pop	b		;cols/line
		xchg
		jmp	en1		;erase line
;
;************************************************
;	enter new line at cursor line, push bottom down
;************************************************
;
enline:		call	nmchm		;set up for move
		push	h		;save cols/line
		dad	d		;<hl>=source begin
		dad	b		;<hl>=end of dest+1
		xchg
		dad	b		;<hl>=end of source+1
		dcx	h
		dcx	d
		call	mvcdn		;move down 1 line
		pop	b
		inx	h
;
en1:		mvi	m,' '
		inx	h
		dcr	c
		jnz	en1
		ret
;
nmchm:		xra	a
		stax	d		;col=0
		call	charsn		;#chars to end of screen
		xchg			;<de>=dest.
		lhld	cline		;cols/line
		mov	a,l		;cols/line
;
nmchm1:		dcx	b
		dcr	a
		jnz	nmchm1		;decrease count by one lines worth
		ret
;
;************************************************
;	calc # chars to end of screen from cursor
;************************************************
;
charsn:		call	calpos
		push	h		;save
		xchg			;<de>=cursor position
		lhld	lastc		;last char position+1
		mov	a,d
		cma
		mov	d,a
		mov	a,e
		cma
		mov	e,a
		inx	d		;compliment <de>
		dad	d		;<hl>=# chars to end-1
		push	h
		pop	b		;<bc>=#chars to end
		pop	h		;current position cursor
		ret
;
;************************************************
;	escape code processing
;************************************************
;
high128:	ani	0f3h
		ori	4h
		xchg			;<hl>=setcmd addr
		pchl
;
;	graphic mode 256 char rom, no inverse vidio
;
graphic:	ori	0ch
		xchg			;<hl>=setcmd addr
		pchl
;
;	lower half of rom+reverse vidio
;
low128:		ani	0f3h
		ori	8h
		xchg			;<hl> setcmd addr
		pchl
;
;	scroll toggle
;
scrl:		xri	80h
		xchg			;<hl>=setcmd addr
		pchl
;
;	upper lower case toggle
;
uplow:		xri	20h
		xchg			;<hl>=setcmd addr
		pchl
;
;	inverse vidio toggle
;
vidio:		xri	10h
		xchg			;<hl>=setcmd addr
		pchl
;
;	lines per page switch
;
lines:		xri	02h
		xchg			;<hl>=setcmd addr
		pchl
;
;	#cols/line toggle
;
cols:		xri	01h
		xchg			;<hl>=setcmd addr
		pchl
;
;************************************************
;	insert cursor char at proper position
;************************************************
;
inscurs:	lhld	curptr
		mov	a,m
		sta	ccur		;save char under cursor for graphics mode
		ori	80h		;bit 7 for inverse vidio
		mov	m,a		;store back
		lda	vdimde
		ora	a
		rnz			;no graphics
		mvi	m,7fh		;block for graphics mode
		ret
;
;************************************************
;	clear tabs
;************************************************
;
clrtbs:		lxi	h,tab		;tab bits
		mvi	b,10		;#bytes for tabs
		xra	a
;
clrt1:		mov	m,a
		inx	h
		dcr	b
		jnz	clrt1
		jmp	escret		;put in cursor
;
;************************************************
;	set or clear tab toggle bit
;************************************************
;
settab:		call	fndtb
		xri	80h		;invert tab bit
;
setd2:		rrc
		dcr	b
		jnz	setd2
		stax	d		;store tab byte
		jmp	escret		;do cursor
;
;	find tab bit,leave in a reg. bit 7
;
fndtb:		lda	curcol		;col#
		mov	h,a
		inr	h
		lxi	d,tab		;word ptr
;
fndtb1:		mvi	c,8		;bit counter
;
fndtb3:		dcr	h
		jz	fndtdn		;found it
		dcr	c		;bit counter
		jnz	fndtb3
		inx	d		;pt at next byte
		jmp	fndtb1
;
fndtdn:		ldax	d		;get tab byte bits
		mov	b,c		;save count of bits
;
fndtb2:		rlc
		dcr	c
		jnz	fndtb2		;rotate until found
		ret
;
;************************************************
;	tab to beginning of next unprotected field or tab or home if none
;************************************************
;
tabb:		xra	a
		sta	pruprf		;protect/unprotect transition flag
;
tab3:		call	bmpc		;bump cursor position
		jnz	tab1		;no line feed necessary
		inr	m		;bump line #
		cmp	m		;exceed lpage?
		jm	scroll3		;yes, home and return
;
tab1:		lda	prtmd		;protect mode flag
		xchg			;<hl> pts at char
		ana	m		;protected?
		mov	a,m		;get char
		lxi	d,pruprf	;transition flag
		jp	tab2		;no protected field
		stax	d		;set transition flag
		jmp	tab3
;
tab2:		ldax	d		;get transition flag
		ora	a
		rm			;unprot field with transition
		call	fndtb		;find tab position bit
		ora	a		;set flags
		rm			;tab is set
		jmp	tab3
;
;************************************************
;	calculate cursor position from curlin and curcol
;************************************************
;
calpos:		lhld	cline		;chars/line-1
		xchg
		lhld	curlin		;l=curlin,h=curcol
		mov	c,h
		mov	b,l
		lxi	h,videoram	;bottom of refresh memory
		inr	b
;
calpos1:	dcr	b		;done yet?
		jz	calpos2		;yes
		dad	d		;add another line of chars
		jmp	calpos1
;
calpos2:	dad	b		;add current col
		shld	curptr		;save
		ret
;
;************************************************
;	bmpc bump cursor 1 place. on return
;	 <de>=cursor position
;	 <hl>=curcol ptr or curlin ptr depending on z flag
;	 z flag=0 if no line feed needed, 1 if line feed needed
;	 curlin and curcol and curptr are updated as if line feed
;	 a reg=lpage if line feed needed
;************************************************
;
bmpc:		lhld	curptr
		inx	h
		shld	curptr		;update abs cursor address
		xchg			;<de>=ptr
		lxi	h,curcol
		inr	m		;bump column
		lda	cline		;max cols/line
		sub	m		;zero if exceed line
		rnz			;ok as is
		mov	m,a		;col=0
		dcx	h
		lda	lpage		;max lines/page
		ret
;
;************************************************
;	addressable cursor function
;************************************************
;
addcurs:	lxi	h,escont	;pt at escape count
		lxi	d,curlin	;pt at current line count
		lda	cchar
		sui	20h		;remove offset for count
		mov	b,a
		mov	a,m		;get count
		sui	3
		rm			;no valid numbs yet
		jnz	xadd		;x axis value
;
;	y-axis value
;
		lda	lpage
;
xadd3:		stax	d		;max line #
		cmp	b
		rm
		mov	a,b
		stax	d
		ret
;
xadd:		mvi	m,0		;escont=0
		lda	cline		;max col/line
		inx	d
		dcr	a
		jmp	xadd3
;
;************************************************
;	insert char at cursor position.  either writes over
;	previous char or pushes entire field over one char
;	before inserting.
;************************************************
;
inschr:		lhld	curptr		;cursor address
		push	h		;save
		lda	insrt		;insert flag
		ora	a
		jz	insc3		;overwrite
		call	charln
		dcx	b		;3chars-1 to end
		dad	b		;<hl> pts at last char on line
		mov	d,h
		mov	e,l
		dcx	d		;<de> pts at source
		xchg			;<hl>=source, <de>=dest.
		call	mvcdn		;move chars right
;
insc3:		pop	h		;cursor position
		lda	invidio
		ani	80h
		mov	b,a		;invert bit
		lda	cchar
		ora	b		;merge with inverted bit
;
insc4:		mov	m,a
		ret
;
;************************************************
;	shift chars right from <de> to <hl>; <bc> chars from right
;************************************************
;
mvcdn:		mov	a,c
		ora	b
		rz			;done
		mov	a,m
		stax	d
		dcx	h
		dcx	d
		dcx	b
		jmp	mvcdn
;
;************************************************
; mvcup move <bc> chars from <hl> to <de> from bottom
;************************************************
;
mvcup:		mov	a,b
		ora	c
		rz
		mov	a,m
		stax	d		; move it
		dcx	b
		inx	h
		inx	d
		jmp	mvcup		; keep going
;
;	control function table
;************************************************
;
ctrtbl		db	0dh		;carriage return
		dw	cret
		db	0ah		;line feed
		dw	lfeed
		db	0bh		;up cursor (ctrl k)
		dw	upline
		db	0ch		;forward cursor (ctrl l)
		dw	bmpcur
		db	08h		;back cursor (ctrl h)
		dw	bcklne
		db	1eh		;home cursor (ctrl ?)
		dw	home
		db	1ah		;screen erase (ctrl z)
		dw	blnks
		db	15h		;clear to eol (ctrl u)
		dw	blankl
		db	16h		;protected fields (ctrl v)
		dw	protc
		db	09h		;tab (ctrl i)
		dw	tabb
		db	7fh		;delete char (rubout)
		dw	delete
		db	14h		;insert mode (ctrl t)
		dw	insmde
		db	04h		;delete line (ctrl d)
		dw	dline
		db	05h		;insert line (ctrl e)
		dw	enline
		db	10h		;protected mode toggle (ctrl p)
		dw	prtect
		db	0		;terminator
;
;************************************************
;	escape function jump table
;************************************************
;
esctbl		db	1dh		;cursor control('='less bit 5 lower case)
		dw	addcurs
		db	49h		;set tab
		dw	settab
		db	09h		;clear tabs
		dw	clrtbs
		db	'T'		;lower 128 bytes of rom
		dw	low128
		db	'E'		;extended mode upper 128
		dw	high128
		db	'G'		;graphic set
		dw	graphic
		db	'S'		;scroll toggle
		dw	scrl
		db	'U'		;upper/lower case
		dw	uplow
		db	'V'		;inverse video toggle
		dw	vidio
		db	'L'		;lines/page
		dw	lines
		db	'C'		;cols/line
		dw	cols
		db	0		;terminator
;
;
		end
