	title	'assign hard disk units,  25 jul 82'
;
	maclib	z80
;
$*macro
;
;
boot		equ	0000h		;warm boot entry
bdos		equ	0005h		;bdos entry point
fcb		equ	005ch		;default file control block
msg		equ	9		;bdos print message function
;
cr		equ	0dh
lf		equ	0ah
;
;
		org	100h
;
start:		lda	fcb+17		;get unit number
		cpi	' '		;check for print syntax
		jrnz	start1		;prameters given so process
		lxi	d,synmsg
		jr	prnmsg		;print message and exit
;
;
start1:		sui	'0'		;remove ascii bias
		jrc	uniterr		;less than zero, error out
		cpi	9		;upper bound
		jrnc	uniterr
		lxi	h,trktbl	;pointer to track offset table
		add	a		; *2
		add	l		;offset into table
		mov	l,a
		jrnc	unit1		;test for overflow
		inr	h
;
unit1:		mov	c,m		;low byte of offset
		inx	h
		mov	b,m		;high byte
;
;	<bc> now have the track offset to be stored
;	in the DPH after we find out which one.
;
		lda	fcb+1		;get drive specifier
		sui	'B'		;ascii bias
		jrc	driverr		;cannot be drive A
		cpi	'D'-'A'
		jrnc	driverr		;or above drive D
;
;	we have a good drive number, now multiply by 15
;	to position us at the correct DPB.
;
		mov	d,a		;use <d> as a counter
		xra	a
addloop:	adi	15
		dcr	d
		jp	addloop
		sui	15		;correct for drive # 0
		lhld	boot+1		;now get DPB base address from bios
		mvi	l,33h
		mov	e,m
		inx	h
		mov	d,m		;<de> now have base of DPB's
		xchg			;to <hl>
		add	l
		mov	l,a
		lxi	d,0013		;offset to DPB sys trk offset word
		dad	d
;
;	<hl> now has the address of the word to modify
;	in the DPB, <bc> contain the track offset value.
;
		mov	m,c		;low byte
		inx	h
		mov	m,b		;high byte
		lxi	d,finmsg	;tell them we are done
		jr	prnmsg
;
;
uniterr:	lxi	d,unitmsg
		jr	prnmsg
;
;
driverr:	lxi	d,drivmsg
;
prnmsg:		mvi	c,msg
		call	bdos
		jmp	boot
;
;
trktbl		dw	188		;unit 0
		dw	384
		dw	580
		dw	776
		dw	972
		dw	1168
		dw	1364
		dw	1560
		dw	1756		;unit 8
;
;
synmsg		db	cr,lf,'Syntax:'
		db	cr,lf,9,'ASSIGN <drive> <unit>',cr,lf,'$'
unitmsg		db	cr,lf,'Unit out of range',cr,lf,'$'
drivmsg		db	cr,lf,'Invalid drive specification',cr,lf,'$'
finmsg		db	cr,lf,'Unit assigned',cr,lf,'$'
;
;
		END
