	title	'MORROW hard disk & CCS floppy cbios,  12 apr 82'
;
		page 58
;
		maclib z80
$*M
;
;
true		equ	0ffffh
false		equ	not true
;
numflpy		equ	1		;number of floppy drives in system
dms		equ	true		;if compatible with DMS dd
;
numhd		equ	03		;number of logical drives / hard disk
hdheads		equ	07		;number of heads per disk mask
;
cc2718		equ	true
autobd		equ	false
;
iniob		equ	94h		;  10 | 01 | 01 | 00
					; lst: pun: rdr: con:
					; =lpt =ptp =hsr =tty
;
vers		equ	22		;cp/m version number
revs		equ	30		;cbios version / revision number
;
msize		equ	64		;cp/m version memory size in kilobytes
bias		equ	(msize-20)*1024
ccp		equ	2c00h+bias	;base of ccp
bdos		equ	ccp+806h	;base of bdos
bios		equ	ccp+1600h	;base of bios
;
lstsec		equ	(bios-ccp)/512	;last sector to load on Wmboot
;
wbootv		equ	0000h		;warm boot vector
ioloc		equ	0003h		;address of i/o control byte
cdisk		equ	0004h		;currently selected disk
bdosv		equ	0005h		;bdos entry point vector
;
;
;	CCS 2810 cpu & 2718 i/o boards port definitions
;
sdata		equ	20h		;serial data port
sinten		equ	sdata+1		;serial interrupt enable port
sident		equ	sdata+2		;serial interrupt identification port
slctrl		equ	sdata+3		;serial line control port
smdmct		equ	sdata+4		;serial modem control port
slstat		equ	sdata+5		;serial line status port
smdmst		equ	sdata+6		;serial modem status port
;
rxrdy		equ	0000$0001b	;receive data available bit
txmty		equ	0010$0000b	;transmit buffer empty bit
;
chrmsk		equ	0111$1111b
dtr		equ	1000$0000b	;dtr bit for list handshake
lrxrdy		equ	0000$0010b
ltxrdy		equ	0000$0001b
;
lstat		equ	83h		;list status port
ldata		equ	82h		;list data port
;
hspdat		equ	84h		;high speed printer
hsprdy		equ	80h		;high order bit of "prstat" is ready
;
prstat		equ	81h		;punch and reader status port
prdata		equ	80h		;  "	"    "	  data port
;
sbaud		equ	06		;19200 baud divisor for 2810
;
;
;	disk controller ports
;
dstat2		equ	04		;disk status 2 port
dcntl2		equ	dstat2		;disk control 2 port
dstat		equ	30h		;disk status port
dcmmd		equ	dstat		;disk command port
dtrck		equ	dstat+1		;disk track port
dsctr		equ	dstat+2		;disk sector port
ddata		equ	dstat+3		;disk data port
dflag		equ	dstat+4		;disk flag port
dcntl		equ	dstat+4		;disk control port
dstat1		equ	dcntl		;disk status 1 port
;
;	disk status register bits
;
dstrnf		equ	00010000b	;record not found
;
;	disk control register 1 bits
;
dc1den		equ	01000000b	;1=>double density
dc1min		equ	00010000b	;1=>maxi drive
;
;	disk status 1 register bits
;
ds1aut		equ	01000000b	;0=>auto-boot
;
;	status register 2 bits
;
ds2min		equ	00000010b	;1=>mini drive
ds2sid		equ	01000000b	;0=>two-sided disk
;
;	wd1793 commands
;
step8		equ	00		;8" disk step rate
restor		equ	08h or step8	; restore 6ms rate no verify
sekcmd		equ	1ch		;seek command
stepi		equ	5ch
wdfi		equ	0d0h		;force interrupt - reset
;
;
;	MORROW hard disk board equates
;
hdorg		equ	50h		;Hard Disk Controller origin
hdstat		equ	hdorg		;Hard Disk Status
hdcntl		equ	hdorg		;Hard Disk Control
hdcmnd		equ	hdorg+1		;Hard Disk Command
hdreslt		equ	hdorg+1		;Hard Disk Result
hdfunc		equ	hdorg+2		;Hard Disk Function
hddata		equ	hdorg+3		;Hard Disk Data
tkzero		equ	01		;Track zero bit of status
opdone		equ	02		;Operaction done bit of status
complt		equ	04		;Complete bit of status
tmout		equ	08		;Time out bit of status
wfault		equ	10h		;Write fault bit of status
drvrdy		equ	20h		;Drive ready bit of status
index		equ	40h		;Index bit of status
pstep		equ	04		;Step bit of function
nstep		equ	0fbh		;Step bit mask of function
hdrlen		equ	04		;Sector header length
seclen		equ	512		;Sector data length
wenabl		equ	0fh		;Write enable
wreset		equ	0bh		;Write reset of function
scenbl		equ	05		;Controller control
dskclk		equ	07		;Disk clock for control
mdir		equ	0f7h		;Direction mask for function
null		equ	0fch		;Null command
idbuff		equ	00		;Initialize data command
isbuff		equ	08		;Initialize header command
rsect		equ	01		;Read sector command
wsect		equ	05		;Write sector command
;
;
;	deblock parameters
;
wrall		equ	00
wrdir		equ	01
wrual		equ	02
;
;
cr		equ	0dh		;ascii carriage return
lf		equ	0ah		;ascii line feed
bell		equ	07		;ascii bell character
ctrlc		equ	03		;control c
;
;
		org	0040h		;disk particulars save area
;
diskno		ds	01		;active disk number
track		ds	01
sector		ds	01
side		ds	01		;side select hold area
status		ds	01
cmnd		ds	01
lunit		ds	01		;last used drive
cunit		ds	01		;current drive
rwflg		ds	01
hstbuf		ds	02		;host buffer address
idsv		ds	08		;sector id save area
;
idssec		equ	idsv+2		;sector
idssiz		equ	idsv+3		;sector size
;
tbuf		equ	80h
tpa		equ	100h
;
tries		equ	10		;# disk error retries
;
;
		org	bios		;origin of this program
;
;
;	jump vector for individual subroutines
;
		jmp	cboot		;cold start
;
wboote:		jmp	wboot		;warm start
		jmp	csts		;console status
		jmp	ci		;console character in
		jmp	co		;console character out
		jmp	lo		;list character out
		jmp	po		;punch character out
		jmp	ri		;reader character out
		jmp	home		;move head to home position
		jmp	seldsk		;select disk
		jmp	settrk		;set track number
		jmp	setsec		;set sector number
		jmp	setdma		;set dma address
		jmp	read		;read disk
		jmp	write		;write disk
		jmp	lsts		;return list status
		jmp	sectran		;sector translate
;
		dw	dp2u1		;address of dph's, for assign
;
;
;	individual subroutines to perform each function
;
;	parameter table for drive-unique constants
;
;	for hard disk, "stp rat" becomes the logical sub-division of the
;	physical drive.  the select byte is defined as follows:
;	bit 7 = 1 is hard disk, = 0 is floppy
;	bit 6 = 1 is double density (floppy only)
;	bit 5 = 1 is motor on control bit (floppy only)
;	bit 4 = 1 is maxi floppy, = 0 is mini floppy
;	bits 3-0 is the drive select bits (1 of 4)
;
prmtbl		db	00,91h,02	;hard	00, unit, slct bits, sctr size
		db	01,91h,02	;	01
		db	02,91h,02	;	02
		db	03,91h,02	;	03
;
fprmtb		db	00,00,00	;floppy	00, spt rat, slct bits, sctr size
;
	if numflpy > 1
		db	00,00,00	;	01
	endif
;
;
wboot:		lxi	sp,tbuf
;
load1:		xra	a		;get a zero, and set normal key
		sta	seckey
		mov	h,a		;set the unit and track
		mov	l,a
		shld	diskno
		lxi	h,0002h		;set the side and sector
		shld	sector
		mvi	b,numflpy * 3	;zero out prmtbl
		lxi	h,fprmtb	;only for floppys
;
load1a:		mov	m,a		;clear floppy table
		inx	h
		djnz	load1a
		cma
		sta	rwflg		;tell drivers to read
		lxi	h,ccp		;setup dma address
		shld	hstbuf
		call	hdseek		;home the hard disk
;
load2:		call	hdio		;do hard disk read
		ora	a
		jrnz	load1		;error so start over
		shld	hstbuf
		lxi	h,sector
		mov	a,m
		cpi	lstsec		;are we done
		jrz	boot0
		inr	m		;set next sector
		jr	load2
;
;
;	end of load operation, set parameters and go to cp/m
;
boot0:		mvi	a,jmp		; get a jump op code
		sta	wbootv		; reset the jump vectors
		sta	bdosv
		lxi	h,wboote
		shld	wbootv+1
		lxi	h,bdos
		shld	bdosv+1		; set up locs 2,3,5 and 6
		lxi	h,dbuf		;set up buffer address
		shld	hstbuf
		lxi	h,0080h		;default dma address is 80h
		shld	dmaad
		xra	a		;set up deblock
		sta	seckey		;set sector key to normal = 00
		sta	hstact		;host not active
		lda	cdisk
		mov	c,a		; tell cpm of this
		ei			;enable the interrupt system
		jmp	ccp		;go to cpm
;
;
;	select disk given by register <c>
;
seldsk:		mov	a,c
		sta	sekdsk
;
seldska:	lxi	h,0000		;error return code
		cpi	numflpy+04	;same, but add hard disk
		rnc			;no carry if 4,5,...
;
;	disk number is in the proper range
;	compute proper disk parameter header address
;
seldsk1:	dad	sp		; prepare to set a local
		shld	oldstk		; bios stack 20 levels deep
		lxi	sp,stack
		mov	l,a		; <l> has disk #, 0..15
		mvi	h,00
		dad	h		;*2
		dad	h		;*4
		dad	h		;*8
		dad	h		;*16 (size of each header)
		mov	a,e		;save new mount argument
		rar
		push	psw
		lxi	d,dpbase
		dad	d		;<hl>=.dpbase(diskno*16)
		push	h		;save the dp table pointer
		call	fdsb		;get the selbits
		sta	seksel
		xchg			; prmtbl pointer to <de>,dpbase to <hl>
		pop	h
		pop	psw
		jc	restack		; return if not new mount
;
ckset:		push	h		;save <hl>
		ldax	d		;get the selbits
		ral
		jrc	set7		;if hard disk then all done
;
set2:		lhld	lunit		;first, save current disk assignments
		push	h
		sta	cunit		;force the read address
		inr	a
		sta	lunit
		lhld	diskno
		lda	side
		mov	h,a
		push	h
		mov	a,c		;reget desired unit
		sta	diskno		;set new disk number
		mvi	a,0d0h		;select side 0 of new disk
		sta	side
		push	b
		call	idrd1		;find out what is out there
		jrnz	selerr
		mov	b,m		;get the selbits
		lxi	d,0004		;address table entry offset
		lxi	h,seltbl-4	;else, set the 8" table address
		in	dstat2		;check for double sided disk
		ani	40h		;isolate two-sided bit
		jrnz	set3		;jump if single sided
		lxi	h,seltbla-4
;
set3:		mov	a,b		;check for double density
		sta	seksel
		ani	40h		;isolate the bit
		jrz	set4		;jump if single-density
		dad	d		;offset to double density entries
		dad	d
		dad	d
		dad	d
;
set4:		dad	d		;offset table address
		dcr	c
		jp	set4
;
set5:		xchg			;save the pointer
		cmp	a		;zero out flags
;
selerr:		pop	b		;restore registers
		pop	h		;restore the current drive
		mov	a,h		;restore the side
		sta	side
		mov	a,l		;  and the diskno
		sta	diskno
		pop	h
		shld	lunit
		pop	h
		jrnz	selerra		;jump if a select error
		push	h		;get, resave dp block pointer
		ldax	d		;move the table entries
		ora	a
		jrz	selerra
		mov	m,a
		inx	d
		inx	h
		ldax	d
		mov	m,a
		inx	d
;
set6:		push	d		;save it for a moment
		lxi	d,0009
		dad	d		;offset the pointer
		pop	d		;reget table address
		ldax	d		;move the table entries
		mov	m,a
		inx	d
		inx	h
		ldax	d
		mov	m,a
;
set7:		pop	h
;
restack:	mov	a,c		; restore drive no.
		lspd	oldstk		; restore bdos stack pointer
		ret
;
;
selerra:	lxi	h,0000
		jr	restack		; return via stack
;
;
;	set track given by register <c>
;
settrk:		push	b
		call	fdsb
		pop	b
		jp	settrk3		;jump if floppy
;
		lxi	d,(numhd shl 8) or hdheads	;else, set 20 mb parameters
;
settrk1:	mov	a,c		;get the track
		ana	e		;apply the head mask
		sta	seksid		;set the head
;
settrk2:	ora	a		;clear the carry bit
		mov	a,b		;find the cylinder
		rar
		mov	b,a
		mov	a,c
		rar
		mov	c,a
		dcr	d
		jrnz	settrk2		;loop control
;
settrk3:	mov	a,c
		sta	sektrk
		ret
;
;	set sector given by register <c>
;
setsec:		call	fdsb
		jm	setsec2		;jump if hard disk
;
		mov	a,c
		ral			;isolate side bit
		mvi	a,0d0h		;set up side select bits
		jrnc	setsec1
		mvi	a,90h		;select side 1
;
setsec1:	sta	seksid		;set the side select bits
;
setsec2:	mov	a,c		;reget sector number
		ani	7fh		;strip off side indicator
		dcr	a
		sta	seksec
		ret
;
;	translate the sector given by <bc> using the
;	translate table given by <de>
;
sectran:	push	d		;save the table address
		call	fdsb		;get the table pointer
		inx	h		;point to the sector size
		mov	d,m
		inr	d		;increment for later use
		push	d		;save for later use
		mov	a,c		;get the desired sector
		sta	cpmsec
		ral
;
sect0:		ora	a		;convert to physical sector number
		rar
		dcr	d
		jrnz	sect0
		pop	d
		pop	h		;reget table address
		cmp	m		;see if side 1
		mvi	b,00		;side zero
		jrc	sect1		; jump if side 0
		mvi	b,80h		;flag bit for side 1
		sub	m
;
sect1:		push	b
		mov	b,d		;save sector size in (b)
		mov	e,a		;set up to build skew
		mov	d,m		;get the skew factor
		inx	h
		mvi	c,0ffh		;get a -1
;
sect2:		inr	c		;build sector offset in (c)
		sub	m
		jrnc	sect2		;loop till offset is built
		inx	h		;point to skew factor
		xra	a		; and get a zero
;
sect3:		add	m		;build the skewed sector number
		dcr	e
		jp	sect3
;
		sub	m
		add	c		;add on the offset
;
sect4:		sub	d		;insure number is in range
		jrnc	sect4
		add	d
;
sect5:		mov	l,a		;move skewed number over to (l)
		inr	a		;set pyhs sector for antic. logic
		sta	nxtsct
		xra	a		;convert physical to logical sector
		mov	h,a
		jr	sect6a
;
;
sect6:		stc
		adc	a		;build the mask
		dad	h		;offset the sector number
;
sect6a:		djnz	sect6
;
sect7:		pop	b
		ana	c		;strip out the sub-sector
		ora	l		;add it to the skewed sector
		inr	a
		ora	b		;add on the side select bit
		mov	l,a
		ret
;
;
;	set dma address given by registers <bc>
;
setdma:		mov	l,c		;low order address
		mov	h,b		;high order address
		shld	dmaad		;save the address
		ret
;
;
;	move to the track 00 position of current drive
;
home:		sub	a
		sta	sektrk
		ret
;
;
;	deblock routines
;
write:		xra	a		; flag as a write operation
		sta	readop
		sspd	oldstk		; set a local stack
		lxi	sp,stack
		mov	a,c		;write type from cp/m
		sta	wrtype
		cpi	wrual		;see if unallocated
		jrnz	chkuna		;jump if not
;
;	unallocated write, set parameters
;
		call	physec		;convert to physical sector
		lhld	sekhst		;set physical sector and side
		shld	unasec
		lhld	sekdsk		;get the disk number
		shld	unadsk		;save it for unallocated write
		mov	a,l
		call	dpfnd		;get dp table address
		inx	d		;offset to the block mask
		inx	d
		inx	d
		ldax	d		;get the block mask
		inr	a		;(a) = logical sectors per block
		sta	unacnt		;save the sector count
;
chkuna:		lxi	h,unacnt	;see if any unallocated space available
		xra	a
		cmp	m
		jrz	alloc1		;jump if not
		dcr	m		;else, use some of it
		call	physec		;set the physical sector number
		lxi	d,unadsk
		call	comp		;compare the units
		jrnz	alloc		;go do the write
;
;	unallocated write next sector anticipation logic
;
nxtsec:		lda	sekdsk		;find address of dp table
		call	dpfnd
		lda	cpmsec		;get last logical sector number
		inr	a
		xchg			;dp table address to <hl>
		cmp	m		;see if overflow
		jrnc	nxtsc2		;jump if so
		lxi	h,-0011		;same track, now see which side/sector
		dad	d
		mov	e,m		;get address of skew table
		inx	h
		mov	d,m
		mov	c,a		;set up to call sectran
		mvi	b,00
		call	sectran		;translate the sector
		mvi	h,0d0h		;side 0 select
		jp	nxtsc1		;jump if side 0
;
		mvi	h,90h		;else, set side 1
;
nxtsc1:		lda	nxtsct		;get the next physical sector
		mov	l,a		;set the sector
		jr	nxtsc3
;
nxtsc2:		lxi	h,unatrk	;set for next track
		inr	m
		lxi	h,0d001h	;side 0 sector 1
;
nxtsc3:		shld	unasec		;set the next side, sector
		xra	a		;get a zero
		jr	alloc2		;go back to mainstream
;
;
read:		mvi	a,wrual		;treat read as unallocated
		sta	wrtype
		sta	readop		;set a read operation
		sspd	oldstk
		lxi	sp,stack	; set a local stack
;
alloc:		xra	a		;allocated write requires preread
		sta	unacnt
;
alloc1:		inr	a
;
alloc2:		sta	rsflag
;
rwoper:		xra	a		;get a zero
		sta	erflag		;reset the error flag
		lxi	h,hstact	;see if host active
		ora	m
		mvi	m,01		;mark it active for next time
		jrz	filhst		;fill the host buffer if empty
		call	physec		;set the physical sector number
		lxi	d,diskno
		call	comp		;compare the units
		jrz	match
;
nomatch:	lda	hstwrt		;see if host written
		ora	a
		cnz	dwrite		;purge the buffer if need be
		sta	erflag		;set the error indicator
;
filhst:		call	physec
		mov	a,d
		sta	idssiz
		lhld	sekdsk		;set up to fill the buffer
		shld	diskno
		lhld	sekhst		;get the sector, side select
		shld	sector		;set them
		lda	seksel
		sta	cunit
		lda	rsflag
		ora	a
		cnz	dread		;fill it if need be
		lxi	h,erflag
		ora	m
		mov	m,a
		xra	a		;reset pending write flag
		sta	hstwrt
;
match:		call	fdsb		;get the sector size
		inx	h
		mov	b,m
		xra	a		;get a zero
;
match1:		adc	a		;build sector mask
		dcr	b
		stc
		jp	match1		;loop til mask is built
;
		lhld	seksec
		ana	l		;find the relative sector
		lhld	dmaad		;get dma address
		xchg			;buffer address to <de>
		lxi	h,dbuf-80h	;build address for cpm sector
		lxi	b,0080h		;# bytes in logical sector
;
match2:		dad	b
		dcr	a
		jp	match2
;
		lda	readop		;see if read or write
		ora	a
		jrnz	rwmove		;pointers ok if read
		xchg			;else, swap them
		inr	a		;  and mark write operation
		sta	hstwrt
;
rwmove:		ldir			;move the data
		lda	wrtype		;get write type
		dcr	a		;see if directory entry
		lda	erflag		;get the error flag
		jrnz	exitsp
		ora	a		;see if any errors
		jrnz	exitsp
		sta	hstwrt		;reset host written
;
dwrita:		call	dwrite		;update the directory
		lxi	h,erflag
		ora	m
		mov	m,a
;
exitsp:		lspd	oldstk		; restore bdos stack
		ret
;
;
;	find address of disk parameter table
;
dpfnd:		lxi	h,dpbase-6	;develop address of dptable
		lxi	d,0016
;
dpfnd1:		dad	d
		dcr	a
		jp	dpfnd1
;
		mov	e,m		;pull up the address
		inx	h
		mov	d,m
		ret
;
;
;	logical to physical sector translation routine
;
physec:		call	fdsb		;get table pointer
		inx	h		;point to sector size
		mov	d,m		;get the sector size
		push	d
		lda	seksec		;get the logical sector number
		ral
;
physc1:		ora	a		;reset the carry bit
		rar			;convert to physical sector
		dcr	d
		jp	physc1
;
		inr	a		;(a) now has physical sector #
		sta	sekhst		;set it
		pop	d
		ret
;
;
;	compare the units
;
comp:		lxi	h,sekdsk
		mvi	b,04
;
comp1:		ldax	d
		sub	m
		rnz			;done if no compare
;
		inx	h		;point to sektrk
		inx	d
		djnz	comp1
		xra	a		; reset c,z flags
		ret
;
;
;	the following routines do the primitive disk accesses.
;	in all cases, one sector of data is transferred.
;	if the disk has not been previously accessed,
;	these routines will automatically determine
;	single or double density and sector size.
;
;	before the desired data is transferred, the desired
;	track is located, the desired sector and side are
;	set,then the actual data transfer takes place.
;
;	up to ten tries will be attempted before the data
;	transfer is aborted.  on return to the calling
;	routine, the a register will contain a zero if the
;	operation was successful, or non-zero if not
;	successful.  the flag register will not necessarily
;	correspond with the a register content.
;
;	these routines are cp/m compatable, and may be used
;	as part of the bios.
;
dread		db	3eh		;sim. mvi a instr
;
dwrite:		xra	a		;set write flag
		sta	rwflg		;save it for later use
		lda	diskno
		call	fdsb0		;see if hard or floppy disk
		jm	hdio		;jump if hard disk
;
		mvi	b,tries		;number of retries
		push	b
;
agn:		call	seek
		cz	rdwr
;
read3:		pop	b
		rz
;
		dcr	b
		rz
;
		ani	dstrnf		;track error?
		push	b		;save retry count
		cnz	eojb		;yes. go home
		jr	agn
;
;
rdwr:		lda	rwflg
		ora	a
		mov	a,c		; get the command
		di
		jrnz	rdat		;write if zero
;
wrdat:		ori	20h		;add write command
		out	dcmmd
		sta	cmnd
;
wrdat1:		mov	a,m
		out	ddata
		inx	h
		djnz	wrdat1
		dcr	d
		jrnz	wrdat1
		jr	dskeoj
;
;
rdat:		out	dcmmd
		sta	cmnd
;
rdat1:		in	ddata
		mov	m,a
		inx	h
		djnz	rdat1
		dcr	d
		jrnz	rdat1
		call	dskeoj
		ani	9ch
		ret
;
;
eojb:		mvi	b,restor	;basis of restore command
		mvi	c,3fh		;single density mask
;
eoja:		push	h		;save the registers
		push	b
		lda	diskno		; as set in deblocker
		call	fdsb0		; point to the step rate
		pop	b
		ana	c		;apply density mask
		out	dcntl		;set it
		dcx	h
		mov	a,m		;get the step rate
		pop	h
		ora	b		;add on the command
;
eojc:		sta	cmnd
		out	dcmmd		;do the command
;
dskeoj:		ei
		in	dflag
		rar			; see if eoj true
		jrnc	dskeoj		; no so go back to delay loop
;
instat:		in	dstat		; get the status
		sta	status
		ani	0fch		; mask relevant errors
		ret
;
;
seek:		call	idrd		;insure header has been read
		cnz	eojb		;restore the drive if error
;
seek1:		lda	sector		;set the sector
		out	dsctr		;disk sector port
		in	dtrck		;disk track port
		mov	c,a		;save it
		lda	track		;get desired track
		cmp	c
		jrz	rdwrt		;jump if no seek needed
		out	ddata		;set the seek track
		ora	a		;see if track 00 seek
		mvi	c,7fh		;normal density mask
		jrnz	seek2		;jump if not
		mvi	c,3fh		;single density mask
;
seek2:		mvi	b,sekcmd	;build the seek command
		call	eoja		;do the seek
		ani	98h		;seek error mask
		rnz			;done if seek error
;
rdwrt:		call	setup
		in	dflag		;disk flag port
		ani	20h		;see if head is loaded
		mvi	a,88h		; read one sector command
		jrnz	rdwrt0		;jump if head loaded
		ori	04h		; else set e bit for 15ms more delay
;
rdwrt0:		mov	c,a		; save command in c
		inx	h		;get the sector size
		mvi	b,00		;clear "ldir" loop counter
		in	dtrck		;get track number, see if track 00
		ora	a		;test for single density
		jrz	rdwrt4		;special setup for S/D
		mov	a,m		;test for single density disk
		ora	a
		jrz	rdwrt4
		mov	d,m
;
rdwrt1:		inr	d		;sector size base length
		lhld	hstbuf		;get the dma address
;
rdwrt3:		xra	a		;clear the flags
		ret
;
;
rdwrt4:		mvi	b,128		;get single density length
		mov	d,a		;<A> has 00, to <D>
		jrz	rdwrt1		;continue
;
idrd5:		mvi	b,stepi		;build a step-in command
		mvi	c,7fh		;selbits density mask
		call	eoja
;
idrd:		lhld	lunit
		mov	a,h		;get the cunit value
		cmp	l		;see if same as lunit
		rz			;return if so
;
idrd1:		mvi	b,04		;limit of two tries
;
idrd1a:		push	b
		call	setup
		push	h		;save pointer
		lxi	h,idsv		;set up to read address
		mvi	d,01
		lxi	b,0633h		;set up to read 6 bytes of data
					;and set up <C> to point to data port
		mvi	a,0c4h		;read address command
		call	rdat
		ani	09ch		; the error mask
		pop	h		;restore pointer
		pop	b
		jrz	idrd2		;jump if good read
		djnz	idrd3		;see if more tries left
		ora	a		; set error flag if done
		ret
;
;
idrd3:		mvi	a,40h
		xra	m		;change the density setting
		mov	m,a
		jr	idrd1a
;
;
idrd2:		in	dsctr		;get the track number
		out	dtrck		;set the track register
		ora	a		;check for track 00
		jrz	idrd5		;step in to next track
		inx	h		;point to sector size
		lda	idssiz		;get the sector size
		mov	m,a
		mov	c,a
		dcx	h
		mov	a,m		;reget selbits
		sta	cunit		;set the current unit
		sta	lunit		;update last used unit
		xra	a		;reset error flags
		ret
;
;
;	set up drive number
;
setup:		lda	diskno
		call	fdsb0		; point to the selbits
		jrnz	set05		; if selbits nz then skip init code
;
setit:		lda	diskno		;get the desired drive
		sui	3		;remove hard disks
		mov	b,a		;save in work register
		xra	a		;zero to a
		stc			;drive select bit
;
set01:		ral			;shift bit into position
		djnz	set01		;loop til bit is in position
		ori	70h		;add on motor on and dden bits
		mov	m,a		; set table to suit
		sta	cunit		; update current unit
;
set03:		dcx	h
		mvi	m,step8		;set the step rate
;
set04:		inx	h		; point to selbits
;
set05:		ora	a
		mov	a,m		;reget the selbits
;
set06:		ori	80h		;addin auto-wait bit
		out	dcntl		;output the selbits
		lda	side		;set the side select
		out	dstat2
		xthl			;waste some time
		xthl			;for side select electronics
		ret
;
;
fdsb:		lda	sekdsk		;get the unit number
;
fdsb0:		lxi	h,prmtbl-2	;point to the selbits
		inr	a
		mov	b,a
;
fdsb1:		inx	h		;offset pointer to right entry
		inx	h
		inx	h
		djnz	fdsb1
		mov	a,m		;get the selbits
		ora	a
		ret
;
;
hdio:		call	hdseek		;get to correct track
		rnz			;error
;
		mvi	c,tries		;number of retries before error
;
hderrlp:	push	b		;save on stack
		call	hdsetup		;setup hard controller
		call	hdrdwr
		pop	b		;get retry count
		rz			;return of no errors
;
		dcr	c		;one less
		jrnz	hderrlp		;loop if more tries left
		mvi	a,0ffh		;return non-zero
		ret
;
;
hdrdwr:		lxi	b,hddata	;<B> = 00 for "ldir" count, <C> = port
		mvi	d,02		;<D> is "ldir" loop counter 256*2=512
		lda	rwflg		;see if read or write
		ora	a
		jrnz	hdrdat
;
hdwdat:		outir			;send data
		dcr	d
		jrnz	hdwdat
		mvi	a,wenabl	;turn wr prot off
		out	hdcntl
		mvi	a,wsect		;transfer done, now write to disk
		out	hdcmnd
;
opfin:		in	hdstat		;get status
		mov	e,a		;save in <E>
		ani	opdone		;wait for controller to finish
		jrz	opfin
		mvi	a,dskclk	;set wr protect
		out	hdcntl
		mov	a,e		;get status
		ani	38h		;remove non-error bits
		xri	10h		;flip write fault bit
		mov	e,a		;resave
		in	hdreslt		;check for crc error
		ani	02h
		ora	e		;include stat bits
		rz			;return of ok
;
		mov	a,e		;check for header error
		ani	tmout
		jrz	onlycrc		;not header, must be only data
		call	hdhome		;retry
		call	hdseek
;
onlycrc:	ori	0ffh		;ret non-zero for error
		ret
;
;
hdrdat:		;read the hard disk
		xra	a
		cma
		out	hddata
		out	hddata
		mvi	a,rsect		;read sector command
		out	hdcmnd
		call	opfin		;wait for disk to finish
		rnz
;
		xra	a
		out	hdcmnd		;point to data buffer
		in	hddata
		in	hddata
;
rddat1:		inir
		dcr	d		;loop counter
		jrnz	rddat1
		xra	a
		ret			;return with no errors
;
;
hdsetup:	;setup ports and sector header
		mvi	a,isbuff	;sector header buffer pointer
		out	hdcmnd
		xra	a
		call	hdbuild		;build function register
		ori	0ch		;set dir and step
		out	hdfunc
		lda	side		;put head, trk, sec, and key
					;in header buffer
		out	hddata
		lda	track
		out	hddata
		lda	sector
		out	hddata
		lda	seckey		;get sector key byte ( sys=80h,norm=00)
		out	hddata		;key byte
		xra	a
		out	hdcmnd		;set pointer to data area
		mvi	a,dskclk	;set wr prot, enable disk clock
		out	hdcntl
		lhld	hstbuf		;sector buffer address
		ret
;
;
hdbuild:	;build head, disk byte
		lda	side		;get head number
	rept 4				;put head in position, [cy] has dir if seek
		ral
	endm
		xri	0f0h		;flip head number
		ret
;
;
hdseek:		in	hdstat		;check if drive ready
		ani	drvrdy
		rnz			;return if error
;
		lda	track		;get destination
		lxi	h,hdtrk		;pointer to track byte
		mov	b,m
		mov	m,a		;current track
		mov	c,a
		mov	a,b
		sub	c
		rz			;if zero, already there
;
		cmc
		jrc	hdseek2
		cma
		inr	a
;
hdseek2:	mov	c,a
		call	hdbuild		;get function register
;
hdsek3:		ani	nstep
		out	hdfunc
		ori	pstep
		out	hdfunc
		dcr	c
		jrnz	hdsek3
;
wseek:		in	hdstat
		ani	complt		;wait for seek complete
		jrz	wseek
		xra	a		;return a zero
		ret
;
;
hdhome:		;home the hard disk
		xra	a		;get a zero
		sta	hdtrk		;up date track save
		mov	c,a		;do 256 steps out
		mvi	a,null		;null command
		jr	hdsek3		;do it
;
;
;	fixed data tables for four-drive standard
;	ibm-compatible 8" disks
;	disk parameter header for disk 00
;
dpbase		dw	thdskw,0000
		dw	0000,0000
		dw	dirbf,dp2u0
		dw	chk00,all00
;
;	disk parameter header for disk 01
;
		dw	thdskw,0000
		dw	0000,0000
		dw	dirbf,dp2u1
		dw	chk01,all01
;
;	disk parameter header for disk 02
;
		dw	thdskw,0000
		dw	0000,0000
		dw	dirbf,dp2u2
		dw	chk02,all02
;
;	disk parameter header for disk 03
;
		dw	thdskw,0000
		dw	0000,0000
		dw	dirbf,dp2u3
		dw	chk03,all03
;
;	disk parameter header for disk 04
;
		dw	0000,0000
		dw	0000,0000
		dw	dirbf,0000
		dw	chk04,all04
;
;	disk parameter header for disk 05
;
	if numflpy > 1
		dw	0000,0000
		dw	0000,0000
		dw	dirbf,0000
		dw	chk05,all05
	endif
;
;
;	sector translate vector
;
seltbl		dw	t826,dp8s0
		dw	0,0,0,0
		dw	0,0,0,0
;
	if not dms
		dw	t826,dp8d1
	else
		dw	t826a,dp8d1n
	endif
;
		dw	t815,dp8d2
		dw	t88,dp8d3
;
;
dp8s0		dw	26		;sectors per track
		db	03		;block shift factor
		db	07		;block mask
		db	00		;extent mask
		dw	242		;blocks per diskette
		dw	63		;# dirctory entries
		db	192		;alloc 0
		db	00		;alloc 1
		dw	16		;dir check vector size
		dw	02		;system track offset
;
	if not dms
;
dp8d1		dw	52		;sectors per track
		db	04		;block shift factor
		db	15		;block mask
		db	01		;extent mask
		dw	242		;blocks per diskette
		dw	63		;# directory entries
		db	128		;alloc 0
		db	00		;alloc 1
		dw	16		;dir check vector size
		dw	02		;system track offset
	endif
;
	if dms
;
dp8d1n		dw	52
		db	04
		db	15
		db	00
		dw	242
		dw	127
		db	0c0h
		db	00
		dw	16
		dw	2
	endif
;
dp8d2		dw	60		;sectors per track
		db	05		;block shift factor
		db	31		;block mask
		db	03		;extent mask
		dw	139		;blocks per diskette
		dw	127		;# directory entries
		db	128		;alloc 0
		db	00		;alloc 1
		dw	16		;dir check vector size
		dw	02		;system track offset
;
dp8d3		dw	64		;sectors per track
		db	04		;block shift factor
		db	15		;block mask
		db	00		;extent mask
		dw	299		;blocks per diskette
		dw	127		;# directory entries
		db	192		;alloc 0
		db	00		;alloc 1
		dw	16		;dir check vector size
		dw	02		;system track offset
;
;
seltbla		dw	0000,0000
		dw	0000,0000
		dw	0000,0000
		dw	0000,0000
		dw	0000,0000
		dw	t826,dp8d1a
		dw	t815,dp8d2a
		dw	t88,dp8d3a
;
dp8d1a		dw	104		;sectors per track
		db	05		;block shift factor
		db	31		;block mask
		db	03		;extent mask
		dw	242		;blocks per diskette
		dw	127		;# directory entries
		db	128		;alloc 0
		db	00		;alloc 1
		dw	16		;dir check vector size
		dw	02		;system track offset
;
dp8d2a		dw	120		;sectors per track
		db	06		;block shift factor
		db	63		;block mask
		db	07		;extent mask
		dw	139		;blocks per diskette
		dw	127		;# directory entries
		db	128		;alloc 0
		db	00		;alloc 1
		dw	16		;dir check vector size
		dw	02		;system track offset
;
dp8d3a		dw	128		;sectors per track
		db	06		;block shift factor
		db	63		;block mask
		db	07		;extent mask
		dw	149		;blocks per diskette
		dw	127		;# directory entries
		db	128		;alloc 0
		db	00		;alloc 1
		dw	16		;dir check vector size
		dw	02		;system track offset
;
;
t88		db	08,08,03
t815		db	15,15,04
t826		db	26,13,06
t826a		db	26,26,01	;DMS compatible
;
thdskw		db	21,21,01	;hard disk skew table
;
;
;    unit #	starting track
;	A		2
;	0		188
;	1		384
;	2		580
;	3		776
;	4		972
;	5		1168
;	6		1364
;	7		1560
;	8		1756
;
dp2u0		dw	84		;sectors per track
		db	05		;block shift factor
		db	31		;block mask
		db	01		;extent mask
		dw	437		;blocks per diskette
		dw	255		;# directory entries
		db	0c0h		;alloc 0
		db	0000		;alloc 1
		dw	0000		;dir check vector size
		dw	0002		;system track offset
;
dp2u1		dw	84		;sectors per track
		db	04		;block shift factor
		db	15		;block mask
		db	00		;extent mask
		dw	1023		;blocks per diskette
		dw	255		;# directory entries
		db	0f0h		;alloc 0
		db	00		;alloc 1
		dw	0000		;dir check vector size
		dw	0188		;system track offset
;
dp2u2		dw	84		;sectors per track
		db	04		;block shift factor
		db	15		;block mask
		db	00		;extent mask
		dw	1023		;blocks per diskette
		dw	255		;# directory entries
		db	0f0h		;alloc 0
		db	0000		;alloc 1
		dw	0000		;dir check vector size
		dw	384		;system track offset
;
dp2u3		dw	84		;sectors per track
		db	04		;block shift factor
		db	15		;block mask
		db	00		;extent mask
		dw	1023		;blocks per diskette
		dw	255		;# directory entries
		db	0f0h		;alloc 0
		db	0000		;alloc 1
		dw	0000		;dir check vector size
		dw	580		;system track offset
;
;	end of fixed tables
;
;
;
;	i/o drivers for the 8250 async comm element
;
csts:		in	slstat		;get 8250 line status
		ani	rxrdy		;see if receive data available
		rz			;return if not
;
		ori	not rxrdy	;flag that data is available
		ret
;
ci:		call	csts		;get 8250 line status
		jrz	ci		;loop until data is in
		in	sdata		;read the data
		ani	chrmsk
		ret
;
co:		in	slstat		;get 8250 line status
		ani	txmty
		jrz	co		;wait until one of the registers empties
		mov	a,c		;move the data over
		out	sdata		;output the data
		ret
;
po:		in	prstat		; high speed punch
		ani	ltxrdy		;get status
		jrz	po
		mov	a,c
		out	prdata
		ret
;
lo:		lda	ioloc		;get iobyte
		ani	0c0h		;list device
		rz
;
		cpi	80h		;test for hs printer
		jrz	hsprn
		rnc
;
crtprn:		call	crtst
		jrz	crtprn
		mov	a,c
		ani	chrmsk
		out	ldata
		ret
;
hsprn:		call	hsst
		jz	hsprn
		mov	a,c		;get character
		ori	80h		;output strobe and char
		out	hspdat
		ani	chrmsk
		out	hspdat
		ori	80h
		out	hspdat		;clear strobe
		ret
;
;
lsts:		; line printer status
		lda	ioloc
		ani	0c0h
		rz
		cpi	80h
		jrz	hsst
		rnc
;
crtst:		in	lstat
		ani	ltxrdy or dtr
		ori	(not (ltxrdy or dtr)) and 0ffh
		inr	a
		jrz	lsts1
		xra	a
		ret
;
lsts1:		dcr	a
		ret
;
hsst:		in	prstat		;line printer
		ani	hsprdy		;check for printer ready
		mvi	a,0ffh
		jrz	hsst_ret
		xra	a
hsst_ret:	ora	a
		ret
;
;
ri:		in	prstat		; high speed paper tape reader
		ani	lrxrdy
		jrz	ri
		in	prdata
		ret
;
;
seckey		db	00		;sector header key value
hdtrk		db	00		;hard disk current track
oldstk		dw	0000		; bdos stack hold
;
		db	'STACK STACK STACK STACK '
stack		equ	$		; start it here
;
;
;--------------------------------------------------
;		one-time code
;--------------------------------------------------
;
cboot:		lxi	sp,tbuf		;set stack to safe area
;
	if autobd
		mvi	a,0fh		;set modem control register
		out	smdmct
		mvi	a,83h		;set baud rate divisor access
		out	slctrl
		mvi	a,sbaud/256	;set baud rate high byte
		out	sinten
		mvi	a,sbaud mod 256	;low byte
		out	sdata
		mvi	a,03		;set 8250 line control
		out	slctrl
		xra	a		;set handshake lines active
		out	sinten
		out	slstat
	endif
;
	if cc2718
		mvi	a,4eh
		out	lstat		;init list usart
		mvi	a,37h
		out	lstat		;again
		mvi	a,80h
		out	hspdat
	endif
;
;
		lxi	h,0000 or iniob
		shld	ioloc		;set ioloc, cdisk
;
		lxi	h,logmsg	;sign on to the system
;
;
;	routine prtwd prints an ascii string onto the console.
;	the string must be terminated by bit 7 set in the
;	last character of the string.
;
prta:		mov	c,m		;get next character from memory
		call	co		;output it
		inx	h		;increment memory pointer
		mov	a,c
		rlc			;test for bit 7 delimiter
		jrnc	prta		;no delimiter, go do next character
		jmp	boot0		;finish rest of boot
;
;
logmsg		db	cr,lf
		db	msize/10+'0',msize mod 10 + '0'
		db	'k CP/M vers-'
		db	vers/10+'0','.',vers mod 10+'0'
		db	' rev-',revs/10+'0','.',revs mod 10+'0'
		db	'h'
	if dms
		db	'n'
	endif
;
	if numflpy ne 00
		db	'f',numflpy+'0'
	endif
;
crmsg		db	0dh,0ah+80h
;
endx		equ	($-bios)	;bios size
;
;
		org	cboot		;dont neet cold boot code any more
;
;
;	the remainder of the ccbios is reserved uninitialized
;	data area, and does not need to be a part of the
;	system memory image (the space must be available,
;	however, between "begdat" and "enddat").
;
begdat		equ	$		;beginning of data area
;
dmaad		ds	02		;direct memory address
;
sekdsk		ds	01
sektrk		ds	01
sekhst		ds	01
seksid		ds	01
seksec		ds	01
seksel		ds	01
;
hstact		ds	01
hstwrt		ds	01
;
unadsk		ds	01
unatrk		ds	01
unasec		ds	01
unasid		ds	01
unacnt		ds	01
cpmsec		ds	01
nxtsct		ds	01
;
erflag		ds	01
rsflag		ds	01
readop		ds	01
wrtype		ds	01
;
;	scratch ram area for bdos use
;
dirbf		ds	128		;scratch directory area
;
all00		ds	64		;allocation vector 0
chk00		ds	00		;check vector 0
;
all01		ds	128		;allocation vector 1
chk01		ds	00		;check vector 1
;
all02		ds	128		;allocation vector 2
chk02		ds	00		;check vector 2
;
all03		ds	128		;allocation vector 3
chk03		ds	00		;check vector 3
;
all04		ds	40		;allocation vector 4
chk04		ds	16		;check vector 4
;
	if numflpy > 1
all05		ds	40		;allocation vector 5
chk05		ds	32		;check vector 5
	endif
;
dbuf		ds	1024		;disk buffer
;
enddat		equ	$		;end of data area
datsiz		equ	$-begdat	;size of data area

		END
