	title	'Hard disk cold boot, MORROW controller  02 dec 81'
;
		maclib	z80
$*Macro
;
;
msize		equ	64		;cp/m version memory size in kilobytes
bias		equ	(msize-20)*1024
ccp		equ	2c00h+bias	;base of ccp
bdos		equ	ccp+806h	;base of bdos
bios		equ	ccp+1600h	;base of bios
;
bank		equ	40h		;shadow rom bank select
;
strtsec		equ	02		;starting sector
;
lstsec		equ	(((bios+800h)-ccp)/512)+1	;last sector to load
lstaddr		equ	ccp+((lstsec-2)*512)		;end check
;
lodsiz		equ	128-3		;number of bytes for prom to load
;
;	hard disk equates
;
hdorg		equ	50h		;Hard Disk Controller origin
hdstat		equ	hdorg		;Hard Disk Status
hdcntl		equ	hdorg		;Hard Disk Control
hdcmnd		equ	hdorg+1		;Hard Disk Command
hdreslt		equ	hdorg+1		;Hard Disk Result
hdfunc		equ	hdorg+2		;Hard Disk Function
hddata		equ	hdorg+3		;Hard Disk Data
tkzero		equ	01		;Track zero bit of status
opdone		equ	02		;Operaction done bit of status
complt		equ	04		;Complete bit of status
tmout		equ	08		;Time out bit of status
wfault		equ	10h		;Write fault bit of status
drvrdy		equ	20h		;Drive ready bit of status
index		equ	40h		;Index bit of status
chalt		equ	80h		;controller halt bit
retry		equ	02		;aux. status retry bit
pstep		equ	04		;Step bit of function
nstep		equ	0fbh		;Step bit mask of function
hdrlen		equ	04		;Sector header length
seclen		equ	512		;Sector data length
wenabl		equ	0fh		;Write enable
wreset		equ	0bh		;Write reset of function
scenbl		equ	05		;Controller control
dskclk		equ	07		;Disk clock for control
mdir		equ	0f7h		;Direction mask for function
null		equ	0fch		;Null command
idbuff		equ	00		;Initialize data command
isbuff		equ	08		;Initialize header command
rsect		equ	01		;Read sector command
wsect		equ	05		;Write sector command
;
;
		org	0080h
;
		db	lodsiz and 0ffh	;number of bytes to load
		dw	boot		;first two bytes are program start
;
boot:		xra	a
		out	bank		;turn off rom
;
cboot:		lxi	h,ccp		;start of cp/m
		mvi	e,strtsec	;starting sector
;
cboot1:		mvi	a,isbuff	;set pointer to header area
		out	hdcmnd
		xra	a		;set head, track to zero
		out	hddata
		out	hddata
		mov	a,e		;get sector
		out	hddata
		xra	a		;get a zero and normal key
		out	hddata
		out	hdcmnd		;set pointer to data area
		cma
		out	hddata
		out	hddata
		mvi	a,rsect		;read sector command
		out	hdcmnd		;do it
;
opwait:		in	hdstat		;get status
		ani	opdone		;wait for operation complete
		jrz	opwait
;
		in	hdstat		;check for read errors
		sta	status		;save for later (debug)
		ani	tmout
		jrnz	cboot		;start over if error
		in	hdreslt		;no errors, check result port
		sta	reslt
		ani	retry
		jrnz	cboot		;restart
;
		xra	a		;reset to data area
		out	hdcmnd
		in	hddata
		in	hddata
		lxi	b,hddata	;<b>=00, <c>= data port
		inir
		inir			;get 512 bytes
		mvi	a,lstsec
		cmp	e		;last sector ?
		jrz	gobios		;go to cbios, done loading
		inr	e		;next sector
		jr	cboot1		;loop
;
gobios:		jmp	bios		;for debug
;
;
status		db	00		;status register save
;
reslt		db	00		;result register save
;
;
		end
