	title	'Hard Disk sysgen program,	06 dec 81'
	page	58
;
vers	equ	1
revs	equ	2
;
key	equ	00		;sector key value
;
bdos	equ	0005h		;cpm entry point
fcb	equ	5ch		;default file control block
tbuff	equ	80h		;default buffer
osbase	equ	0900h		;base of cpm after "movcpm"
;
pmsg	equ	9		;print message
openf	equ	15
readf	equ	20
sdma	equ	26
;
tries	equ	10		;number of retries
lstsec	equ	19		;last sector to write

maxhd	equ	1		;Maximum # of Hard Disk Drives
mrev	equ	20		;Set to the type of hard disk (10, 20, 26)

hdorg	equ	50h		;Hard Disk Controller origin
hdstat	equ	hdorg		;Hard Disk Status
hdcntl	equ	hdorg		;Hard Disk Control
hddata	equ	hdorg+3		;Hard Disk Data
hdfunc	equ	hdorg+2		;Hard Disk Function
hdcmnd	equ	hdorg+1		;Hard Disk Command
hdreslt	equ	hdorg+1		;Hard Disk Result
retry	equ	2		;Retry bit of result
tkzero	equ	1		;Track zero bit of status
opdone	equ	2		;Operaction done bit of status
complt	equ	4		;Complete bit of status
tmout	equ	8		;Time out bit of status
wfault	equ	10h		;Write fault bit of status
drvrdy	equ	20h		;Drive ready bit of status
index	equ	40h		;Index bit of status
pstep	equ	4		;Step bit of function
nstep	equ	0fbh		;Step bit mask of function
hdrlen	equ	4		;Sector header length
seclen	equ	512		;Sector data length
wenabl	equ	0fh		;Write enable
wreset	equ	0bh		;Write reset of function
scenbl	equ	5		;Controller control
dskclk	equ	7		;Disk clock for control
mdir	equ	0f7h		;Direction mask for function
null	equ	0fch		;Null command
idbuff	equ	0		;Initialize data command
isbuff	equ	8		;Initialize header command
rsect	equ	1		;Read sector command
wsect	equ	5		;Write sector command

	if	mrev ne 26
seccnt	equ	21		;21 sectors per track for M10 and M20
	else
seccnt	equ	32		;32 for M26
	endif

	org	100h

	lxi	h,0000		;save stack so we can return
	dad	sp		; without rebooting
	shld	oldstack
	lxi	sp,stack
	lxi	d,signon
	call	print
;
	lda	tbuff		;check if file given
	ora	a
	cnz	rdsys		;read system from disk
	mvi	c,00
	call	setdrv
	jc	drverr		;drive select error
	call	home
	mvi	c,00
	call	settrk
	mvi	c,00
	call	sethead		;first head, track 00
	mvi	c,key		;set system key
	call	setkey
;
	lxi	d,retmsg
	call	print		;wait for user input
	mvi	c,01
	call	bdos
	cpi	0dh		;check for cr
	jnz	done1		;exit if not cr
;
	call	wrsec1		;sector 1 is treated seperatly
	lxi	h,osbase+128	;start of cpm proper
	shld	dmaaddr		;save it
;
;
gensys	equ	$
	mvi	c,tries		;10 retries on write error
	push	b		;save it on stack
;
errloop	equ	$
	lda	sector		;get sector number
	mov	c,a
	call	setsec
	lhld	dmaaddr		;get dma address
	push	h
	pop	b		;mov <hl> to <bc>
	call	setdma
;
	call	write		;out to disk
	pop	b		;get error count
	jc	wrerr		;process error if [cy]
	lda	sector
	cpi	lstsec		;are we done
	jnc	done
	inr	a		;next sector
	sta	sector
	lxi	d,512		;next dma address
	lhld	dmaaddr
	dad	d
	shld	dmaaddr
	jmp	gensys		;loop
;
;
rdsys:	xra	a		;get a zero
	sta	fcb+32		;clear next record
	lxi	d,fcb		;open file
	mvi	c,openf
	call	bdos
	inr	a		;check for good open
	jz	nofile		;not found
	mvi	a,16
	sta	fcb+32
;
rdloop	equ	$
	lhld	dmaaddr		;read file into 900h
	xchg			;<hl> to <de>
	mvi	c,sdma
	call	bdos
	lxi	d,fcb
	mvi	c,readf
	call	bdos		;do read
	ora	a		;check for error, or EOF
	rnz			;none left
	lxi	d,128
	lhld	dmaaddr		;next address
	dad	d
	shld	dmaaddr
	jmp	rdloop		;loop
;
;
nofile:	lxi	d,nofmsg	;print message
	call	print
	jmp	done1		;exit program
;
;
wrsec1:	mvi	b,tries		;10 retries
;
wrsec1a	equ	$
	push	b		;save
	mvi	c,01		;sector 1 only
	call	setsec
	lxi	b,osbase	;just write cold boot
	call	setdma
	call	write
	pop	b
	rnc
;
	mvi	a,5		;set message if 5 errors
	cmp	c
	jnz	wsec1b
	push	b		;save error count
	lxi	d,wmsg
	call	print
	pop	b
wsec1b:	dcr	c		;any counts left
	jnz	wrsec1a
	jmp	wrerr1		;exit program
;
;
wrerr:	push	b		;save error counter
	mvi	a,5
	cmp	c
	lxi	d,wmsg		;print trouble
	cz	print
	pop	b
	dcr	c		;one error less
	push	b
	jnz	errloop		;try again
wrerr1:	lxi	d,nowrmsg
	call	print
	jmp	done1		;exit
;
;
done:	lxi	d,donmsg
	call	print
done1:	lhld	oldstack	;return quiet
	sphl
	ret			;to cpm
;
;
drverr:	lxi	d,drvmsg
	call	print
	jmp	done1
;
;
print:	mvi	c,9		;message print
	jmp	bdos		;do indirect return
;
;
signon:	db	0dh,0ah,'Hard Disk Sysgen program v'
	db	vers+'0','.',revs+'0',0dh,0ah,0dh,0ah,'$'
;
nofmsg:	db	0dh,0ah,'NO file found$'
;
retmsg:	db	0dh,0ah,'Type RETURN to write system, any key to abort.$'
;
drvmsg:	db	0dh,0ah,'Invalid drive select, or drive not ready$'
;
wmsg:	db	0dh,0ah,'Having trouble writing$'
;
nowrmsg	db	07h,0dh,0ah,0dh,0ah,'DISK WRITE ERROR, returning to CP/M$'
;
donmsg:	db	0dh,0ah,0dh,0ah,'SYSTEM written to disk, bye$'
;
;
oldstack:
	dw	0000
;
sector:	db	2		;starting sector
;
dmaaddr:
	dw	osbase		;starting address
;
;
	ds	64
stack	equ	$


setdrv	jmp	hddrv		;Select disk
home	jmp	hdhome		;Recalibrate
settrk	jmp	hdtrk		;Seek to specified track
setsec	jmp	hdsec		;Prep for sector #
setdma	jmp	hddma		;Prep for DMA address
sethead	jmp	hdhead		;Set head #
setkey	jmp	hdkey		;Set the key in next transfer
read	jmp	hdread		;Read one sector
write	jmp	hdwrite		;Write one sector
dmastat	jmp	dmahd		;Return DMA address
getstat	jmp	stathd		;Get drive status

hddrv	mvi	a,3
	ana	c
	sta	hddisk
	ori	null		;Select drive
	out	hdfunc
	mvi	a,wenabl	;Enable the controller
	out	hdcntl
	mvi	c,239		;Wait for Disk to ready
				; 2 minutes for M26
				; 30 seconds for M10 & M20
	lxi	h,0
tdelay	dcx	h
	mov	a,h
	ora	l
	cz	dcrc
	stc
	rz
	in	hdstat		;Test if ready yet
	ani	drvrdy
	jnz	tdelay

	if	mrev ne 20	;M20 will do settle delay in hardware
	lhld	settle
	mov	a,h
	ora	l
	rz
	lxi	h,0		;Time one revolution of the drive
	mvi	c,index
	in	hdstat
	ana	c
	mov	b,a		;Save current index level in B
indx1	in	hdstat
	ana	c
	cmp	b		;Loop util index level changes
	jz	indx1
indx2	inx	h
	in	hdstat		;Start counting until index returns to
	ana	c		;	previous state
	cmp	b
	jnz	indx2
	shld	settle		;Save the Count for timeout delay
	endif
	ret

dcrc	mov	a,c
	ani	0fh
	jnz	dcrc1
	push	b
	push	h
	lxi	d,waitmsg
	call	print
	pop	h
	pop	b
dcrc1	dcr	c		;Conditional decrement C routine
	ret
;
waitmsg	db	0dh,0ah,'Waiting for disk ready$'

hdkey	mov	a,c
	sta	nkey
	ret

hdhome	call	drvptr
	mvi	m,0		;Set track to zero
	inx	h		;Point to seek flag
	mvi	m,1		;Set not seeking, but must delay
stepo	in	hdstat		;Test status
	ani	tkzero		;At track zero ?
	rz

	if	mrev ne 20
	mvi	a,1
	stc
	call	accok		;Take one step out
	call	wsdone		;Wait for previous seek to finish
	jmp	stepo

	else

	xra	a		;Make (a) into zero will do 255 steps
	stc			;and on an m20 this will do a recalibrate
	jmp	accok
	endif

delay	equ	$
	if	mrev ne 20
	lxi	h,0		;Get delay
settle	equ	$-2
deloop	dcx	h		;Wait 20ms
	mov	a,h
	ora	l
	inx	h
	dcx	h
	jnz	deloop
	endif

	lxi	h,drives-1
	mvi	b,maxhd+1
delup	inx	h
	inx	h
	dcr	b
	rz
	mov	a,m
	dcr	a
	jnz	delup
	mov	m,a
	jmp	delup

hdtrk	call	drvptr		;Get pointer to current track
	mov	e,m		;Get current track
	push	h		;Save pointer to current track
	inr	e		;Ever homed this drive ?
	cz	hdhome
	pop	h		;Restore track pointer
	mov	e,m		;Get current track
	mov	m,c		;Update the track
	mov	a,e		;Need to seek at all ?
	sub	c
	rz
	push	psw		;Save # of steps
	inx	h		;Point to the seek complete flag
	mov	a,m		;Get current seek progress flag
	inr	a		;Currently seeking ?
	push	h		;Save seek flag pointer
	cz	wsdone		;Wait if currently seeking
	pop	h
	mvi	m,0ffh		;Set seek in progress flag
	pop	psw
	cmc			;Get carry into direction
	jc	accok
	cma
	inr	a
accok	mov	b,a		;Prep for build
	call	build
sloop	ani	nstep		;Get step pulse low
	out	hdfunc		;Output low step line
	ori	pstep		;Set step line high
	out	hdfunc		;Output high step line
	dcr	b		;Update repeat count
	jnz	sloop		;Keep going the required # of tracks
;
sekdon	in	hdstat		;Wait for seek complete to finish
	ani	complt
	jz	sekdon
	ret

hddma	mov	h,b		;Save the DMA address
	mov	l,c
	shld	hdadd
	ret

wsdone	in	hdstat		;Wait for seek complete to finish
	ani	complt
	jz	wsdone
	lxi	h,drives-1	;Update all seek in progress flags
	mvi	b,maxhd+1
wsup	inx	h
	inx	h
	dcr	b
	rz
	mov	a,m
	ani	1
	mov	m,a
	jmp	wsup

hdsec	xra	a
	ora	c
	stc
	rz
	mvi	a,seccnt
	sub	c
	rc
	mov	a,c
	sta	hdsectr
	ret

hdhead	mov	a,c
	ani	7		; 7 for M26 & M20, 3 for M10
	sta	head
	ret

hdread	call	hdprep
	rc
	xra	a
	out	hdcmnd
	cma
	out	hddata
	out	hddata
	mvi	a,rsect		;Read sector command
	out	hdcmnd
	call	process
	rc
	xra	a
	out	hdcmnd
	mvi	b,seclen/4
	lxi	h,0
hdadd	equ	$-2
	in	hddata
	in	hddata
rtloop	in	hddata		;Move four bytes
	mov	m,a
	inx	h
	in	hddata
	mov	m,a
	inx	h
	in	hddata
	mov	m,a
	inx	h
	in	hddata
	mov	m,a
	inx	h
	dcr	b
	jnz	rtloop
	ret

hdwrite	call	hdprep		;Prepare header
	rc
	xra	a
	out	hdcmnd
	lhld	hdadd
	mvi	b,seclen/4
wtloop	mov	a,m		;Move 4 bytes
	out	hddata
	inx	h
	mov	a,m
	out	hddata
	inx	h
	mov	a,m
	out	hddata
	inx	h
	mov	a,m
	out	hddata
	inx	h
	dcr	b
	jnz	wtloop
;
	mvi	a,dskclk	;enable write
	out	hdcntl
	mvi	a,wsect		;Issue write sector command
	out	hdcmnd
	call	process
	rc
	mvi	a,wfault
	ana	b
	stc
	rz
	xra	a
	ret

process	in	hdstat		;Wait for command to finish
	mov	b,a
	ani	opdone
	jz	process
	mvi	a,wenabl
	out	hdcntl
	in	hdstat
	ani	tmout		;Timed out ?
	stc
	rnz
	in	hdreslt
	ani	retry		;Any retries ?
	stc
	rnz
	xra	a
	ret

hdprep	in	hdstat
	ani	drvrdy
	stc
	rnz
	mvi	a,isbuff	;Initialize pointer
	out	hdcmnd
	call	build
	ori	0ch
	out	hdfunc
	lda	head
	out	hddata		;Form head byte
	call	drvptr
	mov	a,m		;Form track byte
	out	hddata
	mvi	a,0		;Form sector byte
hdsectr	equ	$-1
	out	hddata
	mvi	a,0
nkey	equ	$-1
	out	hddata
	inx	h		;Bump to seek flag
	mov	a,m
	inr	a		;Update the seek in progress flag
	push	h
	cz	wsdone
	pop	h
	mov	a,m
	dcr	a		;Test for delay also
	cz	delay
	mvi	a,wenabl
	out	hdcntl
	xra	a
	ret

drvptr	lhld	hddisk
	xchg
	mvi	d,0
	lxi	h,drives
	dad	d
	dad	d
	ret

build	mvi	a,0
head	equ	$-1
	ral
	ral
	ral
	ral
	ori	0
hddisk	equ	$-1
	xri	0f0h
	ret

dmahd	push	h
	lhld	hdadd
	mov	b,h
	mov	c,l
	pop	h
	ret

stathd	in	hdreslt
	ani	3
	mov	b,a
	in	hdstat
	xri	31h
	ret

drives	dw	0ffffh
	dw	0ffffh
	dw	0ffffh
	dw	0ffffh

	end
