;
;********************************************************
;*							*
;*		M-Labs C1-Board Data Segment		*
;*		Version 1.0   26 dec 83			*
;*		Copyright (C) 1983 V. Nadvornik		*
;*							*
;********************************************************
;
;********************************************************
;*							*
;*		Initialized RAM data areas		*
;*							*
;********************************************************
;
;	DMA controller chip command data string
;
dma_blk	db	1100_0011b	;reset DMA
	db	0111_1101b	;port address and block count follow
dmaport	db	fdc_data	;port address (low)
	db	0000_0000b	;port address (high)
dma_cnt	dw	0000h		;block count
	db	0011_1100b	;port a is fixed
	db	0001_0000b	;port b is memory, incrementing
	db	1100_1101b	;port B address follows
dma_bas	dw	hst_buf		;base of system load
	db	1000_0010b	;ready active low, end of block
	db	0cfh		;load registers
dma_dir	db	05h		;transfer A->B or B->A
	db	0cfh		;reload registers
	db	87h		;arm the DMA
dma_len	equ	$-dma_blk	;DMA command block length
;
;********************************************************
;*							*
;*		  Disk parameter headers		*
;*							*
;********************************************************
;
dpbase	equ	$		;base of disk parameter headers
;
dph0	dw	0000,0000
	dw	0000,0000
	dw	dirbuf,xdpb
	dw	ckv0,alv0
;
dph1	dw	0000,0000
	dw	0000,0000
	dw	dirbuf,xdpb1
	dw	ckv1,alv1
;
dph2	dw	0000,0000
	dw	0000,0000
	dw	dirbuf,xdpb2
	dw	ckv2,alv2
;
dph3	dw	0000,0000
	dw	0000,0000
	dw	dirbuf,xdpb3
	dw	ckv3,alv3
;
;
;********************************************************
;*							*
;*		Disk parameter blocks			*
;*							*
;********************************************************
;
;	CCS/MORROW: 8", single sided, double density, 1k sectors
;
xdpb	dw	64	;cp/m sectors per track
	db	4	;block shift factor
blkmsk	db	15	;block mask
	db	0	;extent mask
	dw	299	;blocks per disk-1
	dw	127	;# of directory entries-1
	db	192	;directory pre-allocation
	db	0
	dw	32	;dir. checksum vect. size
	dw	2	;system track offset
secmsk	db	7	;sector mask ((hstsiz/128)-1)
secshf	db	3	;sector shift (log2(hstsiz/128))
;
;
;	Diskette type configuration bits:
;
;		High byte:
;	d7 d6 d5 d4 d3 d2 d1 d0
;	|  |  |  |  |  |  |  |
;	|  +--+--+--+--+--+--+-- Spare (reserved) [set to zero]
;	+-- System diskette flag:  1= system diskette
;
;		Low byte:
;	d7 d6 d5 d4 d3 d2 d1 d0
;	|  |  |  |  |  |  |  |
;	|  |  |  |  |  |  +--+-- Physical drive number (0-3)
;	|  |  |  |  +--+-- 2-sided track organization
;	|  |  |  |		d3  d2
;	|  |  |  |		 1   1 -- Extended tracks:  side0, 0 to t-1
;	|  |  |  |					    side1, t to t+(t-1)
;	|  |  |  |		 1   0 -- Alternate tracks:  side0, even tracks
;	|  |  |  |					     side1, odd tracks
;	|  |  |  |		 0   1 -- Extended sectors:  side0, 1 to s/2
;	|  |  |  |					     side1, s/2+1 to s
;	|  |  |  |		 0   0 -- Single sided diskette, or sector
;	|  |  |  |			   side flag has side info.
;	|  |  |  |
;	|  |  |  +-- 5.25"/8"* diskette size
;	|  |  +-- 80/40* track diskette (5.25" only)
;	|  +-- Floppy/Hard* disk select bit
;	+-- Single/Double* density bit
;
dsktyp	dw	1000_0000_0100_0000b	;disk configuration byte
;
xlttbl	db	1,4,7,2,5,8,3,6		;physical sector xlt table
	db	255,255,255,255,255,255,255,255
	db	255,255,255,255,255,255,255,255
	db	255,255
;
;	CCS/MORROW: 8", single sided, double density, 1k sectors
;
xdpb1	dw	64	;cp/m sectors per track
	db	4	;block shift factor
	db	15	;block mask
	db	0	;extent mask
	dw	299	;blocks per disk-1
	dw	127	;# of directory entries-1
	db	192	;directory pre-allocation
	db	0
	dw	32	;dir. checksum vect. size
	dw	2	;system track offset
	db	7	;sector mask ((hstsiz/128)-1)
	db	3	;sector shift (log2(hstsiz/128))
;
	dw	0000_0000_0100_0001b	;disk configuration byte
;
	db	1,4,7,2,5,8,3,6		;physical sector xlt table
	db	255,255,255,255,255,255,255,255
	db	255,255,255,255,255,255,255,255
	db	255,255
;
;	IBM 3740: 8", single sided, single density, 128 byte sectors
;
xdpb2	dw	26	;cp/m sectors per track
	db	3	;block shift factor
	db	7	;block mask
	db	0	;extent mask
	dw	242	;blocks per disk-1
	dw	63	;# of directory entries-1
	db	192	;directory pre-allocation
	db	0
	dw	16	;dir. checksum vect. size
	dw	2	;system track offset
	db	00	;sector mask ((hstsiz/128)-1)
	db	00	;sector shift (log2(hstsiz/128))
;
	dw	0000_0000_1100_0001b	;disk configuration byte
;
	db	1,7,13,19,25,5,11,17	;physical sector xlt table
	db	23,3,9,15,21,2,8,14
	db	20,26,6,12,18,24,4,10
	db	16,22
;
;	EAGLE: 5.25",double sided, double density, 80 track, 1k sectors
;
xdpb3	dw	40	;cp/m sectors per track
	db	4	;block shift factor
	db	15	;block mask
	db	0	;extent mask
	dw	394	;blocks per disk-1
	dw	191	;# of directory entries-1
	db	192	;directory pre-allocation
	db	0
	dw	32	;dir. checksum vect. size
	dw	2	;system track offset
	db	7	;sector mask ((hstsiz/128)-1)
	db	3	;sector shift (log2(hstsiz/128))
;
	dw	0000_0000_0111_1111b	;disk configuration byte
;
	db	1,3,5,2,4,255,255,255	;physical sector xlt table
	db	255,255,255,255,255,255,255,255
	db	255,255,255,255,255,255,255,255
	db	255,255
;
;
;	These variables are initialized during cold boot
;
;	Drive configuration table entry bit definitions:
;
;	d7 d6 d5 d4 d3 d2 d1 d0
;	|  |  |  |  |  |  |  |
;	|  |  |  |  |  |  +--+-- step-rate
;	|  |  |  |  +--+-- Not used (reserved)
;	|  |  |  +-- 5.25"/8"* drive size
;	|  |  +-- 80/40* track size (5.25" only)
;	|  +-- Drive installed bit (1 = drive available)
;	+-- Motor on bit (1 = motor on control required)
;
;	Drive configuration table
;
cfgtbl	db	0100_0001b	;drive 0
	db	0100_0001b	;drive 1
	db	1111_0001b	;drive 2
	db	0000_0001b	;drive 3
;
;	Character I/O ready mask and status port table
;
iotbl1	db	cons_stat,rxrdy	;console in and status
iotbl2	db	cons_stat,txrdy	;console out
iotbl3	db	rdr_stat,rxrdy	;reader in
iotbl4	db	pun_stat,txrdy	;punch out
iotbl5	db	cen_stat,00	;centronics list out and status
;
;
;********************************************************
;*							*
;*	       Uninitialized RAM data areas		*
;*							*
;*		  Deblocking variables			*
;*							*
;********************************************************
;
un_init_data	equ	$	;start of uninialized data
;
;	CP/M variables
;
sekdsk	ds	1		;seek disk number
sektrk	ds	2		;seek track number
seksec	ds	1		;seek sector number
sekdpb	ds	2		;seek disk param. block
;
;	Physical variables
;
hstdsk	ds	1		;host disk number
hsttrk	ds	2		;host track number
hstsec	ds	1		;host sector number
hstdpb	ds	2		;host disk param. block
;
;	Deblocking variables
;
sekhst	ds	1		;seek shr secshf
hstact	ds	1		;host active flag
hstwrt	ds	1		;host written flag
;
unacnt	ds	1		;unalloc. record count
unadsk	ds	1		;last unalloc. disk
unatrk	ds	2		;last unalloc. track
unasec	ds	1		;last unalloc. sector
;
;	FDC register copy
;
cdrive	ds	1		;current drive config. byte
csector	ds	1		;current sector number
ctrack	ds	1		;current track number
;
;	Misc. variables
;
drvcpy	ds	1		;copy of drive control port
erflag	ds	1		;error reporting
errcnt	ds	1		;error retry counter
fdc_op	ds	1		;FDC opcode byte
motflg	ds	1		;motor-on flag, 0= motor off
readop	ds	1		;one (1) if read operation
rsfla	d			;rea secto flag
rw_op	ds	1		;read/write opcode byte/flag
wrtype	ds	1		;bdos write operation type
;
cfgptr	ds	2		;pointer to config. table
dmaadr	ds	2		;last dma address
;
;
;********************************************************
;*							*
;*    Disk allocation and directory checksum arrays	*
;*							*
;********************************************************
;
alv0	ds	128		;allocation table vector
ckv0	ds	64		;directory checksum vector
alv1	ds	128		;allocation table vector
ckv1	ds	64		;directory checksum vector
alv2	ds	128		;allocation table vector
ckv2	ds	64		;directory checksum vector
alv3	ds	128		;allocation table vector
ckv3	ds	64		;directory checksum vector
;
;********************************************************
;*							*
;*		CP/M directory buffer and		*
;*		Host deblocking sector buffer		*
;*							*
;********************************************************
;
dirbuf	ds	128		;cp/m directory buffer
;
hstbuf	ds	1024		;host buffer
;
id_vec	ds	6		;read sector ID buffer
;
;	end of data segment
;
