;
;********************************************************
;*							*
;*	      C1 board system error module		*
;*		Version 1.0.  12 jun 83			*
;*		Copyright (C) 1983, V. Nadvornik	*
;*							*
;********************************************************
;
;
bioerr:	lxi	h,biomsg	;first of non-fatal error message
;
errprn:	call	prnmsg
;
ilprn:	pop	h		;recover ERROR message
	call	prnmsg		;print it
	pchl			;return to calling routine
;
errtry:	lxi	h,trymsg	;retry message
	call	prnmsg
	call	conin		;get retry or warm-boot
	cpi	'C'-40h		;control C ?
	jz	wboot		;reboot if so
	ret			;retry error
;
prnmsg:	mov	a,m		;get character
	inx	h
	ora	a		;test for terminator
	rz
	mov	c,a
	call	conout		;print it
	jr	prnmsg
;
selerr:	call	bioerr
	db	'DISK OUT-OF-RANGE',0
	jr	ftlprn
;
sasi_err1:
sasi_err2:
cfger1:	call	bioerr
	db	'NO DRIVE',0
;
ftlprn:	call	ilprn
	db	', re-booting.',cr,lf,0
	xra	a
	sta	cdisk
	jmp	wboot
;
cfger2:	call	bioerr
	db	'CONFIG. MISMATCH',0
	jr	ftlprn
;
homerr:	call	bioerr
	db	'RESTORE ERROR',0
	jr	errtry
;
idxerr:	call	bioerr
	db	'NO INDEX',0
	jmp	errtry
;
sekerr:	call	bioerr
	db	'SEEK ERROR',0
	jmp	errtry
;
biomsg	db	cr,lf,'Bios error: ',0
;
trymsg	db	', Type <ret> to retry, or <^C> to re-boot.',cr,lf,0
	ret
;
;	End of C1-Board error module
;
