	title	'M-Disk, Apple ][ 128k ram CP/M patch.  22 sep 83'
;
;
	maclib	z80
$*Macro
;
;	Patch program for Apple ][ 128k ram card to allow using the
;	card as a 128k-byte memory disk.
;
dir_buf		equ	0080h		;dummy BDOS directory buffer address
alloc_size	equ	128/8		;allocation vector size (in bytes)
;
	org	0f200h			;locate program in Apple ][
					;"getln" buffer area
;
sel_dsk:	mvi	a,-1
		sta	ovl_dsk		;set invalid disk for read/write
;
;	Check drive number for proper range, M: or N:
;
		mov	a,c		;get drive number
		sui	12		;check low range
		jc	0000		;patch in address of bios SELDSK
patch_sel_dsk1	equ	$-2		;filled in by loader
;
		cpi	2		;and high range
		jnc	0000		;patch in address of bios SELDSK
patch_sel_dsk2	equ	$-2		;filled in by loader
;
		sta	ovl_dsk		;save drive number 0 or 1
		lxi	h,slot_tbl
		add	l
		mov	l,a
		mov	a,m		;get slot number
		ora	a
		jm	sel_error
		sta	slot_no		;save selected drive slot
;
;	Build and return pointer to proper DPH in <HL>
;
		lda	ovl_dsk		;re-get logical drive number
		rept 4
		add	a
		endm
		lxi	h,dp_base	;base address of DPH's
		add	l		;offset to proper DPH
		mov	l,a		;ignore carry since we are in one page
		ret			;to BDOS
;
sel_error:	lxi	h,0000
		ret
;
;	Trap and save the track number in-case of a future M-disk read/write
;
set_trk:	mov	a,c		;get track, 1 byte only
		sta	ovl_trk
		jmp	0000		;patch in address of bios SETTRK
patch_set_trk	equ	$-2		;filled in by loader
;
;	Trap and save the sector number incase
;	of a future M-DISK read or write
;
set_sec:	mov	a,c		;get sector number
		sta	ovl_sec
		jmp	0000		;patch in address of bios SETSEC
patch_set_sec	equ	$-2		;filled in by loader
;
;	Trap and set track save to 0 for possible restore
;
home:		xra	a		;get a zero
		sta	ovl_trk		;set track zero
		jmp	0000		;patch in address of bios HOME
patch_home	equ	$-2		;filled in by loader
;
;	Trap and save BDOS DMA address
;
set_dma:	sbcd	ovl_dma		;save DMA address
		jmp	0000		;patch in address of bios SETDMA
patch_set_dma	equ	$-2		;filled in by loader
;
;	Preform a read or write of the memory disk
;	if "ovl_dsk" is a valid drive
;
read:		call	calc_sec	;select the board and set the window
		jm	0000		;patch in address of bios READ
patch_read	equ	$-2		;filled in by loader
;
		jr	ovl_rw		;common read/write code
;
write:		call	calc_sec
		jm	0000		;patch in address of bios WRITE
patch_write	equ	$-2		;filled in by loader
;
		xchg			;write: swap source/dest. registers
;
ovl_rw:		lxi	b,128		;move 1 CP/M sector
		ldir
		xra	a		;return no-errors
		ret
;
;	Select the proper memory board referenced in "slot_no"
;	and set the bank and page selected by "ovl_trk" and "ovl_sec"
;
calc_sec:	lda	ovl_dsk		;get disk
		ora	a		;test for invalid drive
		rm			;not a memory disk access if negative
;
;	Calculate proper board slot
;
		lda	slot_no		;get i/o address
		rept 4
		add	a		;shift left 4 (*16)
		endm
		lxi	h,0e088h	;base of periph. card i/o locations
		ora	l		;proper i/o slot
		mov	l,a
;
;	Get bank and HI/LO sector from BDOS sector number
;
;	sector:		00 --- bank-0, low sector
;			01 --- bank-0, high sector
;			10 --- bank-1, low sector
;			11 --- bank-1, high sector
;
		lda	ovl_sec
		rrc
		rrc			;position bits
		mov	m,a		;set bank
		lxi	b,-8		;set pointer to page register
		dad	b
		push	psw		;save hi/lo sector flag
		lda	ovl_trk		;get page
		mov	m,a		;set page
		pop	psw		;restore hi/lo flag
		rlc			;position flag
		ani	80h		;kill all but sector bit
		mov	c,a
		mvi	b,00
		lda	slot_no
		lxi	h,0e000h	;base of periph. card prom location
		ora	h
		mov	h,a
;
;	Add in sector flag, sector flag is 0 or 80h
;
		dad	b
		lded	ovl_dma		;get BDOS dma address
		xra	a		;clear minus flag
		ret
;
;
dp_base		equ	$
;
dph_1		dw	0,0,0,0
		dw	dir_buf		;"dir_buf" filled in by loader
patch_dir_buf1	equ	$-2
		dw	dpb
		dw	0000,alloc1
;
dph_2		dw	0,0,0,0
		dw	dir_buf		;"dir_buf" filled in by loader
patch_dir_buf2	equ	$-2
		dw	dpb
		dw	0000,alloc2
;
dpb		dw	0004		; 4 128-byte sectors per track
		db	3		;block shift factor
		db	7		;block mask (1k block size)
		db	0		;extent mask
		dw	7fh		;disk size -1 (in blocks)
		dw	63		;max directories -1
		db	1100_0000b	;alloc 0 (reserve 2k for directory)
		db	0000_0000b	;alloc 1
		dw	0000		;check sum vector size (not used)
		dw	0000		;system track offset (none)
;
slot_tbl	db	5		;i/o slot number for drive 0
		db	7		;i/o slot number for drive 1
;
slot_no		db	00		;selected card number
ovl_dsk		db	-1		;BDOS drive number
ovl_trk		db	00		;BDOS track number
ovl_sec		db	00		;BDOS sector number
ovl_dma		dw	0000		;BDOS dma address
;
alloc1		ds	alloc_size
alloc2		ds	alloc_size
;
;
		end
