	title	'M-disk loader.  24 sep 83'
;
;
	maclib	z80
$*Macro
;
bdos		equ	0005h
bias		equ	0f000h
prom		equ	0e000h
;
home		equ	bias+23fh
sel_dsk		equ	bias+200h
set_trk		equ	bias+231h
set_sec		equ	bias+238h
set_dma		equ	bias+246h
read		equ	bias+24dh
write		equ	bias+255h
;
patch_home	equ	bias+244h
patch_sel_dsk1	equ	bias+209h
patch_sel_dsk2	equ	bias+20eh
patch_set_trk	equ	bias+236h
patch_set_sec	equ	bias+23dh
patch_set_dma	equ	bias+24bh
patch_read	equ	bias+251h
patch_write	equ	bias+259h
patch_dir_buf1	equ	bias+2a1h
patch_dir_buf2	equ	bias+2b1h
;
;
swap	macro	bios,patch
	lxi	d,bios
	call	swap_adrs
	sbcd	patch
	endm
;
;	Loader and initializer for Memory Disk bios patch program
;
	org	100h
;
mdisk_ldr:	sspd	ldr_stack	;save CCP stack pointer
		lxi	sp,ldr_stack	;  and set-up local stack
;
;	Move patch program to operating ram
;
		lxi	b,256		;bytes to move
		lxi	d,bias+200h	;destination address
		lxi	h,400h		;source address
		ldir			;move overlay
;
;	Initialize BIOS jump table
;
		call	addr_init
;
;	Patch overlay DPH's with BIOS directory address
;
		call	patch_dir_buf
		lxi	d,8
		dad	d		;point to bios dirbuf pointer
		mov	c,m		;get low byte
		inx	h
		mov	b,m		;get high byte
		sbcd	patch_dir_buf1
		sbcd	patch_dir_buf2
;
;	Initialize memory disk's directory areas
;
		call	clr_dir
		lspd	ldr_stack
		ret			;to CCP (quietly)
;
addr_init:	lhld	1		;get pointer to BIOS
		lxi	d,18h-3		;offset to HOME entry
		dad	d		;point to jump table
;
		swap	<home>,<patch_home>
		swap	<sel_dsk>,<patch_sel_dsk1>
		sbcd	patch_sel_dsk2
		swap	<set_trk>,<patch_set_trk>
		swap	<set_sec>,<patch_set_sec>
		swap	<set_dma>,<patch_set_dma>
		swap	<read>,<patch_read>
		swap	<write>,<patch_write>
		ret
;
swap_adrs:	inx	h		;point to low byte
		mov	c,m		;get low byte
		mov	m,e		;put overlay low byte
		inx	h		;point to high byte
		mov	b,m		;get high byte
		mov	m,d		;put overlay high byte
		inx	h		;point to next jump
		ret
;
patch_dir_buf:	mvi	c,19h		;return current drive function
		call	bdos
		mov	c,a		;get current drive
		lhld	0001
		lxi	d,1bh-3		;bios select disk function
		dad	d
		lxi	d,0001h		;tell select disk already logged in
		pchl
;
;
clr_dir:	mvi	a,5
		sta	slot		;do first board, slot 5
		xra	a
		call	clr_1
		mvi	a,7		;do second board, slot 7
		sta	slot
		xra	a
;
clr_1:		sta	sector		;start at sector zero
		rrc
		rrc
		ani	0fh
		sta	track
		call	e5_dir		;fill sector with e5's
		lda	sector
		inr	a
		cpi	16		;finished with first directory
		jrc	clr_1
		ret
;
;	Select the proper memory board referenced in "slot"
;	and set the bank and page selected by "sector"
;
;	Calculate proper board slot
;
e5_dir:		lda	slot		;get i/o address
		rept 4
		add	a		;shift left 4 (*16)
		endm
		lxi	h,prom+88h	;base of periph. card i/o locations
		ora	l		;proper i/o slot
		mov	l,a
;
;	Get bank and HI/LO sector from BDOS sector number
;
;	sector:		00 --- bank-0, low sector
;			01 --- bank-0, high sector
;			10 --- bank-1, low sector
;			11 --- bank-1, high sector
;
		lda	sector
		rrc
		rrc			;position bits
		mov	m,a		;set bank
		lxi	b,-8		;set pointer to page register
		dad	b
		push	psw		;save hi/lo sector flag
		lda	track		;get page
		mov	m,a		;set page
		pop	psw		;restore hi/lo flag
		rlc			;position flag
		ani	80h
		mov	c,a
		mvi	b,00
		lda	slot
		lxi	h,prom		;base of periph. card prom location
		ora	h
		mov	h,a
;
;	Add in sector flag, sector flag is 0 or 80h
;
		dad	b
		mvi	m,0e5h		;fill value
		lxi	b,127		;bytes to fill
		mov	d,h
		mov	e,l
		inx	d
		ldir
		ret
;
;
slot		db	00
track		db	00
sector		db	00
		ds	64
ldr_stack	db	0,0,'Mdisk, Copyright 1983, V. Nadvornik'
;
;
		end	mdisk_ldr
