;
;	* * * * * * * * * * * * * * * * * * * * * * * * *
;	*						*
;	*    Super-186 peripheral I/O equate module	*
;	*		    24 sep 83			*
;	*						*
;	* * * * * * * * * * * * * * * * * * * * * * * * *
;
;	System I/O controller base addresses
;
ieee_488_dma	equ	pcs2		;488 controller DMA select
ieee_488	equ	pcs1		;488 controller polled read/write select
sio_irq		equ	pcs0 + 70h	;SIO select for interrupt acknowledge
baud_divr	equ	pcs0 + 60h	;8253-5 baud rate generator
cen_ppi		equ	pcs0 + 50h	;8255a-5 centronics interface
clk_ppi		equ	cen_ppi		;  also interface for OKI clock chip
serialB		equ	pcs0 + 40h	;serial controller #2
serialA		equ	pcs0 + 30h	;serial controller #1
sys_ppi		equ	pcs0 + 20h	;system switches, Drive controll register
					;  clock data register
wd_fdc		equ	pcs0 + 10h	;floppy disk controller chip
SASI_ppi	equ	pcs0		;scsi data in/out, command/status
					;  registers
;
;	Z80a-SIO internal register equates
;
sio_cha		equ	0		;Z80a-SIO channel A offset
sio_chb		equ	4		;Z80a-SIO channel B offset
sio_d_reg	equ	0		;Z80a-SIO channel A&B data register offset
sio_c_reg	equ	2		;Z80a-SIO channel A&B command reg. offset
;
sio_wr0		equ	0		;Z80a-SIO write register 0 ...
sio_wr1		equ	1
sio_wr2		equ	2
sio_wr3		equ	3
sio_wr4		equ	4
sio_wr5		equ	5
sio_wr6		equ	6
sio_wr7		equ	7		; ... write register 7
;
tx_rdy		equ	00000100b	;transmitter holding register empty bit
rx_rdy		equ	00000001b	;receiver register full bit
sio_eoi		equ	00111000b	;end of interrupt command
;
;	network and console usart port addresses
;
net_data	equ	serialA + sio_cha + sio_d_reg
net_stat	equ	serialA + sio_cha + sio_c_reg
ci_data		equ	serialA + sio_chb + sio_d_reg
ci_stat		equ	serialA + sio_chb + sio_c_reg
co_data		equ	ci_data
co_stat		equ	ci_stat
;
;	serial list and punch/reader uart port addresses
;
lo_data		equ	serialB + sio_cha + sio_d_reg
lo_stat		equ	serialB + sio_cha + sio_c_reg
li_data		equ	lo_data
li_stat		equ	lo_stat
ri_data		equ	serialB + sio_chb + sio_d_reg
ri_stat		equ	serialB + sio_chb + sio_c_reg
po_data		equ	ri_data
po_stat		equ	ri_stat
;
;	SASI parallel port addresses
;
SASI_cmnd	equ	SASI_ppi + 4	;SASI command port (PPI port C)
SASI_stat	equ	SASI_cmnd	;SASI status port
SASI_data_out	equ	SASI_ppi + 2	;SASI data out port (PPI port B)
SASI_data_in	equ	SASI_ppi + 0	;SASI data in port (PPI port A)
;
;	SASI control and status bits
;
SASI_doebl	equ	10000000b	;SASI data out driver enable* bit
SASI_atn	equ	01000000b	;SASI bus attention* command bit
SASI_rst	equ	00100000b	;SASI reset* bus bit
SASI_sel	equ	00010000b	;SASI controller select* bit
;
SASI_bsy	equ	00001000b	;SASI busy* line
SASI_cd		equ	00000100b	;SASI control*/data line
SASI_io		equ	00000010b	;SASI input*/output line
SASI_req	equ	00000001b	;SASI data transfer request*
;
;	floppy disk controller port addresses
;
fdc_data	equ	wd_fdc + 6	;179x data register
fdc_sec		equ	wd_fdc + 4	;179x sector register
fdc_trk		equ	wd_fdc + 2	;179x track register
fdc_cmnd	equ	wd_fdc + 0	;179x command register
fdc_stat	equ	fdc_cmnd	;179x status register
;
;	WD179x commands
;
step_rate	equ	00000001b		;6ms step rate
;
home_cmd	equ	00001000b + step_rate	;restore: load head, no verify
seek_cmd	equ	00011100b + step_rate	;seek: update trk reg,
						;  load head, verify
step_in_cmd	equ	01011000b + step_rate	;step-in: update trk reg,
						;  load head, no verify
rd_sec_cmd	equ	10000000b	;read sector: single sector, side 0
					;  no 15ms, no side cmp
wr_sec_cmd	equ	10100000b	;write sector: single sector, side 0
					;  no 15ms, no side cmp, data AM
rd_adr_cmd	equ	11000000b	;read address: no 15ms
force_irq	equ	11010000b	;force interrupt command
multi_sec	equ	00010000b	;read or write multiple sectors bit
fdc_verf	equ	00000100b	;verify bit
fdc_hd_ld	equ	00001000b	;head load bit
dly_15_ms	equ	00000100b	;delay 15ms after headload
;
;	WD179x status bits
;
fdc_not_rdy	equ	10000000b	;disk not ready bit
fdc_wr_prot	equ	01000000b	;disk write protected
fdc_hd_load	equ	00100000b	;head loaded bit
fdc_sek_err	equ	00010000b	;seek error bit
fdc_crc_err	equ	00001000b	;read crc error bit
fdc_trk0	equ	00000100b	;head positioned on track 0
fdc_index	equ	00000010b	;copy of index from drive
fdc_busy	equ	00000001b	;command in progress
;
fdc_rec_typ	equ	00100000b	;record type of read (data AM)
fdc_rnf		equ	00010000b	;record not found bit
fdc_lost_data	equ	00000100b	;lost data error (over/under run)
fdc_data_req	equ	00000010b	;copy of data request output
;
rd_err_mask	equ	10011100b	;read error mask
wr_err_mask	equ	11111100b	;write error mask
sek_err_msk	equ	10011000b	;seek error mask
;
;	System PPI port functions and offsets
;
tod_data	equ	sys_ppi + 4	;wall clock data port (d7-d4)
dma_mux_sel	equ	sys_ppi + 4	;memory error enable (d3), and
					;DMA source select control (d2-d0)
sys_sw		equ	sys_ppi + 2	;system configuration switches
drv_sel		equ	sys_ppi + 0	;drive control register
drv_stat	equ	drv_sel
;
ebl_mem_err	equ	00001000b	;enable ECC double bit error interrupt
					;  (Uses NMI)
;
;     mux-2   mux-1   mux-0
;	1	1	1 --- select +5V (disable dma request)
;	1	1	0 --- NOT USED
;	1	0	1 --- select IEEE-488 controller dma request
;	1	0	0 --- select serialB channel-2
;	0	1	1 --- select serialB channel-1
;	0	1	0 --- select serialA channel-2
;	0	0	1 --- select serialA channel-1
;	0	0	0 --- select floppy disk controller DRQ
;
dma_488		equ	00000101b
dma_serb2	equ	00000100b
dma_serb1	equ	00000011b
dma_sera2	equ	00000010b
dma_sera1	equ	00000001b
dma_fdc		equ	00000000b
dma_mux_msk	equ	00000111b	; d2-d0
;
;	System configuration switch definitions
;
cent@488	equ	10000000b	;selects centronics or IEEE-488* interrupt
baud_clock	equ	01000000b	;selects 2Mhz* or 2.4576Mhz input clock
;
;	boot-1	boot-0
;	  1	  1 --- boot from hard disk, controller #0, drive #0
;	  1	  0 --- boot from floppy, drive #2
;	  0	  1 --- boot from floppy, drive #0
;	  0	  0 --- enter monitor if installed, else boot from hard disk
;
boot_jmpr_1	equ	00100000b
boot_jmpr_0	equ	00010000b	;select system boot device and size
boot_mask	equ	00110000b
clk8@4		equ	00001000b	;8Mhz or 4Mhz* system clock
;
;	Memory size select switches
;	M-size2	M-size1	M-size0
;	   1	   1	   1 --- 1 Mbyte of ram, prom enabled
;	   1	   1	   0 --- 640 kbytes of ram, prom enabled
;	   1	   0	   1 --- 512 kbytes of ram, prom enabled
;	   1	   0	   0 --- 256 kbytes of ram, prom enabled
;	   0	   1	   1 --- 128 kbytes of ram, prom enabled
;	   0	   1	   0 --- 1 Mbyte of ram, prom disabled
;	   0	   0	   1 --- NOT USED (do not select)
;	   0	   0	   0 --- NOT USED (do not select)
;
mem_size	equ	00000111b	;memory size select switches
;
;	drive select control bits
;
drv_motr_on	equ	10000000b	;drive motor on* line
drv_sid_sel	equ	01000000b	;select side 0 (0) or side 1 (1)
drv_sel_8	equ	00100000b	;select 5.25" (1) or 8" (0) drive size
drv_sd_dd	equ	00010000b	;select single (1) or double (0) dens
drv_ds3		equ	00001000b	;select drive 3 (5.25" only)
drv_ds2		equ	00000100b	;	drive 2 (5.25" or 8")
drv_ds1		equ	00000010b	;	drive 2 (5.25" or 8")
drv_ds0		equ	00000001b	;	drive 1 (5.25" or 8")
;
;	Centronics data, command/status, and OKI clock command and address
;
cent_stat	equ	cen_ppi + 4	;centronics status port
OKI_addr	equ	clk_ppi + 2	;OKI clock chip address lines port
OKI_cntl	equ	clk_ppi + 2	;OKI clock chip rd/wr/hold port
cent_data_out	equ	cen_ppi + 0	;centronics data out port
;
;	Centronics command/status bit definitions
;
cent_stb	equ	10000000b	;centronics strobe* bit
cent_ack	equ	01000000b	;centronics acknowledge* bit
SASI_msg	equ	00100000b	;SASI message* line
drv_2_sid	equ	00010000b	;single (1) or double (0) sided drive
cent_irq	equ	00001000b	;centronics interrupt bit
cent_fault	equ	00000100b	;centronics printer fault bit
cent_pe		equ	00000010b	;centronics paper empty bit
cent_busy	equ	00000001b	;centronics printer busy bit
cent_err	equ	00000111b	;centronics printer error mask
;
;	OKI wall clock chip bit definitions
;
OKI_hold	equ	10000000b	;OKI hold line
OKI_write	equ	01000000b	;OKI write line
OKI_read	equ	00100000b	;OKI read line
rom_off		equ	00010000b	;disable* system prom
OKI_adr		equ	00001111b	;OKI address bits
;
;	end of system equate module
;
