/***************************************************************\
*								*
*          Program to output data file for ECC PROM		*
*								*
*		By:   Allen J. Larsen				*
*		Date: 12/8/82					*
*		Ver:  1.0					*
*								*
\***************************************************************/
#include BDSCIO.H
int fid;
char iobuf[BUFSIZ];

main()
{
 int i;
   fcreat("ECC.ASM",iobuf);
   for(i=0; i<256; i++)  {
      brec();
      parity(i,0,1,3,4,6);
      parity(i,0,2,3,5,6);
      parity(i,1,2,3,7,8);    /*  "8" is a dummy */
      parity(i,4,5,6,7,8);
      erec();
   }
   putc(CPMEOF,iobuf);
   fflush(iobuf);
   fclose(fid);
}

brec()
{
   fprintf(iobuf,"	DB	");
}

erec()
{
   fprintf(iobuf,"B\12");
}

parity(byte,b1,b2,b3,b4,b5)
int byte,b1,b2,b3,b4,b5;
{
   b1 = byte >> b1 & '\01';
   b2 = byte >> b2 & '\01';
   b3 = byte >> b3 & '\01';
   b4 = byte >> b4 & '\01';
   if(b5 == 8)
      b5 = '\0';
   else
      b5 = byte >> b5 & '\01';
   if(((b1 ^ b2 ^ b3 ^ b4 ^ b5) & '\01') == '\01')
      putc('1',iobuf);
   else
      putc('0',iobuf);
}
