;
; TARBELL ELECTRONICS
; ANOS COLDSTART LOADER
; VERSION OF 3-22-'79.
;
;	BEWARE THE THE ENTRY POINT IS 7DH NOT 0
;	THE 82S123 ROM REQUIRES THIS
;	MODIFIED FOR ANOS BY RLH AND KEJ
;	JUNE 17, 1980
;
; THIS PROGRAM IS LOADED AT LOCATION ZERO
; BY THE BOOTSTRAP PROGRAM, AND EXECUTED.
; ITS PURPOSE IS TO LOAD THE ANOS COLDSTART
; PROGRAM INTO MEMORY AND EXECUTE IT.
;
DISK	EQU  0F8H	;DISK PORT BASE ADDRESS.	**
;
DCOM	EQU  DISK	;COMMAND PORT.
DSTAT	EQU  DISK	;STATUS PORT.
TRACK	EQU  DISK+1	;TRACK PORT.
SECT	EQU  DISK+2	;SECTOR PORT.
DATA	EQU  DISK+3	;DATA PORT.
WAIT	EQU  DISK+4	;WAIT PORT.
DCONT	EQU  DISK+4	;CONTROL PORT.
ABASE	EQU	100H	;WHERE COLD LOADER IS TO GO
NSECTS	EQU  46		;SECTORS OF ANOS.
RTCNT	EQU  10		;NUMBER OF RETRYS.

	ORG  0		;START OF LOADER.

BOOT:	MVI  E,RTCNT	;GET RETRY COUNT.
BLOOP:	LXI  SP,100H	;SET STACK POINTER.
	LXI  H,ABASE	;ANOS BOOT STARTS HERE.
	SHLD	DMA
	MVI  D,NSECTS	;NUMBER OF SECTORS TO READ.
	LXI	H,FPTRANS+2	;SKIP FIRST 2 SECTORS
B0:	MVI	B,4		;HEAD LOAD
B1:	MOV	A,M
	ORA	A
	JZ	B2		;IF AT END OF TRACK
	INX	H
	PUSH	H
	CALL	READ		;READ IN SECTOR
	POP	H		;GET FPTRANS POINTER BACK
	MVI	B,0		;NO HEAD LOAD
	DCR	D		;NUMBER OF SECTORS TO READ
	JZ	ABASE		;IF COLD LOADER IN MEMORY
	JMP	B1
B2:	MVI	A,53H
	OUT	DCOM		;STEP TO NEXT TRACK
	IN	WAIT
	LXI	H,FPTRANS	;START OF SECTOR SKEW TABLE
	JMP	B0

READ:	LHLD	DMA	;SET UP DMA ADDRESS
	OUT  SECT	;SET SECTOR REGISTER.
	CALL CHECK	;CHECK FOR ERROR.
	MVI  A,88H	;COMMAND FOR READ.
	ORA  B		;GET HEAD LOAD BIT.
	OUT  DCOM	;ISSUE COMMAND.
RLOOP:	IN   WAIT	;WAIT FOR DRQ.
	ORA  A		;SET FLAGS.
	JP   CHECK	;JUMP IF DONE.
	IN   DATA	;READ DATA.
	MOV  M,A	;PUT IN MEMORY.
	INX  H		;INCREMENT POINTER.
	JMP  RLOOP	;LOOP UNTIL DONE.

CHECK:	SHLD	DMA	;SAVE DESTINATION ADDRESS
	IN   DSTAT	;READ STATUS.
	ANI  9DH	;LOOK AT ERROR BITS.
	RZ		;OK IF ZERO
	DCR  E		;DECREMENT RETRY COUNT.
	JNZ  BLOOP	;TRY AGAIN IF NOT ZERO.
	CMA		;INVERT AND SEND
	OUT  0FFH	;TO FRONT PANEL.
HERE:	JMP  HERE	;LOOP.

FPTRANS: DB	01H,07H,0DH,13H,19H,05H,0BH,11H
	DB	17H,03H,09H,0FH,15H,02H,08H,0EH
	DB	14H,1AH,06H,0CH,12H,18H,04H,0AH
	DB	10H,16H,0
	ORG	7DH		;ENTRY POINT USED BY 82S123 PROM
	JMP	0
DMA	EQU	$		;WHERE BOOT IS TO GO
	END
