	ORG	100H

;
;	DEFINE MEMORY SIZE IN UNITS OF 1K
;

MEMSIZE	EQU	60

;
;	LOADOS - LOAD THE OPERATING SYSTEM
;
;	LOADOS IS RESPONSIBLE FOR LOADING THE OPERATING SYSTEM INTO MEMORY
;	AND RELOCATING IT TO THE APPROPRIATE SPOT.  THE SPOT IS GOVERNED
;	BY THE VALUE OF 'MEMSIZE', THE USER DESIGNATED MEMORY SIZE.
;

STACK:	DS	0

LOADOS:	LXI	SP,STACK
	CALL	READOS		;READ THE OPERATING SYSTEM INTO MEMORY
	CALL	GETADDR		;COMPUTE DESTINATION ADDRESS OF OPERATING SYSTEM
	CALL	RELOC		;READ AND RELOCATE THE OPERATING SYSTEM

;
;	TRANSFER CONTROL TO THE OPERATING SYSTEM
;

	MVI	A,JMP		;STORE JUMP TO OPERATING SYSTEM ENTRY POINT
	STA	5
	LHLD	OSADDR
	LXI	D,6
	DAD	D
	SHLD	6

	MVI	C,39		;COLDSTART OS
	CALL	5

LOAD1:	JMP	LOAD1		;HANG IF OS RETURNS (IT NEVER SHOULD)

;
;	READOS - READ THE OPERATING SYSTEM INTO MEMORY
;

READOS:	MVI	C,26		;INITIALIZE DMA ADDRESS
	LXI	D,BUFFER
	CALL	5

	MVI	C,15		;OPEN 'ANOS.IMG'
	LXI	D,OSFCB
	CALL	5
	INR	A
	JZ	READ2		;IF ANOS NOT FOUND

	LXI	H,BUFFER	;PRESET DMA ADDRESS

READ1:	XCHG
	MVI	C,26
	PUSH	D
	CALL	5
	MVI	C,20		;READ NEXT RECORD
	LXI	D,OSFCB
	CALL	5
	POP	H
	ORA	A
	RNZ			;IF OS COMPLETELY READ
	LXI	D,128		;ADVANCE DMA ADDRESS
	DAD	D
	JMP	READ1

READ2:	MVI	C,9		;ISSUE MESSAGE AND HANG
	LXI	D,READ4
	CALL	5

READ3:	JMP	READ3

READ4:	DB	'ANOS.IMG NOT FOUND$'

OSFCB:	DB	0,'ANOS    IMG',0,0,0,0
	DS	16
	DB	0


;
;	GETADDR - GET DESTINATION ADDRESS OF OPERATING SYSTEM
;

GETADDR:CALL	CALCADDR	;CALCULATE MEMORY SIZE
	LHLD	BUFFER		;COMPUTE ADDRESS OF OS
	MOV	A,D
	SUB	H
	MOV	H,A
	SHLD	OSADDR

;
;	COMPUTE LENGTH OF BIT MAP
;

	LHLD	BUFFER		;DIVIDE LENGTH BY 8 TO GET LENGTH OF BIT MAP
	MVI	B,3

GETA1:	MOV	A,H		;SHIFT LENGTH RIGHT 3 BITS
	ORA	A
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	DCR	B
	JNZ	GETA1		;IF SHIFT NOT COMPLETE
	XCHG
	LXI	H,BUFFER+2
	DAD	D
	SHLD	NEXTSRC		;INITIALIZE ADDRESS OF NEXT SOURCE BYTE OF OS
	RET

;
;	CALCADDR - CALCULATE MEMORY SIZE
;
;	EXIT	(DE) - LAST BYTE ADDRESS PLUS 1 OF AVAILABLE MEMORY
;

CALCADDR:LXI	H,0FFFFH

CALC1:	XRA	A
	MOV	M,A
	CMP	M
	JZ	CALC2		;IF POSSIBLE RAM
	DCX	H
	JMP	CALC1

CALC2:	CMA
	MOV	M,A
	CMP	M
	JZ	CALC3		;IF RAM
	DCX	H
	JMP	CALC1

CALC3:	MOV	D,H
	INR	D
	MVI	E,0
	RET

;
;	RELOC - RELOCATE OS IMAGE
;
;	RELOC READS BYTES FROM THE OS SOURCE IMAGE AND ADDS THE
;	RELOCATION BASE TO THOSE BYTES WHOSE CORRESPONDING BITS IN THE BIT MAP
;	ARE SET TO 1.
;

RELOC:	LXI	H,BUFFER+2	;INITIALIZE BIT MAP ADDRESS
	XCHG
	LHLD	OSADDR		;INITIALIZE DESTINATION ADDRESS
	SHLD	NEXTDEST

RELOC1:	MVI	B,8		;INITIALIZE COUNT OF BITS IN BYTE
	LDAX	D		;FETCH NEXT MAP ENTRY
	MOV	C,A
	PUSH	D

RELOC2:	PUSH	B
	CALL	NEXT		;READ NEXT BYTE OF IMAGE
	POP	B
	MOV	H,A
	MOV	A,C
	RRC
	MOV	C,A
	MVI	A,0
	JNC	RELOC3		;IF BYTE NOT RELOCATABLE
	LDA	OSADDR+1

RELOC3:	ADD	H
	LHLD	NEXTDEST	;STORE OBJECT BYTE
	MOV	M,A
	INX	H
	SHLD	NEXTDEST
	LHLD	BUFFER		;DECREMENT COUNT OF BYTES IN CLI
	DCX	H
	SHLD	BUFFER
	MOV	A,H
	ORA	L
	JZ	RELOC4		;IF RELOCATION COMPLETE
	DCR	B
	JNZ	RELOC2		;IF NOT END OF BITS IN BYTE
	POP	D
	INX	D
	JMP	RELOC1

RELOC4:	POP	D
	RET

OSADDR:DW	0		;ADDRESS OF CLI

NEXTSRC:DW	0		;ADDRESS OF NEXT SOURCE BYTE

NEXTDEST:DW	0		;NEXT ADDRESS TO STORE RELOCATED BYTE

;
;	NEXT - RETURN NEXT SOURCE BYTE
;
;	EXIT	(A) - NEXT SOURCE BYTE
;

NEXT:	LHLD	NEXTSRC
	MOV	A,M
	INX	H
	SHLD	NEXTSRC
	RET

BUFFER:	DS	0

	END
