;
;	SATELLITE MONITOR INSTALLATION DEPENDENT DEVICE DRIVERS
;
;	THIS MODULE CONTAINS DEVICE DRIVERS ACCESSED BY THE SATELLITE
;	MONITOR TO PERFORM INPUT AND OUTPUT FROM AND TO PERIPHERAL
;	DEVICES.  THIS MODULE IS DESIGNED TO BE RELOCATABLE AND IS
;	LOADED INTO A SATELLITE AT DEADSTART TIME.  THIS MODULE SHOULD
;	BE EXAMINED CLOSELY BY PERSONS WISHING TO MAKE MODIFICATONS.
;	THIS MODULE MUST BE ASSEMBLED TWICE;  ONCE ORIGINED AT 0H
;	AND ONCE AT 100H.  NEXT THE RESULTING HEX FILES MUST BE
;	RENAMED DRIVERS.000 AND DRIVERS.100 RESPECTIVELY.
;	THEN THE USER SHOULD TYPE 
;
;		BUILD DRIVERS
;
;	THIS SHOULD THEN BE MERGED WITH MONITOR.IMG TO PRODUCE A FILE CALLED
;	SATMTR.IMG.  THIS IS DONE BY TYPING
;
;		MERGE SATMTR MONITOR DRIVERS
;
;	SATMTR IS WHAT WILL BE LOADED INTO THE SATELLITE UPON DEADSTARTING IT.
;
;
;	K. E. JORDAN   6/9/79
;
;	ASSEMBLY CONSTANTS
;

TRUE	EQU	0FFFFH
FALSE	EQU	0
HAMP	EQU	FALSE
CDL	EQU	FALSE
TUART	EQU	NOT CDL


	ORG	000H
;
;	PORT CONSTANTS
;

CSP	EQU	0C0H		;CONSOLE STATUS PORT
CDP	EQU	CSP+1		;CONSOLE DATA PORT

;
;	DEVICE DRIVER ENTRY-POINT TABLE
;


;
;	CONSOLE STATUS DRIVERS
;

	JMP	CONS
	JMP	CONS
	JMP	CONS
	JMP	CONS

;
;	CONSOLE INPUT DRIVERS
;

	JMP	CONI
	JMP	CONI
	JMP	CONI
	JMP	CONI

;
;	CONSOLE OUTPUT DRIVERS
;

	JMP	CONO
	JMP	CONO
	JMP	CONO
	JMP	CONO

;
;	LIST OUTPUT DRIVERS
;

	JMP	0	;0 INDICATES COMMON SHARED LIST DEVICE
	JMP	CONO
	JMP	CONO
	JMP	CONO

;
;	PUNCH OUTPUT DRIVERS
;

	JMP	CONO
	JMP	CONO
	JMP	CONO
	JMP	CONO

;
;	READER INPUT DRIVERS
;

	JMP	CONI
	JMP	CONI
	JMP	CONI
	JMP	CONI

;
;	INITIALIZATION ROUTINE JUMP
;
	JMP	INIT	
			;INITIALIZE CONSOLE


;
;	CONS - CONSOLE STATUS DRIVER
;
;	EXIT -	A, 0FFH IF CONSOLE INPUT AVAILABLE

	IF	CDL
CONS:	IN	CSP
	ANI	20H	;IS CHARACTER READY
	RZ		;NO IT IS NOT
	MVI	A,0FFH	;YES IT IS
	RET
	ENDIF
	IF	TUART
CONS:	IN	CSP
	ANI	40H	;CHECK READY BIT
	RZ		;IF ANI GIVES US 0

	MVI	A,0FFH	;IF READY
	RET
	ENDIF

;
;	CONI - CONSOLE INPUT DRIVER
;
;	EXIT -	A, CHARACTER READ FROM CONSOLE
;

CONI:
	IF	CDL
	IN	CSP
	ANI	20H
	JZ	CONI
	IN	CSP+3
	IN	CSP+4
	ANI	7FH	;STRIP PARITY BITS
	RET
	ENDIF

	IF	TUART

	CALL	CONS		;CALL CONSOLE STATUS
	ORA	A
	JZ	CONI		;UNTIL CHARACTER IS READY
	IN	CDP		;GET DATA
	ANI	7FH		;CLEAR HIGH BIT (OPTIONAL)
	RET
	ENDIF

;
;	CONO - CONSOLE OUTPUT DRIVER
;
;	ENTRY -	C, CHARACTER TO OUTPUT
;

CONO:

	IF	CDL
	JMP	CGEN
	ENDIF

	IF	TUART
	IN	CSP
	ANI	80H		;CHECK TRANSMIT READY
	JZ	CONO		;LOOP UNTIL HIGH

	MOV	A,C
	OUT	CDP		;SEND IT OUT
	RET
	ENDIF

;
;
;	INIT THE HARDWARE
;
;
INIT:
	DI
	IF	CDL
	MVI	A,15H
	OUT	CSP+2
	MVI	A,0C0H		;76.5K BAUD RATE
	OUT	CSP			;INIT THE BAUD RATE TO THE HUB

;
;
;			THE USER IS WARNED THAT THIS MUST
;			ALSO BE DONE IN THE ROM BOOT TO TALK TO THE HUB
;			SO BE SURE THAT THIS INITIALIZATION DOES NOT
;			CONFLICT WITH THE HUB COMMUNICATIONS
;
;
	MVI	A,80H
	OUT	CSP+3
	ENDIF

	IF	TUART
	MVI	A,11H		;OCTUPLE THE CLOCK
	OUT	CSP+2
	MVI	A,090H		;BAUD RATE
	OUT	CSP		;90 IS 2400 BAUD BUT ITS OCTUPLED
	RET
;
;
;
;	CGEN IS MERGED WITH DRIVERS AND WILL END UP AT THE NEXT AVAILABLE 
;	PAGE IN MEMORY THE FOLLOING EQUATE WILL REFERENCE THE NEXT PAGE
;
;
CGEN	EQU	($+0FFH) AND 0FF00H
;
;
	END
