;
;	SATELLITE MONITOR DEADSTART PROCESSOR
;
;	THIS MODULE RESIDES IN PROM AND PROCESSES DEADSTART REQUESTS.
;	THIS MODULE ALSO CONTAINS SEVERAL COMMON ROUTINES USED BY THE
;	SATELLITE MONITOR TO COMMUNICATE WITH THE HUB.  
;
;	NOTE:  SOME OF THE ROUTINES IN THIS MODULE MAY BE INSTALLATION
;		DEPENDENT.  THESE ROUTINES ARE: HUBSTAT, BYTE$TO$HUB, BYTE$FROM$HUB
;
;	K. E. JORDAN  6/8/79
;	MODIFIED
;		8-DEC-80	RLH
;

;	IT IS THE RESPONSIBILITY OF THE DSTART ROUTINE TO PLACE
;	A JUMP TABLE AT LOCATION 40H 
;	THIS JUMP TABLE SHOULD HOLD 4 JUMPS AS FOLLOWS
;		JMP	DSTART
;		JMP	SEND
;		JMP	RECIEVE
;		JMP	HUBSTAT
;
;	THE SATELLITE MONITOR WILL REFERENCE THIS TABLE WHENEVER IS
;	WISHES TO ACCESS THESE ROUTINES.
;
;	THE SATCOLD.COM BOOT LOOKS AT LOCATION 40H TO DETERMINE
;	THE AMOUNT OF AVAILABLE RAM SO BE SURE THERE IS RAM
;	DIRECTLY BELOW THE DSTART.COM ROUTINE.  USE THE DSLOAD ROUTINE
;	TO LOAD THIS CODE INTO HIGH RAM FROM THE ROM.
;

;
;	RLH	APRIL 11, 1980
;

;
;	INSTALLATION VARIABLES
;

TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
HAMP	EQU	FALSE
TERC	EQU	NOT HAMP

;
;	ASSEMBLY CONSTANTS
;

DSBASE	EQU	100H		;BASE OF DEADSTART MODULE

;
;	TO USE THE PAGE RELOCATABLE UTILITIES THIS SHOULD BE SET
;	TO 0 THE TO 100H AND ASSEMBLED TWICE.  BUILD WILL PRODUCE A
;	DSTART.IMG AND DSLOAD WILL LOAD IT INTO RAM FOR YOU.
;

	IF	HAMP
	HSP	EQU	8		;HUB STATUS PORT
	HDP	EQU	10		;HUB DATA PORT
	TRNRDY	EQU	8		;TRANSMIT READY FLAG MASK
	RCVRDY	EQU	2		;RECEIVE READY FLAG MASK
	ENDIF
	IF	TERC
	HSP	EQU	000H
	HDP	EQU	001H
	TRNRDY	EQU	80H
	RCVRDY	EQU	40H
	ENDIF
ACK	EQU	6		;POSITIVE ACKNOWLEDGE CHARACTER
NAK	EQU	15H		;NEGATIVE ACKNOWLEDGE CHARACTER
SYN	EQU	16H		;SYNCHRONIZATION CHARACTER

;
;	COMMUNICATION CONSTANTS
;

RESETRQ	EQU	0
OPENRQ	EQU	15
READRQ	EQU	20
SETUIRQ	EQU	28

STACK	EQU	12*1024		;STACK BOTTOM IS AT 16K
LENGTH	EQU	11*1024		;OUTPUT BUFFER BEGINS AT 15K
REQUEST	EQU	LENGTH+1
PARAM	EQU	REQUEST+1
RECORD	EQU	PARAM+2

REPLY	EQU	RECORD+1	;INPUT BUFFER BEGINS AFTER OUTPUT BUFFER
STATUS	EQU	REPLY+1
DATA	EQU	STATUS+4
JTABD	EQU	40H		;DESTINATION OF JUMP TABLE
	ORG	DSBASE

;
;	DEADSTART PROCESSOR ENTRY POINTS
;

JMPTAB:				;START OF JUMP TABEL TO GO TO 40H
	JMP	DSTART		;DEADSTART ENTRY
	JMP	SEND		;SEND MESSAGE TO HUB
	JMP	RECEIVE		;RECEIVE MESSAGE FROM HUB
	JMP	HUBSTAT		;INTERROGATE HUB STATUS

JTABL	EQU	$-JMPTAB	;LENGTH OF JUMP TABLE

;
;	DSTART - DEADSTART PROCESSOR
;

DSTART:	DI			;DISABLE THOSE INTERRUPTS NOW
	LXI	SP,STACK
	CALL	MOVJTAB		;MOVE JUMP TABLE
	CALL	PRESET		;PRESET DEADSTART SEQUENCE
	CALL	LOAD		;LOAD SATELLITE MONITOR
	JMP	100H

;
;	MOVJTAB-	MOVE JUMP TABLE TO 40H
;
MOVJTAB:
	LXI	H,JMPTAB		;START OF JUMP TABLE
	MVI	B,JTABL			;JUMP TABLE LENGTH
	LXI	D,JTABD			;JUMP TABLE DESTINATION
MVJ1:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MVJ1			;LOOP TILL WHOLE TABLE MOVED
	RET
;
;	LOAD - LOAD SATELLITE DEADSTART LOADER
;

LOAD:	CALL	OPEN		;OPEN LOADER FILE
	ORA	A

LOAD1:	JNZ	LOAD1		;IF LOADER NOT FOUND, HANG

;
;	INITIALIZE TO LOAD LOADER
;

	MVI	A,4		;INITIALIZE LENGTH OF MESSAGE TO READ RECORD
	STA	LENGTH
	MVI	A,READRQ		;SET REQUEST
	STA	REQUEST
	LXI	H,LDRFCB	;SET FCB ADDRESS
	SHLD	PARAM
	XRA	A		;INITIALIZE RECORD
	STA	RECORD
	LXI	D,100H		;PRESET DMA ADDRESS

LOAD2:	PUSH	D

LOAD3:	LXI	H,LENGTH	;SEND REQUEST TO READ RECORD
	CALL	SEND
	ORA	A
	JNZ	LOAD3		;IF ERROR IN TRANSMISSION
	LXI	H,REPLY		;RECEIVE RECORD
	CALL	RECEIVE
	ORA	A
	JNZ	LOAD3		;IF ERROR IN TRANSMISSION
	POP	D
	LDA	STATUS
	ORA	A
	RNZ			;IF END OF FILE
	LXI	H,DATA		;COPY RECORD TO DMA ADDRESS
	MVI	B,128

LOAD4:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	LOAD4		;IF COPY NOT COMPLETE
	LXI	H,RECORD	;INCREMENT NEXT RECORD
	MOV	A,M
	INR	A
	ANI	7FH
	MOV	M,A
	JMP	LOAD2		;LOAD NEXT RECORD

;
;	OPEN - OPEN OVERLAY FILE
;

OPEN:	LXI	H,FCBBUF	;SEND OPEN REQUEST TO HUB
	CALL	SEND
	ORA	A
	JNZ	OPEN		;IF TRANSMISSION ERROR
	LXI	H,REPLY		;RECEIVE STATUS
	CALL	RECEIVE
	ORA	A
	JNZ	OPEN		;IF TRANSMISSION ERROR
	LDA	STATUS
	RET

;
;	FILE CONTROL BLOCK FOR DEADSTART LOADER
;

FCBBUF:	DB	FCBLEN		;LENGTH OF MESSAGE
	DB	OPENRQ		;REQUEST
	DW	LDRFCB		;PARAMETER (FCB ADDRESS)
	DB	0		;RECORD

LDRFCB:	DB	0
	DB	'SATCOLD COM'
	DB	0,0,0,0

FCBLEN	EQU	$-(FCBBUF+1)

;
;	PRESET - PRESET DEADSTART SEQUENCE
;

PRESET:	CALL	INITHDW		;INITIALIZE HUB COMMUNICATION HARDWARE
	LXI	H,RESET		;SEND RESET REQUEST TO HUB
	CALL	SEND
	ORA	A
	JNZ	PRESET		;IF ERROR IN TRANSMISSION
	LXI	H,SETUI		;SET USER INDEX TO 0
	CALL	SEND
	ORA	A
	JNZ	PRESET		;IF TRANSMISSION ERROR
	RET

RESET:	DB	1
	DB	RESETRQ

SETUI:	DB	3
	DB	SETUIRQ
	DW	0

;
;	INITHDW - INITIALIZE HUB COMMUNICATION HARDWARE
;

INITHDW:IF	TERC
	MVI	A,15H		;1 FOR RESET, 10H FOR HIGH BAUD
;				;4 FOR PI/17 INTERUPT FOR KEYBOARD
	OUT	HSP+2
				;THE C0 IS FOR 9600 BAUD *8
	MVI	A,0C0H
	OUT	HSP
	MVI	A,80H		;ENABEL HIGH BIT FOR KEYBOARD
	OUT	HSP+3		;THIS IS REPEATED IN DRIVERS
	ENDIF
	RET

;
;	SEND - SEND MESSAGE TO HUB
;
;	SEND SENDS AND VERIFIES RECEIPT OF A MESSAGE.
;
;	ENTRY	(HL) - ADDRESS OF MESSAGE
;
;	EXIT	(A) - 0 IF MESSAGE SENT SUCCESSFULLY
;		      0FFH OTHERWISE
;
;	CALLS	SNDSYN, BYTE$TO$HUB, BYTE$FROM$HUB
;

SEND:	PUSH	H		;SAVE ADDRESS OF MESSAGE (IN CASE RETRY NECESSARY)
	CALL	SNDSYN		;SYNCHRONIZE
	MOV	B,M		;FETCH MESSAGE LENGTH
	MOV	D,B		;PRESET CHECKSUM
	INX	H
	MOV	C,B		;SEND LENGTH BYTE
	CALL	BYTE$TO$HUB
	JC	SEND2		;IF TRANSMISSION ERROR

SEND1:	MOV	A,M		;FETCH NEXT BYTE
	MOV	C,A
	ADD	D		;UPDATE CHECKSUM
	MOV	D,A
	CALL	BYTE$TO$HUB	;SEND DATA BYTE
	JC	SEND2		;IF TRANSMISSION ERROR
	INX	H
	DCR	B
	JNZ	SEND1		;IF MESSAGE NOT COMPLETELY SENT

;
;	SEND CHECKSUM
;

	MOV	A,D		;NEGATE CUMULATIVE SUM
	CMA
	INR	A
	MOV	C,A
	CALL	BYTE$TO$HUB
	JC	SEND2		;IF TRANSMISSION ERROR

;
;	RECEIVE ACKNOWLEDGEMENT
;

	CALL	BYTE$FROM$HUB	;RECEIVE ACKNOWLEDGE CHARACTER
	JC	SEND2		;IF TRANSMISSION ERROR
	POP	H
	CPI	ACK
	JNZ	SEND		;IF NOT POSITIVE ACKNOWLEDGE
	XRA	A
	RET

;
;	PROCESS TRANSMISSION ERROR
;

SEND2:	POP	H
	JMP	SEND		;RETRY UNTIL SUCCESSFUL TRANSMISSION

;
;	RECEIVE - RECEIVE MESSAGE
;
;	RECEIVE RECEIVES A MESSAGE FROM THE HUB AND INSURES ITS INTEGRITY.
;
;	ENTRY	(HL) - ADDRESS OF MESSAGE BUFFER
;
;	EXIT	(A) - 0 IF MESSAGE RECEIVED SUCCESSFULLY
;		      0FFH OTHERWISE
;
;	CALLS	RCVSYN, BYTE$FROM$HUB, BYTE$TO$HUB
;

RECEIVE:MVI	A,10		;INITIALIZE RETRY COUNT
	STA	RETRY		;RLH 12-8-80

RECEIV1:PUSH	H		;SAVE BUFFER ADDRESS (IN CASE RETRY NECESSARY)
	CALL	RCVSYN		;SYNCHRONIZE
	JC	RECEIV4		;IF SYNCHRONIZATION ERROR
	CALL	BYTE$FROM$HUB	;RECEIVE LENGTH BYTE
	JC	RECEIV4		;IF TRANSMISSION ERROR
	MOV	M,A
	MOV	B,A
	MOV	D,A		;INITIALIZE CHECKSUM
	INX	H

;
;	RECEIVE MESSAGE BODY
;

RECEIV2:CALL	BYTE$FROM$HUB	;RECEIVE NEXT DATA BYTE
	JC	RECEIV4		;IF TRANSMISSION ERROR
	MOV	M,A
	INX	H
	ADD	D		;UPDATE CHECKSUM
	MOV	D,A
	DCR	B
	JNZ	RECEIV2		;IF MESSAGE NOT COMPLETELY RECEIVED

;
;	RECEIVE CHECKSUM
;

	CALL	BYTE$FROM$HUB
	JC	RECEIV4		;IF TRANSMISSION ERROR
	ADD	D
	JNZ	RECEIV3		;IF CHECKSUM DOES NOT JIVE
	MVI	C,ACK		;ACKNOWLEDGE SUCCESSFUL RECEIPT
	CALL	BYTE$TO$HUB
	POP	H
	XRA	A		;CLEAR A TO INDICATE SUCCESS
	RET

;
;	NEGATIVELY ACKNOWLEDGE RECEIPT OF MESSAGE
;

RECEIV3:MVI	C,NAK
	CALL	BYTE$TO$HUB
	POP	H

	LDA	RETRY
	DCR	A		;DECREMENT RETRY COUNT
	STA	RETRY		;RLH 12-8-80

	JNZ	RECEIV1		;IF RETRY NOT EXHAUSTED
	MVI	A,0FFH
	RET

;
;	PROCESS IRRECOVERABLE ERROR
;

RECEIV4:POP	H
	MVI	A,0FFH
	RET
RETRY:	DB	0		;TRANSMISSION RETRY RLH 12-8-80

;
;	HUBSTAT - INTERROGATE HUB STATUS
;
;	EXIT	(A) - 0 IF NO MESSAGE AVAILABLE FROM HUB
;		      0FFH OTHERWISE
;

HUBSTAT:IN	HSP		;READ STATUS PORT
	ANI	RCVRDY
	MVI	A,0
	RZ			;IF NO MESSAGE AVAILABLE
	DCR	A
	RET

;
;	SNDSYN - SEND SYNCHRONIZATION CHARACTER TO HUB
;

SNDSYN:	MVI	C,SYN
	CALL	BYTE$TO$HUB
	JC	SNDSYN		;IF TRANMISSION ERROR

SNDSYN1:CALL	BYTE$FROM$HUB	;WAIT FOR HUB ACKNOWLEDGEMENT
	JC	SNDSYN1		;IF NO ACKNOWLEDGEMENT BEFORE TIME OUT
	CPI	SYN
	JNZ	SNDSYN		;IF NOT SYNCHRONIZED
	RET

;
;	RCVSYN - RECEIVE SYNCHRONIZATION CHARACTER FROM HUB
;
;	EXIT	(CARRY) - SET IF SYNCHRONIZATION ERROR
;

RCVSYN:	CALL	BYTE$FROM$HUB
	JC	RCVSYN		;IF TIME OUT
	CPI	SYN
	JNZ	RCVSYN1		;IF NOT SYNCHRONIZATION CHARACTER
	MVI	C,SYN		;ACKNOWLEDGE SYNCHRONIZATION
	CALL	BYTE$TO$HUB
	RET

RCVSYN1:STC
	RET

;
;	BYTE$TO$HUB - TRANSMIT A BYTE TO THE HUB
;
;	ENTRY	(C) - BYTE TO TRANSMIT
;
;	EXIT	(CARRY) - SET IF TIME OUT
;
;	USES	A, E (ONLY THESE REGISTERS MAY BE USED)
;

BYTE$TO$HUB:
	MVI	E,0		;INITIALIZE TIME

BTH1:	IN	HSP		;READ STATUS PORT
	ANI	TRNRDY
	JZ	BTH2		;IF TRANSMITTER NOT READY
	MOV	A,C		;TRANSMIT CHARACTER
	OUT	HDP
	RET

BTH2:	DCR	E		;DECREMENT CLOCK
	JNZ	BTH1		;IF TIME NOT OUT
	STC
	RET

;
;	BYTE$FROM$HUB - RECEIVE A BYTE FROM THE HUB
;
;	EXIT	(A) - BYTE FROM HUB, IF ONE IS RECEIVED
;		(CARRY) - SET IF NO BYTE RECEIVED BEFORE TIME OUT
;
;	USES	A, E (ONLY THESE REGISTERS MAY BE USED)
;

BYTE$FROM$HUB:
	MVI	E,0		;INITIALIZE TIME

BFH1:	IN	HSP		;READ STATUS PORT
	ANI	RCVRDY
	JZ	BFH2		;IF RECEIVER NOT ENABLED
	IN	HDP
	RET

BFH2:	DCR	E
	JNZ	BFH1		;IF TIME NOT OUT
	STC
	RET

	END
