/****************************************************************************

	Return command token function
 Searches "cmd" structure for command & returns token in structure.
	entry-	ops= structure of text commands & tokens
		prompt=	asciiz text for prompt
		cptr= ptr to ptr to buffer to place text. This allows
			modification of ptr for caller to continue
			command argument evaluation.
	exit -	int:	value of token from table equal to command

*****************************************************************************
Revision History:
	11-22-92   grh
	Update to current form.

****************************************************************************/
#include mylib.h

int 
get_cmd( ops, prompt, cptr )
	struct cmd
		ops[];
	char
		*prompt,
		**cptr;		/* ptr to ptr */ 
{

   register unsigned 
	i;		/* counter */
   char	
	*cp;		/* ptr to text */


/* Display prompt */
   printf( "\n%s: ", prompt );

/* Get user option */
   cp = gets( *cptr );
   crlf();

/* Convert to upper case */
   for( ; *cp != '\0'; cp++ )   *cp = toupper( *cp );

/* Reset to beginning of text */
   cp = *cptr;

/* Search for command */
   for( i = 0; *( ops[i].key ) != '\0'; i++ ) {
      if( strncmp( cp, ops[i].key, strlen( ops[i].key ) ) == 0 )   break;
      }

/* Pre-position to possible argument */
   *cptr = skip_c( cp, ' ' );

/* Return token */
   return ops[i].token;
   }
