/* mylib.h
**************************************************************************
/
/	MYLIB.LIB header file
/
***************************************************************************
/ Revision History:
/
/ 0.00	10-28-92   grh
/	Initial cut.
/
/ 1.00	10-29-92   grh
/	Add cdb & farcall defs.
/
/ 1.01	11-22-92   grh
/	Add templates.
/
/ 1.02	11-26-92   grh
/	Add NxtField() template
/
/ 1.03	3-19-95   grh
/	Update style. No functional changes.
/
**************************************************************************/
#ifndef BYTE
#include mydefs.h
#endif


/****************************************************************************
/
/	Command interpreter structure
/
****************************************************************************/
struct	cmd {
   char	
	*key;	/* Text ptr */
   unsigned
	token;	/* Return token */
   };


/****************************************************************************
/
/	farcall structure definition
/
****************************************************************************/
struct regs {
   unsigned short	
	AF,BC,DE,HL,IX,IY,AFP,BCP,DEP,HLP;
   };


/****************************************************************************
/
/	IOPB structures
/
****************************************************************************/
struct iopb {
/*
/	Arguments
*/
   BYTE	pb_cmd;		/* command */
   BYTE	pb_drv;		/* drive */
   WORD	pb_trk;		/* track */
   WORD	pb_sec;		/* sector */
   BYTE	pb_flg;		/* flags */
   WORD	pb_dma;		/* Unused dma address */
   BYTE	pb_dmax;	/* Unused dma extended address */
/*
/	Argument in, Return value out
*/
   WORD	pb_bcnt; 	/* Xfer count */
/*
/	Return values
*/
   BYTE	pb_stat; 	/* Command result status */
   BYTE	pb_st1;		/* fdc status if pb_mod == 0x1f */
   BYTE	pb_st2;		/* returned value #1 */
   BYTE	pb_st3;		/* returned value #2 */
   } ;
/*
/	Commands 
*/
#define	PB_LOGC		0	/* Log on drive */
#define	PB_READC	1	/* Read sector */
#define	PB_WRITC	2	/* Write sector */
#define	PB_FRMTC	3	/* Format track */
#define	PB_RADDC	4	/* Read address */
#define	PB_RDTC		5	/* Read track */
#define	PB_VERSC	8	/* Return firmware version */
#define	PB_XDTAC	9	/* Get/set additional disk data */
#define	PB_LHIC		10	/* Load head */
#define	PB_SEEKC	11	/* Seek track */
#define PB_XCDB		13	/* Execute SCSI CDB */
#define	PB_CLRC		15	/* Clear controller/drive */
/*
/	pb_ffg values
*/
#define	PB_FNSK 0x01	/* Inhibit implied seek flag */
#define	PB_FMTD	0x20	/* Format drive option */
#define PB_INHX	0x40	/* Inhibit data xfer to host flag */
#define	PB_FNRB	0x80	/* Inhibit retries flag */


/****************************************************************************
/
/	Function Templates
/
****************************************************************************/

void
	dmp_iopb (),
	buff_ops ();

BYTE
	exe_iopb ();

WORD
	get_n_args ();

char
	*NxtField (),
	*skip_c ();

int
	farcall (),
	get_cmd (),
	query_u (),
	writhex (),
	readhex ();

unsigned int
	atoh ();
