/****************************************************************************

	Intel (tm) Hex format file loader library module

	This module supports the loading of Intel-Hex files into a buffer
location.

*****************************************************************************

	Known bugs:



*****************************************************************************

	Revisions:

1.00 -	3-7-92   grh
	1st cut.
	11-24-92   grh
	Correct bug not returning anything (garbage) if successful.


****************************************************************************/

#include stdio.h
#include ctype.h
#include mydefs.h

static BYTE
	chksum,		/* Hex record checksum */
	*ld_ptr;	/* Hex record load ptr */


/****************************************************************************

	Load Hex file function
	entry -	infile= stream
		bptr= ptr to start of buffer
		btop= ptr to last byte of buffer (limit check)
	exit -	0= ok
		EOF= Premature End-of-file occured
		-1= Error

****************************************************************************/
int 
readhex( infile, bptr, btop )   
	FILE 
		*infile;   
	BYTE 
		*bptr, 
		*btop; 
{

   register int
	c;
   static BYTE
	rec_len;	/* Hex record length */
   static WORD
	ld_addr,	/* Hex record load address */
	hex_base;	/* Hex file base load address (1st record ld addr) */


/* Start by waiting for record */
   c = scan_rec( infile );

/* If EOF then error */
   if( c == EOF ) {
      phex_err( "**** File Empty! ****" );
      return EOF;
      }

/* Init for record */
   chksum = 0;

/* Process record length */
   if( ( c = getbyte( infile ) ) == EOF )   return EOF;
   if( c == 0 )   return 0;		/* done if length == 0 */
   rec_len = c;

/* Fetch load address */
   if( ( c = getbyte( infile ) ) == EOF )   return EOF;
   ld_addr = c;
   ld_addr = ld_addr << 8;
   if( ( c = getbyte( infile ) ) == EOF )   return EOF;
   ld_addr += c;

/* Init load address */
   hex_base = ld_addr;	/* set base offset ptr */
   ld_ptr = bptr;

/* Test for limit */
   if( &ld_ptr[ rec_len ] > btop ) {
      phex_err( "File Too Large!" );
      return -1;
      }

/* If record type != 0 then error */
   if( ( c = getbyte( infile ) ) == EOF )   return EOF;
   if( c != 0 ) {
      phex_err( "" );   printf( "Unsupported record type : %2xH", c );
      return -1;
      }

   while( rec_len > 0 ) {
      if( ( c = getbyte( infile ) ) == EOF )   return EOF;
      *ld_ptr++ = c;
      --rec_len;
      }

/* Check checksum */
   if( ( c = getbyte( infile ) ) == EOF )   return EOF;
   if( chksum != 0 ) {
      phex_err( "File Checksum Error!" );
      return -1;
      }

/* Do next record(s) */
   while( TRUE ) {
      c = scan_rec( infile );		/* fetch char */

/**** If EOF then error */
      if( c == EOF )   return EOF;

/**** Init for record */
      chksum = 0;

/**** Process record length */
      if( ( c = getbyte( infile ) ) == EOF )   return EOF;
      if( c == 0 )   return 0;		/* done if length == 0 */
      rec_len = c;

/**** Fetch load address */
      if( ( c = getbyte( infile ) ) == EOF )   return EOF;
      ld_addr = c;
      ld_addr = ld_addr << 8;
      if( ( c = getbyte( infile ) ) == EOF )   return EOF;
      ld_addr += c;

/**** If this record's load addr < 1st record's then error */
      if( ld_addr < hex_base ) {
         phex_err( "" );   printf( "\n\
Load Address: %4x is Below Base Address: %4x",
	     ld_addr, 			hex_base );
         return -1;
         }

/**** Set load ptr */
      ld_ptr = &bptr[ ld_addr - hex_base ];

/**** If this record's load addr + count > buffer top then error */
      if( &ld_ptr[ rec_len ] > btop ) {
         phex_err( "File Too Large for buffer!" );
         return -1;
         }
      if( ld_ptr < bptr )  {
	 phex_err( "\
File's Record Load Address Below First Record Load Address!" );
	 return -1;
	 }

/**** If record type != 0 then error */
      if( ( c = getbyte( infile ) ) == EOF )   return EOF;
      if( c != 0 ) {
         phex_err( "" );   printf( "Unsupported record type : %2xH", c );
         return -1;
         }

      while( rec_len-- > 0 ) {
         if( ( c = getbyte( infile ) ) == EOF )   return EOF;
         *ld_ptr++ = c;
         }

/**** Check checksum */
      if( ( c = getbyte( infile ) ) == EOF )   return EOF;
      if( chksum != 0 ) {
         phex_err( "File Checksum Error!" );
         return -1;
         }
      }

/* Return Ok */
   return 0;
   }


/****************************************************************************

	Print Hex File error message function
	entry-	ptr to message

****************************************************************************/
phex_err( mp )   
	char 
		*mp; 
{

   printf( "\nHex File Error - %s", mp );
   }


/****************************************************************************

	Scan hex file for "\n:" function
This function allows comments in Intel-Hex files to be ignored
	entry-	if=	file stream
	exit -	int= 	':': "\n:" found
		     	EOF: End-Of-File encountered before valid record

****************************************************************************/
static int 
scan_rec( inf )   
	FILE 
		*inf; 
{

   static char
	lastch;		/* Last char received */
   register int
	c;		/* Current char */

   lastch = '\n';	/* Assume start of file */
   while( TRUE ) {
      if( ( c = getc( inf ) ) == EOF )   return EOF;
      if( c == ':' && lastch == '\n' )   return c;
      else   lastch = c;
      }
   }


/****************************************************************************

	get byte from file function
	entry-	inf= file stream
	exit -	binary BYTE of next two ascii chars of stream
		EOF

****************************************************************************/
static int 
getbyte( inf )   
	FILE 
		*inf; 
{

   register int
	acc,
	c;

/* If file empty then unexpected */
   c = agetc( inf );
   if( c == EOF ) {
      phex_err( "Premature EOF!" );
      return c;
      }

/* if invalid hex digit then return EOF */
   if( ( acc = atohex( c ) ) == -1 )   return EOF;

/* else if next digit not in file then error */
   acc = acc << 4;
   c = agetc( inf );
   if( c == EOF ) {
      phex_err( "Premature EOF!" );
      return c;
      }

/* if second digit not valid then unexpected */
   if( ( acc += atohex( c ) ) == -1 )    return EOF;

/* add to checksum */
   chksum += acc;

/* return value */
   return acc;
   }


/****************************************************************************

	Convert ASCII char to hex number
	entry-	c= ascii-hex character
   	exit -	converted nibble value or
		-1= invalid hex digit

****************************************************************************/
static int 
atohex( c )   
	char 
		c; 
{

   c = toupper( c );
   if( isdigit( c ) || ( c >= 'A' && c <= 'F' ) ) {
      return  ( c > '9' ) ? ( c - '7' ) : ( c - '0' );
      }
   else   return -1;
   }
