	TITLE	'CBIOS222, Copyright Aug. 13, 1980, ALTOS COMPUTER SYSTEMS'
;-----------------------------------------------------------------------
;
;
;	ALTOS COMPUTER SYSTEMS
;	2360 BERING DRIVE
;	SAN JOSE, CALIFORNIA 95131
;
;	(408) 946-6700
;
;
;	Copyright 1980, ALTOS COMPUTER SYSTEMS
;
;	This program is a copyright program product of 
;	ALTOS COMPUTER SYSTEMS and is distributed to the
;	owners of ALTOS SUN SERIES 8000 computers for
;	use on those systems only. Any other use of this
;	software constitutes a breach of the copyright
;	license to the purchaser.
;
;	VERSION NUMBER: 2.22
;	VERSION DATE:	Aug. 11, 1980
;	.	Add support for CP/M version 2.0
;	.	Add support for Hard disk drives
;	.	Add support for disk MODE selection
;	.	Provide compatability MODE for 1.4 operation
;	.	Remove CTC/1791 counter reset
;	.	Add logic to recover from sleeping 1791
;	.	Improve interrupt handling to recover from unexpected interrupts
;	.	Allow warm boot from E:
;
;-----------------------------------------------------------------------

;-----------------------------------------------------------------------
;
;	Mode	0	IBM single density
;		1	ALTOS double density Version 2.0
;		2	ALTOS double density Version 1.4
;		3	ALTOS hard disk Version 2.0 (8 MEG AT 000)
;		4	ALTOS HARD DISK VERSION 2.0 (8 MEG AT 512)
;		5	ALTOS HARD DISK VERSION 2.0 (8 MEG AT 1024)
;		6	ALTOS HARD DISK VERSION 2.0 (4 MEG AT 512)
;
;-----------------------------------------------------------------------

;-----------------------------------------------------------------------
;
;	ASSEMBLER CONTROL STATEMENTS
;
;-----------------------------------------------------------------------

	MACLIB	DISKDEF
	MACLIB	Z80S

VERSION	EQU	22		;CP/M VERSION NUMBER
ALTOSV	EQU	2		;ALTOS CBIOS VERSION NUMBER
TRUE	EQU	0FFFFH		;VALUE FOR TRUE
FALSE	EQU	NOT TRUE	;VALUE FOR FALSE

;-----------------------------------------------------------------------
;
;	THE FOLLOWING EQUATES ARE USER MODIFIABLE BASED ON THE
;	PARTICULAR USER SYSTEM AND OPTIONS SELECTED.
;
;-----------------------------------------------------------------------

MSIZE	EQU	32		;MEMORY SIZE 
DMA	EQU	TRUE		;DMA HARDWARE SUPPORT ??
HARDSK	EQU	TRUE		;HARD DISK SUPPORT

;-----------------------------------------------------------------------
;
;	THE FOLLOWING CONSTANTS APPLY TO THE DEBLOCKING OF
;	SECTORS LARGER THAN 128 FOR THE ALTOS DOUBLE DENSITY
;	AND THE ALTOS HARD DISK.
;
;-----------------------------------------------------------------------

BLKSIZ	EQU	16384		;CP/M ALLOCATION SIZE
HSTSIZ	EQU	1024		;HOST DISK SECTOR SIZE
HSTSPT	EQU	16		;HOST DISK SECTORS PER TRACK
HSTBLK	EQU	HSTSIZ/128	;CP/M SECTORS PER HOST BUFFER
CPMSPT	EQU	HSTBLK * HSTSPT ;CP/M SECTORS PER TRACK
SECMSK	EQU	HSTBLK - 1	;SECTOR MASK
SECSHF	EQU	3		;LOG2(HHSTBLK)

	PAGE
;-----------------------------------------------------------------------
;
;	THE FOLLOWING EQUATES APPLY TO THE RELOCATABILITY
;	OF THE CBIOS AND SHOULD NOT BE USER ALTERED.
;
;-----------------------------------------------------------------------

RELOC	EQU	FALSE		;RELOCATABLE VERSION ??

;-----------------------------------------------------------------------

	IF	HARDSK
MAXDSK	EQU	12		;MAXIMUM NUMBER OF LOGICAL DRIVES
OFFST	EQU	2800H		;CCP OFFSET FROM TOP OF MEMORY
	ENDIF
	IF	NOT HARDSK
MAXDSK	EQU	4		;MAXIMUM NUMBER OF LOGICAL DRIVES
OFFST	EQU	2000H		;CCP OFFSET FOR FLOPPY ONLY SYSTEM
	ENDIF

	IF	RELOC
BIAS	EQU	0100H		;VALUE FOR RELOCATABLE ASSEMBLY
	ENDIF
	IF	NOT RELOC
BIAS	EQU	(MSIZE*1024)-OFFST ;VALUE FOR ABSOLUTE ASSEMBLY
	ENDIF

;-----------------------------------------------------------------------

CCP	EQU	000H+BIAS	;BASE OF CCP
BDOS	EQU	CCP+0806H	;BASE OF BDOS (RESIDENT PORTION)
BIOS	EQU	CCP+1600H	;BASE OF BIOS
BDPTCH1	EQU	CCP+0144CH	;TEMPORARY PATCH TO BDOS
BDPTCH2	EQU	CCP+0149AH	;TEMPORARY PATCH TO BDOS

	ORG	BIOS		;ORIGIN OF THIS PROGRAM

NSECTS	EQU	($-CCP)/128	;WARM START SECTOR COUNT

IOBYTE	EQU	003H		;LOCATION OF INTEL IOBYTE
CDISK	EQU	004H		;LOCATION OF CURRENT DRIVE NUMBER

WRALL	EQU	0		;WRITE TO ALLOCATED
WRDIR	EQU	1		;WRITE TO DIRECTORY
WRUAL	EQU	2		;WRITE TO UNALLOCATED

	PAGE
;-----------------------------------------------------------------------
;
;	JUMP VECTORS FOR ENTRIES TO CBIOS ROUTINES
;
;-----------------------------------------------------------------------

        JMP     BOOT    	;COLD START
WBOTE:  JMP     WBOOT   	;WARM BOOT ENTRY POINT
        JMP     CONST   	;CONSOLE STATUS
        JMP     CONIN   	;CONSOLE CHARACTER IN
        JMP     CONOUT  	;CONSOLE CHARACTER OUT
        JMP     LIST    	;PRINTER OUT
        JMP     CONOUT  	;PUNCH DEVICE
        JMP     CONIN   	;READER DEVICE
        JMP     HOMEIT    	;MOVE HEAD TO HOME POSITION
        JMP     SELDSK  	;SELECT DISK
        JMP     SETTRK  	;SET TRACK #  (0-76)
        JMP     SETSEC  	;SET SECT #   (1-26)
        JMP     SETDMA  	;SET DMA ADDRESS
        JMP     READ    	;READ ONE SECTOR FROM DISK
        JMP     WRITE   	;WRITE ONE SECTOR TO DISK
	JMP	PRSTAT		;CHECK PRINTER STATUS FOR DESPOOL
	JMP	SECTRAN		;ROUTINE TO TRANSLATE SECTOR NUMBER
	JMP	SETMOD		;ROUTINE TO SET DISK MODE
	JMP	RETMOD		;ROUTINE TO RETURN CURRENT MODE
	
;-----------------------------------------------------------------------
;
;	POINTERS FOR KLH SPOOLER PROGRAM PRODUCT
;
;-----------------------------------------------------------------------

SPOOLER:
	DB	0FFH		;TELLS SPOOLER LIST FOLLOWS
	DW	LSTBSY		;PRINTER BUSY TESTS
	DW	LSTBSY		;
	DW	LSTBSY		;
	DW	LSTBSY		;

	PAGE
;-----------------------------------------------------------------------
;
;	WORK AND CONTROL AREAS FOR CBIOS SERVICES
;
;-----------------------------------------------------------------------

TRK0:	DB	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
SEL0:	DB	004H,008H,010H,020H,010H,010H,010H,020H,020H,020H,010H,020H
MODE:	DB	000H,000H,000H,000H,003H,004H,005H,003H,004H,005H,006H,006H
TCNT:	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
PCNT:	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H    

DISKNO:	DB	000H				;CURRENT DRIVE NUMBER
TRAKNO:	DB	000H				;CURRENT TRACK NUMBER
HEADNO:	DB	000H				;CURRENT HEAD NUMBER
DMAADR:	DW	000H				;CURRENT DMA ADDRESS
SECTNO:	DB	000H				;CURRENT SECTOR NUMBER
DPEPTR:	DW	000H				;CURRENT DPE ADDRESS
DBLKAD:	DW	000H				;CURRENT EXTENSION ADDRESS
MPARMS:	DW	000H				;MISC. PARAMETERS
HTK1:	DB	10H				;HARD DISK  # 1  TRACK
HTK2:	DB	20H				;HARD DISK  # 2  TRACK
;
;	PARAMETER FLAGS
;
;	0100H = DOUBLE HEADED DRIVES
;	0200H = CENTRONICS PRINTER FOR LIST DEVICE
;	0400H = FOUR DRIVE SYSTEM  [ A B C D ]
;	0800H = WARM BOOT FROM DRIVE E:
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;
;	NOTE:
;	NO CHANGES ARE TO BE MADE TO THE ABSOLUTE LOCATIONS OF
;	ANY FIELDS PRIOR TO THIS POINT. EXTERNAL PROGRAMS ARE
;	DEPENDENT UPON THE LOCATION OF THE PRECEEDING DATA.
;
;-----------------------------------------------------------------------

	IF	NOT DMA
NMIRTN:	DB	0EDH,0A2H,0EDH,045H		;FAKE INI AND RETN INST
	ENDIF

DMAS1:	DB	0C3H,07DH			;FIRST PART OF DMA SETUP
DMASA:	DW	000H				;ADDRESS FOR I/O
DMALEN:	DW	1025-1				;LENGTH FOR I/O

DMAS2H:	DB	054H,0CEH,068H,0CEH,0A5H,020H	;HARD DISK SETUP

DMAS2F:	DB	014H,028H,085H,007H		;FLOPPY DISK SETUP

DMAS3:	DB	08AH,0CFH,001H,0CFH		;LAST PART OF DMA SETUP
DMAS3F:	DB	001H				;001=READ, 005=WRITE
	DB	0CFH,087H			;SETUP DMA, ENABLE

	PAGE
;-----------------------------------------------------------------------
;
;	CONTROL BLOCKS FOR DISK DRIVER
;
;-----------------------------------------------------------------------

NDISKS	EQU	12		;NUMBER OF LOGICAL DISK DRIVES

DPBASE	EQU	$		;START OF DISK PARAMETER BLOCKS

DPE0:	DW	XLT0,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB0	;DIR BUFF, PARM BLOCK
	DW	CSV0,ALV0	;CHECK VECTOR, ALLOC VECTOR

DPE1:	DW	XLT0,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB0	;DIR BUFF, PARM BLOCK
	DW	CSV1,ALV1	;CHECK VECTOR, ALLOC VECTOR

DPE2:	DW	XLT0,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB0	;DIR BUFF, PARM BLOCK
	DW	CSV2,ALV2	;CHECK VECTOR, ALLOC VECTOR

DPE3:	DW	XLT0,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB0	;DIR BUFF, PARM BLOCK
	DW	CSV3,ALV3	;CHECK VECTOR, ALLOC VECTOR

	IF	HARDSK

DPE4:	DW	0000H,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB3	;DIR BUFF, PARM BLOCK
	DW	CSV4,ALV4	;CHECK VECTOR, ALLOC VECTOR

DPE5:	DW	0000H,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB4	;DIR BUFF, PARM BLOCK
	DW	CSV5,ALV5	;CHECK VECTOR, ALLOC VECTOR

DPE6:	DW	0000H,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB5	;DIR BUFF, PARM BLOCK
	DW	CSV6,ALV6	;CHECK VECTOR, ALLOC VECTOR

DPE7:	DW	0000H,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB3	;DIR BUFF, PARM BLOCK
	DW	CSV7,ALV7	;CHECK VECTOR, ALLOC VECTOR

DPE8:	DW	0000H,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB4	;DIR BUFF, PARM BLOCK
	DW	CSV8,ALV8	;CHECK VECTOR, ALLOC VECTOR

DPE9:	DW	0000H,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB5	;DIR BUFF, PARM BLOCK
	DW	CSV9,ALV9	;CHECK VECTOR, ALLOC VECTOR

DPEA:	DW	0000H,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB6	;DIR BUFF, PARM BLOCK
	DW	CSVA,ALVA	;CHECK VECTOR, ALLOC VECTOR

DPEB:	DW	0000H,0000H	;TRANSLATE TABLE AND WORK AREA
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB6	;DIR BUFF, PARM BLOCK
	DW	CSVB,ALVB	;CHECK VECTOR, ALLOC VECTOR

	ENDIF

;-----------------------------------------------------------------------

MODL0:	DW	XLT0,000H	;MODEL DPE FOR MODE 0
	DW	000H,000H	;
	DW	DIRBUF,DPB0	;

MODL1:	DW	0000H,0000H	;MODEL DPE FOR MODE 1
	DW	0000H,0000H	;
	DW	DIRBUF,DPB1	;

MODL2:	DW	0000H,0000H	;MODEL DPE FOR MODE 2
	DW	0000H,0000H	;
	DW	DIRBUF,DPB2	;

;-----------------------------------------------------------------------

	PAGE
;-----------------------------------------------------------------------
;
;	THESE ARE THE DISK TYPE DEFINITION BLOCKS
;	EACH OF WHICH CORRESPONDS TO A PARTICULAR MODE.
;
;-----------------------------------------------------------------------

	DISKDEF	0,1,26,6,1024,243,64,64,2,0

	DISKDEF	1,1,52,,2048,243,128,128,2
	DB	1		;SHOW SECTRAN ROUTINE THAT 1ST SECTOR IS A "1"

	DISKDEF 2,1,48,,2048,225,96,96,2,0
	DB	1		;SHOW SECTRAN ROUTINE THAT 1ST SECTOR IS A "1"
	
	
	IF	HARDSK

DPB3:	DISKDEF	3,0,127,,16384,512,512,0,1
	DB	0		;SHOW SECTRAN ROUTINE THAT 1ST SECTOR IS A "0"

DPB4:	DISKDEF	4,0,127,,16384,512,512,0,513
	DB	0		;SHOW SECTRAN ROUTINE THAT 1ST SECTOR IS A "0"

DPB5:	DISKDEF	5,0,127,,16384,512,512,0,1025
	DB	0		;SHOW SECTRAN ROUTINE THAT 1ST SECTOR IS A "0"

DPB6:	DISKDEF	6,0,127,,16384,288,512,0,513
	DB	0		;SHOW SECTRAN ROUTINE THAT 1ST SECTOR IS A "0"

	ENDIF

	PAGE
;-----------------------------------------------------------------------
;
;	COLD BOOTSTRAP AND SET MODE FOR DRIVES BASED ON
;	DATA WRITTEN INTO THE CBIOS BY THE SETUP PROGRAM.
;
;-----------------------------------------------------------------------

BOOT:
	LXI	H,(VERSION MOD 10 SHL 12) OR (ALTOSV SHL 8) OR (VERSION/10) ;CBIOS IDENT
	LXI	H,MSG		;POINT TO BOOT MESSAGE
	CALL	MSPRT		;DISPLAY IT TO CALLER
	DI			;
	MVI	A,076H		;STOP SECOND ENTRY
	STA	BOOT+10		;...TO BOOT ROUTINE WITH "HLT"
	CALL	MOREBOOT	;REMAINING CODE IN DIRECTORY BUFFER

	CALL	RSTHDSK		;RESET HARD DISK
	MVI	A,INTERUPT SHR 8 ;SETUP INTERRUPT VECTOR
	STAI
	EI			;ALLOW INTERRUPTS

	LDA	MPARMS
	ANI	008H		;CHECK FOR WARM BOOT FROM "E:"
	JRZ	GOCPM		;BRANCH IF WARM BOOT FROM "A:"

	LDA	SEL0+4		;IS "E:" THERE?
	ORA	A		;IF NOT...SAY WE CAN'T BOOT FROM "E:"
	JRZ	NOCPMCOM

	OUT	020H
	MVI	C,1
	CALL	DELAY
	IN	024H		;CHECK FOR "E:" READY
	RAL
	CNC	EWAIT		;IF NOT READY...GIVE WAITING FOR "E:" MSG.

	MVI	C,13
	CALL	BDOS		;INITIALIZE CP/M

	LXI	H,CPMFCB	;FCB FOR CPMnn.COM
	LXI	D,05CH
	LXI	B,CFCBLEN
	LDIR			;MOVE FCB TO LOW MEMORY

	MVI	C,15
	LXI	D,05CH
	CALL	BDOS		;OPEN FILE
	CPI	0FFH
	JRZ	NOCPMCOM	;GIVE ERROR MESSAGE IF NOT THERE

	LHLD	05CH+16		;PICK UP EXTENT ADDRESS FROM FCB
	INX	H		;CONVERT TO TRACK ADDRESS
	SHLD	WARMSAVE	;SAVE FOR WARM BOOT ROUTINE
	JR	GOCPM

EWAIT:
	LXI	H,MSGEWAIT
	CALL	MSPRT		;SAY WE ARE WAITING
	RET

NOCPMCOM:
	LXI	H,MSGNOCPM
	CALL	MSPRT		;SAY NO CPMnn.COM
	LDA	MPARMS
	ANI	0F7H		;TURN OFF WARM START BIT
	STA	MPARMS
	JR	GOCPM

RSTHDSK:
	IF	HARDSK
	MVI	A,080H		;ISSUE RESET AGAINST HARD DISK
	OUT	023H		;
	MVI	A,01010000B	;RESET WRITE FAULT
	OUT	020H		;DRIVE 1
	MVI	A,01100000B	;
	OUT	020H		;DRIVE 2
	MVI	A,00010000B	;SELECT DRIVE 1/ HEAD 0
	OUT	020H		;
	MVI	C,20		;WAIT FOR 20 MILLISECONDS
	CALL	DELAY		;

	XRA	A		;ZERO ACCUMULATOR
	STA	HSTACT		;SET HOST BUFFER INACTIVE
	STA	UNACNT		;SET UNALLOCATED COUNT TO ZERO

	LXI	H,HSTBUF-1	;SETUP WRITE CONTROL BYTE FOR HARD DISK
	MVI	M,00DH		;
	ENDIF
	RET

	PAGE
GOCPM:
	LDA	CDISK		;GET CURRENT LOGGED IN DRIVE
	MOV	C,A		;SAVE VALUE FOR JMP TO CCP
	ANI	00FH		;IGNORE USER NUMBER
	JRZ	GOCPM1		;SKIP PATCH IF DRIVE A:

	LDA	MPARMS		;WARM BOOT FROM A:?
	ANI	008H		;
	JRZ	GOCPM1		;IF YES...SKIP PATCH

	XRA	A
	STA	BDPTCH1
	LHLD	BDPTCH2		;PERFORM TEMP. PATCH TO BDOS TO ALLOW
	SHLD	PTCHSAVE	;..WARM BOOT FROM E: WITHOUT HAVING
	LXI	H,PTCHFIX	;..CP/M SELECT A:.  THE "PTCHFIX" ROUTINE
	SHLD	BDPTCH2		;..WILL PUT THE CODE BACK THE WAY IT WAS
;				;..SO THAT ANYONE EXPLICITLY CALLING BDOS
;				;..WILL STILL SELECT A: IF THEY WANT TO.

GOCPM1:
	MVI     A,0C3H     	;STORE A JUMP TO WBOTE AT 0000H
        STA     0
        LXI     H,WBOTE
        SHLD    1
        STA     5          	;STORE A JUMP TO BDOS AT 0005H
        LXI     H,BDOS
        SHLD    6
;				;<C> ALREADY CONTAINS CORRECT DRIVE
	JMP	CCP		;START CCP HERE....

PTCHFIX:
	PUSH	H		;AS SOON AS CCP DOES FIRST CALL TO
	LHLD	PTCHSAVE	;..BDOS FUNCTION 13, RESTORE CODE
	SHLD	BDPTCH2		;..SO THAT FUTURE CALLS TO FUNCTION 13
	POP	H		;..BEHAVE THE WAY THE MANUAL SAYS THEY
	RET			;..WILL

	PAGE
;-----------------------------------------------------------------------
;
;	WARM BOOTSTRAP SUBROUTINE
;
;-----------------------------------------------------------------------

WBOOT:
	LXI	SP,080H		;SET STACK IN A KNOWN PLACE

	CALL	RSTHDSK		;RESET HARD DISK

	LDA	MPARMS
	ANI	008H		;WARM BOOT FROM A: ?
	JRZ	WBT1		;IF YES...BRANCH

	MVI	A,4		;FOR DRIVE E: SELECT
	LHLD	WARMSAVE	;TRACK ADDRESS OF CPMnn.COM
	MVI	E,17		;START READING WITH SECTOR 17
	JR	WBT3

WBT1:
	XRA	A		;FOR DRIVE A: SELECT
	LXI	H,0		;SET TO TRACK 0
	MVI	E,2		;START READING WITH SECTOR 2

WBT3:
	PUSH	D
	PUSH	H
	MOV	C,A		;DRIVE TO BE SELECTED
	PUSH	PSW
	CALL	SELDSK
	POP	PSW
	ORA	A
	JRNZ	WBT4		;SKIP HOME IF E:
	CALL	HOME

WBT4:
	POP	B		;PUT TRACK # IN <BC>
	CALL	SETTRK
	POP	D		;STARTING SECTOR # IN <E>
	MVI	D,NSECTS	;PUT # OF SECTORS TO READ IN <D>
	LXI	H,CCP		;BASE OF CP/M

WBT5:
	PUSH	D		;<D> = # OF SECTORS YET TO READ
;				;<E> = NEXT SECTOR # TO READ
	PUSH	H		;<HL> = NEXT DMA ADDRESS

	MOV	C,E
	CALL	SETSEC
	POP	B		;GET DMA ADDRESS FROM <HL>
	PUSH	B
	CALL	SETDMA

	CALL	READ		;READ NEXT SECTOR
	ORA	A
	JRNZ	WBOOT		;IF ERROR - RETRY FROM START

	POP	H		;PREVIOUS DMA ADDRESS
	LXI	D,128
	DAD	D		;UPDATE DMA ADDRESS

	POP	D		;<D> = # OF SECTORS YET TO READ
;				;<E> = NEXT SECTOR # TO READ
	DCR	D
	JZ	GOCPM		;EXIT TO FINAL PROCESSING

	INR	E		;NEXT SECTOR NUMBER
	LDA	MPARMS
	ANI	008H
	JRNZ	WBT5		;BRANCH IF WARM BOOT FROM E:

	MOV	A,E
	CPI	27		;IS THIS THE END OF FLOPPY DISK TRACK 0?
	JRC	WBT5		;BRANCH IF NOT END OF TRACK

	MVI	E,1		;RESET SECTOR # TO 1
	PUSH	D
	PUSH	H
	LXI	B,1
	CALL	SETTRK		;SET TO TRACK # 1
	POP	H
	POP	D
	JR	WBT5		;COMPLETE LOADING FROM FLOPPY

;-----------------------------------------------------------------------
;
;	DISK ACCESS ROUTINES
;
;-----------------------------------------------------------------------

SELDSK:
	MOV	A,C		;LIMIT SELECT TO REAL OPTIONS
	CPI	MAXDSK		;
	JRNC	SELBAD		;  NOT REAL
	LXI	H,SEL0		;CHECK VALID DISK SELECT
	MVI	B,0		;
	DAD	B		; POINT TO SELECT BYTE
	MOV	A,M		;  IS IT A ZERO ?
	ANA	A		;
	JRNZ	SELGD		;  NO  -  THEN GOOD
SELBAD:
	LXI	H,0		;  YES -  BAD
	RET

SELGD:
	MOV	A,C		;DRIVE ADDRESS PASSED
	STA	NEWDSK		;SAVE FOR I/O LATER
	MOV	L,C		;COMPUTE DP HEADER ADDRESS
	MVI	H,000H		;
	DAD	H		;* 2
	DAD	H		;* 4
	DAD	H		;* 8
	DAD	H		;* 16 (DP HEADER SIZE)
	LXI	D,DPBASE	;START OF DP HEADERS
	DAD	D		;POINT TO CORRECT ONE
	SHLD	DPEPTR		;SAVE ADDRESS OF CURRENT DP BLOCK

	LXI	D,10		;POINT TO BYTE AFTER DISK PARM. BLOCK
	DAD	D		;..IT WILL INDICATE WHETHER 1ST SECTOR
	MOV	E,M		;..IS A "0" OR A "1"
	INX	H
	MOV	D,M		;D,E NOW POINT TO DISK PARAMETER BLOCK
	LXI	H,15
	DAD	D		;POINT TO BYTE JUST AFTER DPB
	MOV	D,M		;GET BYTE
	LXI	H,SECTOR$ADJ
	MOV	M,D		;SAVE FOR SECTRAN ROUTINE
	LHLD	DPEPTR		;RESTORE ADDRESS OF CURRENT DP HEADER

	RET			;

SETDMA:
	MOV	H,B		;TO ALLOW SAVING
	MOV     L,C		;
        SHLD    DMAADR		;
        RET			;RETURN TO CALLER

SETTRK:
	MOV	H,B		;TO ALLOW SAVE
	MOV	L,C		;
	SHLD	NEWTRK	  	;SAVE NEXT TRACK NUMBER
        RET			;RETURN TO CALLER

SETSEC:
	MOV	A,C		;FOR SAVE
	STA	NEWSEC		;
        RET			;RETURN TO CALLER

SETDEN:
	LXI	D,SEL0		;START OF SELECT/DENSITY MASKS
	LHLD	NEWDSK		;NEXT DRIVE ADDRESS
	MVI	H,000H		;ENSURE ZERO FOR SINGLE BYTE QUANTITY
	DAD	D		;POINT TO CORRECT MASK
	MOV	A,C		;ISOLATE DENSITY BIT
	ANI	00000001B	;
	MOV	C,A		;SAVE FOR NOW
	MOV	A,M		;LOAD SELECT DENSITY MASK
	ANI	11111110B	;RESET CURRENT DENSITY SETTING
	ORA	C		;SET NEW VALUE
	MOV	M,A		;RESTORE MASK IN TABLE
	RET			;RETURN TO CALLER

READ:
	CALL	RETMOD		;WHAT TYPE OF I/O ??
	CPI	003H		;
	JC	READSOFT	;FLOPPY DISK DRIVE....
	JMP	READHARD	;HARD DISK I/O

WRITE:
	CALL	RETMOD		;WHAT TYPE OF I/O ??
	CPI	003H		;
	JC	WRITESOFT	;FLOPPY DISK
	JMP	WRITEHARD	;HARD DISK I/O

	PAGE
;-----------------------------------------------------------------------
;
;	ROUTINES TO SET AND RETURN THE CURRENT DRIVE MODE
;
;-----------------------------------------------------------------------

SETMOD:
	LHLD	NEWDSK		;NEXT DRIVE FOR I/O
	MVI	H,000H		;
	MOV	A,L		;CHECK MODE SET VALIDITY
	CPI	004H		;ONLY VALID FOR FLOPPY DISK DRIVES
	RNC			;INVALID DRIVE FOR MODE SET, RETURN
	LXI	D,MODE		;START OF MODE BYTES
	DAD	D		;
	MOV	M,C		;SAVE NEW MODE BYTE
	PUSH	H		;SAVE MODE BYTE ADDRESS
	MOV	A,C		;SETUP FOR DENSITY CHANGE
	ORA	A		;
	MVI	C,000H		;ASSUME SINGLE DENSITY MODE....
	JRZ	SETM1		;VERIFY ASSUMPTION
	MVI	C,001H		;SET FOR DOUBLE DENSITY MODE....
SETM1:	CALL	SETDEN		;SET DENSITY BASED ON LOW BIT

	POP	H		;RESTORE
	MOV	L,M		;PICKUP MODE AGAIN
	MVI	H,000H		;FOR SINGLE BYTE PRECISION
	MOV	A,L		;SAVE MODE IN ACCUMULATOR FOR LATER
	DAD	H		;* 2
	DAD	H		;* 4
	PUSH	H		;SAVE * 4
	DAD	H		;* 8
	POP	D		;REGAIN * 4
	DAD	D		;* 12
	LXI	D,MODL0		;FIRST MODEL DPE
	DAD	D		;POINT TO THIS ONE
	XCHG			;SETUP TEMPORARILY AS DESTINATION
	LHLD	DPEPTR		;ADDRESS OF CURRENTLY SELECTED DPE
	XCHG			;SETUP TO ALTER
	LXI	B,12		;LENGTH FOR MOVE
	LDIR			;DO MOVE
	RET			;RETURN TO CALLER

RETMOD:
	LXI	D,MODE		;START OF MODE BYTES
	LHLD	NEWDSK		;NEXT DRIVE FOR I/O
	MVI	H,000H		;RESET FOR SINGLE BYTE QUANTITY
	DAD	D		;POINT TO IT....
	MOV	A,M		;LOAD IT FOR CALLER
	RET			;RETURN, WITH CURRENT MODE SETTING

	PAGE
;-----------------------------------------------------------------------
;
;	THIS IS THE HOME DEVICE ROUTINE
;
;-----------------------------------------------------------------------

HOME:
	LDA	NEWDSK		;GET VALUE OF DRIVE FOR HOME
	CPI	004H		;IS IT A HARD DISK ??
	JRNC	HOMEHARD	;YES, PROCESS....

HOMESOFT:
	CALL	DSKSEL		;SELECT CORRECT DRIVE (IN ACCUMULATOR)
	CALL	POINT		;POINT TO TRACK REGISTER SAVE AREA
	MVI	M,000H		;RESET TO TRACK ZERO
	CALL	DBL$UPDATE	;
	LDA	STEPRATE	;GET STEP RATE FOR FLOPPY
	ORI	008H		;HOME COMMAND....
	CALL	FLPYWAIT	;ISSUE COMMAND AND WAIT
	LDA	STATUS		;PICKUP STATUS BYTE
	ANI	10011000B	;CHECK STATUS
	RZ			;RETURN WITH GOOD ESULT
	MVI	A,001H		;SET ERROR ON HOME
	RET			;AND RETURN....

HOMEHARD:
	IF	HARDSK
	CALL	DSKSEL		;SELECT CORRECT DRIVE (IN ACCUMULATOR)
	CALL	POINT		;POINT TO SAVE AREA
	MVI	M,000H		;SET TO TRACK ZERO
	XCHG			;POINT TO SELECT WORD
	MOV	A,M		;LOAD SELECT MASK
	ANI	11110000B	;RESET HEAD MASK
	MOV	M,A		;SAVE
	OUT	020H		;WRITE HEAD/SELECT MASK
	MVI	A,020H		;HOME COMMAND
	CALL	HARDWAIT	;ISSUE COMMAND AND WAIT
	MVI	C,20		;DELAY FOR 20 MILLISECONDS
	CALL	DELAY		;
	XRA	A		;SET NEW TRACK REGISTER TO ZERO
	OUT	022H		;FOR CONTROLLER
;	LXI	H,MHM		;***DEBUG***
;	CALL	MSPRT		;***DEBUG***
	LDA	STATUS		;PICKUP STATUS BYTE
	ANI	01011101B	;CHECK STATUS
	RZ			;
	MVI	A,001H		;SET ERROR ON HOME
	ENDIF
	RET			;AND RETURN

	PAGE
;-----------------------------------------------------------------------
;
;	THESE ARE THE HARD DISK UNBLOCK/REBLOCK AND READ AND WRITE
;	ROUTINES CALLED BY THE BDOS SOFTWARE.
;
;-----------------------------------------------------------------------

READHARD:
	IF	HARDSK
	XRA	A		;RESET UNALLOCATED COUNT
	STA	UNACNT		;
	MVI	A,001H		;READ THE SELECTED CP/M SECTOR
	STA	READOP		;
	STA	RSFLAG		;MUST READ DATA
	MVI	A,WRUAL		;
	STA	WRTYPE		;TREAT AS UNALLOCATED
	JMP	RWOPER		;TO PERFORM THE READ
	ENDIF

WRITEHARD:
	IF	HARDSK
	XRA	A		;WRITE THE SELECTED CP/M SECTOR
	STA	READOP		;NOT A READ OPERATION
	MOV	A,C		;WRITE TYPE IS PASSED IN REG C
	STA	WRTYPE		;
	CPI	WRUAL		;IS IT WRITE UNALLOCATED ??
	JRNZ	CHKUNA		;CHECK FOR UNALLOCATED

;
;	WRITE TO UNALLOCATED, SET PARAMETERS
;

	MVI	A,BLKSIZ/128	;NEXT UNALLOC RECS
	STA	UNACNT		;
	LDA	NEWDSK		;DISK FOR I/O
	STA	UNADSK		;UNADSK = NEWDSK
	LHLD	NEWTRK		;
	SHLD	UNATRK		;UNATRK = NEWTRK
	LDA	NEWSEC		;
	STA	UNASEC		;UNASEC = NEWSEC

;
;	CHECK FOR WRITE TO UNALLOCATED SECTOR
;

CHKUNA:
	LDA	UNACNT		;ANY UNALLOCATED REMAIN ??
	ORA	A		;
	JRZ	ALLOC		;SKIP IS NOT

;
;	MORE UNALLOCATED RECORDS REMAIN
;

	DCR	A		;UNACNT = UNACNT - 1
	STA	UNACNT		;
	LDA	NEWDSK		;SAME DISK ??
	LXI	H,UNADSK	;
	CMP	M		;NEWDSK = UNADSK ??
	JRNZ	ALLOC		;SKIP IF NOT

;
;	DISKS ARE THE SAME
;

	LXI	H,UNATRK	;
	CALL	NEWTRKCMP	;NEWTRK = UNATRK ??
	JRNZ	ALLOC		;SKIP IF NOT

;
;	TRACKS ARE THE SAME
;

	LDA	NEWSEC		;SAME SECTOR ??
	LXI	H,UNASEC	;
	CMP	M		;NEWSEC = UNASEC ??
	JRNZ	ALLOC		;SKIP IF NOT

;
;	MATCH, MOVE TO NEXT SECTOR FOR FUTURE REFERENCE
;

	INR	M		;UNASEC = UNASEC + 1
	MOV	A,M		;END OF TRACK ??
	CPI	CPMSPT		;COUNT CP/M SECTORS
	JRC	NOOVF		;SKIP IF NO OVERFLOW

;
;	OVERFLOW TO NEXT TRACK
;

	MVI	M,000H		;UNASEC = 0
	LHLD	UNATRK		;
	INX	H		;
	SHLD	UNATRK		;UNATRK = UNATRK + 1
 
;
;	MATCH FOUND, MARK AS UNNECESSARY READ
;

NOOVF:
	XRA	A		;ZERO TO ACCUMULATOR
	STA	RSFLAG		;RSFLAG = 0
	JR	RWOPER		;TO PERFORM THE WRITE

;
;	NOT AN UNALLOCATED RECORD, REQUIRES PRE-READ
;

ALLOC:
	XRA	A		;ZERO TO ACCUMULATOR
	STA	UNACNT		;UNACNT = 0
	INR	A		;ONE TO ACCUMULATOR
	STA	RSFLAG		;RSFLAG = 1

;-----------------------------------------------------------------------
;
;	THE FOLLOWING CODE IS COMMON TO BOTH READ AND WRITE
;
;-----------------------------------------------------------------------

RWOPER:
	XRA	A		;ZERO TO ACCUMULATOR
	STA	ERFLAG		;NO ERRORS YET....
	LDA	NEWSEC		;COMPUTE HOST SECTOR
	REPT	SECSHF		;COMPUTE HOST SECTOR
	ORA	A		;CARRY = 0
	RAR			;SHIFT RIGHT
	ENDM
	STA	NEWHST		;HOST SECTOR TO SEEK

;
;	ACTIVE HOST SECTOR ??
;

	LXI	H,HSTACT	;HOST ACTIVE FLAG
	MOV	A,M		;
	MVI	M,001H		;ALWAYS BECOMES 1
	ORA	A		;WAS IT ALREADY ??
	JRZ	FILLHST		;FILL HOST IF NOT

;
;	HOST BUFFER ACTIVE, SAME AS SEEK BUFFER
;

	LDA	NEWDSK		;
	LXI	H,HSTDSK	;SAME DISK ??
	CMP	M		;NEWDSK = HSTDSK ??
	JRNZ	NOMATCH		;

;
;	SAME DISK, SAME TRACK ??
;

	LXI	H,HSTTRK	;
	CALL	NEWTRKCMP	;NEWTRK = HSTTRK ??
	JRNZ	NOMATCH		;

;
;	SAME DISK, SAME TRACK, SAME BUFFER ??
;

	LDA	NEWHST		;
	LXI	H,HSTSEC	;NEWHST = HSTSEC ??
	CMP	M		;
	JRZ	MATCH		;SKIP IF MATCH

;
;	PROPER DISK, BUT NOT CORRECT SECTOR
;

NOMATCH:
	LDA	HSTWRT		;HOST WRITTEN ??
	ORA	A		;
	CNZ	WRITEHST	;CLEAR HOST BUFFER

;
;	MAY HAVE TO FILL HOST BUFFER
;

FILLHST:
	LDA	NEWDSK		;
	STA	HSTDSK		;
	LHLD	NEWTRK		;
	SHLD	HSTTRK		;
	LDA	NEWHST		;
	STA	HSTSEC		;
	LDA	RSFLAG		;NEED TO READ ??
	ORA	A		;
	CNZ	READHST		;YES, IF 1
	XRA	A		;ZERO TO ACCUMULATOR
	STA	HSTWRT		;NO PENDING WRITE

;
;	COPY DATA TO OR FROM BUFFER
;

MATCH:
	LDA	NEWSEC		;MASK BUFFER NUMBER
	ANI	SECMSK		;LEAST SIGNIF BITS
	MOV	L,A		;READY TO SHIFT
	MVI	H,000H		;DOUBLE COUNT
	REPT	7
	DAD	H		;
	ENDM

;
;	HL NOW HAS RELATIVE HOST BUFFER ADDRESS
;

	LXI	D,HSTBUF	;
	DAD	D		;HL = HOST ADDRESS
	XCHG			;NOW IN DE
	LHLD	DMAADR		;GET/PUT CP/M DATA
	XCHG			;SET FOR Z80 LDIR INSTRUCTION
	LXI	B,128		;LENGTH OF MOVE
	LDA	READOP		;WHICH WAY ??
	ORA	A		;
	JRNZ	RWMOVE		;SKIP IF READ
;
;	WRITE OPERATION, MARK AND SWITCH DIRECTION
;

	MVI	A,001H		;
	STA	HSTWRT		;HSTWRT = 1
	XCHG			;SWAP DIRECTION

;
;	MOVE SUBROUTINE
;

RWMOVE:
	LDIR			;MOVE DATA TO/FROM BUFFER

;
;	DATA HAS BEEN MOVED TO/FROM HOST BUFFER
;

	LDA	WRTYPE		;WRITE TYPE ??
	CPI	WRDIR		;TO DIRECTORY ??
	JRNZ	RWEND		;NO, JUST END UP HERE

;
;	CLEAR HOST BUFFER FOR DIRECTORY WRITE
;

	LDA	ERFLAG		;CHECK PRIOR TO DIR ACTIVITY
	ORA	A		;ERRORS ??
	JRNZ	RWEND		;SKIP IF SO....
	XRA	A		;ZERO TO ACCUMULATOR
	STA	HSTWRT		;BUFFER WRITTEN
	CALL	WRITEHST	;

RWEND:
	LDA	ERFLAG		;
	ORA	A		;IF ERRORS, RESET SO NO MATCH NEXT TIME THRU
	RZ			;NONE, JUST RETURN
	LXI	H,HSTDSK	;
	MVI	M,0FFH		;CANT POSSIBLY MATCH, MUST REDO I/O
	ENDIF
	RET			;

	PAGE
;-----------------------------------------------------------------------
;
;	WRITEHST PERFORMS THE PHYSICAL WRITE TO THE HOST DISK.
;	READHST PERFORMS THE PHYSICAL READ FROM THE HOST DISK.
;
;	HSTDSK = HOST DISK NUMBER
;	HSTTRK = HOST TRACK NUMBER
;	HSTSEC = HOST SECTOR NUMBER
;	RETURN ERROR FLAG IN ERFLAG
;
;-----------------------------------------------------------------------
	IF	HARDSK

WRITEHST:
;	LXI	H,MWRT		;***DEBUG***
;	CALL	MSPRT		;***DEBUG***
	MVI	A,005H		;SETUP DMA FOR WRITE
	STA	DMAS3F		;
	MVI	A,002H		;WRITE COMMAND
	STA	CMD		;SAVE FOR LATER
	LXI	H,HSTBUF-1	;WRITE MUST WRITE CONTROL BYTE
	SHLD	DMASA		;
	JR	HRW0		;

READHST:
;	LXI	H,MRD		;***DEBUG***
;	CALL	MSPRT		;***DEBUG***
	MVI	A,001H		;SETUP DMA FOR READ
	STA	DMAS3F		;
	MVI	A,004H		;READ COMMAND
	STA	CMD		;SAVE FOR LATER
	LXI	H,HSTBUF	;READ ONLY DATA BYTES
	SHLD	DMASA		;

HRW0:
	MVI	A,05		;FIVE RETRIES
	STA	T$RETRIES	;SETUP TEMPORARY RETRIES COUNT
	MVI	A,0FFH		;INIT TOGGLE SO THAT NO HOME IS DONE ON FIRST RETRY
	STA	HOME$TOGGLE	;ALTERNATE RETRIES WILL BE DONE WITHOUT HOME
;				;OTHER RETRIES WILL BE DONE WITH HOME

HRW1:
	LDA	HSTSEC		;HOST SETOR NUMBER
	STA	SECTNO		;SAVE SECTOR NUMBER
	LDA	HSTDSK		;PICKUP DRIVE ID FOR SELECT
	CALL	DSKSEL		;SELECT CORRECT DRIVE FOR I/O
	CALL	POINT		;POINT TO TRACK REGISTER SAVE AREA
	XCHG			;POINT TO SELECT MASK
	MVI	A,11110000B	;TO REMOVE CURRENT HEAD SELECTION
	ANA	M		;
	MOV	M,A		;
	PUSH	H		;SAVE MASK ADDRESS
	CALL	SETHED		;COMPUTE CORRECT HEAD NUMBER
	MOV	A,L		;TRACK NUMBER AFTER HEAD CALCULATION
	STA	TRAKNO		;
	POP	H		;RESTORE MASK ADDRESS
	LDA	HEADNO		;TO OR IN NEW HEAD NUMBER
	ORA	M		;
	MOV	M,A		;SAVE NEW DRIVE/HEAD SELECTION
	ANI	07FH		; MASK OFF LARGE DRIVE FLAG
	OUT	020H		;WRITE IT TO SELECT NEW HEAD....
;	PUSH	PSW		;***DEBUG***
;	LXI	H,MDV		;***DEBUG***
;	CALL	MSPRT		;***DEBUG***
;	POP	PSW		;***DEBUG***
;	CALL	HEXCONV		;***DEBUG***
	MVI	C,1		;DELAY FOR 1 MILLISECOND
	CALL	DELAY		;

HRW2:
	CALL	POINT		;IS A SEEK NECESSARY ??
	LDA	TRAKNO		;CHECK
	CMP	M		;WELL ??
	JRZ	HRW5		;NO SEEK NECESSARY...

HRW3:
	OUT	022H		;WRITE NEW TRACK NUMBER
;	PUSH	PSW		;***DEBUG***
	MOV	B,M		;SAVE TEMPORARILY
	MOV	M,A		;UPDATE TRACK REGISTER SAVE AREA
	MOV	A,B		;OLD TRACK NUMBER
	OUT	021H		;TO OLD TRACK REGISTER
;	PUSH	PSW		;***DEBUG***
	MVI	A,010H		;SEEK COMMAND
	CALL	HARDWAIT	;ISSUE COMMAND AND WAIT

	MVI	C,20		;DELAY AFTER SEEK FOR 20 MILLISECONDS
	CALL	DELAY		;

;	LXI	H,MSK		;***DEBUG***
;	CALL	MSPRT		;***DEBUG***
;	POP	PSW		;***DEBUG***
;	CALL	HEXCONV		;***DEBUG***
;	LXI	H,MSK2		;***DEBUG***
;	CALL	MSPRT		;***DEBUG***
;	POP	PSW		;***DEBUG***
;	CALL	HEXCONV		;***DEBUG***

HRW5:
	LDA	SECTNO		;SET SECTOR
	OUT	021H		;

;	PUSH	PSW		;***DEBUG***
;	LXI	H,MSC		;***DEBUG***
;	CALL	MSPRT		;***DEBUG***
;	POP	PSW		;***DEBUG***
;	CALL	HEXCONV		;***DEBUG***

HRW6:
	LXI	H,DMAS1		;SETUP DMA FOR HARD DISK I/O
	LXI	B,0600H		;
	OUTIR			;
	LXI	H,DMAS2H	;
	LXI	B,0600H		;
	OUTIR			;
	LXI	H,DMAS3		;
	LXI	B,0700H		;
	OUTIR			;

	LDA	CMD		;PICKUP I/O COMMAND
	CALL	HARDWAIT	;ISSUE COMMAND AND WAIT

	MVI	A,01011101B	;SETUP STATUS AND MASK
	STA	MASK		;SAVE FOR STATUS CHECK
	CALL	CHECK$STAT	;CHECK STATUS FROM I/O
	RZ			;OK ??

	LDA	HOME$TOGGLE	;
	CMA			;CHANGE TOGGLE SO THAT HOMES ARE DONE EVERY OTHER RETRY
	STA	HOME$TOGGLE	;

	JMP	HRW1		;RETRY I/O
	ENDIF

	PAGE
;-----------------------------------------------------------------------
;
;	DOUBLE SIDED TRACK REGISTER UPDATE ROUTINE
;
;-----------------------------------------------------------------------


DBL$UPDATE:
	LDA	MPARMS		;CHECK FOR DOUBLE SIDED DRIVES
	ANI	1		;  IS FLAG SET
	RZ			;   NO  - SO RETURN
	LDA	DISKNO		;CURRENT DISK DRIVE
	CPI	004H		;IS IT A FLOPPY
	RNC			;NO, RETURN WITHOUT UPDATE
	ANI	00000010B	;IS THIS DRIVE 2 0R 3 ??
	MOV	A,M		;WE WERE CALLED WITH (HL) POINTING TO TRACK
	JRZ	DBL$LOW		;IT MUST BE DRIVE ZERO OR ONE
	DCX	H		;BACKUP TO OTHER SIDE POINTER
	DCX	H		;
	JR	DBL$SAVE	;

DBL$LOW:
	INX	H		;BUMP UP TO DRIVE TWO OE TRHEE
	INX	H		;

DBL$SAVE:
	MOV	M,A		;UPDATE OTHER SIDE REGISTER
	RET			;

	IF	HARDSK
MWRT:	DB	00DH,00AH,'WRITE ',0
MRD:	DB	00DH,00AH,'READ  ',0
MHM:	DB	00DH,00AH,'HOME HARD ',0
MDV:	DB	' DRIVE/HEAD ',0
MSK:	DB	' SEEK FROM ',0
MSK2:	DB	' TO ',0
MSC:	DB	' SECTOR ',0
	ENDIF


	PAGE
;-----------------------------------------------------------------------
;
;	ROUTINE TO COMPUTE HEAD NUMBER FROM TRACK NUMBER
;	TRACK NUMBER IS IN HL ON ENTRY
;
;-----------------------------------------------------------------------

	IF	HARDSK
SETHED:
	LHLD	HSTTRK		;CP/M TRACK NUMBER (0-800)
	ANI	80H		; CHECK FOR LARGE DRIVE
	MOV	A,L		;LOW ORDER
	JRZ	SETH14		;  SMALL DRIVE
	ANI	00000111B	;GET TRACK MOD 8 (HEAD NUMBER)
	MVI	C,3		;LIMIT LOOP FOR DIVIDE BY EIGHT
	JR	SETDVD		;
SETH14:	ANI	00000011B	;GET TRACK MOD 4 (HEAD NUMBER)
	MVI	C,2		;LIMIT LOOP FOR DIVIDE BY FOUR
SETDVD:	STA	HEADNO		;SAVE AS HEAD NUMBER
SHD1:	ORA	A		;ENSURE CARRY IS ZERO
	MOV	A,H		;FOR SHIFT
	RAR			;ONE BIT
	MOV	H,A		;
	MOV	A,L		;LOW ORDER
	RAR			;CARRY PARTICIPATES FROM HIGH ORDER
	MOV	L,A		;
	DCR	C		;END OF DIVIDE YET ??
	JRNZ	SHD1		;NO, CONTINUE
	RET			;RETURN TO CALLER, TRACK IN HL
	ENDIF

	PAGE
;-----------------------------------------------------------------------
;
;	DISK DRIVE SELECT ROUTINE
;		ON ENTRY, THE ACCUMULATOR CONTAINS THE DRIVE FOR SELECTION
;		RETURNS CARRY SET FOR HARD DISK SELECTED
;		RETURNS CARRY RESET FOR FLOPPY DISK SELECTED
;
;-----------------------------------------------------------------------

DSKSEL:
	CPI	004H		;IS IT HARD DISK ??
	JRNC	SELHARD		;YES, GO PROCESS....

SELSOFT:
	LXI	H,DISKNO	;CURRENT DRIVE NUMBER
	CMP	M		;SAME DRIVE AS LAST TIME ??
	JRZ	SLS3		;YES, DONT BOTHER WITH UNLOAD
	MOV	M,A		;UPDATE WITH CURRENT DRIVE NUMBER

;-----------------------------------------------------------------------
;
;	WE WILL NOW FORCE THE HEAD TO UNLOAD PRIOR TO THE SWITCH
;	TO ENSURE THAT WHEN WE RETURN TO THIS DISK WE WILL
;	LOAD AND WAIT FOR THE HEAD TO SETTLE.
;
;-----------------------------------------------------------------------

SLS1:
	IN	004H		;ENSURE FLOPPY PORT NOT BUSY
	RAR			;
	JRC	SLS1		;
	IN	005H		;READ THE TRACK REGISTER
	OUT	007H		;ENSURE WE DONT MOVE THE HEAD

	LDA	STEPRATE	;GET FLOPPY STEP RATE
	ORI	010H		;SEEK AND UNLOAD HEAD
	CALL	FLPYWAIT	;ISSUE COMMAND AND WAIT

;-----------------------------------------------------------------------
;
;	WE WILL NOW LOAD THE SELECT MASK AND SELECT THE DRIVE
;	EVEN IF ITS THE SAME DRIVE BECAUSE THE DENSITY MAY
;	HAVE CHANGED.
;
;-----------------------------------------------------------------------

SLS3:
	CALL	POINT		;POINT TO TRACK SAVE AREA
	XCHG			;POINT TO SELECT MASK
	LDA	NEWTRK		;NEXT TRACK FOR I/O
	CPI	002H		;IS IT TRACK ZERO OR ONE
	MVI	A,11111111B	;ASSUME NO....
	JRNC	SLS4		;VERIFY ASSUMPTION
	MVI	A,11111110B	;FORCE SINGLE DENSITY FOR 0, & 1

SLS4:
	ANA	M		;LOAD MASK AND CORRECT IF NECESSARY
	OUT	008H		;SELECT IT
	XCHG			;RESTORE TRACK REGISTER ADDRESS
	MOV	A,M	   	;PICK UP TRACK NUMBER
	OUT	005H		;GIVE IT TO CONTROLLER
	ORA	A		;ENSURE CARRY IS RESET
	RET

;-----------------------------------------------------------------------
;
;	THIS ROUTINE SETS UP THE HARD DISK BY SELECTING THE CORRECT
;	DRIVE AND RELOADING THE HEAD AND TRACK REGISTERS IN THE
;	HARD DISK CONTROLLER READY FOR I/O LATER.
;
;-----------------------------------------------------------------------

SELHARD:
	IF	HARDSK
	LXI	H,DISKNO	;CURRENT DRIVE SELECTED
	CMP	M		;SAME ??
	RZ			;YES, NO NEW SELECT NECESSARY
	MOV	M,A		;UPDATE DISKNO

SLH1:
	CALL	POINT		;TRACK SAVE REGISTER
	XCHG			;POINT TO SELECT MASK
	MOV	A,M		;LOAD DRIVE/HEAD VALUE
	ANI	07FH		;MASK OFF LARGE DRIVE FLAG
	OUT	020H		;WRITE IT TO SELECT PORT
	XCHG			;REGAIN ADDRESS OF TRACK REGISTER
	MOV	A,M		;LOAD OLD TRACK NUMBER
	OUT	022H		;WRITE IT TO OLD TRACK REGISTER
	MVI	C,20		;DELAY FOR 20 MILLISECONDS AFTER SELECT
	CALL	DELAY		;
	STC			;SET CARRY TO SHOW HARD DISK
	ENDIF
	RET			;RETURN TO CALLER

	PAGE
;-----------------------------------------------------------------------
;
;	SUBROUTINE TO POINT TO CURRENT TRACK REGISTER SAVE AREA
;
;-----------------------------------------------------------------------

POINT:
	LHLD	DISKNO	   ;PICKUP CURRENT DISK
	MOV	A,L	   ;
	MVI	H,0	   ;RESET HIGH ORDER HALF
	LXI	D,TRK0	   ;LOAD TRACK POINTER
	DAD	D	   ;POINT TO CURRENT TRACK PTR
	MOV	D,H	   ; DE = TRACK
	MOV	E,L	   ;
	LXI	B,12	   ;
	DAD	B	   ; HL = SELECT
	IF	HARDSK
	CPI	4	   ;
	JRC	PNTFN	   ; FLOPPY DISK
	MVI	A,10H	   ;
	ANA	M	   ; CHECK DRIVE SELECT
	JRZ	PNTH2	   ;   MUST BE DRIVE  # 2
	LXI	D,HTK1	   ; POINT TO DRIVE 1
	JR	PNTFN	   ;
PNTH2:	LXI	D,HTK2	   ; POINT TO DRIVE 2
	ENDIF
PNTFN:	XCHG		   ; SWITCH
	RET		   ; HL = TRACK    DE = SELECT

;-----------------------------------------------------------------------
;
;	ROUTINES TO DO FLOPPY I/O
;
;-----------------------------------------------------------------------

READSOFT:
	MVI	A,09FH		;MASK FOR READ STATUS
	STA	MASK		;
	MVI	A,001H		;SETUP DMA FOR READ
	STA	DMAS3F		;
	MVI	A,08CH		;READ COMMAND
	JR	SRW1		;

WRITESOFT:
	MVI	A,0FFH		;MASK FOR WRITE STATUS
	STA	MASK		;
	MVI	A,005H		;SETUP DMA FOR WRITE
	STA	DMAS3F		;
	MVI	A,0ACH		;WRITE COMMAND

SRW1:
	STA	CMD		;
	LHLD	DMAADR		;
	SHLD	DMASA		;
	LDA	NEWDSK		;
	CALL	DSKSEL		;SELECT DRIVE FOR I/O

SRW2:
	MVI	A,10		;SET NUMBER OF TRIALS
	STA	T$RETRIES	;SAVE FOR RETRY ROUTINE
	XRA	A
	STA	HOME$TOGGLE	;FORCE HOME PRIOR TO EACH RETRY

LOAD$HEAD:
	IN	008H		;IS HEAD LOADED ??
	ANI	00000010B	;CHECK IT....
	JRNZ	REMOVE$LD	;YES, ITS LOADED, DONT RELOAD....
	IN	005H		;DUMMY SEEK TO START HEAD LOADING
	OUT	007H		;KEEP IT SHORT....
	LDA	STEPRATE	;GET FLOPPY STEP RATE
	ORI	018H		;START HEAD LOADING
	CALL	FLPYWAIT	;ISSUE COMMAND AND WAIT

	MVI	C,16		;WAIT HERE FOR 16 MS
	CALL	DELAY		;CALL WAIT ROUTINE
	CALL	POINT		;REESTABLISH TRACK REGISTER POINTER
	MVI	M,254		;ENSURE FURTHER SEEK AND DELAY....
	JR	TRKTST		;

REMOVE$LD:
	LXI	H,CMD		;POINT TO I/O COMMAND
	MVI	A,11111011B	;REMOVE HEAD LOAD BIT
	ANA	M		;DO IT....
	MOV	M,A		;SAVE IT BACK INTO CMD

TRKTST:
	CALL	POINT		;RESTORE TRACK REGISTER POINTER
	LDA	NEWTRK	   	;GET NEW TRACK NUMBER
	STA	TRAKNO		;SAVE IN COMMON PLACE
	CMP	M		;SAME AS LAST TIME ??
	JRZ	FSECSET		;YES, DONT BOTHER WITH SEEK
	MOV	M,A	   	;SAVE IT
	OUT	007H	   	;ALSO SEND IT TO CONTROLLER

	CALL	DBL$UPDATE	;DOUBLE SIDED SUPPORT

FLOPPY$SEEK:
	LDA	STEPRATE	;FLOPPY STEP RATE
	ORI	018H		;SEEK COMMAND WITH HEAD LOAD
	CALL	FLPYWAIT	;ISSUE COMMAND AND WAIT

	MVI	C,16		;SET FOR 16 MS DELAY
	CALL	DELAY		;

FSECSET:
	LDA	NEWSEC		;SET SECTOR
	STA	SECTNO		;SAVE IN COMMONN PLACE
	OUT	006H		;

	CALL	FLOPPYIO	;DO I/O
	CALL	CHECK$STAT	;CHECK STATUS OF I/O
	LDA	ERFLAG		;SETUP TO RETURN TO BDOS
	RZ			;EITHER OK OR PERMANENT ERROR
	JR	LOAD$HEAD	;ERROR, JUST RETRY THIS SAME I/O

	PAGE
;-----------------------------------------------------------------------
;
;	THIS IS THE ROUTINE THAT DOES THE FLOPPY DISK I/O
;
;-----------------------------------------------------------------------

FLOPPYIO:
	IF	NOT DMA
        LXI     H,066H		;MOVE DATA FROM 066H TO SAVE
        LXI     D,SAVE1		;
        LXI     B,004H		;
	LDIR			;MOVE IT

        LXI     H,NMIRTN	;SET NMI ROUTINE TO NMI ADDRESS
        LXI     D,066H		;
        LXI     B,004H		;
	LDIR			;MOVE IT

	LDA	CMD		;IS IT A WRITE ??
	ANI	20H		;
	JZ	FRD		;NO, LEAVE INI CMD IN LOW MEMORY
	LXI	H,067H		;POINT TO COMMAND AREA
	MVI	M,0A3H		;MAKE IT AN OTI CMD....
FRD	EQU	$		;LABEL
	ENDIF

	IF	DMA
	LXI	H,DMAS1		;INITIALIZE DMA
	LXI	B,0600H		;
	OUTIR			;WRITE TO DMA
	LXI	H,DMAS2F	;
	LXI	B,0400H		;
	OUTIR			;WRITE TODMA
	LXI	H,DMAS3		;
	LXI	B,0700H		;
	OUTIR			;WRITE TO DMA
	ENDIF

	MVI	C,007H		;PORT ADDRESS FOR I/O
	LHLD	DMAADR		;DMA ADDRESS
	LDA	CMD		;I/O COMMAND
	CALL	FLPYWAIT	;ISSUE COMMAND AND WAIT

	IF	NOT DMA
	LXI     H,SAVE1    	;SETUP TO REPLACE DATA
	LXI     D,066H      	;COPIED FROM NMI LOCATION
	LXI     B,004H		;
	LDIR			;MOVE IT....
	ENDIF

	RET			;RETURN, I/O COMPLETED

;-----------------------------------------------------------------------
;
;	WE WILL NOW CHECK THE STATUS OF THE I/O OPERATION
;		RETURN WITH CONDITION CODE ZERO = NO RETRY
;		RETURN WITH CONDITION CODE NON ZERO = RETRY
;
;-----------------------------------------------------------------------

CHECK$STAT:
	LXI	H,ERFLAG	;POINT TO ERROR INDICATOR
	MVI	M,000H		;ASSUME OK
	LXI	H,STATUS	;CHECK STATUS
	LDA	MASK		;MASK FOR UNWANTED BIT REMOVAL
	ANA	M		;
	MOV	M,A		;SAVE CLEANED STATUS
	RZ                 	;OK, SO RETURN

CHKS0:
	CALL	RETMOD		;
	CPI	003H		;HARD DISK ??
	LXI	H,STATUS	;
	MOV	A,M		;RELOAD STATUS BYTE
	JRNC	CHKS2		;YES, CHECK FOR DRIVE READY

CHKS1:
	CPI	080H		;IS FLOPPY DISK NOT READY ???
	JRZ	BADIO		;YES, DONT BOTHER WITH RETRY OR MESSAGE
	JR	CHKS3		;GO TO BAD MESSAGE ROUTINE

CHKS2:
	CPI	000H		;IS HARD DISK NOT READY ??
	JRZ	BADIO		;YES, BYPASS ERROR MESSAGE AND COUNTING
	ANI	01000000B	;IS IT WRITE FAULT ??
	JRZ	CHKS3		;NO, CONTINUE ON
	CALL	POINT		;POINT TO TRACK REGISTER
	XCHG			;POINT TO SELECT MASK
	MOV	A,M		;
	ORI	01000000B	;TURN ON WRITE FAULT CLEAR
	OUT	020H		;
	MOV	A,M		;RESET CLEAR
	OUT	020H		;
	MVI	C,20		;DELAY JUST TO BE SAFE
	CALL	DELAY		;

CHKS3:
	LDA	HOME$TOGGLE
	ORA	A		;IS A HOME NEEDED ON THIS RETRY?
	JRNZ	CHKS4		;IF NOT...BRANCH

	LDA	STATUS		;SAVE STATUS OVER HOME
	PUSH	PSW		;
	CALL	HOME		;RESET DEVICE TO HOME
	POP	PSW		;
	STA	STATUS		;SAVE FOR ERROR MESSAGE

CHKS4:
	LXI	D,TCNT		;BUMP TEMP ERROR COUNT
	CALL	ADDERRORS	;
	LXI	H,T$RETRIES	;PICKUP RETRY COUNT
	DCR	M		;DECREMENT COUNT OF RETRIES
	RNZ			;

	LXI	D,PCNT		;BUMP PERMANENT ERROR COUNT
	CALL	ADDERRORS	;
	CALL	P$ERROR		;PRINT PERMANENT ERROR MESSAGE

BADIO:
	LXI	H,ERFLAG	;SET PERMANENT ERROR
	MVI	M,001H		;DO IT....
	XRA	A		;RESET TO PRECLUDE RETRIES
	RET			;RETURN TO CALLER

ADDERRORS:
	LHLD	DISKNO		;BUMP COUNT OF DISK ERRORS
	MVI	H,000H		;
	DAD	D		;POINT TO ERROR REGISTER
	INR	M		;
	RET			;

	PAGE
;-----------------------------------------------------------------------
;
;	SERIAL PRINTER ROUTINE (WITH SEPARATE BUSY TEST FOR SPOOLER)
;
;-----------------------------------------------------------------------

PRSTAT:
	MVI	A,10H	   	;RESET INT BIT
	OUT	1FH	   	;SEND IT TO 'SIO'
	IN	1FH	   	;READ STATUS
	ANI	00001100B	;CHECK FOR DTR AND TXE
	CPI	00001100B	;WE MUST HAVE BOTH TO SEND NEXT BYTE
	MVI	A,0FFH		;ASSUME READY FOR CHARACTER
	RZ			;RETURN IF READY
	XRA	A		;SHOW STILL BUSY
	RET			;RETURN TO CALLER
;
;	WE WILL NOW PERFORM THE PRINT FUNCTION BUSY TEST
;

LSTBSY:
	CALL	PRSTAT		;CHACK CURRENT STATUS
	CPI	0FFH		;READY ??
	JRNZ	LSTBSY		;NO, CHECK AGAIN
	RET			;ITS NOW READY TO ACCEPT NEXT CHARSCTER

LIST:
	CALL	LSTBSY		;WAIT FOR PRINTER TO FREE UP
        MOV     A,C
        OUT     1EH
        RET


	PAGE



;-----------------------------------------------------------------------
;
;	CENTRONICS PRINTER ROUTINE (WITH SEPARATE BUSY TEST FOR SPOOLER)
;
;-----------------------------------------------------------------------

CNSTAT:
	MVI	A,001H		;TO SET STROBE HIGH
	OUT	010H		;
	IN	010H		;READ PRINTER STATUS
	ANI	020H		;REMOVE ALL BUT BUSY BIT
	MVI	A,0FFH		;ASSUME NOT BUSY
	RZ			;CHECK ASSUMPTION
	XRA	A		;SET TO SHOW STILL BUSY
	RET			;
;
;	WE WILL NOW PERFORM THE PRINT FUNCTION BUSY TEST
;
CNTBSY:
	CALL	CNSTAT		;CHECK STATUS OF PRINTER
	CPI	0FFH		;READY ??
	JRNZ	CNTBSY		;NO, WAIT HERE
	RET			;

CLIST:
	CALL	CNTBSY		;WAIT FOR PRINTER TO FREE UP
	MOV	A,C		;CHARACTER TO PRINT
	OUT	011H		;WRITE IT TO DATA PORT
	MVI	A,000H		;TO FORCE STROBE LOW
	OUT	010H		;
	MVI	A,001H		;TO FORCE STROBE HIGH
	OUT	010H		;
	RET			;

	PAGE
;-----------------------------------------------------------------------
;
;	INTERRUPT VECTORS
;
;-----------------------------------------------------------------------

	ORG	(($+0A2H) AND 0FF00H)+05EH
INTERUPT:
	DW	FLOPPY$INT		;FLOPPY DISK INTERRUPT
	DW	NULL$INT		;
	DW	NULL$INT		;
	DW	NULL$INT		;
	DW	NULL$INT		;
	DW	NULL$INT		;

	IF	HARDSK
	DW	HARD$INT		;HARD DISK INTERRUPT
	ELSE
	DW	NULL$INT
	ENDIF


;-----------------------------------------------------------------------
;
;	DISK INTERRUPT ROUTINE
;
;-----------------------------------------------------------------------

FLOPPY$INT:
	PUSH	PSW
	PUSH	H
	LXI	H,FLPYBYTE	;ARE WE WAITING ON FLOPPY I/O?
	MOV	A,M
	ORA	A
	IN	004H		;GET STATUS IN ANY CASE
	JRNZ	FLOPPY$I1	;IGNORE INTERRUPT IF NOT WAITING FOR FLOPPY
	STA	STATUS		;SAVE STATUS
	MVI	M,0FFH		;CHANGE FLAG TO SHOW I/O COMPLETE

FLOPPY$I1:
	POP	H
	POP	PSW
NULL$INT:
        EI			;ENABLE SYSTEM
	RETI			;RETURN FROM INTERRUPT

	IF	HARDSK
HARD$INT:
	PUSH	PSW
	PUSH	H
	LXI	H,HARDBYTE	;ARE WE WAITING FOR HARD DISK INTERRUPT?
	MOV	A,M
	ORA	A
	IN	024H		;GET STATUS IN ANY CASE
	JRNZ	HARD$I1		;DO NOTHING IF NO HARD DISK I/O PENDING
	STA	STATUS		;SAVE FOR CHECK LATER
	MVI	M,0FFH		;SHOW I/O IS COMPLETE

HARD$I1:
	XRA	A		;RESET INTERRUPT BY RELOADING
	OUT	023H		;... COMMAND REGISTER
	POP	H
	POP	PSW
	JR	NULL$INT	;EXIT INTERRUPT
	ENDIF
	PAGE
FLPYWAIT:
	LXI	H,FLPYBYTE
	MVI	M,0		;SHOW THAT I/O IS PENDING
	OUT	004H		;OUTPUT COMMAND TO 1771 OR 1791

	MVI	A,4		;SET A 4 SECOND TIME LIMIT
FLPYW0:	STA	TIMING0
	LXI	H,48780		;1 SECOND MAX PER LOOP
	SHLD	TIMING1

FLPYW1:
	LHLD	TIMING1
	DCX	H
	SHLD	TIMING1
	MOV	A,H
	ORA	L		;CHECK FOR END OF 1 SECOND
	JRZ	FLPYW2		;BRANCH IF END OF 1 SECOND

	LDA	FLPYBYTE
	ORA	A
	JRZ	FLPYW1		;LOOP UNTIL I/O COMPLETE

	RET

FLPYW2:
	LDA	TIMING0
	DCR	A		;HAS TOTAL TIME ELAPSED?
	JRNZ	FLPYW0		;IF NOT, REPEAT LOOP

;				;HERE WE HAVE TIMED OUT.  1791 HAS DIED.
	IN	009H		;GET BANK IN CASE THIS IS BIG BOARD
	ANI	00011000B	;MASK OUT EVERYTHING ELSE
	OUT	009H		;START RESET OF 1791
	MVI	C,1
	CALL	DELAY		;WAIT 1 MILLISECOND
	ORI	00000010B
	OUT	009H		;END RESET
	LDA	NEWDSK
	STA	DISKNO		;MAKE SURE CURRENT DISK & OLD DISK ARE SAME
	MVI	A,10010000B
	STA	STATUS		;SHOW I/O ERROR
	LHLD	FLPYTCNT
	INX	H
	SHLD	FLPYTCNT		;COUNT NUMBER OF TIMES 1791 DIES
	RET

TIMING0:
	DB	0
TIMING1:
	DW	0
FLPYTCNT:
	DW	0
FLPYBYTE:
	DB	0FFH		;INIT TO SHOW NO I/O PENDING


	IF	HARDSK
HARDWAIT:
	LXI	H,HARDBYTE
	MVI	M,0		;SHOW I/O IS PENDING FOR HARD DISK
	OUT	023H		;OUTPUT COMMAND TO HARD DISK CONTROLLER

HARDW1:
	LDA	HARDBYTE
	ORA	A
	JRZ	HARDW1		;LOOP UNTIL I/O COMPLETE

	RET

HARDBYTE:
	DB	0FFH		;INIT TO SHOW NO I/O PENDING

	ENDIF

	PAGE

;-----------------------------------------------------------------------
;
;	UTILITY SUBROUTINE FOR 16 BIT COMPARE
;
;-----------------------------------------------------------------------

	IF	HARDSK
NEWTRKCMP:
	XCHG			;HL = .UNATRK OR .HSTTRK
	LXI	H,NEWTRK	;
	LDAX	D		;LOW BYTE COMPARE
	CMP	M		;SAME ??
	RNZ			;RETURN IF NOT
	INX	D		;TO CHECK HIGH BYTE
	INX	H		;
	LDAX	D		;
	CMP	M		;SETS FLAGS
	RET			;
	ENDIF

;----------------------------------------------------------------------
;
;	Routine to translate sector number
;
;----------------------------------------------------------------------

SECTRAN:
	XCHG			;TABLE ADDRESS WAS IN <DE>, NOW IN <HL>
	MOV	A,H		;IS THERE A TABLE ADDRESS ??
	ORA	L		;
	JRZ	STRN2		;IF NO ADDRESS...JUMP

	DAD	B		;ADD SECTOR NUMBER
	MOV	L,M		;LOAD TRANSLATED VALUE
	MVI	H,0
	RET			;NEW VALUE IN <HL>

STRN2:
	DAD	B		;RETURN SECTOR NUMBER WITHOUT TRANSLATE
	LDA	SECTOR$ADJ	;FIND IF FIRST SECTOR IS "0" OR IS "1"
	ORA	A
	RZ			;RETURN IF NO ADJUSTMENT NECESSARY
	INX	H		;ELSE ADD 1
	RET

SECTOR$ADJ:
	DB	1		;"0" = 1ST SECTOR = 0
;				;"1" = 1ST SECTOR = 1


	PAGE

;-----------------------------------------------------------------------
;
;	THIS IS THE MESSAGE DISPLAY ROUTINE
;
;-----------------------------------------------------------------------

MSPRT:
	MOV     A,M        	;MESSAGE PRINTOUT ROUTINE
        ORA     A
        RZ
        INX     H
	MOV	C,A		;SETUP FOR CONOUT
        CALL    CONOUT
	JR	MSPRT		;LOOP UNTIL END OF MESSAGE


;-----------------------------------------------------------------------
;
;	DISK ERROR MESSAGE ROUTINE.
;
;-----------------------------------------------------------------------

P$ERROR:
	LXI	H,PERR		;PERMANENT ERROR
        CALL    MSPRT      	;PRINT " ERROR, DRIVE "
	LDA	DISKNO		;PICKUP DRIVE FOR DISPLAY
	CALL	HEXCONV		;
	LXI	H,TRKERR	;PICKUP " TRACK "
	CALL	MSPRT		;
	LDA	TRAKNO		;PICKUP TRACK FOR DISPLAY
	CALL	HEXCONV		;
	LDA	DISKNO		;IS IT A HARD DISK ??
	CPI	004H		;
	JRC	P$SEC		;NO, DONT PRINT HEAD NUMBER
	LXI	H,HEDERR	;
	CALL	MSPRT		;
	LDA	HEADNO		;PICKUP HEAD NUMBER
	CALL	HEXCONV		;
P$SEC:	LXI	H,SECERR	;SECTOR ERROR MESSAGE
	CALL	MSPRT		;
	LDA	SECTNO		;
	CALL	HEXCONV		;
	LXI	H,STERR		;STATUS ERROR MESSAGE
	CALL	MSPRT		;
	LDA	STATUS		;
	CALL	HEXCONV		;
	RET			;

	PAGE

;--------------------------------------------------------------------
;
;	SPECIAL DISK CONTROL ROUTINES
;
;	 LIMIT HOME CALLS FROM BDOS
;
;--------------------------------------------------------------------

HOMEIT:	LDA	NEWDSK		; CHECK FOR FIRST HOME
	CPI	4		;  CHECK FOR FLOPPY
	JC	HOME		;  DO NOT BYPASS FLOPPY HOME
	MOV	C,A		;
	MVI	B,0		; POINT TO PRESENT TRACK STORED

	LDA	HSTWRT		;CHECK FOR PENDING WRITE
	ORA	A
	JRNZ	HOMED
	STA	HSTACT		;CLEAR HOST ACTIVE FLAG
HOMED:

	LXI	H,TRK0		;
	DAD	B		;
	MOV	A,M		; CHECK IF INITIALIZED
	CPI	0FFH		;
	MVI	A,0		;
	RNZ			;  YES -  RETURN WITH NO ERROR
	MOV	M,A		;
	JMP	HOME		;  NO  -  SO REALLY DO IT



	PAGE
;-----------------------------------------------------------------------
;
;	CONSOLE DISPLAY ROUTINE
;
;-----------------------------------------------------------------------

CONOUT:
	MVI	A,10H	   	;RESET INT BIT
	OUT	1DH	   	;SEND IT TO 'SIO'
	IN	1DH	   	;READ STATUS
	ANI	00001100B	;CHECK FOR DTR AND TXE
	CPI	00001100B	;WE MUST HAVE BOTH TO PROCEED
	JRNZ	CONOUT		;LOOP UNTIL CLEAR
        MOV     A,C
        OUT     1CH
        RET

;-----------------------------------------------------------------------
;
;	CONSOLE STATUS ROUTINE
;
;-----------------------------------------------------------------------

CONST:
	XRA      A         	;TEST CONSOLE FOR KEYDOWN
        OUT      1DH
        IN       1DH
        ANI      1
        RZ
        MVI     A,0FFH
        RET

;-----------------------------------------------------------------------
;
;	CONSOLE READ ROUTINE
;
;-----------------------------------------------------------------------

CONIN:
	CALL	CONST		;IS THERE"A CHARACTER WAITING ??
	JRZ	CONIN		;NO, WAIT HERE FOR ONE....
        IN      1CH
        ANI     7FH
        RET

	PAGE
;-----------------------------------------------------------------------
;
;	ROUTINE TO CONVERT ACCUMULATOR TO HEX AND DISPLAY IT
;
;-----------------------------------------------------------------------

HEXCONV:
        PUSH    PSW        	;SAVE IT
        RRC
        RRC                	;SHIFT DOWN TO LOWER NIBBLE
        RRC
        RRC
        CALL    HEXOT      	;PRINT IT OUT IN HEX
        POP     PSW        	;GET ORIGINAL LOWER NIBBLE

HEXOT:
	ANI     0FH        	;PRINT OUT NIBBLE IN HEX
        ADI     '0'
        CPI     '9'+1
	JRC	HX1		;LESS THAN 'A'
        ADI     7
HX1:    MOV     C,A
	CALL	CONOUT		;DISPLAY BYTE
	RET			;

;-----------------------------------------------------------------------
;
;	THIS IS THE DELAY ROUTINE. IT WILL LOOP HERE FOR THE
;	NUMBER OF MILLISECONDS SPECIFIED IN REGISTER C.
;
;-----------------------------------------------------------------------

DELAY:
DEL1:	MVI	B,100		;FORCE DELAY FOR 1 MILLISECOND
DEL2:	NOP			;INSTRUCTIONS TO FILL IN TIME
	DAD	H		;
	DAD	H		;
	DCR	B		;AT ONE MILLISECOND YET ??
	JNZ	DEL2		;NO, KEEP ON LOOPING
	DCR	C		;END OF REQUESTED INTERVAL YET ??
	JNZ	DEL1		;NO, KEEP ON
	RET			;RETURN TO CALLER

	PAGE
;-----------------------------------------------------------------------
;
;	MESSAGES
;
;-----------------------------------------------------------------------

CR	EQU	00DH		;CARRIAGE RETURN
LF	EQU	00AH		;LINE FEED

MSG:	DB	CR,LF
	IF	RELOC
	DB	'00'		;FILLED IN BY CPMOVE
	ENDIF
	IF	NOT RELOC
	DB	MSIZE/10+'0',MSIZE MOD 10 +'0'
	ENDIF
	DB	'K ALTOS DOS VERS '
	DB	VERSION/10+'0','.',VERSION MOD 10 +'0'
	DB	ALTOSV+'0'	;ALTOS VERSION NUMBER
CRLF:	DB	CR,LF		;
        DB      0
;
PERR:	DB	CR,LF,'PERMANENT DISK ERROR, DRIVE ',0
TRKERR:	DB	' TRACK ',0
HEDERR:	DB	' HEAD ',0
SECERR:	DB	' SECTOR ',0
STERR:	DB	' STATUS ',0

MSGEWAIT:
	DB	CR,LF,'E: NOT READY...WAITING'
	DB	0

MSGNOCPM:
	DB	CR,LF,'CPM',MSIZE/10+'0',MSIZE MOD 10 +'0'
	DB	'.COM NOT ON E: USER 0'
	DB	CR,LF,'WARM BOOT FROM A:'
	DB	0

CPMFCB:
	DB	5,'CPM',MSIZE/10+'0',MSIZE MOD 10 +'0'
	DB	'   COM',0,0,0,0
CFCBLEN	EQU	$-CPMFCB

BIOSLN	EQU	$-BIOS		;LENGTH OF THIS BIOS

	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0		; SAVE AREA RESERVED

	IF	HARDSK
						;     PIN CONFIGURATION

DSCN0:	DB	00H,00H,00H,00H,00H,00H,00H,00H
	DB	10H,00H,00H,00H,00H,00H,10H,00H		;  1
	DB	90H,90H,90H,00H,00H,00H,00H,00H		;  2
	DB	00H,00H,00H,00H,00H,00H,00H,00H
	DB	10H,00H,00H,20H,00H,00H,10H,20H		;  4
	DB	00H,00H,00H,00H,00H,00H,00H,00H
	DB	90H,90H,90H,20H,00H,00H,00H,20H		;  6
	DB	90H,90H,90H,0A0H,0A0H,0A0H,0H,0H	;  7
	ENDIF

;-----------------------------------------------------------------------
;
;	[THE FOLLOWING CODE IS EXECUTED ONLY ONCE AT COLD BOOT]
;
;-----------------------------------------------------------------------

MOREBOOT:
	LDA	MPARMS		;CHECK PARAMETERS FOR CENTRONICS
	ANI	00000010B	;....PRINTER SUPPORT
	JRZ	PRTOK		;IF NOT, DON'T CHANGE ANYTHING

	LXI	H,CLIST		;ELSE MODIFY ADDRESSES
	SHLD	WBOTE+13
	LXI	H,CNSTAT
	SHLD	WBOTE+43
	LXI	H,CNTBSY	;UPDATE SPOOLER LIST
	SHLD	SPOOLER+1
	SHLD	SPOOLER+3
	SHLD	SPOOLER+5
	SHLD	SPOOLER+7
	MVI	A,003H		;INIT PARALLEL PORT FOR CENTRONICS
	OUT	013H
	MVI	A,00FH
	OUT	013H

PRTOK:
	XRA	A
	STA	IOBYTE		;ZERO THE IOBYTE
	STA	CDISK		;ZERO THE CURRENT DISK DRIVE
	LXI	B,3		;SET THE MODE FOR FLOPPIES INITIALIZED BY "SETUP"

MODESET:
	CALL	SELDSK		;SELECT DRIVE FOR MODESET
	LXI	H,MODE
	DAD	B		;POINT TO CORRECT MODE BYTE
	PUSH	B		;SAVE COUNT OF DRIVES
	MOV	C,M
	CALL	SETMOD		;SET THE MODE
	POP	B
	DCR	C
	JP	MODESET		;DO ALL THE FLOPPY DISK DRIVES

;-----------------------------------------------------------------------
;
;	SET UP DISK CONFIGURATON
;
;-----------------------------------------------------------------------
;
SDCONF:	LXI	H,SEL0+2	;POINT TO DRIVE C:
	LDA	MPARMS		;
	ANI	05H		; TEST FOR FOUR FLOPPIES
	JR	SDDBL		;  YES  SKIP THE ZAP
	MOV	M,A		;
	INX	H		; ZAP C: AND  D:
	MOV	M,A		;
SDDBL:
	IF	HARDSK
	LXI	D,SEL0+4	;POINT TO DRIVE E:
	IN	025H		;READ CONFIGURATION PORT
	ANI	07H		;STRIP OFF HIGH PART
	RAL			;
	RAL			;
	RAL			;
	MVI	B,0		;
	MOV	C,A		;POINT TO CONFIGURATION TABLE
	LXI	H,DSCN0		;
	DAD	B		;  INDEX TO RIGHT ENTRY
	MVI	B,8		;
SDL1:	MOV	A,M		; CHECK ALL 8 POSSIBILITIES
	STAX	D		;      -  CHANGE SELECT MASKS
SDOK:	INX	D		; NEXT
	INX	H		;  DRIVE
	DJNZ	SDL1		;
	ENDIF
	IF	NOT HARDSK
	LXI	H,SEL0+4	;POINT TO DRIVE E:
	MVI	B,8		;
	XRA	A		;
SDL2:	MOV	M,A		; ZAP ALL HARD DRIVES
	INX	H		;
	DJNZ	SDL2		;
	ENDIF			;

	LXI	H,STEPRATE
	MVI	M,002H		;SET 10 MSEC STEP RATE FOR SINGLE SIDED FLOPPY
	LDA	MPARMS
	ANI	00000001B	;CHECK FOR DOUBLE SIDED FLOPPY
	JRZ	SDLXIT		;GO ON IF SINGLE SIDED
	MVI	M,000H		;SET 3 MSEC STEP RATE FOR DOUBLE SIDED FLOPPY

SDLXIT:	RET			;FINISH OTHER INITIALIZATION


	ORG	BIOS+BIOSLN


	PAGE
;-----------------------------------------------------------------------
;
;	THE FOLLOWING AREA CONTAINS THE DISK/WORK SAVE AREAS
;	USED BY THE CBIOS IN THE NORMAL COURSE OF ACTIVITY.
;
;-----------------------------------------------------------------------

BEGDAT	EQU	$			;START OF BDOS AREAS
CMD:	DB	0			;COMMANDS FOR NEXT I/O
MASK:	DB	0			;STATUS MASKS BUFFER FOR DISK I/O
STATUS:	DB	0			;STATUS SAVE LOCATION FOR DISK I/O

	IF	NOT DMA
SAVE1:	DB	000H,000H,000H,000H	;SAVE AREA FOR NMI ROUTINE
	ENDIF

PTCHSAVE:
	DW	0			;SAVE OF JMP ADDRESS FOR BDOS PATCH

P$RETRIES: DB	000H			;COUNTER FOR PERMANENT ERRORS
T$RETRIES: DB	000H			;COUNTER FOR TEMPORARY ERRORS
HOME$TOGGLE:
	DB	000H			;INDICATOR TO TELL HARD DISK ERROR RECOVERY
;					;.. IF HOME SHOULD BE DONE BEFORE NEXT I/O

WARMSAVE:
	DW	0			;TRACK # ON E: OF CPMNN.COM

STEPRATE: DS	1			;STEP RATE FOR FLOPPY HOMES & SEEKS
;					;...  3 MSEC FOR DOUBLE SIDED
;					;... 10 MSEC FOR SINGLE SIDED

NEWDSK:	DS	1			;SEEK DISK NUMBER
NEWTRK:	DS	2			;SEEK TRACK NUMBER
NEWSEC:	DS	1			;SEEK SECTOR NUMBER

HSTDSK:	DS	1			;HOST DISK NUMBER
HSTTRK:	DS	2			;HOST TRACK NUMBER
HSTSEC:	DS	1			;HOST SECTOR NUMBER

NEWHST:	DS	1			;SEEK SHR SECSHF
HSTACT:	DS	1			;HOST ACTIVE FLAG
HSTWRT:	DS	1			;HOST WRITTEN FLAG

UNACNT:	DS	1			;UNALLOCATED RECORD COUNT
UNADSK:	DS	1			;LAST UNALLOCATED DISK
UNATRK:	DS	2			;LAST UNALLOCATED TRACK
UNASEC:	DS	1			;LAST UNALLOCATED SECTOR

ERFLAG:	DS	1			;ERROR REPORTING
RSFLAG:	DS	1			;READ SECTOR FLAG
READOP:	DS	1			;1 IF READ OPERATION
WRTYPE:	DS	1			;WRITE OPERATION TYPE

DIRBUF:	DS	128
ALV0:	DS	31
CSV0:	DS	32
ALV1:	DS	31
CSV1:	DS	32
ALV2:	DS	31
CSV2:	DS	32
ALV3:	DS	31
CSV3:	DS	32
	IF	HARDSK
ALV4:	DS	64
CSV4:	DS	0
ALV5:	DS	64
CSV5:	DS	0
ALV6:	DS	64
CSV6:	DS	0
ALV7:	DS	64
CSV7:	DS	0
ALV8:	DS	64
CSV8:	DS	0
ALV9:	DS	64
CSV9:	DS	0
ALVA:	DS	36
CSVA:	DS	0
ALVB:	DS	36
CSVB:	DS	0

	DS	1			;MUST PRECEDE HSTBUF
HSTBUF:	DS	1024			;HOST BUFFER AREA
	ENDIF

DATSIZE	EQU	$-BEGDAT

	END
