;ROUTINE TO TEST INTERRUPT CIRCUITRY OF Z-80 BOARD
;8 ROUTINES FROM 0 THROUGH 8 AND UP TO 38H WILL BE INITIALIZED
;GENERATING AN INTERRUPT BY HAND SHOULD CAUSE THE Z-80 TO EXECUTE THE 
;THE APPROPRIATE ROUTINE.  REQUIRES GODBOUT OPERATING SYSTEM,WITH
;INTERFACER ADDRESSED AT 0.
STATUS	EQU	1	;INTERFACER STATUS PORT
DATA	EQU	0	;INTERFACER DATA PORT
TBE	EQU	1	;INTERFACER TRANSMITTER BUFFER EMPTY BIT
CR	EQU	0AH	;CARRIAGE RETURN
LF	EQU	0DH	;LINE FEED
PRINT	EQU	9H	;PRINT STRING IN DE REGISTER
BDOS	EQU	5
	ORG	100H
	LXI	SP,80H
;
	LXI	D,CPYMSG  ;COPYRIGHT MESSAGE
	MVI	C,PRINT
	CALL	BDOS
;
;MOVE CODE FROM VECT0 TO VECT7 + 8 INTO RAM BEGINNING AT 0
	LXI	H,VECT0	;HL POINTS TO SOURCE ADDRESS 
	LXI	D,0	;DESTINATION ADDRESS
	MVI	C,40H	;LENGTH OF ROUTINES
MOVEIT:	MOV	A,M	;BYTE TO MOVE INTO REG A
	XCHG		;HL HAS DESTINATION ADDRESS
	MOV	M,A	;CODE INTO LOWER MEMORY
	XCHG		;SWAP BACK
	INX	H	;NEXT SOURCE ADDRESS
	INX	D	;NEXT DESTINATION ADDRESS
	DCR	C	;DECREMENT COUNTER
	JNZ	MOVEIT	;KEEP GOING
WATE:   DI		;ENABLE INTERRUPTS
	MVI	B,21H	;EXCLAMATION MARK INTO B
	CALL	HAND   	;CALL HANDSHAKE ROUTINE
	EI
	JMP	WATE	;WAIT FOR INTERRUPT 
HAND:	DI
	IN	STATUS	;PUT STATUS INTO REG A
	ANI	TBE	;SEE IF IT'S READY  
	JZ 	HAND	;IF NOT READY START OVER
	MOV	A,B	;CHARACTER TO PRINT INO A
	OUT	DATA	;OUTPUT REG A TO TERMINAL
	RET
;
VECT0:	MVI	B,'0'	;VECTOR LINE NUMBER INTO B REG
	JMP	HAND	;OUTPUT 
	NOP
	NOP
	NOP
VECT1:	MVI	B,'1'	;VECTOR LINE NUMBER INTO B REG
	JMP	HAND	;OUTPUT
	NOP	
	NOP
	NOP
VECT2:	MVI	B,'2'	;VECTOR LINE NUMBER INTO B REG
	JMP	HAND	;OUTPUT
	NOP
	NOP
	NOP
VECT3:	MVI	B,'3'	;VECTOR LINE NUMBER INTO B REG
	JMP	HAND	;OUTPUT
	NOP
	NOP
	NOP
VECT4:	MVI	B,'4'	;VECTOR LINE NUMBER INTO B REG
	JMP	HAND	;OUTPUT
	NOP
	NOP
	NOP
VECT5:	MVI	B,'5'	;VECTOR LINE NUMBER INTO B REG
	JMP	HAND	;OUTPUT
	NOP
	NOP
	NOP
VECT6:	MVI	B,'6'	;VECTOR LINE NUMBER INTO B REG
	JMP 	HAND	;OUTPUT
	NOP
	NOP
	NOP
VECT7:	MVI	B,'7'	;VECTOR LINE NUMBER INTO B REG
	JMP	HAND	;OUTPUT
	NOP
	NOP
	NOP
CPYMSG:	DB	CR,LF,'COPYRIGHT COMPUPRO 1983'
	DB	CR,LF,CR,LF,'$'
