; LAST UPDATED:		20 JULY 84
; REASON FOR UPDATE:	The boot ROM will now load all of track 0, head 0,
;		26 single density 128 byte sector format sectors, if a floppy
;		disk (8 inch) is present.  If not, it will attempt to boot from
;		a 5 1/4" floppy.        				rrs
;		
;
; PROGRAM NAME:		PROM1A3.ASM
;
; PURPOSE:	3rd routine for Disk 1A boot rom:  8 or 5 1/4 inch Floppy
;		Disk initial program loader (IPL), which consequently will load
;		the remainder of the operating system upon execution entry.
;
;	==========================	Copyright 1984, CompuPro Corporation,
;	|| 8- OR 5 1/4-INCH	|| 	A division of Godbout Electronics.
;	||  FLOPPY DISK PROM	||	3506 Breakwater Court
;	||   POWER UP LOADER	||      Hayward, CA  94545
;	||			||
;	==========================
;
;	This product is a copyright program product of CompuPro and is
;	supplied for use with the CompuPro Disk controllers.
;
; Disk layout Definition.
;
;  Cylinder 0,  Head 0,  8 inch disk = 26 X 128 byte single density sectors.
;
;	The code is loaded starting at XBOOT and may be
; any type of secondary loader or the runtime operating system itself.
;
;
; LIBRARY CONSTANTS:
	MACLIB	COMPUPRO	;Disk and Serial/Parallel interface constants
	MACLIB	ACTIVE		;Flags directing construction for the various
;
; EQUATED CONSTANTS:
;
ENTRY	EQU	100h			;Org address (= 0, for ROM)
HIRAM	EQU	8000h			;RAM offset of ROM so loader doesn't overlay 2nd page
RBOOT	EQU	ENTRY+200h+HIRAM	;end of PROM in RAM
XBOOT	EQU	100h			;Base Location of second phase loader in RAM
; Drive specific constants. (Set to handle nearly any drive)
SRT	EQU	16 - 10		;10 millisecond step rate for controller value
HUT	EQU	240 / 16	;Head unload delay time in milliseconds (240)
HDLT	EQU	(35 + 1) / 2	;Head load time in milliseconds (35)
;
; controller port for Disk 1A at 0C0h--8 inch drives
FDPORT	EQU	0C0h	; FDC port
FDDRS	EQU	0	; special select register -- Disk 1A only
NS$128	EQU	26	; 128 byte sectors / track	-- 3.25K
NS$256	EQU	26	; 256 byte sectors / track	-- 6.5K
NS$512	EQU	15	; 512 byte sectors / track	-- 7.5K
NS1024	EQU	 8	;1024 byte sectors / track	-- 8K bytes total
;
; 5 1/4" drives
NS5$128	EQU	18	; 128 byte sectors / track	-- 2.25K
NS5$256	EQU	18	; 256 byte sectors / track	-- 4.5K
NS5$512	EQU	 8	; 512 byte sectors / track	-- 4K (IBM PC compatible)
NS51024	EQU	 5	;1024 byte sectors / track	-- 5K bytes total
;	ROM Bootstrap loader.

;
    ASEG
	ORG	ENTRY		;Base address of bootstrap PROM
	NOP! NOP! NOP! NOP	;8080 power up delay opcodes
INIT:	MVI	A,0FFh		;Turn on disk motors, leave PROM active
	OUT	FDPORT+FDON
;
; Loop on total error to this point.
	LXI	B,04000h	;init delay count
DELAY	EQU	$-ENTRY
	XTHL!	XTHL		;safe but time-consuming instructions
	DCX B!	MOV A,B! ORA C	;bump count, test if done
	JNZ	DELAY		;wait till time passes
; read ROM and write to RAM
ROMOVE:	LXI	H,RBOOT-HIRAM-ENTRY	;point to end of ROM
	LXI	D,RBOOT-ENTRY		;point to end of RAM
ROMOV1	EQU	$-ENTRY
	MOV	A,M		;read ROM byte
	STAX	D		;write to RAM
	DCX	D		;point to next byte
	DCX H!	MOV A,L! ORA H	;bump count (also pointer)
	JNZ 	ROMOV1		;loop if more bytes left to move
;
	JMP	START8		;jump to code located in high RAM
WAIT	EQU	$+HIRAM-ENTRY		;delay subroutine
	LXI	B,0C000h	;init delay count
WAIT0	EQU 	$+HIRAM-ENTRY
	XTHL!	XTHL		;safe but time-consuming instructions
	DCX B!	MOV A,B! ORA C	;bump count, test if done
	JNZ	WAIT0		;wait till time passes
	RET
;
START8	EQU	$+HIRAM-ENTRY
	LXI	D,CLOCK		;point to 8" data clock parameter
START	EQU	$+HIRAM-ENTRY
	MVI	A,0FEh		;turn on motors and disable ROM
	OUT	FDPORT+FDON	;send command
	LDAX	D		;set data clock
	OUT	FDPORT+FDDRS	;send to special select register
	CALL	WAIT		;let command settle
; Load Specify Command.
	INX	D		;point to SPECIFY command sequence
	MVI	B,LSPEC		;Length in "B"
SPEC1	EQU	$+HIRAM-ENTRY
	IN	FDPORT+FDCS	;See if ready to accept next byte
	ORA	A
	JP	SPEC1		;Wait if not ready
	LDAX	D		;Load command byte
	OUT 	FDPORT+FDCD	;to controller command port
	INX	D		;Point to next byte
	DCR	B		;Bump count until all loaded
	JNZ	SPEC1		;Loop if more to do
	CALL	WAIT		; let command settle
;
; Recalibrate drive.
	MVI	B,LRECAL	;Length of command in "B"
RCAL1	EQU	$+HIRAM-ENTRY
	IN	FDPORT+FDCS	;See if ready to accept next byte
	ORA	A
	JP	RCAL1		;Wait if not ready
	LDAX	D		;Load command byte
	OUT 	FDPORT+FDCD	;to controller command port
	INX	D		;Point to next byte
	DCR	B		;Bump count until all loaded
	JNZ	RCAL1		;Loop if more to command load
;
RCAL2	EQU	$+HIRAM-ENTRY
	IN	FDPORT+INTS	;See if command execution completed
	ORA	A
	JP	RCAL2		;Wait if not
;
; Verify successful completion of recalibrate command.
	MVI	A,FD$RSTS	;"Read Status" command
	OUT	FDPORT+FDCD	; to controller
	CALL	WAIT		; blink drive light
;
RCAL3	EQU	$+HIRAM-ENTRY
	IN	FDPORT+FDCS	;See if command accepted
	ORA	A
	JP	RCAL3		;Loop until ready
	IN	FDPORT+FDCD	;Get first resulting "Status Byte"
	XRI	20h		;Flip "drive ready" status bit
	MOV	C,A		;Put result in "C"
RCAL4	EQU	$+HIRAM-ENTRY
	IN	FDPORT+FDCS	;Get command execution status again
	ORA	A
	JP	RCAL4		;See if seek complete
	IN	FDPORT+FDCD	;Get second "execution" result byte
	ORA	C		;Combine the two result status bytes
	ANI	0FCh		;mask drive bits
	JNZ	TSTDRV		;if error, try other drive
				;otherwise fall through to READ
;
; Execute read operation sequence until loaded successfully.
	MVI	B,LDMA		;Length of DMA data
;
; Output beginning DMA address.
ADDR	EQU	$+HIRAM-ENTRY
	LDAX	D		;Get byte of extended address
	OUT	FDPORT+FDMA	;Send to DMA port of DISK 1
	INX	D		;Next byte to xfer
	DCR	B		;Bump count
	JNZ	ADDR		;Loop until all 3 bytes loaded
;
; Read all the data on track 0 in to get the cold boot loader.
	MVI	B,LREAD		;Load "B" with command lenght
READ1	EQU	$+HIRAM-ENTRY
	IN	FDPORT+FDCS	;Get controller status
	ORA	A
	JP	READ1		;Wait until controller ready for another byte
	LDAX	D		;load command byte
	OUT 	FDPORT+FDCD	; to controller
	INX	D		;Point to next byte to load
	DCR	B		;Bump command load count
	JNZ	READ1		;Loop if more bytes to load
;
READ2	EQU	$+HIRAM-ENTRY
	IN	FDPORT+INTS	;See if interrupt active (command complete)
	ORA	A
	JP	READ2		;Loop until so
;
READ3	EQU	$+HIRAM-ENTRY
	IN	FDPORT+FDCS	;See if ready to read status
	ORA	A
	JP	READ3		;Wait if not
	IN	FDPORT+FDCD	;Get resulting status of read operation
	SUI	40h		;Remove "abnormal ending" status bit
	ANI	0FCh		;mask drive bits
	MOV	H,A		;Put result in "H"
READ4	EQU	$+HIRAM-ENTRY
	IN	FDPORT+FDCS	;Get second status byte
	ORA	A
	JP	READ4		;Loop until ready
	IN	FDPORT+FDCD	;Second status byte in "L"
	XRI	FD$EOC		;Remove "End of Cylinder" bit
	MOV	L,A		;Put result in "D"
;
	MVI	B,7-2		;Count of remaining status bytes (ignored)
READ5	EQU	$+HIRAM-ENTRY
	IN	FDPORT+FDCS	;See if controller ready
	ORA	A
	JP	READ5		;Loop if not
	IN	FDPORT+FDCD	;Read status byte, ignore it
	DCR	B		;Bump remaining count
	JNZ	READ5		;Wait until all done
; If "Abnormal Ending" caused by "End of Cylinder" error, then read is valid.
	MOV A,L!  ORA	H	;Combine the two significant status bytes
	JZ	BOOTVEC		;Exit from boot PROM if successful

				;otherwise, fall through to drive test
				;to choose next drive
TSTDRV	EQU	$+HIRAM-ENTRY
	MOV	A,E		;LOB of floppy data addres
	CPI	low DATA55	;error after HOME on 5 1/4"
	JZ	START8		;if equal, try 8"
	CPI	low READ55 + LREAD	;error after READ on 5 1/4"
	JZ	START8		;if equal, try 8" -- otherwise try 5 1/4"
	LXI	D,CLOCK55	;CY set so poin to 5 1/4" clock
	JMP	START		;and try 5 1/4" next

;
;*******************************************
;*    EXIT ON SUCCESSFUL READ OPERATION    *
;*******************************************
;
BOOTVEC	EQU	$+HIRAM-ENTRY
; instructions after semi-colons in ROM, not test program
 	IN	0C2h		;sense switch value
 				;if bit 4 on then Interfacer 3/4
 				;if bit 4 off then SS
 	RRC!	RRC		;divide by 4	
 	ANI	1		;mask bit 4
 	ORI	2		;add 2 for boot switch value
 	MOV	C,A
	JMP 	XBOOT		;second phase loader
;
	DB	'RR3'
;************************************************
;*	FIXED STORAGE FOR DISK PARAMETERS	*
;************************************************
	ORG	($ and 0FFF0h) + 16	;Next Segment boundary
;
CLOCK	EQU	$+HIRAM-ENTRY
	DB	0		;single-sided 8", 8 MHz clock
SPEC	EQU	$+HIRAM-ENTRY
	DB	FD$SPEC		;Floppy disk specification command
	DB	0DFh
	DB	HDLT SHL 1
LSPEC	EQU	HIRAM+$-ENTRY-SPEC	;Length of specification sequence
;
RECAL	EQU	$+HIRAM-ENTRY
	DB	FD$RECA,0	;Recalibrate command (home to track 0)
LRECAL	EQU	HIRAM+$-ENTRY-RECAL	;Command length
;
; Function data for controller to boot
DATA	EQU	$+HIRAM-ENTRY
	DB	0		;Extended Address
	DB	high XBOOT	;Base address of BOOT loader
	DB	low XBOOT
LDMA	EQU	HIRAM+$-ENTRY-DATA	;Length of DMA to load
;
; Try to read disk as single density 128 byte sectors.
READ	EQU	$+HIRAM-ENTRY
	DB	FD$RDAT		;Read sector(s) command for 8272 controller
	DB	0		;Head select, Drive select = 0
	DB	0		;Cylinder #0
	DB	0		;Head #0
	DB	1		;Starting Record (sector)
	DB	0		;"N" parameter (128 byte sectors)
	DB	NS$128		;Read to end of track = 3.25K bytes
	DB	07h		;GPL (Gap length)
	DB	128		;DTL (Data length)
LREAD	EQU	HIRAM+$-ENTRY-READ	;Length of parameter block to xmit
;
;****************************************************************
;*	FIXED STORAGE FOR 5 1/4 INCH FLOPPY DISK PARAMETERS	*
;****************************************************************
;
CLOCK55	EQU	$+HIRAM-ENTRY
	DB	FD5SL+FDF2S	;double-sided 5 1/4", 4 MHz clock
SPEC55	EQU	$+HIRAM-ENTRY
	DB	FD$SPEC		;Floppy disk specification command
	DB	0DFh
	DB	1Eh		; 15 * 2
;
RECAL55	EQU	$+HIRAM-ENTRY
	DB	FD$RECA		;Recalibrate command (home to track 0)
	DB	2		;drive select
;
; Function data for controller to boot
DATA55	EQU	$+HIRAM-ENTRY
	DB	0		;Extended Address
	DB	high XBOOT	;Base address of BOOT loader
	DB	low XBOOT
;
; Try to read disk as single density 128 byte sectors.
READ55	EQU	$+HIRAM-ENTRY
	DB	FD$RDAT+40h	;Read sector(s) command (MFM)
	DB	2		;Head select, Drive select = 2
	DB	0		;Cylinder #0
	DB	0		;Head #0
	DB	1		;Starting Record (sector)
	DB	3		;"N" parameter (1024 byte sectors)
	DB	NS51024		;Read to end of track = 2.25K bytes
	DB	35h		;GPL (Gap length)
	DB	0FFh		;DTL (Data length)
