***	FBIOS -- Fortran call to BIOS
*
*
**		This FORTRAN-77 callable subroutine provides easy access
*		to CP/M-68K BIOS primitives from a FORTRAN program.  The
*		calling sequence is:
*
*			INTEGER*4 iarray(3)
*			CALL FBIOS (iarray)
*
*		where 'iarray' is an array of two 32-bit words.  Each
*		element of 'iarray' corresponds to an MC68000 DATA register,
*		thus iarray(1) == D0
*		     iarray(2) == D1
*			etc.
*		and 'iarray' MUST be dimensioned at least 3 longwords (to
*		allow for the maximum number of returned values).
*
*		For further information, consult the 'CP/M-68K Operating
*		System SYSTEM GUIDE'.
*
*
*****
*
*
	.globl	FBIOS
*
	.text
FBIOS:
	move.l	4(a7),a0	; get address of iarray
	movem.l	d3-d7/a2-a6,-(a7)
	move.l	a0,-(a7)	; save para pointer
	move.l	(a0)+,d0	;  iarray => D0
	move.l	(a0)+,d1	; iarray(2) => D1
	move.l	(a0),d2
	trap	#3		; call bios
*
	move.l	(a7)+,a0	; restore address of iarray
	move.l	d0,(a0)+	; return values
	move.l	d1,(a0)+
	move.l	d2,(a0)
*
	movem.l	(a7)+,d3-d7/a2-a6
	move.l	(a7)+,(a7)	; pop return address
	rts
*
	.end
