;PROGRAM TO PUT A STANDARD BPNF ROM TAPE TO THE
;CP/M PUN: DEVICE OF THE 100H AREA IN RAM STARTING
;AT 200H
;
.
;
;PROGRAM EXITS TO RST7 - I.E. RETURN TO DDT. CHANGE
;TO RST0 IF A STAND ALONE PROGRAM
;
IFDOS	EQU	1	;PUT OUTPUT TO CP/M PUN:
;
;	PUNCH BPNF TAPE FOR PROM PROGRAMMING
;
SPC	EQU	20H
CR	EQU	13
LF	EQU	10
RUBOUT	EQU	00FFH
LLEN	EQU	4	; BYTES PER LINE
BDOS	EQU	5
;
	ORG	100H
	JMP	START
SIZE:	DW	256	; SIZE OF PROM IN BYTES
;
	IF	IFDOS
PUN:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,C
	MVI	C,4
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
	ENDIF
;
	IF	NOT IFDOS
PUN:	IN	10H
	ANI	10H
	JZ	PUN
	MOV	A,C
	OUT	12H
	RET
	ENDIF
;
LDR:	MVI	B,30
	MVI	C,RUBOUT
;
PLDR:	CALL	PUN
	DCR	B
	JNZ	PLDR
;
	RET
;
BPNF:			; ONE BYTE IN BPNF FORM  IN 'E' 
	MVI	D,8
	MVI	C,'B'
	CALL	PUN
BPLP:	MOV	A,E
	RLC
	MOV	E,A
	ANI	1
	MVI	C,'P'
	JNZ	BPNN
	MVI	C,'N'
BPNN:	CALL	PUN
	DCR	D
	JNZ	BPLP
	MVI	C,'F'
	CALL	PUN
	MVI	C,SPC
	CALL	PUN
	RET
;
;
START:	LXI	SP,STACK
	CALL	LDR
	LXI	D,BUFF
	LHLD	SIZE
	XCHG
	XRA	A	; ZERO LIN CNTR
	STA	LCNT
;
BYLP:			; PUNCH ONE BYTE
	PUSH	D
	PUSH	H
	MOV	E,M
	CALL	BPNF
;
	LDA	LCNT
	INR	A
	STA	LCNT
	CPI	LLEN
	JM	BYLN
;
	MVI	C,CR
	CALL	PUN
	MVI	C,LF
	CALL	PUN
	XRA	A
	STA	LCNT
;
BYLN:	POP	H
	POP	D
	INX	H
	DCX	D
	MOV	A,D
	ORA	E
	JNZ	BYLP
	CALL	LDR
;
	RST	7	; DONE  RETURN TO DDT
	DS	20H
STACK:	DS	0
LCNT:	DS	1
	ORG	200H	;  INPUT BUFFER
BUFF:	DS	0
	END	100H
