;---------------------------------------------------------
;
; PROGRAM TO PATCH CP/M VERSION DSI-3.5
; TO RECOGNIZE BACKSPACE CHARACTER IN CONSOLE INPUT.
;
; VERSION 0.2 - 5 NOV 77
;
; JEFFREY W. SHOOK, P.O. BOX 185, ROCKY POINT, NY 11778
;
;---------------------------------------------------------

; DEFINITIONS

SIZE	EQU	16	; SYSTEM SIZE IN DECIMAL K-BYTES
OFFST	EQU	( SIZE - 16 ) * 1024
DEL	EQU	7FH
BS	EQU	08H

	ORG	OFFST + 33E4H

START:	MOV	A,M
	CPI	DEL
	JZ	LABL1
	CPI	BS
	JNZ	LABL3
LABL1:	MOV	E,A
	XRA	A
	DCR	L
	SUB	M
	JNC	OFFST + 3436H
	DCR	M
	MOV	A,M
	ADI	02
	MOV	C,A
	MVI	B,00
	LHLD	OFFST + 3D34H
	DAD	B
	MVI	A,BS
	CMP	E
	JZ	LABL2
	MOV	A,M
LABL2:	MOV	M,A
	MOV	C,A
	CALL	OFFST + 32DAH
	JMP	OFFST + 3436H
LABL3:	MOV	A,M
	ANI	60H
	JNZ	LABL4
	CALL	OFFST + 3365H
	JMP	OFFST + 3423H
	HLT
	HLT
	HLT
LABL4:	; END OF PATCH

;----------------------------------------------------
;
; SUGGESTIONS FOR INSERTION OF PATCH INTO CP/M
;
;----------------------------------------------------

;     XX = CP/M SYSTEM SIZE IN K-BYTES

; (0) THIS PROCEEDURE ASSUMES THAT YOUR VERSION
;     OF CP/M DSI 3.5 IS STORED IN SYSGEN FORMAT
;     ON THE DISK AS A COM FILE.
; (1) CHANGE SIZE AT THE START OF THIS PROGRAM
;     TO THE CORRECT VALUE FOR YOUR SYSTEM.
; (2) ASSEMBLE THIS PROGRAM.
; (3) RUN DDT, AND EXECUTE FOLLOWING COMMANDS.
; (4) LOAD SYSTEM FILE
;     EG. ICPMXX.COM AND THEN R
; (5) LOAD PATCH HEX FILE WITH OFFSET:
;     EG. IBSPATXXB.HEX
;         R<TOTOFF>
; (6) SAVE PATCHED SYSTEM.
;     EG. ^C - SAVE 35 SYSXX.COM
; (7) PLACE PATCHED SYSTEM ON DISK WITH SYSGEN.
; (8) ENJOY.

; VALUES OF PARAMETERS TO INSERT IN COMMANDS

TOTOFF	EQU	- OFFST - 1F80H

	END
