;************************************************************
;
;		FORMAT.  A PROGRAM FOR FORMATTING DISKETTES
;		IN THE IBM 3740 STANDARD FORMAT FOR USERS
;		OF THE TARBELL FLOPPY DISK INTERFACE.

;************************************************************

;		JAMES A. WILLIS, M.D.
;		3300 BARBERRY LN. SACTAMENTO CA. 95825

;************************************************************
;		THIS PROGRAM IS INTENDED FOR SINGLE
;		DISK INSTALLATIONS AND WILL HALT
;		WHEN CALLED TO ALLOW THE USER TO INSERT
;		THE DISK TO BE FORMATTED.  THE USER THEN
;		MUST START THE PROGRAM AT LOCATION 0200H
;		MANUALLY.  THE PROGRAM WILL THEN FORMAT THE
;		DISK, HALTING AT THE END OF THE OPERATION.
;************************************************************
;		SUBROUTINE DESCRIPTIONS:
;		DISC: FORMATS EACH OF 77 TRACKS IN TURN
;		TRACK:  WRITES 1 TRACK, REG.D CONTAINS
;		        TRACK NUMBER
;		IMAGE:  CREATES AN IMAGE OF THE INFORMATION
;		        TO BE WRITTEN ON EACH TRACK IN CORE
;		        STARTING AT LOACTION 1000H.
;		        TRACK NUMBER IN REGISTER D., SECTOR
;			NUMBER IN REGISTER C.
;
;		NOTE:  THIS SOFTWARE SHOULD BE
;			READILY ADAPTABLE TO OTHER DISK
;			SYSTEMS BY RE-WRITING DISK DRIVER
;			ROUTINES IN SUBROUTINE TRACK.
;************************************************************
            ORG 0100H
START       HLT
;
;
            ORG 0200H
DISC        MVI D,0
            MVI A,3
            OUT 0F8H; OUT HOME
            IN 0FCH; WAIT
;
D1          CALL IMAGE
            CALL TRACK
            MOV A,D;TRACK#TOA
            CPI 4CH; LAST TRACK?
            JZ LAST
            INR D
            JMP D1
;
LAST        HLT
;
;
TRACK       LXI H,1000H
            MOV A,D
            OUT 0FBH;TRACK # DR
            MVI A,13H; LOAD SEEK
            OUT 0F8H; ISSUE SEEK
            IN 0FCH;WAIT
            MVI A,0F4H; WRITE TRACK COMMAND LOAD
            OUT 0F8H;ISSUE WRITE TRACK
;
WLOOP       IN 0FCH; WAIT
            ORA A
            JP DONE
            MOV A,M
            OUT 0FBH;DATA OUT
            INX H
            JMP WLOOP
;
DONE        RET
;
;
;
IMAGE       LXI H,1000H ;ORG OF DATA
            MVI C,40
            MVI B,0
            CALL PUT
;
            MVI C,6
            MVI B,0
            CALL PUT
;
            MVI C,1
            MVI B,0FCH
            CALL PUT
;
            MVI C,26
            MVI B,0
            CALL PUT
;
;SECTOR =1
            MVI E,1;SET E=1 SECTOR1
;
LOOP1       MVI C,6
            MVI B,0
            CALL PUT
;
            MVI C,1
            MVI B,0FEH;ID ADDRESS MARK
            CALL PUT
;
            MVI C,1
            MOV B,D; TRACK 
            CALL PUT
;
            MVI C,1
            MVI B,0
            CALL PUT
;
            MVI C,1
            MOV B,E;SECTOR #
            CALL PUT
;
            MVI C,1
            MVI B,0
            CALL PUT
;
            MVI C,1
            MVI B,0F7H;2 CRC'S
            CALL PUT
;
            MVI C,11
            MVI B,0
            CALL PUT
;
            MVI C,6
            MVI B,0
            CALL PUT
            MVI C,1
            MVI B,0FBH;DATA ADDRESS MARK
            CALL PUT
;
            MVI C,128
            MVI B,0E5H;DATA E5
            CALL PUT
;
            MVI C,1
            MVI B,0F7H; 2CRC'S
            CALL PUT
;
            MVI C,27
            MVI B,0
            CALL PUT
;
            MOV A,E
            CPI 26
            JZ FINIS
            INR E
            JMP LOOP1
;
;
FINIS       MVI C,255; FILL
            MVI B,0
            CALL PUT
            RET

;
;
PUT         MOV A,C
            CPI 0
            RZ
            MOV M,B
            INX H
            DCR C
            JMP PUT
;
;
       