	PRINT "DATA ENTRY PROGRAM OF 3-22-78"
	FIELDS = 20
	ZERO = 0: ONE = 1: TWO = 2
	SEQUENTIAL = ZERO
	RANDOM = 1
	INDEXED = 3
	LINKED = 7
	ALPHA = ONE: NUMERIC = ZERO
	DIM FIELD$(FIELDS),TYPE(FIELDS),WIDE(FIELDS),DATA$(FIELDS)
	DIM FEED(FIELDS),MIN(FIELDS),MAX(FIELDS)
	INPUT "DO YOU WANT INSTRUCTIONS";ANS$
	IF ANS$="NO" THEN 2100
	PRINT "THE PURPOSE OF THIS PROGRAM IS TO ALLOW THE OPERATOR"
	PRINT "TO MAKE ENTRIES INTO A FILE PREVIOUSLY SET UP BY THE"
	PRINT "SET-UP PROGRAM.  EXAMPLES OF SUCH FILES WOULD BE"
	PRINT "A LIST OF ALL THE INTEGRATED CIRCUITS ON HAND, OR"
	PRINT "A LIST OF ALL THE SALES MADE ON A PARTICULAR DATE, OR"
	PRINT "A LIST OF ALL THE ITEMS SHIPPED IN ONE WEEK."
	PRINT "THE FILE IS MADE UP OF RECORDS, AND EACH RECORD"
	PRINT "IS MADE UP OF FIELDS.  THE RECORD MIGHT BE ONE"
	PRINT "INVENTORY ITEM, OR ONE TRANSACTION.  THE FIELD "
	PRINT "MIGHT BE A QUANTITY, A PRICE, OR A PART NUMBER."
	PRINT "THERE ARE PRESENTLY THREE TYPES OF FILES ALLOWED:"
	PRINT "  TYPE 0		SEQUENTIAL"
	PRINT "  TYPE 1		RANDOM"
	PRINT "  TYPE 3		INDEXED-RANDOM"
	PRINT "  TYPE 7		LINKED-INDEXED-RANDOM"
	PRINT "A SEQUENTIAL FILE IS NORMALLY USED FOR ITEMS THAT"
	PRINT "NEED NO CHANGES, SUCH AS A RECEIVING OR SHIPPING LOG."
	PRINT "A RANDOM FILE IS NOT AS COMPACT AS A SEQUENTIAL FILE,"
	PRINT "BUT IT HAS THE ADVANTAGE OF BEING EASY TO MAKE CHANGES."
	PRINT "AN INDEXED FILE ALLOWS QUICK ACCESS TO ANY ENTRY BY"
	PRINT "SPECIFYING A KEY FIELD, SUCH AS A PART NUMBER IN"
	PRINT "AN INVENTORY OR A COMPANY NAME IN AN ORDER FILE."
	PRINT "A LINKED FILE MAKES IT POSSIBLE TO DELETE AND INSERT"
	PRINT "RECORDS, WITHOUT REWRITING THE WHOLE FILE."
	PRINT
	PRINT "AFTER EACH ENTRY:"
	PRINT "ENTER AN AMPERSANS (&) FOR ANOTHER ENTRY."
	PRINT "ENTER A NUMBER SIGN (#) TO CANCEL LAST ENTRY."
	PRINT "ENTER A PERIOD (.) AFTER THE LAST ITEM."
	PRINT
	PRINT "ENTER AN EQUAL SIGN (=) INSTEAD OF A"
	PRINT "DATA ENTRY IF YOU WANT THE SAME DATA"
	PRINT "AS IN THE LAST RECORD."
	PRINT
2100	REM  FILE SELECTION
	INPUT "WHAT IS THE NAME OF THE FILE";FILENAME$
2900	REM  READ A PREVIOUSLY STORED FILE TO THE END.
	FILE FILENAME$
	RECNO = ONE		REM  INIT. RECORD NUMBER.
	REM  READ HEADER (FIRST) RECORD.
	READ #ONE;RECLEN,NO.OF.FIELDS,NHEAD,NIND,FILETYPE,CODE,SPARE
	REM  RECLEN IS RECORD LENGTH.
	REM  NHEAD IS NUMBER OF HEADERS.
	REM  NIND IS NUMBER OF INDEXES.
	REM  FILETYPE IS EXPLAINED ABOVE.
	RECNO = RECNO + ONE		REM  BUMP RECORD NUMBER.
	IF FILETYPE <> SEQUENTIAL THEN \
	    CLOSE ONE :\		REM  THEN CLOSE IT,
	    FILE FILENAME$(RECLEN)	REM  AND REOPEN CORRECTLY.
	N = NO.OF.FIELDS
	IF NHEAD = ZERO THEN 2910	REM  NO HEADINGS?
	REM  READ HEADINGS.
	FOR I = ONE TO NHEAD
	    IF FILETYPE = SEQUENTIAL THEN \
		READ #ONE;HEADINGS$ \	REM  READ THIS WAY.
	    ELSE \			REM  OTHERWISE,
		READ #ONE,RECNO;HEADINGS$
	RECNO = RECNO + ONE
	NEXT I
2910	FOR I = ONE TO NO.OF.FIELDS	REM  READ FIELDS INTO AN ARRAY.
	  IF FILETYPE = SEQUENTIAL THEN \
	    READ #ONE;FIELD$(I),TYPE(I),WIDE(I),FEED(I),MIN(I),MAX(I),SPARE \
	  ELSE \
	    READ #ONE,RECNO;FIELD$(I),TYPE(I),WIDE(I),FEED(I),MIN(I),MAX(I), \
			    SPARE
	RECNO = RECNO + ONE
	NEXT I
2920	IF END #ONE THEN 2600		REM  READ REST OF FILE.
	IF FILETYPE = SEQUENTIAL THEN \
	    READ #ONE;DUMMY$ \
	ELSE \
	    READ #ONE,RECNO;DUMMY$
	RECNO = RECNO + ONE
	GOTO 2920
2600	REM  IF THERE'S AN INDEX, READ IT TO THE END.
	IF NIND = 0 THEN 2200		REM  IF NO INDEXES, SKIP IT.
	    INDEX.FILE$ = FILENAME$ + ".IND"
	    FILE INDEX.FILE$		REM  OPEN SEQUENTIAL INDEX FILE.
	    READ #TWO;INDEX.FIELD$	REM  READ INDEX FILE HEADER.
2650	    IF END #TWO THEN 2200	REM  READ REST TILL END.
	    READ #TWO;DUMMY$
	    GOTO 2650
2200	REM  DATA ENTRY
	PRINT
	PRINT "START ENTERING DATA NOW."
	PRINT
2210	PRINT	REM  PUT A LINE BETWEEN EACH RECORD ENTRY.
	RECORD$ = ""
	FOR I = ONE TO N
		PRINT FIELD$(I);
2215		INPUT ANS$
		IF ANS$ = "=" THEN ANS$ = DATA$(I)
		DATA$(I) = ANS$
		IF WIDE(I) = ZERO THEN 2217	REM  FREE FIELD?
		X = LEN(ANS$) - WIDE(I)
		IF X > ZERO THEN \
			PRINT "ENTRY ";X;" CHARACTERS TOO WIDE." :\
			GOTO 2215
2217		IF TYPE(I) = ALPHA THEN 2217.5
		    DIF = MIN(I) - VAL(ANS$)
		    IF DIF > ZERO THEN \
			PRINT "ENTRY IS ";DIF;" TOO SMALL." :\
			GOTO 2215
		    DIF = VAL(ANS$) - MAX(I)
		    IF DIF > ZERO THEN \
			PRINT "ENTRY IS ";DIF;" TOO LARGE." :\
			GOTO 2215
2217.5		RECORD$ = RECORD$ + ANS$ + "!"
		IF NIND<>0 AND INDEX.FIELD$=FIELD$(I) THEN \
			INDEX.ENTRY$ = ANS$
	NEXT I
2218	INPUT "& OR # OR .";ANS$
	IF ANS$ = "#" THEN 2210
	IF ANS$ = "&" THEN 2219
	IF ANS$ <> "." THEN 2218
2219	IF NIND<>0 THEN \		REM  IF THERE'S AN INDEX,
	    PRINT #TWO;INDEX.ENTRY$,RECNO	REM  WRITE OUT TO IT.
	IF FILETYPE = SEQUENTIAL THEN \
	    PRINT #ONE;RECORD$
	IF FILETYPE = INDEXED THEN \
	    PRINT #ONE,RECNO;RECORD$
	IF FILETYPE = LINKED THEN \
	    PRINT #ONE,RECNO;RECORD$,RECNO+1
	IF ANS$ = "." THEN 2220		REM  CHECK FOR LAST ENTRY.
	RECNO = RECNO + ONE		REM  INCREMENT RECORD NUMBER.
	GOTO 2210
2220	PRINT
	RECNO = RECNO - NO.OF.FIELDS - NHEAD - ONE
	PRINT "THERE ARE NOW ";RECNO;"RECORDS IN ";FILENAME$;"."
	CLOSE ONE
	IF NIND <> 0 THEN CLOSE TWO	REM  CLOSE INDEX FILE.
	INPUT "DO YOU WANT TO ENTER DATA INTO ANOTHER FILE NOW";ANS$
	IF ANS$ = "YES" THEN 2100
	STOP
	END
