	TITLE	'NOTATE - ADD COMMENTS TO ASSEMBLER PROGRAM'
;
	ORG	100H
;
;	INVOKED BY:	NOTATE <FILENAME>
;	INPUT FILE:	<FILENAME>.ASM
;	OUTPUT FILE:	<FILENAME>.ASM
;			INPUT FILE IS RENAMED TO <FILENAME>.BAK
;
;	EACH LINE OF THE INPUT FILE IS DISPLAYED, AND THE
;	USER IS PROMPTED FOR A COMMENT.  IF A COMMENT IS
;	ENTERED, IT IS INSERTED IN THE FILE.  THE PROCESS
;	MAY BE TERMINATED BY ENTERING ^Z AS A COMMENT.
;
;	CP/M MACRO LIBRARIES:
	MACLIB	NCOMPARE
	MACLIB	SYMSTACK
	MACLIB	SEQIO
	MACLIB	DOWHILES
	MACLIB	WHENS
;
;	ADDITIONAL MACROS:
READ	MACRO	F,X		;;READ FRNM FILE F INTO X
	GET	F
	STA	X
	ENDM
;
WRITE	MACRO	F,X		;;WSITE FROM X TO FILE F
	LDA	X		;; AND THE CONSOLE
	PUT	F
	LDA	X
	PUT	CON
	ENDM
;
NXTCHR	MACRO	I,O,C		;;BUMP CHARACTER BEINF PROCESSED
	WRITE	O,C		;; OUTPUT FILE O
	READ	I,C		;; INPUT FILE C
	ENDM
;
	LHLD	@BDOS+1	;SET STACK AT TOP OF TPA
	DCX	H
	SPHL
;
;	OPEN SOURCE FILE
	FILE	INFILE,SOURCE,,1,ASM,4096
;	OPEN TEMPORARY OUTPUT FILE
	FILE	OUTFILE,DEST,,1,$$$,4096
;
;	DO FIRST INPUT
	READ	SOURCE,CHAR
;
;	NOW EXECUTE MAIN LOOP UNTIL EOF
	DOWHILE	CHAR,NEQ,%EOF	;LOOP UNTIL EOF
	    DOWHILECHAR,EQL,%';'
	    	DOWHILE	CHAR,NEQ,10	;SKIP COMMENTED LINES
	    	    NXTCHR	SOURCE,DEST,CHAR
	    	    ENDDO
	    	NXTCHR	SOURCE,DEST,CHAR
	    	ENDDO
	    WHEN	CHAR,EQL,13	;FOUND END OF A LINE
		LXI	D,PROMPT	; PROMPT FOR COMMENT
		MVI	C,9	; WIUH TAB AND SEMICOLON
		CALL	@BDOS
		LXI	H,COMBUF	;INPUT THE COMMENT
		MVI	M,128
		PUSH	H
		XCHG
		MVI	C,10
		CALL	@BDOS
		POP	H
		INX	H
		PUSH	H
		MOV	A,M
		WHEN	COMSIZ,EQL,1	;SINGME CHAR?
		    WHEN	COMONE,EQL,%EOF	;CTL-Z?
		    	POP	H
		  ! 	DOWHILE	CHAR,NEQ,%EOF
			    LDA	CHAR	;COPY REST OF FILE WITH
			    PUT	DEST	; NO FURTHER COMMENTS
			    READ	SOURCE,CHAR
			    ENDDO
		    	JMP	CLOSUP	; AND EXIT
		    	ENDW
		  ! ENDW
		WHEN	COMSIZ,NEQ,0	;OUTPUT TAB AND SEMICOLON
		    MVIA,9	; IF A COMMENT WAS ENTERED
		    PUT	DEST
		    MVI	A,';'
		    PUT	DEST
		    ENDW
		DOWHILE	COMSIZ,GTR,0	;INSERT THE COMMENT
		    POP	H
		    INX	H
		    PUSH	H
		    MOV	A,M
		    PUT	DEST
		    LXI	H,COMSIZ
		    DCR	M
		    ENDDO
		POP	H
		ENDW
	    NXTCHR	SOURCE,DEST,CHAR	;GET NEXT CHARACTER
	    ENDDO	;END OF MAIN LOOP
;
;	CLOSE AND SWITCH FILES
CLORUP:	FINIS	DEST	;CLOSE OUTPUT FILE
	FILE	SETFILE,BACKUP,,1,BAK	:CREATE .BAK FCB
	ERASE	BACKUP	;DELETE OLD BACKUP IF ANY
	RENAME	BACKUP,SOURCE	;RENAME INPUT FILE TO .BAK
	RENAME	SOURCE,DEST	;RENAME OUTPUT TO INPUT
;
;	ALL DONE, EXIT
	JMP	0
;
CHAR:	DS	1	;HOLDS CURRENT CHARACTER FROM SOURCE FILE
COMBUF:	DS	130	;INPUT BUFFER FOR COMMENT
COMSIZ	EQU	COMBUF+1	;LENGTH OF INPUT (SET BY CP/M)
COMONE	EQU	COMBUF+2	;FIRST CHARACTER INPUT
;
PROMPT:	DB	9,';$'
;
BUFFERS:	;MACROS WILL STICK BUFFERS HERE
MEMSIZE	EQU	BUFFERS+@NXTB	;TOTAL MEMORY USED
	END
