;
	TITLE	'CCS DISK INITIALIZATION ROUTINE V2.0'
	PAGE	56
;
;
	ORG	100H	;RUN FROM THE TPA
;
BDOSV:	EQU	5
CR:	EQU	0DH
LF:	EQU	0AH
LCMSK:	EQU	5FH
;
;
DCMD:	EQU	0F8H
DSTAT:	EQU	DCMD
DTRK:	EQU	DCMD+1
DSCTR:	EQU	DCMD+2
DDATA:	EQU	DCMD+3
DCTRL:	EQU	DCMD+4
BCTRL:	EQU	DCMD+5
;
TRCK:	EQU	41H
SDE:	EQU	43H	;SIDE INDICATOR LOCATION
;
NEXT:	LXI	SP,SSTACK  ;SET STACK TO KNOWN VALUE
	DI		;CAN NOT AFFORD ANY INTERRUPTS
	IN	BCTRL	;SEE IF MINI OR MAXI
	ANI	2
	MVI	A,20H	;MINI SELBITS
	JNZ	ENTR	;JUMP IF MINI IS SELECTED
	MVI	A,30H	;ELSE, SET MAXI SELBITS
ENTR:	MOV	B,A	;SAVE FOR A MOMENT
	IN	BCTRL	;NOW, GET THE DDEN BIT
	ANI	40H
	ORA	B	;ADD ON THE MINI/MAXI BITS
	MOV	B,A	;SAVE AGAIN IN B
	IN	DCTRL	;GET THE UNIT BIT
	RAR		;SHIFT IT OVER
	ANI	0FH	;ISOLATE THE SELECT BIT
	ORA	B	;ADD ON THE REST OF THE SELBITS
	STA	SELSV	;SAVE FOR LATER RESTORAL
	IN	DTRK	;SAVE THE TRACK REGISTER
	STA	TRKSV
	LXI	H,HELLO	;ADDRESS OF SIGN-ON MESSAGE
	CALL	PRTLN	;GO PRINT IT
NXTDRV:	LXI	H,MSG1	;ASK FOR DRIVE ASSIGNMENT
	CALL	PRTRD	
	ANI	LCMSK	;SET TO UPPER CASE
	STA	DRV	;SAVE FOR ERROR MESSAGE
	SUI	'A'	;GET RID OF ASCII ZONE
	JC	NXTDRV	;BAD ASSIGNMENT, TRY AGAIN
	CPI	4	;INSURE A GOOD ASSIGNMENT
	JNC	NXTDRV	;BAD, JUMP
	STA	DRIVE	;SAVE IT FOR LATER USE
SID:	LXI	H,MSG7	;SIDE MESSAGE
	CALL	PRTRD
	SUI	'0'	;CHECK FOR VALID SIDE # (0 OR 1)
	JC	SID
	CPI	2
	JNC	SID
	STA	SIDE	;SAVE FOR LATER USE
DEN:	LXI	H,MSG3	;ASK FOR DENSITY
	CALL	PRTRD
	ANI	LCMSK	;GET RID OF LOWER CASE
	SUI	'D'	;CHECK FOR VALID INPUT (S OR D)
	JZ	DEN1
	SUI	'S'-'D'
	JNZ	DEN
	INR	A	;FLAG SINGLE DENSITY
DEN1:	STA	DENS	;SAVE FOR LATER USE
TKNO:	LXI	H,MSG5	;ASK FOR TRACK NUMBER (0-4C) OR ALL (*)
	CALL	PRTLN
	CALL	GETNUM	;GO GET THE NUMBER
	JC	TKNO	;BAD NUMBER, TRY AGAIN
	STA	TRKNO	;SAVE FOR LATER USE
	CALL	PCRLF
SECSZ:	LXI	H,MSG4	;ASK FOR SECTOR SIZE
	CALL	PRTRD
	SUI	'0'	;SEE IF VALID (0-3)
	JC	SECSZ
	CPI	4
	JNC	SECSZ
	STA	SCTSZ	;SAVE FOR LATER USE
TYPDRV:	LXI	H,MSG2	;SEE IF A MINI DRIVE
	CALL	PRTRD	
	ANI	LCMSK	
	STA	DRVA	;SAVE FOR LATER USE
	CPI	'Y'	;SEE IF MINI
	JNZ	TYPDRA	;JUMP IF NOT
TYPDR0:	LXI	H,MSG9	;YES, ASK FOR NUMBER OF TRACKS
	CALL	PRTLN
	CALL	GETNUM	;GET THE ANSWER
	JC	TYPDR0	;BAD ANSWER, TRY AGAIN
	STA	MAXTRK	;SAVE THE ANSWER
	CALL	PCRLF	;START A NEW LINE
	LDA	DRVA	;REGET DRIVE TYPE
TYPDRA:	LXI	B,200BH	;MINI DRIVE COMMANDS
	CPI	'Y'	
	LXI	H,S5S
	LXI	D,D5S-S5S
	JZ	SORD
	DAD	D
	DAD	D
	LXI	B,300AH
	CPI	'N'
	JNZ	TYPDRV
	MVI	A,77	;SET 8" NUMBER OF TRACKS
	STA	MAXTRK
SORD:	LDA	DENS
	DCR	A
	MOV	A,B
	JZ	SORDA
	DAD	D
	ORI	40H
SORDA:	STA	DRVTYP
	MOV	B,A
	PUSH	B
	CALL	SELDRV
	POP	B
	MOV	A,C
	STA	RSCMD
	CALL	CMDOUT
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	XCHG
	SHLD	BUFEND
	XCHG
	MOV	E,M
	INX	H
	MOV	D,M
	LDA	SCTSZ
	INR	A
SORDB:	INX	H
	DCR	A
	JNZ	SORDB
	MOV	A,M
	INR	A
	JZ	TRYAGN
	XCHG
	MOV	M,A
	LXI	D,-11
	DAD	D
	LDA	MAXTRK	;GET NUMBER OF TRACKS
	MOV	M,A	;PUT INTO TABLE
	LDA	TRKNO
	INR	A
	JZ	TRKLP
	CMP	M	;INSURE TRACK SEL IS IN RANGE
	JNC	TRYAGN	;JUMP IF NOT
	DCR	A	;SEE IF A SEEK IS NEEDED
	JZ	TRKLP	;JUMP IF NOT
	OUT	DDATA
	LDA	RSCMD
	ORI	18H
	CALL	CMDOUT
	IN	DTRK
;
;
TRKLP:	STA	TRACK	;INITIALIZE TRACK COUNTER
	MVI	A,0D0H	;SELECT SIDE 0
	OUT	BCTRL
	XRA	A	;SET THE CURRENT SIDE NUMBER
TRKLP1:	STA	CSIDE
	PUSH	H	;SAVE FOR LATER USE
	INX	H	;POINT TO # OF SECTORS PER TRACK
	LXI	D,BUFFER	;INIT BUFFER POINTER
	MVI	C,5	;FIRST 5 ENTRIES ARE FOR LEADER
	CALL	MMOV	;EXPAND THEM INTO TRACK IMAGE
	MVI	A,1	;INITIALIZE SECTOR COUNTER
SCTRLP:	STA	SCTR	;INIT OR UPDATE SECTOR COUNTER
	PUSH	H	;SAVE FOR SECTOR REPEAT FUNCTION
	INX	H	;POINT TO DATA DTABLE
	MVI	C,3	;NEXT 3 ARE THE PRE HEADER FILL
	CALL	MMOV	;PUT THEM INTO THE IMAGE
	LDA	TRACK
	STAX	D
	INX	D
	LDA	CSIDE
	STAX	D
	INX	D
	LDA	SCTR
	STAX	D
	INX	D
	LDA	SCTSZ
	STAX	D
	INX	D
	MVI	C,5	;DO THE PRE-DATA FILL
	CALL	MMOV
	LDA	SCTSZ	;INITIALIZE THE DATA AREA
	INR	A	;SET UP LOOP CONTROL
	PUSH	H	;SAVE (H,L)
	LXI	H,40H
SSZLP:	DAD	H	;DOUBLE (H,L)
	DCR	A
	JNZ	SSZLP	;LOOP TIL BYTE COUNT IN (H,L)
	MOV	B,H
	MOV	C,L
	POP	H	;RESTORE (H,L)
STSCLP:	MOV	A,M
	STAX	D
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	STSCLP
	INX	H
	MVI	C,2	;2 MORE ENTRIES COMPLETE THE SECTOR
	CALL	MMOV
	LDA	SCTR	;INCREMENT THE SECTOR COUNTER
	INR	A
	POP	H	;REGET POINTER TO SECTORS PER TRACK
	CMP	M	;ALL FOR THIS TRACK?
	JNZ	SCTRLP
	DCX	H	;POINT TO GAP 4 FILL CHARACTER
	LDA	BUFEND	;FIND THE END OF THE TRACK BUFFER
	SUB	E
	MOV	C,A	;# OF GAP 4 FILL CHAR IN (B,C)
	LDA	BUFEND+1
	SBB	D
	MOV	B,A
G4FILL:	MOV	A,M	;GET THE FILL CHARACTER
	STAX	D	;PUT IT IN THE BUFFER
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	G4FILL	;CONTINUE TIL FILLED
	CALL	OUTRK	;WRITE THE TRACK
	POP	H	;REGET TABLE POINTER
	LDA	SIDE	;GET SINGLE/DOUBLE SIDE FLAG
	MOV	B,A	;SAVE FOR A MOMENT
	LDA	CSIDE	;GET CURRENT SIDE INDICATOR
	SUB	B
	JZ	NXTRK	;JUMP IF DONE WITH THIS SIDE
	MVI	A,90H	;SELECT OTHER SIDE
	OUT	BCTRL
	MVI	A,1	;SET INDICATOR
	JMP	TRKLP1	;GO DO OTHER SIDE
;
NXTRK:	LDA	TRKNO	;SEE IF SINGLE TRACK REQUEST
	INR	A
	JNZ	NXTDRV	;JUMP IF SO
	LDA	RSCMD	;ELSE, STEP IN ONE TRACK
	ORI	58H
	CALL	CMDOUT
	LDA	TRACK	;GET TRACK COUNTER
	INR	A	;ADVANCE TRACK COUNTER
	CMP	M	;SEE IF DONE WITH DISK
	JNZ	TRKLP	;NO, JUMP
	XRA	A	;GO BACK AND DO TRACK 0
	STA	SCTSZ
	STA	TRKNO
	INR	A
	STA	DENS
	LDA	DRVA
	JMP	TYPDRA	;GO DO TRACK 0
;
;
TRYAGN:	LXI	H,MSG8	;BAD SELECTION MESSAGE
	CALL	PRTLN
	JMP	DEN	;GET A NEW SELECTION
;
;
CMDOUT:	OUT	DCMD	;OUTPUT THE COMMAND
WEOC:	IN	DCTRL	;GET THE STATUS
	RAR		;SEE IF -INTRQ IS SET
	JNC	WEOC	;NO, JUMP AND TRY AGAIN
	IN	DSTAT	;GET THE 1791 CHIP STATUS
	STA	STATSV	;SAVE IT
	ANI	98H	;MASK OUT THE NON-ERROR BITS
	RZ
SKERR:	LXI	H,SEEKMS	;ADDRESS OF 'SEEK'
	JMP	PRTERR	;GO PRINT THE ERROR
;
;
MMOV:	CALL	MOVENT	;MOVE THE CURRENT TABLE ENTRY
	DCR	C	;MORE ENTRIES TO DO?
	JNZ	MMOV	;YES, JUMP
	RET
;
;
MOVENT:	MOV	B,M	;GET THE # OF BYTES
	INX	H	;POINT TO NEXT ENTRY
	MOV	A,M	;GET THE CURRENT DATA VALUE
	INX	H	;POINT TO NEXT VALUE
MOVLP:	STAX	D	;PUT VALUE INTO TRACK IMAGE
	INX	D	;POINT TO NEXT LOCATION
	DCR	B	;LOOP CONTROL
	JNZ	MOVLP
	RET
;
;
OUTRK:	LDA	DRVTYP	;GET CONTROL BITS
	ORI	80H	;ADD ON THE AUTO-WAIT BIT
	MOV	B,A
	IN	DDATA	;CLEAR ANY JUNK OUT
	CALL	SELDRV
	LHLD	BUFEND	;COMPUTE THE BUFFER LENGTH
	LXI	B,-BUFFER
	DAD	B
	MOV	B,H
	MOV	C,L	;BYTE COUNT IN (B,C)
	LXI	H,0	;SAVE THE STACK POINTER
	DAD	SP
	LXI	SP,BUFFER  ;USE THE STACK AS A BUFFER POINTER
	POP	D
	MVI	A,0F4H	;GET THE WRITE TRACK COMMAND
	OUT	DCMD	;START IT GOING
OUTLP:	MOV	A,E	;GET NEXT BYTE
	OUT	DDATA
	DCR	C	;DO LOOP CONTROL NOW
	DCR	C
	MOV	A,D	;GET NEXT BYTE
	POP	D	;GET NEXT TWO BYTES OF DATA
	OUT	DDATA
	JNZ	OUTLP	;FLAGS WERE SET BY LAST DCR C
	DCR	B	;SECONDARY LOOP CONTROL
	JNZ	OUTLP
	SPHL
EOJ:	IN	DCTRL	;WAIT FOR NOT BUSY
	RAR
	JNC	EOJ	;LOOP UNTIL NOT BUSY
;
;
CMDEND:	IN	DSTAT	
	STA	STATSV	
	ANI	64H	
	RZ	
	LXI	H,INITMS	
PRTERR:	LXI	D,ERRTYP	
	LXI	B,4	
	DB	0EDH,0B0H	;Z80 LDIR
	LXI	H,ERRMSG	
	CALL	LNPRT	
	JMP	NEXT	
;
;
DRVTYP:	DB	0	
;
;
SELDRV:	LDA	DRIVE	
	MOV	C,A
	INR	C
	XRA	A
	STC
DRVLP:	RAL		;ROTATE SELECT BIT INTO POSITION
	DCR	C
	JNZ	DRVLP
	ORA	B	
	OUT	DCTRL	
	RET	
;
;
PCRLF:	LXI	H,CRLF	
PRTLN:	MOV	A,M	
	ANA	A	
	RZ	
	CALL	PCHAR	
	INX	H	
	JMP	PRTLN	
;
;
HEX1:	PUSH	PSW	
	RAR	
	RAR	
	RAR	
	RAR	
	CALL	HEX2	
	POP	PSW	
HEX2:	ANI	0FH	
	ADI	90H
	DAA
	ACI	40H
	DAA
PCHAR:	PUSH	H	
	PUSH	D	
	PUSH	B	
	MOV	E,A	
	MVI	D,0	
	MVI	C,2	
	CALL	BDOSV	
	POP	B	
	POP	D	
	POP	H	
	RET	
;
;
PRTRD:	CALL	PRTLN	
	CALL	GETCHR	
	PUSH	PSW	
	CALL	PCRLF	
	POP	PSW	
	CPI	CR
	RNZ
;
;
RTCPM:	LDA	SELSV	;RESTORE THE CURRENT UNIT SELECT
	OUT	DCTRL
	LDA	SDE	;RESTORE THE SIDE SELECTED ON ENTRY
	OUT	BCTRL
	LDA	TRKSV
	OUT	DTRK
	STA	TRCK
	MVI	C,13	
	CALL	BDOSV	
	EI		;REENABLE INTERRUPTS
	CALL	0	
	HLT	
;
;
GETCHR:	MVI	C,1	
	JMP	BDOSV	
;
;
GETNUM:	CALL	GETCHR	;GET THE FIRST CHARACTER
	CPI	CR	;SEE IF ABORT WANTED
	JZ	RTCPM	;JUMP IF SO
	CPI	'*'	;SEE IF ENTIRE DISK WANTED
	MOV	C,A
	MVI	A,0FFH
	RZ
	MOV	A,C
	MVI	B,0	;INITIALIZE HOLD AREA
NUMB:	SUI	'0'	;SEE IF VALID HEX DIGIT
	RC		;BAD ENTRY
	CPI	'G'-'0'
	CMC
	RC		;BAD VALUE EXIT
	CPI	'9'-'0'+1
	JC	NXTNUM	;JUMP IF GOOD NUMBER
	SUI	'A'-'9'-1
	CPI	10
	RC		;BAD VALUE EXIT
NXTNUM:	ADD	B	;BUILD THE VALUE
	MOV	B,A
	PUSH	B
	CALL	GETCHR
	POP	B
	MOV	C,A
	CPI	' '
	MOV	A,B
	RZ
	RLC		;OLD VALUE * 16
	RLC
	RLC
	RLC
	MOV	B,A	;SAVE IT IN (B)
	MOV	A,C	;RESTORE (A)
	JMP	NUMB	;GO GET NEXT CHARACTER
;
;
PRTHEX:	INX	H	
	MOV	A,M	
	INX	H	
	CALL	HEX1	
LNPRT:	MOV	A,M	
	ANA	A	
	RZ	
	CPI	80H	
	JZ	PRTHEX	
	CALL	PCHAR	
	INX	H	
	JMP	LNPRT	
;
;
HELLO:	DB	CR,LF,'CCS DISK FORMATTER PROGRAM V2.0',CR,LF,0
MSG1:	DB	'WHICH DRIVE (A-D)? ',0
MSG2:	DB	'IS IT A MINI (YN)? ',0
MSG3:	DB	'SINGLE OR DOUBLE DENSITY (S/D)? ',0
MSG4:	DB	'SECTOR SIZE (0-3)? ',0
MSG5:	DB	'TRACK NUMBER (0-4C OR *)? ',0
MSG6:	DB	'IS THE DISKETTE MOUNTED (Y/N)? ',0
MSG7:	DB	'SINGLE OR DOUBLE SIDED (0 OR 1)? ',0
MSG8:	DB	'BAD TRACK OR SECTOR SIZE/DENSITY SELECTION:',CR,LF,LF,0
MSG9:	DB	'NUMBER OF TRACKS (23, 28, OR 46)? ',0
;
;
S5S:	DW	BUFFER+3450
	DW	S5+11
	DB	18
	DB	10
	DB	5
	DB	0FFH
D5S:	DW	BUFFER+6500
	DW	D5+11
	DB	0FFH
	DB	18
	DB	10
	DB	5
S8S:	DW	BUFFER+5500
	DW	S8+11
	DB	26
	DB	15
	DB	8
	DB	0FFH
D8S:	DW	BUFFER+10800
	DW	D8+11
	DB	0FFH
	DB	26
	DB	15
	DB	8
;
;
S8:	DB	77	;TRACKS PER SIDE
	DB	20,0FFH	;GAP 4 DATA
	DB	20,0FFH	;GAP 4 DATA
	DB	6,0
	DB	1,0FCH	;INDEX MARK
	DB	26,0FFH	;GAP 1 DATA
	DB	27	;SECTORS PER TRACK + 1
	DB	3,0
	DB	3,0
	DB	1,0FEH	;ADDRESS MARK
	DB	1,0F7H	;CRC REQUEST
	DB	5,0FFH	;GAP 2 DATA
	DB	6,0FFH
	DB	6,0
	DB	1,0FBH	;DATA MARK
	DB	0E5H	;DATA FILL
	DB	1,0F7H	;CRC REQUEST
	DB	27,0FFH	;GAP 3 DATA
;
D8:	DB	77	;TRACKS PER SIDE
	DB	80,4EH	;GAP 4 DATA
	DB	12,0	;GAP 4 DATA
	DB	3,0F6H
	DB	1,0FCH	;INDEX MARK
	DB	50,4EH	;GAP 1 DATA
	DB	27	;SECTORS PER TRACK + 1
	DB	12,0
	DB	3,0F5H
	DB	1,0FEH	;ADDRESS MARK
	DB	1,0F7H	;CRC REQUEST
	DB	22,4EH	;GAP 2 DATA
	DB	12,0
	DB	3,0F5H
	DB	1,0FBH	;DATA MARK
	DB	0E5H	;DATA FILL
	DB	1,0F7H	;CRC REQUEST
	DB	54,4EH	;START OF GAP 3 OR 4
;
S5:	DB	35	;TRACKS PER SIDE
	DB	3,0FFH	;GAP 4 DATA
	DB	3,0FFH	;GAP 4 DATA
	DB	4,0FFH	;GAP 4 DATA
	DB	3,0FFH	;GAP 4 DATA
	DB	3,0FFH	;GAP 4 DATA
	DB	19	;SECTORS PER TRACK + 1
	DB	3,0
	DB	3,0
	DB	1,0FEH	;ADDRESS MARK
	DB	1,0F7H	;CRC REQUEST
	DB	5,0FFH	;GAP 2 DATA
	DB	6,0FFH
	DB	6,0
	DB	1,0FBH	;DATA MARK
	DB	0E5H	;DATA FILL
	DB	1,0F7H	;CRC REQUEST
	DB	11,0FFH	;START OF GAP 3 OR 4
;
D5:	DB	35	;TRACKS PER SIDE
	DB	6,4EH	;GAP 4 DATA
	DB	6,4EH	;GAP 4 DATA
	DB	8,4EH	;GAP 4 DATA
	DB	6,4EH	;GAP 4 DATA
	DB	6,4EH	;GAP 4 DATA
	DB	19	;SECTORS PER TRACK + 1
	DB	8,0
	DB	3,0F5H
	DB	1,0FEH	;ADDRESS MARK
	DB	1,0F7H	;CRC REQUEST
	DB	22,04EH	;GAP 2 DATA
	DB	12,0
	DB	3,0F5H
	DB	1,0FBH	;DATA MARK
	DB	0E5H	;DATA FILL
	DB	1,0F7H	;CRC REQUEST
	DB	22,4EH	;START OF GAP 3 OR 4
;
;
SEEKMS:	DB	'SEEK'
INITMS:	DB	'INIT'
ERRMSG:	DB	CR,LF
ERRTYP:	DB	'     ERROR:  DRIVE '
DRV:	DB	0,'; SIDE ',80H
SIDE:	DB	0,'; TRACK ',80H
TRACK:	DB	0,'; SECTOR ',80H
SCTR:	DB	0,'; STATUS-',80H
STATSV:	DB	0,0
RSCMD:	DB	0
BUFEND:	DW	0
DRIVE:	DB	0
DENS:	DB	0
TRKNO:	DB	0
SCTSZ:	DB	0
CRLF:	DB	CR,LF,0
DRVA:	DS	1
SELSV:	DS	1	;ENTRY DRIVE SELECT BITS SAVE
TRKSV:	DS	1	;TRACK SAVE AREA
SIDSV:	DS	1	;SIDE SAVE AREA
MAXTRK:	DS	1	;TEMP NUMBER OF TRACKS HOLD
CSIDE:	DS	1	;CURRENT SIDE HOLD
	DS	20H	;STACK AREA
SSTACK: DS	0	;START THE STACK HERE
BUFFER:	DS	10800
;
;
	END
