;aciboot.asm
; THIS PROGRAM IS LOADED AT LOCATION
; 0 BY THE BOOTSTRAP PROGRAM, AND RUN.
; IT'S PURPOSE IS TO LOAD AND RUN THE MAIN
; CP/M DISK OPERATING SYSTEM AT THE TOP OF
; THE MEMORY IN USE.
;*************************************************************
;
; DEFINE VALUES FOR TRUE AND FALSE
	TRUE	EQU	0FFFFH
	FALSE	EQU	0000H
MSIZE	EQU  61		;MEMORY SIZE IN DECIMAL KB.
;
DDENS	EQU	TRUE	;TRUE TO BOOT ON A DOUBLE DENSITY DISK
			;FALSE TO BOOT ON A SINGLE DENSITY DISK
DSIDE	EQU	FALSE	;TRUE TO BOOT A LARGE A: DOUBLE SIDE DISK
REMOVEPROM EQU	TRUE	;ON BOOT REMOVE EPROM
;
PROM	EQU  0F800H	;AEC MONITOR
DCOM    EQU  0F8H
DSTAT   EQU  0F8H
TRACK   EQU  0F9H
SECT    EQU  0FAH
DDATA   EQU  0FBH
DCONT   EQU  0FCH
DENS	EQU  DCONT+1
CBASE   EQU  (MSIZE-20)*1024
CPMB    EQU  CBASE+3400H
BOOTE	EQU	CPMB+1600H		;COLD BOOT ENTRY POINT
        ORG  0
;
	IF REMOVEPROM
	MVI	A,01H		
	OUT 7
	ENDIF
;
	LXI  SP,100H
;	load system track into CPMB
;	MVI	A,9
;	CALL	DCOMM
	LXI	H,CPMB
	MVI	A,1
	OUT	DENS		;SET DOUBLE DENSITY
	OUT	DDATA		;SET TRACK REG 1
	OUT	SECT		;SET SECTOR 1
	MOV	E,A
	MVI	A,19H		;SEEK TRACK
	CALL	DCOMM
	MVI	C,DDATA		;DATA PORT
	MVI	A,8CH		;READ W/15MS DELAY
	DB	0DDH,21H
	DW	RL1		;LD IX,RL1
RBLK:	CALL	RLOOP		;SAVES AT HL (STARTING AT BUFF)
	IN	DSTAT
	ANI	9DH
	JNZ	ERROR
	MOV	A,E
	INR	A
	CPI	9		;
	JNC	FIN		;LAST SECTOR
	MOV	E,A
	OUT	SECT
	MVI	A,88H		;READ W/NO DELAY
	JMP	RBLK
;
RLOOP:	OUT DCOM
	EI
RL1	HLT
	DB 0EDH,0A2H	;INI	INPUT PORT C(DDATA) TO (HL)
	EI		;INC HL, DEC B
	DB 0DDH,0E9H	;JP (IX)
FIN:	IF NOT DDENS
	MVI A,2		;SET SINGLE DENSITY IF NOT DOUBLE
	OUT DENS
	ENDIF
	JMP BOOTE	;GOTO CP/M
;
DCOMM:	OUT DCOM
	EI		;enable interrupts
	HLT
	RET
;
;
ERROR:
	MOV	B,A
	IF REMOVEPROM
	XRA A			;GET ZERO
	OUT 7			;TURN ON PROM
	ENDIF
	CALL 0F9A9H		;OUTHX ROUTINE IN MONITOR
	JMP  0F820H		;GOTO MONITOR 0F820H
;DOUBLE DENSITY FLAGS
	ORG  7DH
	RST	0
	NOP
	IF DSIDE
	DB	0D0H
	ENDIF
	IF DDENS AND (NOT DSIDE);IF DOUBLE THEN PUT CODE
	DB	0DDH		;DOUBLE DENSITY FLAG
	ENDIF
;
	IF NOT (DSIDE OR DDENS)	;ELSE 00H
	DB 00
	ENDIF
	END
