;	common data for cp/m assembler module
;
	title	'macro source, common data'
;
	org	2f80h
;
offset	equ	0ch	;used to be 000c bytes here
;
	org	$+offset
;
;	print buffer and print buffer pointer
;
pbmax	equ	120		;max print buffer
pbuff:	ds	pbmax
pbp:	ds	1		;print buffer pointer
;
;	scanner parameters
;
token:	ds	1		;current token
value:	ds	2		;binary value for numbers
acclen:	ds	1		;accumulator length
acmax	equ	64		;length of accumulator
accum:	ds	acmax		;accumulator (must folllow acclen)
;
;	operand expression evaluator parameters
;
evalue:	ds	2		;value of expression after evaluation
;
;	symbol table  module parameters
;
sytop:	ds	2		;first location available for symbol table
symax:	ds	2		;last available location for symbol table
;
;	miscellaneous data areas
;
pass:	ds	1		;pass # 0,1
fpc:	ds	2		;fill address for next hex record
aspc:	ds	2		;assembler's pseudo pc
sybas:	ds	2		;symbol table base
syadr:	ds	2		;current symbol base
sypar:	ds	2		;base of parameter fill/retrieval
deflev:	ds	1		;macro definition level
nextc:	ds	1		;next character for scanner
copytyp:
	ds	1		;type of macro being copied (tmac...tirpc)
libinp:	ds	1		;true if reading lib file
symlst:	ds	1		;true if symbol list is on
maclst:	ds	1		;true if listing macro lines, 0 if not
macbeg:	ds	2		;beginning of macro text for backscan on ;;
titloc:	ds	2		;location of title in symbol table (or 0000)
qsymlst:
	ds	1		;true if listing ?? symbols
liblst:	ds	1		;true if listing the library
lstflg:	ds	1		;true if listing source
relflg:	ds	1		;true if generating the rel-1 image

endmod	equ	($ and 0ff00h)+100h
	end
