;	common data for the macro processor
;
	title	'macro source, common macro stacks'
;
	org	2e80h
;
	ds	3		;originally jmp endmod (not used)
maxexp	equ	15		;top element of parallel macro stacks
macsiz	equ	maxexp+1	;size of parallel macro stacks
dmacsiz	equ	macsiz*2	;double precision mac size
;
ptsize	equ	16		;parameter hash table size
tmain	equ	0		;"type" corresponding to current macro level (main)
tmac	equ	1		;processing a macro definition
tparm	equ	2		;processing macro parameter
tirpc	equ	3		;processing irpc statement
tirp	equ	5		;processing irp statement
trept	equ	6		;processing rept statement
;
pentry:	ds	ptsize*2	;parameter entry hash table (0-15)
macsp:	ds	1		;macro stack pointer (00=main program)
mactyp:	ds	macsiz		;macro type (tmain,tparm,tirpc,tirp, or trept)
reppro:	ds	dmacsiz		;address of prologue for irpc,irp, and rept types
repbas:	ds	dmacsiz		;address of 1st character in repeat text
macnxt:	ds	dmacsiz		;address of next character to fetch in macro
nxtchr:	ds	macsiz		;value of lookahead character for scanner
macfol	equ	nxtchr		;nextc and idfoll char
maclev:	ds	dmacsiz		;value of symax at entry to current level
macflg:	ds	macsiz		;macro list flag at entry to current level
macif:	ds	macsiz		;if stack pointer
;
;	macro id scanner accumulator
;
idmax	equ	15		;last position in id buffer
idbp:	ds	1		;buffer pointer
idfoll:	ds	1		;follow character
idlen:	ds	1		;length of idbuffer element
idbuf:	ds	idmax+1		;identifier buffer
;
;	the parallel stacks for macro processing are shown below
;	mactyp  reppro  repbas  macnxt  nxtchr  maclev  macflg  macif
;	(1 by)  (2 by)  (2 by)  (2 by)  (1 by)  (2 by)  (1 by)  (1 by)
;maxexp :     :       :       :       :       :       :       :       :
;	:     :       :       :       :       :       :       :       :
;  00   :     :       :       :       :       :       :       :       :
;	the current active element is located at 00, and saved at macsp
;	as successive macro levels are invoked (00 filled and copied by
;	the subroutines "pushm" and "popm" in the symbol table section)
;	the values taken on by each vector element are shown below
;	mactyp --
;		tmain:	main program level (should occur only at 00)
;		tmac :	processing a macro definition (reppro, repbas unused)
;		tparm:	processing a parameter (reppro and repbas unused)
;		tirpc:	processing a repeat character statement
;		tirp :  processing a repeat statement
;		trept:	processing a repeat expression statement
;
;	reppro --
;		holds the address of the prologue of the repeat statement
;		which is an absolute address in the top of the symbol table
;		where repeat information is held.  the exact format of the
;		information at this address is defined by mactyp
;		tmain:  (unused)
;		tmac :	(unused)
;		tparm:  (unused)
;		tirpc:  addresses an area of the table of the form
;			---------
;			:   00	:
;			---------
;			:  dn	:
;			---------
;			:  dn-1	:
;			---------
;			   ...
;			---------
;			:  d1	:
;			---------
;			:  cl	:
;			---------
;			:  cl-1	:
;			---------
;			   ...
;			---------
;			:  c1	:
;			---------
;			:hc :l-1:
;			---------
;			: nexth	:
;			---------
;		reppro=	: nextl	:
;			---------
;
;			where d1 ... dn is the character string to be
;			processed in the repeat or repeat character,
;			c1 ... cl is the identifier associated with
;			each repeat loop, with corresponding hash code
;			(modulo 16) and length-1, and
;			'next' is the absolute position of the next
;			character to be processed in the string d1 ... dn
;			(next starts out at d1 and continues until 00)
;
;		tirp:	(same at tirpc above)
;		trept:	addresses an area similar to the above,
;			---------
;			:  00	:
;			---------
;			:  dn	:
;			---------
;			   ...
;			---------
;			:  d1	:
;			---------
;			:high c	:
;			---------
;		reppro=	:low  c	:
;			---------
;
;			where c is the repeat count (16 bit counter)
;
;	repbas --
;		tparm:	(unused)
;		tmac:	(unused)
;		tirpc:	address of the 1st character in the repeat
;			text (i.e., the absolute address of d1 ... dn above)
;		tirp:	(same as tirpc)
;		trept:	(same as tirpc)
;
;	macnxt --
;		holds the absolute address of the next character to fetch
;		from the expanding macro (or parameter or repeat)
;
;	nxtchr --
;		holds the lookahead character for the previous macro level
;		so that it can be properly restored when the current
;		level is exhausted
;
;	maclev --
;		holds the value of 'symax' upon macro expansion entry so
;		that it can be properly restored when the current level
;		is exhausted
;
;	macflg --
;		holds the listing flags for the current level so that
;		they can be properly restored upon exit
;
;	macfol --
;		holds the value of idfoll (used for char lookahead in macro
;		identifier scanning)
;		note that this shares the macnxt stack
;
;
;	macif --
;		holds the value of the conditional stack pointer on entry
;		to a macro, restored upon exit
;
;	note that the initial conditions must be set as follows --
;		macsp = 00	indicates that we are not expanding macros
;		mactyp(0)=tmain	indicates we are in the main program
;		maclev(0)=symax indicates that nothing is in the upper
;				portion of the symbol table
;
;	the idbuffer holds the identifiers which are possible macro dummy
;	parameters, and has the form --
;		idlen:	number of active unfed characters from buffer
;		idbp :	next character position to read from buffer
;		idbuff:	character buffer
;		idfoll:	character which follows the current buffer
;
;	the active formal/actual correspondences are given by entries in
;	the upper portion of the symbol table (above symax as indicated by
;	entries in maclev), and take the form
;
;			-----------
;			:   00	:
;			---------
;			:  dn	:
;			---------
;			:  dn-1	:
;			---------
;			   ...
;			---------
;			:  d1	:
;			---------
;			:  cl	:
;			---------
;			:  cl-1	:
;			---------
;			   ...
;			---------
;			:  c1	:
;			---------
;			:hc :l-1:
;			---------
;			:hi col	:
;			---------
;			:low col:
;			---------
;
;	where hc is the hash code for the formal parameter name (modulo 16)
;	and l is the name length.  c1 ... cl denote the formal parameter
;	characters, and d1 ... dn give the actual parameter characters.
;
;	note that the current active formal names are listed in the pentry
;	(parameter entry) hash code table, which is shorter than the primary
;	hentry table for the usual labels and names which occur within the
;	normal symbol table operations.  the entries in pentry address the
;	base of a formal parameter list which is chained upward
;	through the collision fields of the active formal parameters.
;	the entries are removed from the pentry list when the current level
;	is exhausted (as indicated by maclev)
;
endmod	equ	($+100h) and 0ff00h
	end
