;	symbol table manipulation module
;
	title	'macro source, symbol table primitives'
;
	org	1c00h
;
mainmod	equ	100h
scmod	equ	1600h
iomod	equ	2580h		;io module
macmod	equ	2e80h		;macro common
commod	equ	2f80h		;common data
;
t11e2	equ	mainmod+10bah
;
gncz	equ	scmod+52h
;
pcon	equ	iomod+12h
perr	equ	iomod+18h	;print error from register <a>
eor	equ	iomod+1eh
;
;	common areas for the macro processor
;
maxexp	equ	15		;top element of parallel macro stacks
macsiz	equ	maxexp+1	;size of parallel macro stacks
dmacsiz	equ	macsiz*2	;double precision mac size
;
ptsize	equ	16		;parameter hash table size
tmain	equ	0		;"type" corresponding to current macro level (main)
tmac	equ	1		;processing a macro definition
tparm	equ	2		;processing macro parameter
tirpc	equ	3		;processing irpc statement
tirp	equ	5		;processing irp statement
trept	equ	6		;processing rept statement
;
pentry	equ	macmod+3	;start of hash entry for parameters
macsp	equ	pentry+ptsize*2		;macro stack pointer (00=main program)
mactyp	equ	macsp+1		;macro type (tmain,tparm,tirpc,tirp, or trept)
reppro	equ	mactyp+macsiz	;address of prologue for irpc,irp, and rept
repbas	equ	reppro+dmacsiz	;address of 1st character in repeat text
macnxt	equ	repbas+dmacsiz	;address of next character to fetch in macro
nxtchr	equ	macnxt+dmacsiz	;value of lookahead character for scanner
macfol	equ	nxtchr		;share nextc and idfoll stacks
maclev	equ	nxtchr+macsiz	;value of symax at entry to current level
macflg	equ	maclev+dmacsiz	;macro list flag at entry to current level
macif	equ	macflg+macsiz	;conditional stack pointer
emacstk	equ	macif+macsiz-1	;last entry for the macro stacks
;
idmax	equ	15		;last prescanner buffer position
idbp	equ	emacstk+1
idfoll	equ	idbp+1
idlen	equ	idfoll+1
idbuff	equ	idlen+1
;
;
;	the parallel stacks for macro processing are shown in the maccom module
;	entry points to symbol table module
;
	jmp	endmod
	jmp	inisy
	jmp	lookup
	jmp	found
	jmp	enter
	jmp	setty
	jmp	getty
	jmp	setval
	jmp	getval
	jmp	setparn		;set parm count from reg-<a>
	jmp	getparn		;get parm count to reg-<a>
	jmp	setpar		;copy parm name to symbol table from accum
	jmp	getpar		;copy parm name to accum from symbol table
	jmp	setchr		;reg-<a> to symbol table at sypar+1
	jmp	getchr		;value at table sypar+1 to reg-<a>
	jmp	pushm		;push macro parameters
	jmp	popm		;pop macro parameters
	jmp	plookup		;look up parameter
	jmp	pfound		;check for item found
	jmp	entdef		;enter parameter definition
	jmp	entpar		;enter parameter
	jmp	rempar		;remove parameters until maclev encountered
	jmp	gettxa		;get absolute beginning of text string
	jmp	lcomp		;continue table lookup operation (after lookup)
	jmp	chash		;compute hash code for current accumulator
	jmp	initpar		;initialize the parm hash table
;
;
;	common equates
;
pbmax	equ	120		;max print size
pbuff	equ	commod+0ch	;print buffer
pbp	equ	pbuff+pbmax	;print buffer pointer
;
token	equ	pbp+1		;current token under scan
value	equ	token+1		;value of number in binary
acclen	equ	value+2		;accumulator length
acmax	equ	64		;max accumulator length
accum	equ	acclen+1
;
evalue	equ	accum+acmax	;value from expression analysis
;
sytop	equ	evalue+2	;current symbol top
symax	equ	sytop+2		;max address+1
;
pass	equ	symax+2		;current pass number
fpc	equ	pass+1		;fill address for next hex byte
aspc	equ	fpc+2		;assembler's pseudo pc
sybas	equ	aspc+2		;base of symbol table
syadr	equ	sybas+2		;current symbol being accessed
sypar	equ	syadr+2		;base for macro parm operations
deflev	equ	sypar+2		;(not used here)
;
;	global equates
;
iden	equ	1		;identifier
numb	equ	2		;number
strng	equ	3		;string
specl	equ	4		;special character
;
plabt	equ	0000$0001b	;program label
dlabt	equ	0000$0010b	;data label
equt	equ	0000$0100b	;equate
sett	equ	0000$0101b	;set
mact	equ	0000$0110b	;macro
;
extt	equ	0000$1000b	;external
reft	equ	0000$1011b	;refer
glbt	equ	0000$1100b	;global
;
cr	equ	0dh
;
;	data areas
;	symbol table begins at the end of this module
;
fixd	equ	5		;5 bytes overhead with each symbol entry
				;2by collision, 1by type/len, 2by value
hsize	equ	128		;hash table size
hmask	equ	hsize-1		;hash mask for coding
pmask	equ	ptsize-1	;hash mask for macro parameters
hasht:	ds	hsize*2		;hash table
hashc:	ds	1		;hash code after call on lookup
hbase:	ds	2		;set to pentry or hasht depending upon search type
;
;	symbol table entry format is
;		-----------------
;		: high val byte	:
;		-----------------
;		: low  val byte	:
;		-----------------
;		: character n	:
;		-----------------
;		:    ... 	:
;		-----------------
;		: character 1	:
;		-----------------
;		: type  : leng	:
;		-----------------
;		: high collision:
;		-----------------
;	syadr=	: low collision :
;		-----------------
;
;	where the low/high collision field addresses another entry with
;	the same hash code (or zero if the end of chain), type describes
;	the entry type (given below), leng is the number of characters in
;	the symbol printname -1 (i.e., leng=0 is a single character print-
;	name, while leng=15 indicates a 16 character name).  character 1
;	through n give the printname characters in ascii upper case (all
;	lower case names are translated on input), and the low/high value
;	give the particular address or constant value associated with the
;	name.  the representation of macros differs in the fields which
;	follow the value field (macros are not currently implemented).
;
;	the type field consists of four bits which are assigned as
;	follows:
;
;		0000	undefined symbol
;		0001	local	labelled program
;		0010	local	labelled data
;		0011	(unused)
;		0100		equate
;		0101		set
;		0110		macro
;		0111		(unused)
;
;		1000		(unused)
;		1001	extern	labelled program
;		1010	extern	labelled data
;		1011		reference to module
;		1100		(unused)
;		1101	global	undefined symbol
;		1110	global	labelled program
;		1111		(unused)
;
;
;	the format for macro definitions resembles the simple labels as
;	shown above, except that the value field contains a link to the
;	other macros.  during a particular pass, the variable lastmac
;	addresses the last macro which has been defined, whose value
;	field in turn addresses the previous macro.  at the end of a pass,
;	the chain is reversed and headed by nextmac, which links the macro
;	definitions in the order in which they must occur on subsequent passes
;	with the end of list denoted by 0ffffh.  as each macro is encountered
;	on subsequent passes, it is moved from the nextmac list to the
;	lastmac list.  the macro parameters and macro definition are
;	stored immediately above the value field as shown below:
;		-----------------
;		: binary   00	:
;		-----------------
;		: last def char	:
;		-----------------
;		     ...
;		-----------------
;		: first def char:
;		-----------------
;		: param #n	:
;		-----------------
;		: param #n-1	:
;		-----------------
;		: param #1	:
;		-----------------
;		: param count n	:
;		-----------------
;		: high value	:
;		-----------------
;		      ...
;		-----------------
;	syadr=	: low collision	:
;		-----------------
;
;	where the parameters are each multi-byte fields which hold the
;	name and hash code of the formal parameter.  each of these fields
;	has the form:
;
;		-----------------
;		: parm char #k	:
;		-----------------
;		: parm char #k-1:
;		-----------------
;		     ...
;		-----------------
;		: parm char #1	:
;		-----------------
;		: hashc : k-1	:
;		-----------------
;
;	note that the hashc field (4bits) holds the hash code modulo 16
;	but is not linked until the macro is activated.  the length is
;	stored in the rightmost 4 bits.  the above template is duplicated
;	n times (once for each parameter).
;
;
;	type definitions
;
plabt	equ	0000$0001b	;program label
dlabt	equ	0000$0010b	;data label
equt	equ	0000$0100b	;equate
sett	equ	0000$0101b	;set
mact	equ	0000$0110b	;macro
;
extt	equ	0000$1000b	;external attribute
reft	equ	0000$1011b	;refer
glbt	equ	0000$1100b	;global attribute
;
;
inisy:		;initialize the symbol table
	lxi	h,hasht		;zero the hash table
	mvi	b,hsize
	xra	a		;clear accum
ini0:
	mov	m,a
	inx	h
	mov	m,a		;clear double word
	inx	h
	dcr	b
	jnz	ini0
;
;	hash table is cleared,
;	set symbol table pointers
;
	lxi	h,0
	shld	syadr
	ret
;
initpar:	;initialize parameter hash table
	lxi	h,pentry
	mvi	b,ptsize
	xra	a
inip0:	mov	m,a		;00
	inx	h
	mov	m,a		;0000
	inx	h
	dcr	b
	jnz	inip0
	ret
;
phash:		;compute hash code for current accumulator for parameter test
	call	chash
	ani	pmask
	sta	hashc		;shorter form of the hash code
	ret
;
pushm:		;push current values to the macro processing stacks
	lxi	h,macsp
	mov	a,m		;current stack pointer
	cpi	maxexp		;at top of stack area?
	jnc	pperr		;push or pop error 'b'
;
;	no overflow, move from zero to macsp+1 position
;
	inr	m		;macsp=macsp+1
	mov	e,m		;low(macsp)
	mvi	d,0		;double precision macsp to <de>
	lxi	h,mactyp
	mov	a,m		;macro type
	dad	d
	mov	m,a		;placed at top of stack
	lxi	h,repbas
	call	stkd		;stack double precision repbas
	lxi	h,reppro
	call	stkd		;stack double precision reppro
	lxi	h,macnxt
	call	stkd		;stack double precision next char pointer
	lxi	h,nxtchr
	mov	a,m
	dad	d
	mov	m,a		;save lookahead character
	lxi	h,maclev
	call	stkd		;stack double precision symbol level
	lxi	h,macflg
	mov	a,m
	dad	d
	mov	m,a		;stack macro flags
	lxi	h,macif
	mov	a,m
	dad	d
	mov	m,a		;stack conditional stack level
	ret
;
stkd:		;utility subroutine for pushm to stack double precision value
	mov	c,m		;low byte
	inx	h
	mov	b,m		;high byte
	dad	d		;indexed to high byte position
	dad	d		;double precision index
	mov	m,b
	dcx	h
	mov	m,c		;high then low stored into stacks
	ret
;
popm:		;pop top elements of macro stacks to simple variables at 00
	lxi	h,macsp
	mov	a,m		;any elements present?
	ora	a
	jz	pperr		;cannot perform operation if 00
	push	h		;save macsp address
	mov	e,m		;double precision macsp to <de>
	mvi	d,0
	lxi	h,mactyp
	call	ustk		;unstack single precision value
	lxi	h,repbas
	call	ustkd		;unstack double precision value
	lxi	h,reppro
	call	ustkd		;unstack double precision reppro
	lxi	h,macnxt
	call	ustkd		;unstack double precision next to get
	lxi	h,nxtchr
	call	ustk		;unstack lookahead character
	lxi	h,maclev
	call	ustkd		;unstack double precision symbol level
	lxi	h,macflg
	call	ustk		;unstack macro flags
	lxi	h,macif
	call	ustk		;unstack idfoll character
	pop	h		;recall macsp address to <hl>
	dcr	m		;macsp=macsp-1
	ret
;
ustk:		;unstack single precision value
	push	h		;save base address
	dad	d
	mov	a,m
	pop	h		;restore base address
	mov	m,a		;back to simple variable
	ret
;
ustkd:		;unstack double precision value
	push	h
	dad	d
	dad	d		;addressing top element
	mov	c,m		;low byte
	inx	h
	mov	b,m		;high byte
	pop	h		;recall base address
	mov	m,c		;store low byte to simple variable
	inx	h
	mov	m,b		;store high byte to simple variable
	ret
;
pperr:		;push or pop error
	mvi	a,'B'		;balance error
	jmp	perr		;print and return through perr
;
chash:		;compute hash code for current accumulator
	lxi	h,acclen
	shld	symbuff		;normal base is accum
;
chash0:		;can enter here with symbuff set to idbuff for prescanner
	lhld	symbuff		;length in v(<hl>)
	mov	b,m		;get accum length
	xra	a		;clear accumulator
ch0:	inx	h		;move to first/next character position
	add	m		;add with overflow
	dcr	b
	jnz	ch0
	ani	hmask		;mask bits for modulo hzise
	sta	hashc		;fill hashc with result
	ret
;
setln:		;set the length field of the current symbol
	mov	b,a		;save length in <b>
	lhld	syadr
	inx	h
	inx	h
	mov	a,m		;get type/length field
	ani	0f0h		;mask out type field
	ora	b		;mask in length
	mov	m,a
	ret
;
getln:		;get the length field to reg-<a>
	lhld	syadr
	inx	h
	inx	h
	mov	a,m
	ani	0fh
	inr	a		;length is stored as value - 1
	ret
;
pfound:		;pfound returns true if syadr addresses an active
		;parameter.  that is, syadr is non zero, and addresses an area
		;of the symbol table which is below the top most active macro
	call	found
	rz			;return immediately if no match was found
;
;match was found, search down the mactyp vector for the first
;active macro name (if it exists)
;
	xchg			;syadr to <de>
;
;	check outer level first, then search stacks
;
	lxi	b,0		;in case it is found at outer level
	lda	mactyp
	cpi	tmac		;outer level macro?
	jz	pf2
;
;	not outer level macro - scan down stacks
;
	lxi	h,macsp		;current stack pointer
	mov	c,m		;low(macsp)
	mvi	b,0		;becomes double precision
	lxi	h,mactyp	;type vector for active macros
	dad	b		;indexed to topmost element
;
pf0:		;any active elements?
	mov	a,c
	ora	a
	jz	pf1		;skip to end if addressing element 00
	mov	a,m		;otherwise retrieve element type
	cpi	tmac		;is the element a macro?
	jz	pf2		;get out if so
;
;	element is not a macro, move down stacks one position
;
	dcx	b
	dcx	h
	jmp	pf0		;for another element
;
pf1:		;no active macro names, return with non zero set
	inr	a		;set flags
	xchg
	ret			;with <hl>=syadr
;
pf2:		;active macro - index is in <bc>
	lxi	h,maclev
	dad	b
	dad	b		;<hl>=maclev(active macro)
	mov	a,e		;low(syadr)
	sub	m
	mov	a,d		;high(syadr)
	inx	h		;high order active macro symbol level
	sbb	m
	jc	found		;restores syadr and sets non zer flag
;
;	the element which matched was outside the current macro range
;
	lxi	h,0
	shld	syadr		;clear the syadr
	xra	a		;zero flag set
	ret
;
found:		;found returns true if syadr is not zero (true is nz flag here)
	lhld	syadr
	mov	a,l
	ora	h
	ret
;
plookup:	;look for symbol in parameter area of symbol table
	lxi	h,idlen		;base of string to hash
	shld	symbuff		;symbol buffer is idbuff
	call	chash0
	lda	hashc
	ani	pmask		;to shorten it
	sta	hashc		;adjusted to 16 bit value
	lxi	h,pentry	;hash vector for parameters
	shld	hbase		;base of vector which leads to parameters
	jmp	elook0		;entry point for lookup
;
lookup:		;look for symbol in accumulator
	call	chash		;compute hash code
	lxi	h,hasht		;search hash table
	shld	hbase
;
elookup:
	lxi	h,acclen
	shld	symbuff		;normal buffer at acclen
;
elook0:		;may enter here to lookup idbuff for macro prescanner
	lhld	symbuff
;
;	enter here for label and macro parameter searches
;	normalize identifier to 16 characters
;
	mov	a,m
	cpi	17
	jc	lenok
	mvi	m,16
;
lenok:		;look for symbol through hash table
	lxi	h,hashc
	mov	e,m
	mvi	d,0		;double hash code in <de>
	lhld	hbase		;base of hasht or pentry
	dad	d
	dad	d		;hasht(hashc)
	mov	e,m		;low order address
	inx	h
	mov	h,m
	mov	l,e		;header to list of symbols is in <hl>
look0:	shld	syadr
	call	found
	rz			;return if syadr becomes zero
;
;	otherwise examine character string for match
;
	call	getln		;get length to reg-<a>
	lhld	symbuff		;length of accumulator
	cmp	m
	jnz	lcomp
;
;	length match, try to match characters
;
	mov	b,a		;string length in <b>
	inx	h		;<hl> addresses accum
	xchg			;to <de>
	lhld	syadr
	inx	h
	inx	h
	inx	h		;addresses characters
look1:	ldax	d		;next character from accum
	cmp	m		;next character in symbol table
	jnz	lcomp
;
;	character matched, increment to next
;
	inx	d
	inx	h
	dcr	b
	jnz	look1
;
;	complete match at current symbol, syadr is set
;
	ret
;
lcomp:		;not found, move syadr down one collision address
	lhld	syadr
	mov	e,m
	inx	h
	mov	d,m		;collision address in <de>
	xchg
	jmp	look0
;
;
enter:		;enter symbol in accumulator
		;ensure there is enough space in the table
	lxi	h,acclen
	mov	e,m
	mvi	d,0		;double precision acclen in <de>
	lhld	sytop
	shld	syadr		;next symbol location
	dad	d		;sytop+acclen
	lxi	d,fixd		;fixed data/symbol
	dad	d		;<hl> has next table location for symbol
	xchg			;new sytop in <de>
	lhld	symax		;maximum symtop value
	mov	a,e
	sub	l		;compute 16-bit difference
	mov	a,d
	sbb	h
	xchg			;new sytop in <hl>
	jnc	overer		;overflow in table
;
;	otherwise no error
;
	shld	sytop		;set new table top
	lxi	h,hasht		;use label hash entry
	shld	hbase
	call	entsym		;enter symbol
;
;	printname has been copied, set value field to zero
;
	xra	a
	inx	h		;low order value field
	mov	m,a
	inx	h		;high order value field
	mov	m,a
	ret
;
;
entsym:		;enter symbol given by accum with length acclen and hashcode hashc
		;into the symbol table at syadr, using the hash table addressed
		;by the contents of hbase
	lhld	syadr		;set collision field
	xchg			;current symbol address to <de>
	lxi	h,hashc		;hash code for current symbol to <hl>
	mov	c,m		;low byte
	mvi	b,0		;double precision value in <bc>
	lhld	hbase		;base of relevant hash table
	dad	b
	dad	b		;hasht(hashc) in <hl>
;
;	<de> addresses current symbol - change links
;
	mov	c,m		;low order old header
	inx	h
	mov	b,m		;high order old header
	mov	m,d		;high order new header to hash table
	dcx	h
	mov	m,e		;low order new header to hash table
	xchg			;<hl> holds symbol table address
	mov	m,c		;low order old header to collision field
	inx	h
	mov	m,b		;high order old header to collision field
;
;	hash chain now repaired for this entry, copy the printname
;
	lxi	d,acclen
	ldax	d		;get symbol length
	cpi	17		;larger than 16 symbols?
	jc	ent1
	mvi	a,16		;truncate to 16 characters
;
;	copy length field, followed by printname characters
;
ent1:	mov	b,a		;copy length to <b>
	dcr	a		;1-16 changed to 0-15
	inx	h		;following collision field
	mov	m,a		;store length with undefined type (0000)
ent2:	inx	h
	inx	d
	ldax	d
	mov	m,a		;store next character of printname
	dcr	b		;length=length-1
	jnz	ent2		;for another character
	ret
;
;
topspace:	;reserve space for accum + reg <bc> in top of table
	lhld	symax
	xchg
	lxi	h,acclen
	mov	l,m		;<l> is accumulator length (reduced to <= 16)
	mvi	h,0		;for double precision add
	dad	b		;<hl> is number of bytes required for this value
	mov	a,e		;low(symax)
	sub	l		;low order difference
	mov	l,a
	mov	a,d
	sbb	h		;high order difference
	mov	h,a		;<hl> hold new symax after subtracting size
	shld	syadr		;may be used below
	xchg			;to <de> for compare against sytop
	lxi	h,sytop
	mov	a,e
	sub	m		;low order difference syadr-sytop
	inx	h
	mov	a,d
	sbb	m		;high order difference syadr-sytop
	jc	overer		;error if sytop>syadr
	xchg			;new symax
	shld	symax		;this will be restored when we leave the macro def
	ret
;
entdef:		;enter text from accum to high table addresses (ready for parm)
	lxi	b,1		;one extra byte required for 00 at end
	call	topspace	;reserve space at top of table (symax set)
	lhld	symax		;first position to fill
	xchg
	lxi	h,acclen	;length of fill operation
	mov	c,m
entd0:	inx	h		;next to copy from accum
	mov	a,c		;at end of copy?
	ora	a
	jz	entd1		;could be copying a zero length actual parm
	dcr	c		;count characters down
	mov	a,m		;get next character to <a>
	stax	d		;store to symbol table
	inx	d		;ready for next fill
	jmp	entd0		;for another character
;
entd1:		;end of accumulator copy, fill end of string with 00
	xra	a
	stax	d
	ret
;
entpar:		;enter the formal parameter name from the accumulator
	lxi	b,3		;three extra cells required (collision, hc/len-1)
	call	topspace	;space reserved for the copy (syadr, symax set)
	lxi	h,pentry
	shld	hbase		;use the parameter entry table for the operation
	call	entsym		;symbol is entered, copy hash code for later ref
	lda	hashc
	call	setty		;uses the type field of the entry
	ret
;
rempar:		;remove parameters until maclev is reached
	lhld	symax
	xchg
	lxi	h,maclev	;<de> is current max, <hl> =.maclev
	mov	a,e
	sub	m		;low order difference
	inx	h
	mov	a,d
	sbb	m		;high order difference
	rnc			;no carry if maclev <= symax
;
;	otherwise there is another entry to remove
;
	xchg
	shld	syadr		;base of entry to remove
	call	getty		;hash code in pentry to register <a>
	mov	e,a		;convert to double precision
	mvi	d,0
	lxi	h,pentry	;base of parameter entry
	dad	d
	dad	d		;pentry(hashc)
	xchg
	lhld	syadr		;get the collision field back to pentry
	mov	a,m		;low collision
	stax	d		;to pentry
	inx	h
	mov	a,m		;high collision
	inx	d
	stax	d		;back to pentry
;
;	pentry now addresses the next parameter (or 0000) up the table
;
	call	valadr		;<hl> set to the string which is the actual parm
remp0:	mov	a,m		;end of the string?
	ora	a
	inx	h		;to next character in preparation for continued scan
	jnz	remp0		;loop until 00 found
	shld	symax		;restore symbol table top
	jmp	rempar		;to possibly remove another parameter
;
gettxa:		;get the absolute address of the text string corresponding to
		;the currently addressed formal parameter
	jmp	valadr		;same position as value field
;
;
overer:		;overflow in symbol table
	lxi	h,erro
	call	pcon
	jmp	eor		;end of execution
;
erro:	db	'SYMBOL TABLE OVERFLOW',cr
;
setty:		;set current symbol type to value in reg-<a>
	ral
	ral
	ral
	ral
	ani	0f0h		;type moved to high order 4-bits
	mov	b,a		;save it in <b>
	lhld	syadr		;base of symbol to access
	inx	h
	inx	h		;address of type/length field
	mov	a,m		;get it and mask
	ani	0fh		;leave length
	ora	b		;mask in type
	mov	m,a		;store it
	ret
;
getty:		;return the type of the value in current symbol
	lhld	syadr
	inx	h
	inx	h
	mov	a,m
	rar
	rar
	rar
	rar
	ani	0fh		;type moved to low 4-bits of reg-<a>
	ret
;
valadr:		;get value field address for current symbol
	call	getln		;printname length to accum
	lhld	syadr		;base address
	mov	e,a
	mvi	d,0
	dad	d		;base(len)
	inx	h
	inx	h		;for collision field
	inx	h		;for type/len field
	ret			;with <hl> addressing value field
;
setval:		;set the value field of the current symbol
		;value is sent in <hl>
	push	h		;save value to set
	call	valadr
	pop	d		;pop value to set, <hl> has address to fill
	mov	m,e
	inx	h
	mov	m,d		;field set
	ret
;
getval:		;get the value field of the current symbol to <hl>
	call	valadr		;address of value field to <hl>
	mov	e,m
	inx	h
	mov	d,m
	xchg
	ret
;
paradr:		;set sypar for the current macro (addressed by syadr)
	call	valadr		;<hl> set to value field
	inx	h
	inx	h		;set to parameter count field
	shld	sypar		;ready for parameter operations
	ret
;
setparn:	;set parm count to value in register <a>
	push	psw
	call	paradr		;<hl> address the parm count
	pop	psw
	mov	m,a		;stored into symbol table
	ret
;
getparn:	;get number of parameters to register <a>
	call	paradr		;<hl> and sypar set to parm count
	mov	a,m
	ret
;
setpar:		;copy next parameter from accum to symbol table
	call	chash		;compute hash code
	ani	0fh		;modulo 16
	add	a
	add	a
	add	a
	add	a		;shl 4
	mov	c,a
	lxi	h,acclen
	mov	a,m
	cpi	17		;truncate name if necessary
	jc	setpar0
	mvi	m,16		;set to length 16
setpar0:
	mov	a,m		;length of name
	dcr	a		;-1
	ora	c		;include hash code
	call	setchr		;store character at sypar+1
	lxi	h,acclen
	mov	c,m		;length of copy to <c>
setpar1:
	inx	h		;next to store
	mov	a,m
	push	b		;save count
	push	h		;save accum address
	call	setchr		;store character
	pop	h
	pop	b
	dcr	c
	jnz	setpar1		;for another character
	ret
;
getpar:		;copy next parameter to accumulator
	call	getchr		;<a> holds next byte
	mov	c,a		;save it
	rlc
	rlc
	rlc
	rlc
	ani	0fh		;ls 4 bits holds hash code
	sta	hashc
	mov	a,c		;recover hashc/length-1
	ani	0fh
	inr	a		;length in <a>
	mov	c,a
	lxi	d,acclen	;ready for the copy
	stax	d		;store the length
getp0:	call	getchr		;next to get
	inx	d		;next to fill
	stax	d
	dcr	c
	jnz	getp0		;loop til copy done
	ret
;
getchr:		;get character at sypar+1 and increment
	lhld	sypar
	inx	h
	shld	sypar
	mov	a,m
	ret
;
	ret
;
setchr:		;store character from register <a> to memory at sypar+1
	mov	c,a		;save for later store operation
	lhld	sypar
	inx	h
	xchg			;test against symax
	lhld	symax
	mov	a,e
	sub	l
	mov	a,d
	sbb	h
	jnc	overer		;overflow
	xchg
	shld	sypar		;new symbol table top
	mov	m,c
	inx	h		;top leads par by one
	shld	sytop		;update parameter pointer
	ret
;
symbuff:
	ds	2		;address of the relevant accumulator (see plookup)
endmod	equ	($ and 0ff00h) + 100h
;
s20d8:	cpi	2ch
	jnz	gncz
	shld	t11e2
	jmp	gncz

	end
