;		PROGRAM MBOOT3
;	CP/M DOWNLOAD SYSTEMS
;

FALSE	EQU	0
TRUE	EQU	NOT FALSE

BASE	EQU	0

EXITCHR	EQU	05H
ESC	EQU	1BH
FASTCLK	EQU	FALSE


;	I/O DEFINITION

MODCTLP	EQU	0F5H	; MODEM CONTROL PORT
MODSNDB	EQU	01H	; TBE
MODSNDR	EQU	01H	; 
MODRCVB	EQU	02H	; RBF
MODRCVR	EQU	02H	; 
MODDATP	EQU	0F4H	; MODEM DATA PORT

ERRLIM	EQU	10	; MAX NUMBER OF ERRORS

;
;	GENERAL CHARACTER DEFINITIONS
;

SOH	EQU	1
EOT	EQU	4
ACK	EQU	6
NAK	EQU	15H
CAN	EQU	18H
LF	EQU	10
CR	EQU	13

BDOS	EQU	BASE+5
FCB	EQU	BASE+5CH


	ORG	BASE+100H

START:
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	CALL	INITADR
	CALL	ILPRT
	DB	'MBOOT AS OF 11/5/80',CR,LF,0
	LDA	FCB+1
	CPI	' '
	JNZ	TERMI
	CALL	ILPRT
	DB	'** NO FILE NAME SPECIFIED ',CR,LF,0
	JMP	EXIT

TERMI:
	CALL	INITMOD
	IN	MODDATP
	IN	MODDATP
	CALL	ILPRT
	DB	CR,LF,'TERMINAL MODE',CR,LF
	DB	'CTL-E EXITS TO CP/M, ESC STARTS FILE TRANSFER',CR,LF,0

TERM:
	CALL	STAT
	JZ	TERML
	CALL	KEYIN
	CPI	EXITCHR
	JZ	EXIT
	CPI	ESC
	JZ	RCVFIL
	OUT	MODDATP
TERML:
	IN	MODCTLP
	ANI	MODRCVB
	CPI	MODRCVR
	JNZ	TERM
	IN	MODDATP
	ANI	07FH
	CALL	TYPE
	JMP	TERM

RCVFIL:
	CALL	ERASFIL
	CALL	MAKEFIL
	CALL	ILPRT
	DB	'FILE OPEN, READY TO RECEIVE',CR,LF,0
RCVLP:
	CALL	RCVSECT
	JC	RCVEOT
	CALL	WRSECT
	CALL	INCRSNO
	CALL	SENDACK
	JMP	RCVLP

RCVEOT:
	CALL	WRBLOCK
	CALL	SENDACK
	CALL	CLOSFIL
	CALL	ERXIT
	DB	CR,LF,'TRANSFER COMPLETE'

RCVSECT:
	XRA	A
	STA	ERRCT
RCVRPT:
	MVI	B,10
	CALL	RECV
	JC	RCVSERR
	CPI	SOH
	JZ	RCVSOH
	ORA	A
	JZ	RCVRPT
	CPI	EOT
	STC
	RZ

RCVSERR:
	MVI	B,1
	CALL	RECV
	JNC	RCVSERR
	call	ilprt
	db	'nak',cr,lf,0
	MVI	A,NAK
	CALL	SEND
	LDA	ERRCT
	INR	A
	STA	ERRCT
	CPI	ERRLIM
	JC	RCVRPT

RDVSABT:
	CALL	CLOSFIL
	CALL	ERXIT
	DB	'**UNABLE TO RECEIVE BLOCK',CR,LF,0,'**ABORTING**$'
RCVSOH:
	MVI	B,1
	CALL	RECV
	JC	RCVSERR
	PUSH	PSW
	CALL	ILPRT
	DB	CR,LF,'{SOH}',0
	POP	PSW
	MOV	D,A
	MVI	B,1
	CALL	RECV
	JC	RCVSERR
	CMA
	CMP	D
	JZ	RCVDATA
	CALL	ILPRT		; DBUG
	DB	CR,LF,'BAD SECTOR NUMBER',CR,LF,0
	JMP	RCVSERR

RCVDATA:
	MOV	A,D
	STA	RCVSNO
	MVI	C,0
	LXI	H,BASE+80H

RCVCHR:
	MVI	B,1
	CALL	RECV
	JC	RCVSERR
	MOV	M,A
	INR	L
	JNZ	RCVCHR
	MOV	D,C
	MVI	B,1
	CALL	RECV
	JC	RCVSERR
	CMP	D
	JNZ	RCVSERR
	LDA	RCVSNO
	MOV	B,A
	LDA	SECTNO
	CMP	B
	JZ	RECVACK
	INR	A
	CMP	B
	JNZ	ABORT
	RET

RECVACK:
	CALL	SENDACK
	JMP	RCVSECT

SENDACK:
	CALL	ILPRT
	DB	'ACK',CR,LF,0
	MVI	A,ACK

SEND:
	PUSH	PSW
	ADD	C
	MOV	C,A

SENDW:
	IN	MODCTLP
	ANI	MODSNDB
	JZ	SENDW
	POP	PSW
	OUT	MODDATP
	RET

ABORT:
	LXI	SP,STACK
ABORTL:
	MVI	B,1
	CALL	RECV
	JNC	ABORTL
	MVI	A,CAN
	CALL	SEND
ABORTW:
	MVI	B,1
	CALL	RECV
	JNC	ABORTW
	MVI	A,' '
	CALL	SEND
	CALL	ERXIT
	DB	'MBOOT PROGRAM CANCLED$'

INCRSNO:
	LDA	SECTNO
	INR	A
	STA	SECTNO
	RET

ERASFIL:
	LXI	D,FCB
	MVI	C,17
	CALL	BDOS
	INR	A
	RZ
	CALL	ILPRT
	DB	'**FILE EXHISTS, TYPE Y TO ERASE: ',0
	CALL	KEYIN
	PUSH	PSW
	CALL	TYPE
	CALL	CRLF
	POP	PSW
	ANI	5FH
	CPI	'Y'
	JNZ	MXIT
	LXI	D,FCB
	MVI	C,19
	JMP	BDOS

MAKEFIL:
	LXI	D,FCB
	MVI	C,22
	CALL	BDOS
	INR	A
	RNZ
	CALL	ERXIT
	DB	'**ERROR -CAN''T MAKE FILE',CR,LF
	DB	'**DIRECTORY MUST BE FULL$'

CLOSFIL:
	LXI	D,FCB
	MVI	C,16
	CALL	BDOS
	INR	A
	RNZ
	CALL	ERXIT
	DB	'**CAN''T CLOSE FILES$'

WRSECT:
	LHLD	SECPTR
	XCHG
	LXI	H,BASE+80H
	CALL	MOVE128
	XCHG
	SHLD	SECPTR
	LDA	SECINBF
	INR	A
	STA	SECINBF
	CPI	16
	RNZ

WRBLOCK:
	LDA	SECINBF
	ORA	A
	RZ
	MOV	C,A
	LXI	D,DBUF
DKWRLP:
	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,26
	CALL	BDOS
	LXI	D,FCB
	MVI	C,21
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	ORA	A
	JNZ	WRERR
	LXI	H,80H
	DAD	D
	XCHG
	DCR	C
	JNZ	DKWRLP
	XRA	A
	STA	SECINBF
	LXI	H,DBUF
	SHLD	SECPTR

RSDMA:
	LXI	D,BASE+80H
	MVI	C,26
	JMP	BDOS

WRERR:
	CALL	RSDMA
	CALL	ILPRT
	DB	'**ERROR WRITING FILE',CR,LF,0
	JMP	ABORT

RECV:
	PUSH	D
MSEC:
	LXI	D,50000

MWTI:
	IN	MODCTLP
	ANI	MODRCVB
	CPI	MODRCVR
	JZ	MCHAR
	DCR	E
	JNZ	MWTI
	DCR	D
	JNZ	MWTI
	DCR	B
	JNZ	MSEC
	POP	D
	STC
	RET

MCHAR:
	IN	MODDATP
	PUSH	PSW
	CALL	TYPE
	POP	PSW
	POP	D
	PUSH	PSW
	ADD	C
	MOV	C,A
	POP	PSW
	ORA	A
	RET

INITADR:
	LHLD	BASE+1
	LXI	D,3
	DAD	D
	SHLD	VSTAT+1
	DAD	D
	SHLD	VKEYIN+1
	DAD	D
	SHLD	VTYPE+1
	RET

INITMOD	EQU	$
	RET

CRLF:
	MVI	A,CR
	CALL	TYPE
	MVI	A,LF

TYPE:
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MOV	C,A
VTYPE:
	CALL	$-$
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET

STAT:
	PUSH	B
	PUSH	D
	PUSH	H
VSTAT:
	CALL	$-$
	POP	H
	POP	D
	POP	B
	ORA	A
	RET

KEYIN:
	PUSH	B
	PUSH	D
	PUSH	H
VKEYIN:
	CALL	$-$
	POP	H
	POP	D
	POP	B
	ANI	07FH
	RET

ILPRT:
	XTHL
ILPLP:
	MOV	A,M
	ORA	A
	JZ	ILPRET
	CALL	TYPE
	INX	H
	JMP	ILPLP

ILPRET:
	XTHL
	RET

ERXIT:
	POP	D
	MVI	C,9
	CALL	BDOS

MXIT:
	CALL	ILPRT
	DB	CR,LF,'DON''T FORGET TO DISCONNECT MODEM'
	DB	CR,LF,0

EXIT:
	LHLD	STACK
	SPHL
	RET

MOVE128:
	MVI	B,128
MOVE:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET

RCVSNO	DB	0
SECTNO	DB	0
ERRCT	DB	0
EOFLG	DB	0
SECPTR	DW	DBUF
SECINBF	DB	0
	DS	60
STACK	DS	2
DBUF	EQU	$

	END
