
TRUE	EQU 0FFFFH	;DEFINE VALUE OF TRUE
FALSE	EQU NOT TRUE	;DEFINE VALUE OF FALSE


ROM:	EQU 0F000H	;THIS WILL CHANGE
RAM:	EQU 0EF00H	;THIS WILL CHANGE
STACK:	EQU RAM+100	;STACK AREA
FDC	EQU	0CH	;FLOPPY DISK BASE ADDRESS
FDCTRK	EQU	FDC+1
FDCSEC	EQU	FDC+2
FDCDATA	EQU	FDC+3
WAIT	EQU	014H	;FLOPPY WAIT PORT & DRIVE SELECT
;
;	STORAGE AREA
;
	ORG RAM		;RAM AREA
;
PRNTFLG:DS 1		;PRINTER FLAG STORAGE
ECHO:	DS 1		;ECHO FLAG
ADR:	DS 2		;EXAM/MODIF ADDRESS
NUM:	DS 1
NBR:	DS 1
BYTE:	DS 10
NM:	DS 1
SA:	DS 2
FA:	DS 2

;
;	SYSTEM EQUATES
;
BKSP	EQU 08H		;BACKSPACE EQUATE
CR	EQU 0DH		;CARRAIGE RETURN
LF	EQU 0AH		;LINEFEED
ESC	EQU 1BH		;ESCAPE KEY
RUBOUT	EQU 7FH		;RUBOUT KEY
CRTS	EQU 1		;CRT STATUS PORT
CRTO	EQU 0		;CRT OUTPUT PORT
TTYS	EQU 3		;TTY STATUS PORT
TTYO	EQU 2		;TTY OUTPUT PORT
SPORT	EQU CRTS
IPORT 	EQU CRTO

;
;
;	MONITOR SUPPORT VECTORS
;
	ORG ROM		;THIS CHANGES
;
EXEC:	JMP BEGIN	;AND BEGIN
	JMP OUTPUTY	;OUTPUT A CHARACTER FROM REG A
	JMP INPUT	;GET A CHAR. INTO REG A (NO ECHO)
	JMP INPUT0	;CHECK FOR KEY PUSHED..RET IF NONE
	JMP CHIN	;GET CHAR INTO A W/ ECHO,PARITY STRIP
	JMP MSG		;OUTPUT MESSAGE,-H,L. ZERO TERMIN.
	JMP CRET	;OUTPUT CR,LF,RUBOUT
	JMP SPACE	;OUTPUT ONE SPACE
	JMP THXN	;OUT B 3-0 OF'A'IN HEX(1 ASCII CHAR)
	JMP THXB	;OUT REG A IN ASCII-HEX (2 CHARS)
	JMP THXW	;OUTPUT H,L IN ASCII-HEX (4 CHARS)
	JMP GHXN	;GET HEX NIBBLE INTO REG A (B 3-0)
	JMP GHXB	;GET HEX BYTE INTO REG A (B 7-0)
	JMP GHXW	;GET HEX WORD INTO H,L
	JMP STORE	;STORE A BYTE TO MEMORY (CHECK)
	JMP NEGDE	;NEGATE D,E REGISTER
	JMP READY	;OUTPUT'READY' & WAIT. CR IF OK.
	JMP BOOTERR	;PRINT BOOT ERROR
;
;
;
BEGIN:
	MVI A,01001111B	;RESET POWER ON JUMP AND ENABLE MEMORY
	OUT 16H		;WRITE TO CONTROL PORT
	XRA A		;CLEAR REG A
	STA PRNTFLG	;SET PRINTER FLAG
	LXI SP,STACK	;SET SP TO EXEC STACK AREA

; Set up SIO channels
	LXI	H,ISIOA	 		; point to SIO init table
	LXI	B,ISIOAL*256+CRTS	; length in B & port in C
	DB	0EDH			; OTIR
	DB  	0B3H			; mass programming
	LXI	H,ISIOB	 		; repeat for channel B
	LXI	B,ISIOBL*256+TTYS
	DB  	0EDH			; OTIR
	DB	0B3H

	JMP	SIGN			; go signon
; ****** INITIALIZATION TABLES FOR SIO DEVICES ******
;
; CHANNEL A
ISIOA:	DB	018H			; channel reset
	DB	004H			; write reg 4
	DB	044H			; X16 clock, 1 stop bit
	DB	003H			; write reg 3
	DB	0C1H			; Rx 8-bit char, Rx enable
	DB	005H			; write reg 5
	DB	0EAH			; DTR, Tx 8-bit char, Tx enable, RTS
;
;
	DB	000H			; read reg 0

ISIOAL	EQU	$-ISIOA			; length of sequence
;
; CHANNEL B
ISIOB:	DB	018H			; channel reset
	DB	004H			; write reg 4
	DB	044H			; X16 clock, 1 stop bit
	DB	003H			; write reg 3
	DB	0C1H			; Rx 8-bit char, Rx enable
	DB	005H			; write reg 5
	DB	0EAH			; DTR, Tx 8-bit char, Tx enable, RTS
;
	DB	000H			; read reg 0
ISIOBL	EQU	$-ISIOB			; length of sequence

SIGN:
	LXI H,M0	;OUTPUT ENTRY SIGN-ON
	CALL MSG	;PRINT IT
;
;	START OF MONITOR COMMAND AREA
;
NEXT:	LXI SP,STACK	;SET UP SP AGAIN
	LXI H,M1	;OUTPUT PROMPTER (*)
	CALL MSG	;PRINT IT
NEXT1:	CALL CHIN	;GET COMMAND CHAR. IN
	CPI 10H		;CNTL P?
	JZ PRNT		;CHANGE PRINT FLAG
	MOV B,A		;SAVE IT REG B
;
;	SEARCH TABLE FOR COMMAND
;
	LXI H,OPTAB	;H,L POINTS TO START OF TABLE
SRCH:	MOV A,M		;GET COMMAND BYTE
	CPI 0FFH	;END OF TABLE?
	JZ ILLEG	;NOT FOUND IN COMMAND
	CMP B		;DOES A = B?
	JZ FNDCM	; YES!
	INX H		;BUMP 3 TIMES
	INX H		;FOR NEXT BYTE
	INX H
	JMP SRCH	;CONTINUE,,,
;
;	UNDEFINED COMMAND,,DO ERROR MESSAGE
;
ILLEG:	LXI H,M2	;GET ERROR MSG
	CALL MSG	;PRINT IT
	JMP NEXT	;TRY ANOTHER COMMAND
;
;	COMMAND FOUND,,GO DO IT
;
FNDCM:	INX H		;GET LOW ADDR. BYTE
	MOV E,M		;PUT IT IN E REG
	INX H		;GET HIGH ADDR. BYTE
	MOV D,M		;PUT IT IN D REG
	XCHG		;FLIP D,E & H,L
	PCHL		;GO DO IT!
;
;
;	THIS IS AN OUTPUT ROUTINE FOR
;	BOTH AN CRT AND AN TTY MACHINE
;
;
;
OUTPUTY:PUSH PSW	;SAVE DATA
	LDA PRNTFLG	;CHECK PRINT FLAG
	RAR		;IS IT ON?

	JNC OUTPUTC

TTYS1:	IN TTYS		;CHECK TTY STATUS
	ANI 04H		;MASK BIT 2
	JZ TTYS1	;NOT READY..DO AGAIN
	POP PSW		;RESTORE DATA

	PUSH PSW

	OUT TTYO	;PRINT IT ON TTY

OUTPUTC:IN CRTS		;GET CRT STATUS
	ANI 04H		;MASK BIT 7
	JZ OUTPUTC
	POP PSW		;GET DATA
	OUT CRTO
	RET

;
;
;	THIS IS THE INPUT ROUTINE
;
;
;
INPUT0:	IN SPORT	;CHECK STATUS
	ANI 01H		;MASK BIT 0
	RZ		;RET IF NO KEY PUSHED
	JMP INPUT1	;GET KEY PUSHED
;
;
INPUT:	IN SPORT	;CHECK STATUS
	ANI 01H		;MASK BIT 0
	JZ INPUT	;NOT READY
INPUT1:	IN IPORT	;GET DATA
	ANI 7FH		;STRIP PARITY OFF
	RET
;
;
;	CHIN - INPUT ONE CHAR,,STRIP
;	PARITY,,ECHO IF >= SPACE
;
;
CHIN:	MVI A,0FFH	;SET ECHO
	STA ECHO	; FLAG ON
CHINN:	CALL INPUT	;GET CHAR.
	PUSH PSW	;SAVE DATA
	LDA ECHO	; AND CHECK
	ANA A		;  ECHO FLAG
	JNZ $+5		;ECHO SET
	POP PSW		;ECHO NOT SET
	RET		; SO RETURN
	POP PSW		;RESTORE DATA & ECHO
	CPI 20H		;CHECK FOR CNTL.
	CNC OUTPUTY	;PRINT IF >= SPACE
	RET
;
;
;	MESSAGE PRINT ROUTINE
;
;
MSG:	PUSH PSW	;SAVE DATA
	PUSH H		;SAVE H,L
MNXT:	MOV A,M		;GET CHAR
	ORA A		;IS IT ZERO?
	JZ MDONE	;YES,,RESTORE REGS.
	CALL OUTPUTY	;PRINT IT!
	INX H		;BUMP H,L BY 1
	JMP MNXT	;DO AGAIN
;
;
MDONE:	POP H		;RESTORE H,L
	POP PSW		;RESTORE A
	RET		;BACK TO CALLER
;
;
;	ROUTINE TO TYPE CR,LF,RUBOUT
;
;
CRET:	PUSH H		;SAVE H,L
	LXI H,CRMSG	;CR,LF,RBO MSG
	CALL MSG	;PRINT IT
	POP H		;RESTORE H,L
	RET
;
;
CRMSG:	DB CR,LF,0
;
;
HOLDDIS:CALL INPUT0	;KEY PUSHED YET?
	CPI ESC		;ESCAPE?
	JZ NEXT		;BACK TO MONITOR
	CPI 08H		;ANY KEY PUSHED?
	RNC		;YES,,PRINT MORE
	JMP HOLDDIS	;NO,,SO HOLD SOME MORE
;
;
;	ROUTINE CHANGES PRINT FLAG VALUE
;	WHEN CNTL P IS USED
;
;
PRNT:	LDA PRNTFLG	;GET PRINT FLAG
	CMA		;FLIP OVER
	STA PRNTFLG	;NEW FLAG VALUE
	JMP NEXT1	;PAST (*) CHAR.
;
;
;
;
;	ROUTINE TO TYPE A SPACE
;
;
SPACE:	PUSH PSW	;SAVE A
	MVI A,20H	;SPACE CHAR
	JMP THXN1	;PRINT IT
;
;
;	TYPES REG A
;
;	ON OUTPUT DEVICE
;
;
THXB:	PUSH PSW	;SAVE A
	RRC
	RRC
	RRC
	RRC
	CALL THXN	;PRINT HEX NIBBLE
	POP PSW		;RESTORE DATA
	CALL THXN	;PRINT RIGHT NIBBLE
	RET
;
;
;	ROUTINE TYPES ONE ASCII CHAR. FROM
;	BITS 3-0 OF REG A IN HEX
;
;
THXN:	PUSH PSW	;SAVE A
	ANI 0FH		;ISOLATE B 3-0
	CPI 0AH		;IS IT > 9?
	JC $+5
	ADI 7
	ADI 30H
THXN1:	CALL OUTPUTY	;PRINT IT
	POP PSW		;RESTORE A
	RET
;
;
;	ROUTINE TYPES A WORD IN HEX FROM
;	REG H,L
;
;
THXW:	PUSH PSW	;SAVE A
	MOV A,H		;GET HIGH BYTE
	CALL THXB	;PRINT IT
	MOV A,L		;GET LOW BYTE
	CALL THXB	;PRINT IT
	POP PSW		;RESTORE DATA TO A
	RET
;
;
;	ROUTINE GETS ONE HEX CHAR FROM INPUT
;
;
GHXN:	CALL CHIN	;GET CHAR
	CPI '0'
	RC		;RET IF < ZERO
	CPI ':'		;IS IT NUMERIC?
	JC GHX1		;CHAR IS 0 TO 9
	CPI 'A'		;IS IT A - F?
	RC		;CHAR : TO ' '
	CPI 'G'		;IS IT > F?
	CMC		;FLIP CARRY SENSE
	RC		;IT IS > F!
	SUI 7		;ADJ FOR A - F
GHX1:	SUI '0'		;MAKE BINARY
	RET
;
;
;	ROUTINE GETS ONE HEX BYTE FROM INPUT
;
;
GHXB:	CALL GHXN	;GET LEFT NIBBLE
	RC		;NON-HEX,,JUMP OUT!
	PUSH B		;SAVE B,C
	RLC
	RLC
	RLC
	RLC
	MOV B,A		;SAVE IN B
	CALL GHXN	;GET RIGHT NIBBLE
	JC $+4		;JUMP IF NON-HEX
	ADD B		;ADD LEFT NIBBLE
	POP B		;RESTORE B,C
	RET
;
;
;	ROUTINE GETS HEX WORD FROM INPUT
;
;
GHXW:	STC		;SET AND CLEAR CY
	CMC
	PUSH PSW
	CALL GHXB	;GET HIGH HEX BYTE
	MOV H,A
	JNC GHX2	;JMP IF VALID
	POP PSW
	MOV A,H
	STC
	RET
;
;
GHX2:	CALL GHXB	;GET LOW HEX BYTE
	MOV L,A
	JNC GHX3	;JMP IF VALID
	POP PSW
	MOV A,L
	STC
	RET
;
;
GHX3:	POP PSW		;ALL OK!
	RET		;RET,,H,L IS WORD
;
;
;	ROUTINE TO STORE A BYTE IN MEMORY
;	WITH CHECK.
;
;
STORE:	MOV M,A		;STORE BYTE
	CMP M		;CHECK IT
	RZ		;RETURN IF OK
	PUSH H		;SAVE ADDRESS
	LXI H,M4	;TYPE ERROR
	CALL MSG	;PRINT IT
	POP H		;RESTORE ADDRESS
STOREA:	CALL THXW	;TYPE BAD ADDRESS
	JMP NEXT	;RETURN TO MONITOR
;
;
;	MEMORY EXAM/MODIFY ROUTINES
;
;
GETAD:	CALL SPACE	;TYPE A SPACE
	CALL GHXW	;GET ADDR.
	JNC GTA1	;JMP IF VALID
ILLCH:	LXI H,M3	;ILLEGAL INPUT
	JMP ILLEG+3
GTA1:	SHLD ADR	;SAVE ADDR.
LOCAT:	CALL CRET	;GET CR,LF
	LHLD ADR	;GET ADDR.
	CALL THXW	;PRINT IT
	CALL SPACE
	MOV A,M
	CALL THXB	;PRINT MEMORY CONTENTS
	CALL SPACE
	CALL GHXB	;GET DATA OR COMMAND
	JC NONHX	;NON-HEX INPUT
	CALL STORE	;STORE VALUE IF VALID
NXLOC:	LHLD ADR
	INX H		;BUMP H,L 1
	JMP GTA1	;CONTINUE
NONHX:	CPI CR		;IS IT CR?
	JZ NEXT		;YES,,SO EXIT
	CPI 20H		;IS IT SPACE?
	JZ NXLOC	;GET NEXT ADDR.
	CPI '-'		;BACK ONE POSITION?
	JNZ ILLCH
LSTLC:	LHLD ADR	;GET ADDR.
	DCX H		;DECREASE -1
	JMP GTA1	;CONTINUE
;
;
;	ROUTINE NEGATES REG D,E
;
;
NEGDE:	PUSH PSW	;SAVE DATA
	MOV A,D
	CMA
	MOV D,A
	MOV A,E
	CMA
	MOV E,A
	INX D
	POP PSW
	RET
;
;
;	DUMP MEMORY ROUTINE
;
;
DUMP:	CALL PU3	;GET HEX ADDR.
	CALL PU3	;ANOTHER
;
;  FROM ADDR IN H,L TO ADDR IN D,E
;
	CALL NEGDE	;COMP.D,E FOR END CK.
DMRET:	CALL CRET	;GET CR,LF
	CALL THXW	;PRINT ADDR
	CALL SPACE
DMNXT:	CALL SPACE
	MOV A,M		;GET DATA
	CALL THXB	;PRINT IT
	CALL LAST	;CHECK FOR END
	CALL ESCAPE	;CHECK FOR ABORT
	CPI 'S'-40H	;CNTL-S?
	CZ HOLDDIS	;YES,,STOP DISPLAY
	MOV A,L		;CHECK FOR MOD 16
	ANI 15
	JZ DMRET	;DO NEW LINE IF 16
	JMP DMNXT	;CONTINUE
;
;
;	DIRECT GO-TO ROUTINE
;
;
GOTO:	CALL PU3	;GET ADDR.
	XCHG		;FLIP D,E & H,L
	CALL READY	;CHECK FOR MOVE
	PCHL		;BE THERE
HELP:
	LXI	H,HELPM
	CALL	MSG
	JMP	NEXT

;
;
;	VERFIY ROUTINE,,TYPES READY?
;
;
READY:	PUSH PSW
	PUSH H
	LXI H,M7	;GET READY MSG
	CALL MSG	;PRINT IT
	LXI H,M7A	;GET ?
	CALL MSG	;PRINT IT
	LXI H,M8	;POSSIBLE ABORT
	CALL CHIN
	CPI 'Y'		;IS IT A YES?
	JNZ ILLEG+3	;DO ABORT MSG
	POP H
	POP PSW
	RET
;
;
;	ROUTINE CHECK FOR END OF ADDR
;
;
LAST:	PUSH H		;SAVE MEM ADDR
	DAD D		;ADD NEG END OF ADDR
	JC NEXT		;END,,BACK TO MONITOR
	POP H
	INX H
	RET
;
;
;	MOVE ROUTINE
;
;
MOVE:	CALL PU3	;GET ADDR
	PUSH D
	CALL PU3
	CALL PU3
	XCHG
	XTHL
	CALL NEGDE
	CALL READY
MOV1:	MOV A,M
	XTHL
	CALL STORE
	INX H
	XTHL
	CALL LAST
	CALL ESCAPE	;ABORT?
	JMP MOV1
;
;
;	FILL ROUTINE
;
;
FILL:	CALL PU3
	CALL PU3
	CALL NEGDE
	CALL SPACE
	CALL GHXB
	JC ILLCH
	CALL READY
FILLF:	CALL STORE
	CALL LAST
	JMP FILLF
;
;
;	ROUTINE INPUTS ADDR INTO
;	H,L,,,THEN XCHG'S WITH D,E
;
;
PU3:	CALL SPACE
	CALL GHXW
	JC ILLCH
	XCHG
	RET
;
;	MEMORY CATALOG ROUTINE
;	FIND AND PRINTS RAM SPACE
;
;
LOOKM:	CALL CRET	;GET CR,LF
	CALL CRET
	LXI H,RAM		;START AT ZERO
	LXI D,ROM	;END WITH WRAP-AROUND
LOOPM1: CALL TESTM1	;FIND GOOD RAM
	JZ CONTM	;IF GOOD RAM..CONTINUE!
	INX H
	CALL DONEM	;IS IT THE END?
	JNZ LOOPM1	;NO,,,CONTINUE!
CONTM:  CALL THXW	;PRINT ADDRESS
	MVI A,'-'
	CALL OUTPUTY	;PRINT IT
LOOPM2:	MOV A,D
	CMP H
	JNZ BYPAS
	INR H
BYPAS:	CALL TESTM1	;TEST FOR GOOD RAM
	JNZ ERRORM
	INX H
	CALL DONEM
	JNZ LOOPM2
	DCX H
	CALL THXW	;PRINT ADDRESS
	JMP RETMON;	;BACK TO MONITOR
ERRORM:	DCX H
	CALL THXW	;PRINT ADDRESS
	CALL SPACE
	INX H
	INX H
LOOPM3:	CALL TESTM1
	JZ LOOPM1
	INX H
	CALL DONEM
	JNZ LOOPM3
RETMON:	CALL CRET
	JMP NEXT
TESTM1:	MOV A,M
	MOV B,A
	CMA
	MOV M,A
	MOV A,M
	CMA
	CMP B
	MOV M,A
	RET
DONEM:	XRA A
	CMP L
	RNZ
	CMP H
	RET
;
;
;	MEMORY TEST ROUTINE
;
;
MEMTS:	CALL CRET	;GET CR,LF
	LXI H,READST	;H,L = STARTING ADDR. MSG
	CALL MSG	;PRINT IT
	CALL PU3	;GET START ADDRESS
	PUSH D		;SAVE D FOR POP H LATER
	CALL CRET
	LXI H,ENDADD	;H,L = ENDING ADDR. MSG
	CALL MSG	;PRINT IT
	CALL PU3	;GET ENDING ADDRESS
	INX D		;BUMP FOR CORRECTION
	CALL CRET
	CALL NEGDE	;SET UP D,E FOR END ADDR.
	MVI B,0		;SET UP MODIFIER
	PUSH PSW	;SAVE DATA AND FLAGS
	MOV A,B		;LOAD B INTO A
	CMA		;FLIP OVER FOR LIGHTS
	OUT 0FFH	;SHOW ON FRONT PANEL
	POP PSW		;RESTORE REG A
LOOP:	POP H		;GET START ADDR OFF STACK
	PUSH H		;SAVE FOR MEMORY COMPARE
FILL1:	CALL RND	;GET RANDOM NUMBER FOR MEM.
	CALL STORE1	;STORE IT WITH CHECK
	INX H		;BUMP H,L BY 1
	CALL ESCAPE	;CHECK FOR ABORT
	PUSH H		;SAVE H,L FOR END CHECK
	DAD D		;ADD NEG END OF ADDRESS TO H,L
	JC TEST1	;IT'S THE END..JMP TO TEST
	POP H		;NOT END.. GO BACK TO FILL1
	JMP FILL1	;DO AGAIN
TEST1:	POP H		;FIX STACK BACK 1 SO CORRECT
TEST:	POP H		;THIS IS CORRECT START ADDR.
	PUSH H		;SAVE FOR USE AGAIN LATER
TESTM:	CALL RND	;GET RANDOM NUMBER FOR TEST COMP.
	CMP M		;IS IT THE SAME?
	CNZ ERROR	;NO..SHOW WHAT IT IS!
	INX H		;BUMP H,L BY 1
	CALL ESCAPE	;CHECK FOR ABORT
	PUSH H		;SAVE FOR END CHECK
	DAD D		;ADD NEG ADDR TO H,L
	JC RESTART	;YES..DO MEMTS AGAIN!
	POP H		;RESTORE H,L
	JMP TESTM	;TEST MORE MEMORY
RESTART:POP H		;FIX STACK DOWN 1
	INR B		;CHANGE MODIFIER
	PUSH PSW	;SAVE REG A
	MOV A,B		;A = MODIFIER UPDATE
	CMA		;FLIP OVER FOR PANEL
	OUT 0FFH	;SHOW ON PANEL
	POP PSW		;RESTORE REG A
	JMP LOOP	;DO MEMTS AGAIN
STORE1:	MOV M,A		;STORE INTO MEMORY (H,L)
	CMP M		;CHECK IF THERE...
	RZ		;RETURN IF OK
ERROR:	CALL THXW	;TYPE BAD ADDRESS
	CALL SPACE
	CALL THXB	;TYPE GOOD BYTE
	CALL SPACE
	PUSH PSW	;SAVE DATA FOR RET
	MOV A,M		;GET BAD BYTE
	CALL THXB	;TYPE BAD BYTE
	CALL SPACE
	PUSH H		;SAVE ADDRESS FOR RET
	LXI H,M4A	;ERROR! WORD
	CALL MSG	;PRINT IT
	CALL CRET	;GET CR,LF
	POP H		;RESTORE ADDRESS
	POP PSW		;RESTORE GOOD BYTE
	RET
RND:	MOV A,L		;GET LOW BYTE OF ADDRESS
	XRA H		;XOR WITH HIGH BYTE
	XRA B		;XOR WITH MODIFIER
	RET		;RETURN TO CALLER
;
;	ASCII PRINT ROUTINE
;	PRINTS FROM START ADDRESS,
;	TO ENDING ADDRESS IN MOD 16
;
;
APRINT:	CALL PU3	;GET HEX ADDRESS
	CALL PU3	;AGAIN,,,
	CALL NEGDE
APRET:	CALL CRET	;CR,LF
	CALL THXW	;TYPE ADDRESS
	CALL SPACE
APNXT:	CALL SPACE
	CALL SPACE
	CALL APRNT	;PRINT H,L IN ASCII
	CALL LAST	;END?
	CALL ESCAPE	;ABORT?
	CPI 'S'-40H	;CNTL-S?
	CZ HOLDDIS	;IF YES,,STOP PRINT
	MOV A,L		;MOD 16 YET?
	ANI 15
	JZ APRET	;NEW LINE
	JMP APNXT	;CONTINUE
APRNT:	MOV A,M		;GET CHAR (H,L)
	CPI 20H		;LESS THAN SPACE?
	JC BCKSLAS
	CALL OUTPUTY	;PRINT IT
	RET
BCKSLAS:MVI A,5CH	;BACKSLASH
	CALL OUTPUTY
	RET
;
;	SEARCH ROUTINE
;
;
;SERCH:	CALL ZBUF	;ZERO BUFFER
;	CALL PU3	;GET START ADDR.
;	XCHG
;	SHLD SA		;SAVE START ADDR.
;	CALL PU3	;GET END ADDR.
;	XCHG
;	SHLD FA		;SAVE END ADDR.
;	CALL CRET
;	CALL CRET
;	LXI H,PATMSG	;PATTERN MSG
;	CALL MSG
;	CALL GHXN	;GET # OF BYTES
;	STA NBR
;	STA NM
;	PUSH PSW
;	LXI H,PATTRN
;	CALL MSG
;	POP PSW
;	MOV C,A		;SAVE COUNT IN C
;	LXI D,BYTE	;PATTERN STORAGE
;	CALL SPACE
;	CALL SPACE
;ETTER:	CALL GHXB	;GET PATTERN
;	STAX D		;STORE A
;	INX D
;	DCR C
;	CALL SPACE	;SPACE BETWEEN CHARS.
;	JNZ ENTER	;GET MORE NOT = ZERO
;	CALL CRET
;	CALL CRET
;LOOK:	LHLD FA		;GET END ADDR.
;	XCHG
;	CALL NEGDE	;NEG. FOR END CHECK
;LOOK1:	LXI B,BYTE	;B,C POINTS TO PATTERN
;	LHLD SA		;GET START ADDR.
;	LDAX B		;GET PATTERN
;LOOK1A: PUSH PSW	;SAVE REG A
;	LDA NBR		;GET COUNT
;	STA NUM		;SAVE IT HERE
;	CALL ENCK	;END YET?
;	CALL ESCAPE	;ABORT?
;	POP PSW		;RESTORE A
;	CMP M		;MATCH?
;	JZ LOOK2	;YES..DO MORE
;	INX H
;	SHLD SA		;SAVE NEW ADDR.
;	JMP LOOK1A	;NO..START AGAIN
;LOOK2:	INX H
;	SHLD SA
;	DCX H
;LOOK3:	CALL FIN	;LAST BYTE?
;	INX H
;	INX B
;	LDAX B
;	CMP M		;MATCH?
;	JZ LOOK3	;YES,,DO MORE!
;	JMP LOOK1	;NO,,,START AGAIN
;FIN:	PUSH H		;SAVE H,L
;	LXI H,NUM
;	DCR M
;	POP H		;RESTORE H,L
;	RNZ		;MORE BYTES IF <>0
;PRT:	LHLD SA
;	DCX H
;	SHLD SA
;	CALL THXW	;PRINT ADDR.
;	CALL SPACE
;	CALL SPACE
;	LXI H,NBR	;GET # OF BYTES
;	MOV C,M		;PUT COUNT INTO C
;	INX H
;PRT1:	MOV A,M		;GET HEX PATTERN
;	CALL THXB	;PRINT ASCII HEX
;	CALL SPACE
;	DCR C
;	PUSH H
;	LXI H,NM
;	MOV M,C
;	POP H
;	XRA A
;	CMP C
;	JZ PRT2
;	INX H
;	JMP PRT1
;PRT2:	CALL CRET	;GET CR,LF FOR NEXT LINE
;	LHLD SA
;	INX H
;	SHLD SA
;	JMP LOOK1	;LOOK FOR MORE IN MEMORY
;ENCK:	PUSH H		;SAVE H,L
;	DAD D		;ADD NEG OF END ADDR (TO H,L)
;	POP H
;	RNC		;CY=0,NOT END YET
;	CALL CRET
;	LDA NM
;	CPI 0
;	JZ NEXT		;IF NO ERROR,,TO MONITOR
;	LXI H,M3	;PRINTS ? ? ?
;	JMP ILLEG+3	;PRINT IT
;ZBUF:	XRA A		;CLEAR A
;	LXI H,NUM	;BUFFER AREA
;	MVI B,17	;BUFFER LENGTH
;ZBUF1:	CALL STORE1	;STORE A WITH CHECK
;	INX H
;	DCR B
;	JNZ ZBUF1	;NOT DONE,,DO MORE
;	RET
ESCAPE: CALL INPUT0	;CHECK FOR KEY PUSHED
	CPI ESC		;ESCAPE KEY?
	JZ NEXT
	RET

; READ TRACK O SECTOR 1 INTO MEMORY

BOOT5:
	MVI	A,8
	OUT	WAIT			; set double density for mini
BOOT:
	MVI	A,0DH			; reset fdc
	OUT	FDC
	NOP
FDCW1:
	IN	FDC			; check busy
	RRC
	JC	FDCW1

	NOP
	NOP
	NOP
	NOP

	MVI	A,3			; get a restore
	OUT	FDC
	NOP

	IN	WAIT
	NOP
TK0:	
	IN	FDC
	ANI	4			; check track 0
	JZ	TK0

	XRA	A
	MOV	L,A			; point at loc 0
	MOV	H,A
	INR	A
	OUT	FDCSEC			; SET SECTOR
	MVI	A,08CH
	OUT	FDC
	NOP
FDCRD:
	IN	WAIT
	ORA	A
	JP	BOOTDN
	IN	FDCDATA
	MOV	M,A
	INX	H
	JMP	FDCRD

BOOTDN:	
	IN	FDC
	ORA	A
	JZ	0
BOOTERR:
	PUSH	PSW
	LXI	H,BTERR
	CALL	MSG
	POP	PSW
	CALL	THXB
	JMP	NEXT
 
;	MONITOR MESSAGES
;
M0:	DB CR,LF,' > ADVANCED MICRO DIGITAL CORP.'
	DB CR,LF,'   Monitor Version 1.1'
	DB CR,LF,'   Mar - 1982'
	DB CR,LF,'   Press "H" for help',0
M1:	DB CR,LF,' >',0
M2:	DB ' UNDEFINED',0
M3:	DB ' ????',0
M4:	DB CR,CR,LF,'MEMORY WRITE ERROR AT ',0
M4A	DB 'ERROR',0
M5:	DB ' PAUSE',0
M7:	DB ' READY (Y,N)',0
M7A:	DB '? ',0
M8:	DB ' ABORTED',0
FINLMSG:DB 'ENDING ADDRESS.',LF,0
LENGTH: DB ' LENGTH:',0
READST:	DB 'STARTING ADDRESS:',0
ENDADD: DB 'ENDING ADDRESS:',0
BTERR:	DB 'FDC COLD BOOT ERROR CODE ',0
HELPM:	DB CR,LF,'MONITOR COMMANDS :'
	DB CR,LF,'Control B	= Load disk boot loader 5.25"'
	DB CR,LF,'Control C	= Load disk boot loader 8"'
	DB CR,LF,'D SSSS QQQQ	= Dump memory in hex from SSSS to QQQQ'
        DB CR,LF,'F SSSS QQQQ BB	= Fill memory from SSSS to QQQQ with BB'
	DB CR,LF,'G AAAA	 	= Go to address AAAA'
	DB CR,LF,'L AAAA	 	= Load memory starting at AAAA'
	DB CR,LF,'M SSSS QQQQ DDDD= Move starting at S to Q to Addr. D'
	DB CR,LF,'P SSSS QQQQ	= Print in ascii from SSSS to QQQQ'
	DB CR,LF,'T		= Test Memory'
	DB CR,LF,'ESC will terminate any command'
	DB 0

;	THIS IS THE COMMAND TABLE
;	FOR THE NEW SYSTEM MONITOR
;
;
OPTAB:	DB 'L'		;COMMAND
	DW GETAD	; FOR ADDRESS
	DB CR		;COMMAND
	DW NEXT		;OVER AGAIN
	DB '.'		;COMMAND
	DW LOCAT	; CURRENT LOC.
	DB '-'		;COMMAND
	DW LSTLC	; LOC - 1
	DB 'D'		;COMMAND
	DW DUMP		; DUMP
	DB 'F'		;COMMAND
	DW FILL		; FILL
	DB 'G'		;COMMAND
	DW GOTO		; GOTO
	DB 'M'		;COMMAND
	DW MOVE		; MOVE
	DB 'T'		;COMMAND 
	DW MEMTS	; MEMORY TEST
	DB 'P'		;COMMAND
	DW APRINT	; ASCII PRINT
 	DB 03H		;COMMAND
	DW BOOT		; BOOT FLOPPY
	DB 02H		; COMMAND ^B
	DW BOOT5	; BOOT MINI FLOPPY
	DB 'H'		;COMMAND
	DW HELP
	DB 0FFH		;TERMINATOR

	END
	
