/*
	           C to dBASE II INTERFACE PROGRAM
    Copyright (c) 1983,84 Computer Innovations, Inc. All Rights Reserved. 

*/

#define TRUE 	  1	/* to provide boolean processing */
#define FALSE 	  0
#define DOS	  TRUE	/* for MS/PC-DOS systems */

#ifndef NULL
#define NULL 	  0
#endif

#ifndef EOS
#define EOS '\0'
#endif

/*
	C2DBASE.H - header file for the c_to_dbase system
*/

/* contrived data types */ 
#define UCHAR   unsigned char       /*  8 bits unsigned */ 
#define SCHAR   char		    /*  8 bits signed   */ 
#define CHAR	char		    /* 8 bits, doesn't matter */
#define SSHORT	short               /* 16 bits signed   */ 
#define USHORT  unsigned short      /* 16 bits unsigned */ 
#define SINT	int		    /* signed int */
#define UINT	unsigned int	    /* unsigned int */
#define SLONG   long                /* 32 bits signed   */ 
#define ULONG   unsigned long       /* 32 bits unsigned */ 
#define DOUBLE  double		    /* 64 bits floating point */ 
#define VOID	int		    /* doesn't return anything */ 
#define BOOL	int		    /* returns TRUE/FALSE */
#define NODE	struct dnode	    /* basic node structure */
#define KEY	struct bucket       /* basic key structure */ 
#define UKEY	union  ukey	    /* pointer union for keys */
#define RECNO   USHORT		    /* for record numbers */

/* 
	maximum number of fields per record, set by dBASE 
*/ 
#define MAX_FIELDS	32      /* don't change this parameter */

/*
	You will probably want to increase the next two defines if
	you want to process larger data files with indices
*/

/* name of the printer file */
#define PRTFILE	"PRN:"

/* maximum number of keys per node */
#define MAXKEYS	 255

/* maximum number of nodes per index file */
#ifdef	_C86_BIG 
#define MAXMN	 100           /* you need about 1K byte for each node */ 
#else 
#define MAXMN	 50 
#endif 

/* define minimum number of nodes in memory cache */
#define MINMN	3 

/* default maximum number of nodes in memory cache */
#define DEFMN	10 

/* default minimum number of bytes that coreleft() must return to call 
   calloc() */ 
#define CORE_MIN	3000

/* Define the stack level for processing of index file trees. 
   This should be enough for 64k keys. 
*/ 
#define STACKDEPTH 	9	/* actually 8 is enough, but be safe */ 

/* error code returns */
#define SUCCESS   	0	/* file is found and read correctly */
#define NO_FILE   	1	/* file not found and opened */
#define NOT_DBASE 	2	/* file opened was not dbase file */
#define FIELD_ERROR 	3	/* error reading a field */
#define NO_PRINT	4	/* printer not opened */
#define NDXERROR	5	/* index file error */
#define NO_CREATE	6	/* couldn't create dbase file */
#define FILE_EXISTS	7	/* file already exists */ 
#define NOARG 		10	/* no command line argument supplied */

#define EFFLUSH		20	/* fflush error */ 
#define EFWRITE		21    	/* fwrite error */ 
#define ERDNODE		22	/* error in reading node */ 
#define EFSEEK	     	23	/* error in fseek */ 
#define EDREAD	     	24	/* error in dread() */ 
#define EWR_NODE     	25	/* error in wr_node() */ 
#define EPOS_NODE    	26	/* error in pos_node() */ 
#define ERD_NODE     	27	/* error in rd_node() */ 
#define EDCLOSE		28	/* error closing data or index file(s) */
#define EDALLOC		29	/* error in dalloc() */
#define EDBOTTOM     	30	/* error in dbottom() */



/* special characters */
#define ESC 		0x1b	/* escape character     */
#define CTRLC 		0x03	/* control C character  */

/* for printing of records */
#define NARROW 		79	/* for 80 column output  */
#define WIDE 		127	/* for 128 column output */

/* dBASE data types */
#define CHARACTER 	'C'	/* dBASE character information */
#define LOGICAL 	'L'	/* dBASE logical information   */
#define NUMERIC 	'N'	/* dBASE numeric information   */

#ifdef	DOS
#define FNAMELEN	100	/* leave enough room for path in DOS 2.0 */ 
#else
#define FNAMELEN	15
#endif

#define	BLOCK 		255	/* temporary strings */ 

#define DBFHDRLEN	(521L)	/* data file header size */ 

#define NDXHDROFF 	(512L)	/* offset for index file header */ 
#define NODESIZE	(512L)  /* size of a node in bytes */

typedef struct master *MASTER;

/*
	struct bucket:

	This structure holds the actual key contents. These include
	a pointer to the lower level, a record number and the actual
	key that is being indexed on.

	The names of the elements of this structure begin with key_

*/

struct bucket {
		USHORT	 key_pll; 	/* pointer to lower level      */
		RECNO	 key_rno;	/* record number               */
		union ukey { 
			UCHAR  *ckey;
			DOUBLE *fkey;
			} key_val;
		} ;

/*
	struct dnode:

	This structure holds: 

	dn_nnode: the number of the node put here (zero if empty) 
	dn_dirty: TRUE if the node is dn_dirty 
	dn_nkeys: number of keys in this node 
	dn_leaf: pointer table for leaves	 
	 
	The names of the elements of this structure begin with dn_

*/

struct dnode {
	struct bucket **dn_leaf;	 /* pointer table for leaves */ 
	ULONG	 dn_used;		 /* for least recently dn_used  */ 
	USHORT   dn_nnode;		 /* number of node put here */ 
	UCHAR	 dn_dirty;		 /* is the node dn_dirty ? */ 
	UCHAR	 dn_nkeys;		 /* number of keys in this node */
} ;

/*
	struct dndx:
	
	This structure holds the index file header record information.
	This gives information about the nodes in the file and how
	they are to be interpreted.

	The names of the elements of this structure begin with ndx_

*/

struct dndx {
	RECNO	ndx_root, 	/* node number of root node      */
		ndx_next;	/* node number of next free node */
	SSHORT	ndx_nblocks,	/* # of blocks in memory         */ 
		ndx_ncnt;	/* # of nodes in the index file  */ 
	UCHAR	ndx_lkey, 	/* length of key                 */
		ndx_lkp, 	/* length of key + ptr (key+2)   */
		ndx_kmax, 	/* max. no. keys per node        */
		ndx_flag, 	/* 0 if character key            */ 
		ndx_fwidth,	/* field width		         */ 
		ndx_fprec,  	/* number of decimals	         */ 
		ndx_kexpr[256];	/* key expression in ASCII       */
	KEY 	*ndx_kcurr;	/* pointer to current key   */
	} ;

/*
	struct field_descr:

	This structure is dn_used to hold a single field in a record.
	It has places to store name, type, width, precision and the
	actual field contents, which may be character, numeric, or
	logical data. A union is provided so that any of the above 
	types can be placed in the same memory location even though
	they vary in size. In the following code:

	fld_u.string signifies a character string such as "this"
	fld_u.numeric signifies a floating point number such as 99.88
	fld_u.logical signifies a single character (logical) such as 'T'

	The names of the elements of this structure begin with fld_
*/

struct field_descr {
	union {
		DOUBLE numeric;		/* numeric data */
		UCHAR  string[BLOCK];	/* char string */
		UCHAR  logical;		/* logical data */
		} fld_u;
	UCHAR fld_type,			/* C N or L */
	      fld_width,    		/* field size binary */
	      fld_prec,     		/* number of decimals binary */
	      fld_name[11];     	/* Zero filled, ASCII */
	} ;
/*

	struct master:

	This structure is dn_used to hold the names of and the pointers to
	the data base file and the index file associated with it (if any),
	as well as the header record for the data base file. It also is
	dn_used to hold pointers to the other structures needed for indexed
	and sequential file processing. This is the master control 
	structure.

	This structure is needed for all processing.

	The names of the elements of this structure begin with m or m_

*/

struct master {
	struct 	dnode *mno[MAXMN];
	struct 	dndx *mndx;
	struct 	field_descr mfd[MAX_FIELDS];     /* field descriptors */
	FILE 	*m_ndx_ptr;	    	/* pointer to index file           */
   	FILE 	*m_dbf_ptr;	    	/* file pointer for i/o operations */
   	RECNO 	m_nrecs; 	    	/* number of records in the file   */
	USHORT	m_rsize; 		/* size of records 		   */
	USHORT 	m_mincore;		/* minimum amount of coreleft() 
  					 needed before calling calloc() */ 
	SSHORT	m_maxnodes;		/* # of memory buffers to use for nodes */
	UCHAR 	m_month,	 	/* date of last update             */
	     	m_day,
	        m_year,
	        m_nflds,	 	/* number of fields present        */
	      	m_deleted,	 	/* '*' if record deleted, else ' ' */
	      	m_error,     		/* error code */
	      	m_ndx_here,		/* TRUE if ndx is present          */
                m_dbf_name[FNAMELEN], 	/* name of dBASE data file  	   */
	     	m_ndx_name[FNAMELEN]; 	/* name of dBASE index file        */
        	} ;

/* 
	direct console io: bdos(1) will read single characters from the 
		console. If you want to use multiple character function keys 
		for commands, you should write a filter function to return 
		the proper single character for this program. Instead of
		using macros for conin and conout, just write functions 
		that do the proper checking. 

	These calls are the same for CPM-86 as for MS-DOS. 

*/ 
#define conin() (bdos(1)&0xff)  /* direct console input  */ 
#define conout(c) bdos(2,c);    /* direct console output */

