; cat.xm: conCATenate unicum
; /AJK 15.Jun.81, 12.Jul.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800		; Z80 components
	uses LIB2801		; CP/M components

	db	'CAT V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

BigBuf	equ	8192		; disk buffer size (to decrease head latency)
StdOut	equ	1		; standard output channel number

	entry cat
cat:
	HEAhea [hl=0100h]	; initialize heap
	USKini []		; scan command
	USKflg [hl=flgtbl]	; interpret flags
	USKdef [stk="-",stk=0]	; default command is "cat -"
	IO.sts [a=StdOut]->[a,b,hl]+C ; get status of standard output channel
	and	(1 SHL StDsk)	; see if channel 1 is open to a device
	ld	hl,128		; assume it is: small I/O buffer
	jr	z,cat1		; branch if device
	ld	hl,BigBuf	; disk device, use large I/O buffer
cat1:				; here with buffer size in HL
	ld	(bufsiz),hl	; remember buffer size
	USKall [hl=hl]->[(bufadr)=hl] ; allocate the buffer

; Top of loop for each file: write it to standard output (channel 1).
cat2:
	USKtnc [stk=(nflg),stk=(vflg)]->[hl=stk,bc=stk,de=stk,a]+C
	jr	c,cat5		; branch when files exhausted
	ld	(inch),a	; save input channel number

; Top of loop to read and write a buffer.
cat3:
	IO.rea [stk=(inch),stk=(bufadr),stk=(bufsiz)]->[a,hl]+C
	jr	nc,cat4		; branch if no I/O error
	ERRMSG [a=a,b=1,c=1,hl=hl] ; announce error and abort program
cat4:
	ld	a,h		; check for EOF
	or	l		; signaled by zero bytes read
	jr	z,cat2		; branch if EOF
	IO.wri [stk=StdOut,stk=(bufadr),stk=hl]->[a,hl]+C
	jr	nc,cat3		; loop if no errors
	ERRMSG [a=a,b=1,c=1,hl=hl] ; write error is fatal

; All done.
cat5:
	SHLexi [a=0]

; Flag table.
flgtbl:
	db	'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw	0
	db	'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw	0
	db	0

inch:	ds	1		; input channel
bufadr:	ds	2		; location of buffer
bufsiz:	ds	2		; length of buffer

	end cat
