; sc.xm: Source Comparator Unicum
; /AJK 31.Aug.81, 1.Sep.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'SC V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

LinSiz	equ	256		; default line size
BufSiz	equ	4096		; input buffer size

; Data structures.
; For each of the two files, a list of lines is maintained.
; Each list is anchored by a head, a structure of the following form:
HDfr	equ	0		; (word) "front": -> first line in list, or 0
HDrr	equ	2		; (word) "rear": -> last line in list, or HDfr
HDfn	equ	4		; (word) -> file name
HDch	equ	6		; (word) channel
HDbuf	equ	8		; (word) -> line buffer
HDno	equ	10		; (word) current line number
HDeof	equ	12		; (byte) nonzero if EOF has occurred

; Each line is contained in a heaped structure whose format is:
LINnxt	equ	0		; (word) -> next line in list, or 0
LINno	equ	2		; (word) line number
LINsig	equ	4		; (byte) nonzero if line is significnt
LINeof	equ	5		; (byte) nonzero if this is an EOF marker
LINmat	equ	6		; (byte) nonzero if this is the match line
LINstr	equ	7		; string begins here

; Forward declarations
	proc Compar [FILEA:ix,FILEB:iy]+Z-a-bc-de-hl
	proc Debug  [FILE:ix]
	proc Dump   [BAN:stk,FILE:ix]-a-bc-de-hl
	proc Elim   []+Z-a-bc-de-hl
	proc LstLen [FILE:ix]->[LENGTH:hl]
	proc Qdel   [FILE:ix]+C+Z-a
	proc Qins   [FILE:ix,LINE:iy]
	proc RdLin  [FILE:ix]+C-a-bc-de-hl

	entry sc
sc:

; Initialize, scan command, open files, allocate buffers.
	HEAhea [hl=0100h]		; initialize stack and heap
	USKini []			; scan command
	USKgna []->[(FILE1+HDfn)=hl]+C-a; get first filename
	jr	c,sc1
	USKgna []->[(FILE2+HDfn)=hl]+C-a; get second filename
	jr	c,sc1
	USKgna []->[hl]+C-a		; be sure there are no other arguments
	jr	c,sc2
sc1:
	EPUTF [stk="Usage: sc file1 file2^m^j"]
	SHLexi [a=1]
sc2:
	ld	hl,(FILE1+HDfn)		; file 1 name
	BBIopn [stk=hl,stk=RO+Text+OldOnly,stk=BufSiz]->[(FILE1+HDch)=a]+C
	jp	c,sc9
	ld	hl,(FILE2+HDfn)		; file 2 name
	BBIopn [stk=hl,stk=RO+Text+OldOnly,stk=BufSiz]->[(FILE2+HDch)=a]+C
	jp	c,sc9
	USKall [hl=LinSiz]->[(FILE1+HDbuf)=hl]
	USKall [hl=LinSiz]->[(FILE2+HDbuf)=hl]

; Top of comparison loop.
; If both files have experienced EOF, dump them both and quit.
sc3:
	LstLen [ix=FILE1]->[de=hl]	; DE = length of file 1 list
	LstLen [ix=FILE2]->[hl]		; HL = length of file 2 list
	ld	a,(FILE1+HDeof)
	ld	b,a			; B = file 1 EOF flag
	ld	a,(FILE2+HDeof)		; A = file 2 EOF flag
	and	b
	jr	z,sc4			; if not both on, branch
	ld	a,d			; if both lists are empty,
	or	e			;   don't dump
	or	h
	or	l
	jr	z,sc8
	Dump [stk=fmt1,ix=FILE1]-a-bc-de-hl
	Dump [stk=fmt2,ix=FILE2]-a-bc-de-hl
	jr	sc8

; Determine which list has fewer lines, and add a new line to that list.
; If they have the same length, augment file 1.
sc4:
	ld	iy,FILE1		; assume we augment file 2
	and	a
	sbc	hl,de			; see if len(file 1) > len(file 2)
	jr	c,sc6			; branch if so

; Reverse the files: exchange IX and IY.
sc5:
	push	ix
	ex	(sp),iy
	pop	ix

; Here with IX -> file to augment, IY -> other file.
sc6:
	RdLin [ix=ix]+C-a-bc-de-hl	; read a line from that file
	jr	c,sc5			; EOF on that file, do the other

; If the first lines in each list match, eliminate them without publishing
; them.  Repeat this until the first lines don't match.
sc7:
	Elim []+Z-a-bc-de-hl
	jr	z,sc7			; loop while lines are eliminated

; Now seek a match between the line just read and the lines of the other file.
; If the line just read has been eliminated, Compar will immediately
; return with no match.
	Compar [ix=ix,iy=iy]+Z-a-bc-de-hl
	jr	nz,sc3			; branch if no match (or no lines)

; Got a match, dump it.
	Dump [stk=fmt1,ix=FILE1]-a-bc-de-hl
	Dump [stk=fmt2,ix=FILE2]-a-bc-de-hl
	jr	sc3

; Here when done.
sc8:
	SHLexi [a=0]

; Here on an error.
sc9:
	ERRMSG [a=a,b=1,c=1,hl=hl]

; Compar: compare the last line in FILEA with all the lines in FILEB.  If
;   a match is found, set the LINmat flags for the two lines and return with
;   Z set, otherwise return with Z clear.
; Only significnt lines are compared.

	proc Compar [FILEA:ix,FILEB:iy]+Z-a-bc-de-hl
	begin

	push	ix			; save IX
	ld	a,(ix+HDfr)		; make sure FILEA has a line
	or	(ix+HDfr+1)
	jr	z,cm3			; branch if it doesn't, return
	ld	l,(ix+HDrr)
	ld	h,(ix+HDrr+1)
	push	hl
	pop	ix			; now IX -> last line of FILEA
	bit	0,(ix+LINsig)		; is this line significant?
	jr	z,cm3			; if not, don't compare
	ld	de,LINstr
	add	hl,de
	ex	de,hl			; DE -> FILEA string for comparison
	ld	c,(iy+HDfr)
	ld	b,(iy+HDfr+1)		; BC -> first line of FILEB
cm1:					; loop to compare lines
	ld	a,b			; see if we're run out of lines
	or	c
	jr	z,cm3			; branch if so, return no match
	ld	hl,LINsig		; see if line is significant
	add	hl,bc
	bit	0,(hl)
	jr	z,cm2			; branch if so, don't match them
	ld	hl,LINstr		; compare the two lines
	add	hl,bc
	STRcmp [de=de,hl=hl]->[]+C+Z
	jr	nz,cm2			; if they don't match, move on
	ld	(ix+LINmat),1		; mark "match" in both lines
	ld	hl,LINmat
	add	hl,bc
	ld	(hl),1
	xor	a			; set the Z flag
	jr	cm4			; go return
cm2:					; here to skip this line
	ld	hl,LINnxt
	add	hl,bc
	ld	c,(hl)
	inc	hl
	ld	b,(hl)			; BC -> next line in list
	jr	cm1			; go compare it
cm3:					; here to return with no match
	ld	a,1
	and	a			; clear the Z flag
cm4:
	pop	ix			; restore IX
	end Compar

; Dump: dump the differences between matches.
; Displays the lines up to and including the "match" lines for the file,
;   and removes those lines from the lists.

	proc Dump [BAN:stk,FILE:ix]-a-bc-de-hl
	begin
	push	iy

; Herald the file.
	ld	hl,4
	add	hl,sp
	ld	e,(hl)
	inc	hl
	ld	d,(hl)			; DE -> BAN
	ld	l,(ix+HDfr)
	ld	h,(ix+HDfr+1)
	push	hl
	pop	iy			; IY -> first line
	ld	c,(iy+LINno)
	ld	b,(iy+LINno+1)		; BC = line number of first line
	ld	l,(ix+HDfn)
	ld	h,(ix+HDfn+1)		; HL -> file name
	OPUTF [stk=de,stk=hl,stk=bc]

; Loop through the lines, displaying and deallocating.
dm1:
	ld	l,(ix+HDfr)
	ld	h,(ix+HDfr+1)
	push	hl
	pop	iy			; IY -> next line
	ld	a,h			; see if we've reached end of list
	or	l
	jr	z,dm4			; if so, finish up
	bit	0,(iy+LINeof)		; is this an EOF line?
	jr	z,dm2			; branch if not
	OPUTF [stk="<eof>^m^j"]		; if so, it displays as "<eof>"
	jr	dm3
dm2:
	ld	de,LINstr
	add	hl,de			; HL -> string
	OPUTF [stk="%s^m^j",stk=hl]	; put the line
dm3:
	ld	c,(iy+LINmat)		; C = match flag for line
	Qdel [ix=ix]+C+Z-a		; delete the line from the queue
	bit	0,c			; was that the match line?
	jr	z,dm1			; if not, loop to do next line
dm4:
	pop	iy
	end Dump

; Elim: eliminate any matching lines at the start of the lists.
; Returns Z set if it happened, Z clear if the top lines don't match.

	proc Elim []+Z-a-bc-de-hl
	begin
	push	ix
el1:
	ld	hl,(FILE1+HDfr)		; HL -> first line, file 1
	ld	a,h			; see if it exists
	or	l
	jr	z,el2			; done if not
	ld	bc,LINstr
	add	hl,bc
	ex	de,hl			; DE -> first line string
	ld	hl,(FILE2+HDfr)		; HL -> first line, file 2
	ld	a,h			; see if it exists
	or	l
	jr	z,el2
	add	hl,bc			; HL -> first line string
	STRcmp [de=de,hl=hl]+Z+C	; do they match?
	jr	nz,el2			; branch if not
	Qdel [ix=FILE1]+Z+C-a		; they do, eliminate them
	Qdel [ix=FILE2]+Z+C-a
	xor	a			; set Z
	jr	el3
el2:
	ld	a,1
	and	a			; clear Z
el3:
	pop	ix
	end Elim

; LstLen: return the length of a file's line list.

	proc LstLen [FILE:ix]->[LENGTH:hl]
	begin
	push	af
	push	bc
	push	de
	ld	bc,0			; accumulate length in BC
	ld	l,(ix+HDfr)
	ld	h,(ix+HDfr+1)		; HL -> first line
ll1:
	ld	a,h			; check for end of list
	or	l
	jr	z,ll2
	inc	bc			; count this line
	ld	e,(hl)
	inc	hl
	ld	d,(hl)			; -> next line
	ex	de,hl			; HL -> next line
	jr	ll1			; loop
ll2:					; here with line count in BC
	ld	h,b
	ld	l,c
	pop	de
	pop	bc
	pop	af
	end LstLen

; Qdel: delete the first line in a file's line list.
; Returns C set if list was already empty;
; returns Z set if list becomes empty as a result of this operation.

	proc Qdel [FILE:ix]+C+Z-a
	begin
	push	de
	push	hl
	ld	l,(ix+HDfr)
	ld	h,(ix+HDfr+1)		; HL -> first line in list
	ld	a,l			; see if queue is empty
	or	h
	jr	nz,qd1			; branch if not
	ld	a,1			; clear Z
	and	a
	scf				; set C
	jr	qd2			; go return
qd1:
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	dec	hl			; DE -> line after first line
	HEAfre [hl=hl]			; free the deleted line
	ld	(ix+HDfr),e		; set front pointer to new first line
	ld	(ix+HDfr+1),d
	ld	a,d			; see if list is now empty
	or	e			; (clears carry)
	jr	nz,qd2			; if not, return
	push	ix			; queue is empty, reset rear pointer
	pop	hl
	ld	de,HDfr
	add	hl,de			; HL -> front pointer
	ld	(ix+HDrr),l		; make rear pointer -> front pointer
	ld	(ix+HDrr+1),h
					; now, carry is clear from "add hl,de"
					;      and Z is clear from "or e"
qd2:
	pop	hl
	pop	de
	end Qdel

; Qins: insert a line at the end of a file's line list.

	proc Qins [FILE:ix,LINE:iy]
	begin
	push	de
	push	hl
	ld	l,(ix+HDrr)
	ld	h,(ix+HDrr+1)		; HL -> last line in list
	push	iy
	pop	de			; DE -> line to link in
	ld	(ix+HDrr),e
	ld	(ix+HDrr+1),d		; set rear pointer to new line
	ld	(hl),e			; set previous last line to point to us
	inc	hl
	ld	(hl),d
	pop	hl
	pop	de
	end Qins

; RdLin: read a line from a file and insert it into the file's list.
; If the file has experienced EOF, return with carry set, otherwise
; get the line and return with carry clear.
; Lines that are not all white space are marked significant.

	proc RdLin [FILE:ix]+C-a-bc-de-hl
	begin

; Check for previous EOF.
	bit	0,(ix+HDeof)		; has EOF happened?
	scf				; (assume so)
	ret	nz			; if so, return with carry set

; Read a line into the buffer.
	push	iy
	ld	l,(ix+HDbuf)
	ld	h,(ix+HDbuf+1)		; HL -> line buffer
	ld	c,(ix+HDch)
	ld	b,(ix+HDch+1)		; BC = channel number
	BBIgl [stk=bc,stk=hl,stk=LinSiz]->[]+C-a ; read a line
	jr	nc,rl1			; branch if EOF didn't occur
	ld	(hl),'Z'-64		; set string to control-Z
	inc	hl			;   so it won't compare with anything
	ld	(hl),0
	dec	hl
	ld	(ix+HDeof),1		; set EOF flag
rl1:

; Allocate a new line structure.
	ld	e,(ix+HDbuf)
	ld	d,(ix+HDbuf+1)		; DE -> new line
	STRlng [hl=de]->[bc=hl]		; BC = length of the line
	inc	bc			; plus one for null delimiter
	ld	hl,LINstr		; add room for rest of structure
	add	hl,bc
	USKall [hl]->[iy=hl]		; IY -> structure for the line

; Fill in the information in the structure.
	xor	a
	ld	(hl),a			; zero "next line" pointer
	inc	hl
	ld	(hl),a
	inc	hl
	push	de			; save DE
	ld	e,(ix+HDno)
	ld	d,(ix+HDno+1)		; DE = last line number
	inc	de			; increment for this line
	ld	(ix+HDno),e
	ld	(ix+HDno+1),d		; restore into file header
	ld	(hl),e			; store into line structure
	inc	hl
	ld	(hl),d
	inc	hl
	pop	de			; restore DE
	ld	(hl),a			; zero flags
	inc	hl
	ld	(hl),a
	inc	hl
	ld	(hl),a
	inc	hl			; HL -> LINstr
	STRcpy [de=de,hl=hl,bc=bc]	; copy in the string
	ld	a,(ix+HDeof)		; copy any EOF mark
	ld	(iy+LINeof),a

; See if the line is significant.  It isn't if it is null or contains
; only white space.
rl2:
	ld	a,(hl)			; get a character
	and	a			; stop at end of string
	jr	z,rl3
	inc	hl			; bump pointer
	cp	' '			; space is not significant
	jr	z,rl2
	cp	'I'-64			; tab is not significant
	jr	z,rl2
	ld	(iy+LINsig),1		; anything else is significant
rl3:

	Qins [ix=ix,iy=iy]		; link in the line
	and	a			; clear carry for return
	pop	iy
	end RdLin

; File banner formats.
fmt1:	db '----- %t line %u ---------------',13,10,0
fmt2:	db '----- %t line %u -----',13,10,0

; File headers.
FILE1:
	dw	0		; HDfr: queue front
	dw	FILE1+HDfr	; HDrr: queue rear
	dw	0		; HDfn: file name
	dw	0		; HDch: channel number
	dw	0		; HDbuf: line buffer
	dw	0		; HDno: line number
	db	0		; HDeof: EOF flag
FILE2:
	dw	0		; HDfr: queue front
	dw	FILE2+HDfr	; HDrr: queue rear
	dw	0		; HDfn: file name
	dw	0		; HDch: channel number
	dw	0		; HDbuf: line buffer
	dw	0		; HDno: line number
	db	0		; HDeof: EOF flag

	end sc
