; sfa.xm: Set File Attributes unicum
; /AJK 15.Jul.81, 23.Jul.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

; Mod 23.Jul.81 V1A: allow attributes to be expressed in flag format,
;                    via the pseudo-flags "-r" and "-s".

	db	'SFA V1A: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

	entry sfa
sfa:
	HEAhea [hl=0100h]	; initialize stack and heap
	USKini []		; scan command
	USKflg [hl=flgtbl]	; scan flags

; Obtain the attribute argument.
; If the "-r" or "-s" flag was seen, assume the attribute argument started
; with "-" and was eaten by the flag interpreter; otherwise look for and
; interpret an attribute argument.
	ld	a,(rflg)	; A = "-r" flag
	ld	hl,sflg		; HL -> "-s" flag
	or	(hl)		; clear Z if either flag was specified
	jr	nz,sfa5		; branch if so, assume attributes were
				;   captured by the flag handler
	USKgna []->[hl]+C-a	; HL -> first argument: attributes
	jr	nc,sfa1
	EPUTF [stk="Usage: sfa [-nv] [-|r|s|rs] file ..^m^j"]
	SHLexi [a=1]
sfa1:

; Determine what attributes to set.
; Set "rflg" to desired "r" attribute, "sflg" to desired "s" (1=on, 0=off).
	ld	de,1		; DE = 1 for setting rflg/sflg
sfa2:				; loop through characters of attributes
	ld	a,(hl)		; A = next attribute character
	inc	hl
	and	a		; look for end of string
	jr	z,sfa5
	cp	'-'		; do nothing for "-"
	jr	z,sfa2
	cp	'r'		; R means Read/Only
	jr	nz,sfa3
	ld	(rflg),de	; set rflg
	jr	sfa2
sfa3:				; here if not R
	cp	's'		; S means set SAT
	jr	nz,sfa4
	ld	(sflg),de	; set sflg
	jr	sfa2
sfa4:				; here if unrecognized attribute character
	EPUTF [stk="unknown attribute '%pc'^m^j",stk=af]
	SHLexi [a=1]

; "Attr" is a mask to XOR with existing file attributes to determine
; which attribute must be changed.
; Set bit 0 in attr for "r", set bit 1 for "s".
sfa5:
	ld	a,(sflg)	; A = -s flag
	add	a,a		; put "s" attribute in bit 1
	ld	hl,rflg
	or	(hl)		; put "r" attribute in bit 0
	ld	(attr),a	; store attributes

; Here when attributes decoded.
; Loop for each file.
sfa6:
	USKmnf [stk=(nflg),stk=(vflg)]->[hl=stk,bc=stk,de=stk]+C-a
	jr	c,sfa9		; branch when files exhausted

; Got a file, set attributes.
	ld	a,(attr)	; A = desired attributes
	xor	c		; exclusive-or with actual attributes
	ld	b,a		; keep those bits in B

; See if we need to change the R/O attribute.
	bit	0,b
	jr	z,sfa7		; branch if R/O attribute okay
	DUTslk [stk=hl,stk=(rflg)]->[a]+C
	jr	c,sfa8		; branch if file untouchable

; See if we need to change the SYS attribute.
sfa7:
	bit	1,b
	jr	z,sfa6		; branch if SYS attribute okay, do next file
	DUTssf [stk=hl,stk=(sflg)]->[a]+C
	jr	nc,sfa6		; branch if okay, do next file

; Here if an error occurs.
sfa8:
	ld	(code),a	; save error code
	ERRMSG [a=a,b=1,c=0,hl=hl]

; Here when all files done.
sfa9:
	ld	a,(code)
	SHLexi [a=a]

; Flags
flgtbl:
	db 'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw 0
	db 'r',0,0,0,0,0,0,0,0,0,0,0,0
rflg:	dw 0
	db 's',0,0,0,0,0,0,0,0,0,0,0,0
sflg:	dw 0
	db 'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw 0
	db 0

code:	db 0			; error return code

; Data
attr:	ds	1		; attribute bits to set

	end sfa
