; tee.xm: TEE pipe fitting Unicum
; /AJK 4.Sep.81, 4.Sep.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'TEE V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

	entry tee
tee:
	HEAhea [hl=0100h]	; initialize stack and heap

; For each argument, presumed to be a filename, open the file and add the
; resulting channel number to the list of channels to be written to.
	USKini []		; scan command
	USKflg [hl=flgtbl]	; interpret flags
	ld	ix,chnls	; IX -> block of channels
	ld	(ix+0),1	; start with channel 1 (standard output)
	inc	ix
tee1:
	USKgna []->[hl]+C-a	; HL -> next file name
	jr	c,tee3		; branch when arguments exhausted
	IO.opn [stk=hl,stk=WO+Text+Replace]->[a]+C ; open the file
	jr	nc,tee2
	ld	(code),a	; unsuccessful open
	ERRMSG [a=a,b=1,c=0,hl=hl]
	jr	tee1		; skip that argument
tee2:				; here on successful open
	ld	(ix+0),a	; stow the channel number into the list
	inc	ix
	ld	hl,aflg
	bit	0,(hl)		; was -a specified?
	jr	z,tee1		; if not, don't append to file
	ld	e,a
	ld	d,0		; DE = channel number
	IO.app [stk=de]->[a,hl]+C ; append to file
	jr	nc,tee1		; next file if no error
	ERRMSG [a=a,b=1,c=0,hl=hl] ; can't even append
	ld	(ix-1),255	; strike that file
	jr	tee1		; loop for next argument
tee3:				; here when arguments exhausted
	ld	(ix+0),0	; 0 marks end of channel list

; Files all open, allocate the buffer.
; We use the rest of available memory, to minimize head latency.
	HEAall [de=128,hl=0FF00h]->[(bufsiz)=de,(buf)=hl]+C
	jr	nc,tee4		; branch if successful
	EPUTF [stk="Not enough memory^m^j"]
	SHLexi [a=IoNMM]

; All files are open.
; Loop:
;   Read a bufferful from standard input.
;     (If EOF, exit loop.)
;     (If error, print message and abort.)
;   For each file open for output:
;     Write the bufferful to the file.
;       (If error, print message, strike file, and continue.)
tee4:
	IO.rea [stk=0,stk=(buf),stk=(bufsiz)]->[a,hl]+C
	jr	nc,tee5
	ERRMSG [a=a,b=1,c=1,hl=hl]
tee5:
	ld	a,h		; check for EOF
	or	l
	jr	z,tee7
	ld	(datlen),hl	; store number of bytes actually read
	ld	ix,chnls	; IX -> block of channels
tee6:
	ld	a,(ix+0)	; A = next output channel number
	inc	ix
	and	a		; check for end of list
	jr	z,tee4		; if encountered, go read some more
	cp	255		; check for stricken channel
	jr	z,tee6		; and skip
	ld	e,a
	ld	d,0		; DE = channel number
	IO.wri [stk=de,stk=(buf),stk=(datlen)]->[a,hl]+C
	jr	nc,tee6		; on good read, loop for next channel
	ld	(code),a
	ERRMSG [a=a,b=1,c=0,hl=hl] ; publish error message
	IO.cls [stk=de]->[a,hl]+C ; close file, ignore any error
	ld	(ix-1),255	; strike this channel
	jr	tee6		; loop

; Here on EOF.  Let SHLexi close the files for us.
tee7:
	SHLexi [a=(code)]

; Data
flgtbl:
	db 'a',0,0,0,0,0,0,0,0,0,0,0,0
aflg:	dw 0
	db 0

code:	db	0		; return code

buf:	ds	2		; -> buffer
bufsiz:	ds	2		; size of buffer
datlen:	ds	2		; number of bytes obtained by last read
chnls:	ds	16		; List of output channels, one per byte.
				; Terminated by zero byte.
				; When a channel is stricken (because of an
				;   output error), 255 is stowed in its entry.

	end tee
